/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import shetiphian.core.client.model.CompositeBakedModel;

public class ModelMultiLayered {
    public static final Loader LOADER = new Loader();

    public static class Loader {
        public Unbaked read(JsonObject modelContents) {
            ImmutableMap children;
            String name;
            class_793 source = class_793.method_3430((String)class_3518.method_43680((JsonElement)modelContents));
            EnumMap<BlendMode, Set<String>> renderLayers = new EnumMap<BlendMode, Set<String>>(BlendMode.class);
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            if (modelContents.has("children")) {
                for (Map.Entry entry : class_3518.method_15296((JsonObject)modelContents, (String)"children").entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof JsonObject)) continue;
                    JsonObject subModel = (JsonObject)v;
                    name = (String)entry.getKey();
                    childrenBuilder.put((Object)name, (Object)class_793.method_3430((String)class_3518.method_43680((JsonElement)subModel)));
                    if (!name.endsWith("_fast")) {
                        itemPasses.add(name);
                    }
                    BlendMode blendMode = BlendMode.SOLID;
                    if (subModel.has("render_type")) {
                        switch (class_3518.method_15265((JsonObject)subModel, (String)"render_type")) {
                            case "cutout": {
                                BlendMode blendMode2 = BlendMode.CUTOUT;
                                break;
                            }
                            case "cutout_mipped": {
                                BlendMode blendMode2 = BlendMode.CUTOUT_MIPPED;
                                break;
                            }
                            case "translucent": {
                                BlendMode blendMode2 = BlendMode.TRANSLUCENT;
                                break;
                            }
                            default: {
                                BlendMode blendMode2 = blendMode = BlendMode.SOLID;
                            }
                        }
                    }
                    if (!renderLayers.containsKey(blendMode)) {
                        renderLayers.put(blendMode, new HashSet());
                    }
                    renderLayers.get(blendMode).add(name);
                }
            }
            if ((children = childrenBuilder.build()).isEmpty()) {
                throw new JsonParseException("Layered model requires a \"children\" block with at least one element.");
            }
            if (modelContents.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : class_3518.method_15261((JsonObject)modelContents, (String)"item_render_order")) {
                    name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            return new Unbaked((class_1100)source, (Map<String, class_793>)children, (List<String>)ImmutableList.copyOf(itemPasses), renderLayers);
        }
    }

    private static class Baked
    extends CompositeBakedModel {
        private final boolean useAO;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_809 transforms;
        private final Map<String, class_1087> children;
        private final List<class_1087> itemPasses;
        private final Map<BlendMode, Set<String>> renderLayers;

        private Baked(boolean useAO, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 transforms, Map<String, class_1087> children, List<class_1087> itemPasses, Map<BlendMode, Set<String>> renderLayers) {
            this.useAO = useAO;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.children = children;
            this.itemPasses = itemPasses;
            this.renderLayers = renderLayers;
        }

        @Override
        protected List<class_1087> handleBlockState(class_2680 state, class_1921 layer, class_5819 random, Object modelData) {
            if (layer == null) {
                return this.handleItemState(class_1799.field_8037, random);
            }
            ArrayList<class_1087> list = new ArrayList<class_1087>();
            this.renderLayers.getOrDefault(BlendMode.fromRenderLayer((class_1921)layer), Collections.emptySet()).forEach(name -> {
                if (class_310.method_1517() ? name.endsWith("_fast") : name.endsWith("_fancy")) {
                    return;
                }
                class_1087 model = this.children.get(name);
                if (model != null) {
                    list.add(model);
                }
            });
            return list;
        }

        @Override
        protected List<class_1087> handleItemState(class_1799 stack, class_5819 random) {
            return this.itemPasses;
        }

        @Override
        public boolean method_4708() {
            return this.useAO;
        }

        @Override
        public boolean method_4712() {
            return this.isGui3d;
        }

        @Override
        public boolean method_24304() {
            return this.isSideLit;
        }

        @Override
        public class_1058 method_4711() {
            return this.particle != null ? this.particle : super.method_4711();
        }

        @Override
        public class_806 method_4710() {
            return this.overrides;
        }

        @Override
        public class_809 method_4709() {
            return this.transforms;
        }
    }

    private record Unbaked(class_1100 source, Map<String, class_793> children, List<String> itemPasses, Map<BlendMode, Set<String>> renderLayers) implements class_1100
    {
        public Collection<class_2960> method_4755() {
            HashSet set = Sets.newHashSet();
            set.addAll(this.source.method_4755());
            this.children.forEach((name, model) -> set.addAll(model.method_4755()));
            return set;
        }

        public void method_45785(Function<class_2960, class_1100> modelLoader) {
            this.source.method_45785(modelLoader);
            this.children.values().forEach(child -> child.method_45785(modelLoader));
        }

        public class_1087 method_4753(class_7775 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelId) {
            class_1087 context = this.source.method_4753(bakery, spriteGetter, modelState, modelId);
            ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
            for (Map.Entry<String, class_793> entry : this.children.entrySet()) {
                String name = entry.getKey();
                class_793 model = entry.getValue();
                bakedPartsBuilder.put((Object)name, (Object)model.method_3446(bakery, model, spriteGetter, modelState, modelId, true));
            }
            ImmutableMap bakedParts = bakedPartsBuilder.build();
            ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
            for (String name : this.itemPasses) {
                class_1087 model = (class_1087)bakedParts.get((Object)name);
                if (model == null) {
                    throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                }
                itemPassesBuilder.add((Object)model);
            }
            if (context == null) {
                return new Baked(true, true, true, null, class_806.field_4292, class_809.field_4301, (Map<String, class_1087>)bakedParts, (List<class_1087>)itemPassesBuilder.build(), this.renderLayers);
            }
            return new Baked(context.method_4708(), context.method_4712(), context.method_24304(), context.method_4711(), context.method_4710(), context.method_4709(), (Map<String, class_1087>)bakedParts, (List<class_1087>)itemPassesBuilder.build(), this.renderLayers);
        }
    }
}

