/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;

public class BlockItemRGB16
extends class_1747
implements IColored,
IRGB16_Item {
    private final short startColor;
    private int[] tintedIndexes;

    public BlockItemRGB16(class_2248 block, class_1792.class_1793 settings, class_1767 color) {
        this(block, settings, RGB16Helper.getIndexFor(color));
    }

    public BlockItemRGB16(class_2248 block, class_1792.class_1793 settings, RGB16 rgb16) {
        this(block, settings, rgb16.getIndex());
    }

    public BlockItemRGB16(class_2248 block, class_1792.class_1793 settings, short index) {
        super(block, settings);
        this.startColor = index;
    }

    public BlockItemRGB16 callback(Consumer<BlockItemRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockItemRGB16 tint(int ... indexes) {
        this.tintedIndexes = indexes;
        return this;
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        if (RGB16StackHelper.getRGB16(stack) == null) {
            RGB16StackHelper.setRGB16(stack, this.getStartingIndex(stack));
        }
    }

    @Override
    public short getRGB16(class_1799 stack) {
        return RGB16StackHelper.readColorTag(stack, this.startColor);
    }

    @Override
    public boolean setRGB16(class_1799 stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags(stack, rgbIndex);
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.method_7960() && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index))) {
            return RGB16Helper.getColor(this.getRGB16(data.stack));
        }
        return 0xFFFFFF;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43470((String)RGB16Helper.getTooltip(this.getRGB16(stack))));
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public short getStartingIndex(class_1799 stack) {
        return this.startColor;
    }

    @Override
    public boolean enableDyeRecipe(class_1799 stack) {
        return true;
    }

    @Override
    public boolean dyeUseChance(class_1799 stack) {
        return true;
    }

    @Override
    public double getDyeUseChance(class_1799 result, class_1799 dye, int dyeCounter) {
        if (result.method_7909() == this && RGB16StackHelper.getRGB16Index(result) == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

