/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;

public class InventorySideAssignable
extends InventoryInternal
implements class_1278 {
    private static final SlotGroup EMPTY = new SlotGroup("empty");
    private final List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();
    private byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    private byte defaultIndex = (byte)-1;
    private class_2350 blockDirection = class_2350.field_11035;

    public InventorySideAssignable(class_2586 invOwner, String saveName, int invSize, String displayName) {
        super(invOwner, saveName, invSize, displayName);
    }

    public InventorySideAssignable(class_2586 invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        super(invOwner, saveName, invSize, displayName, callback);
    }

    public InventorySideAssignable(class_2586 invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        super(invOwner, saveName, invSize, invStackLimit, displayName);
    }

    public InventorySideAssignable(class_2586 invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        super(invOwner, saveName, invSize, invStackLimit, displayName, callback);
    }

    public InventorySideAssignable setup(int defaultIndex, SlotGroup ... groups) {
        this.slotGroups.clear();
        if (groups != null) {
            for (SlotGroup group : groups) {
                if (group == null || this.slotGroups.contains(group)) continue;
                this.slotGroups.add(group);
            }
        }
        this.defaultIndex = this.clamp(defaultIndex);
        return this;
    }

    public int getGroupCount() {
        return this.slotGroups.size();
    }

    public void setSideGroup(class_2350 side, int groupIndex) {
        if (side != null) {
            this.indexSide[side.method_10146()] = this.clamp(groupIndex);
        }
    }

    public void setBlockDirection(class_2350 direction) {
        this.blockDirection = direction;
    }

    private byte clamp(int index) {
        return (byte)(index > -1 && index < this.slotGroups.size() ? index : -1);
    }

    public byte[] getIndexes() {
        return this.indexSide;
    }

    @Override
    public void writeToNBT(class_2487 nbtTag, String name) {
        super.writeToNBT(nbtTag, name);
        nbtTag.method_10570("sidedWrapper", this.indexSide);
    }

    @Override
    public void readFromNBT(class_2487 nbtTag, String name) {
        byte[] indexes;
        super.readFromNBT(nbtTag, name);
        if (nbtTag.method_10545("sidedWrapper") && (indexes = nbtTag.method_10547("sidedWrapper")).length == 6) {
            this.indexSide = indexes;
        }
    }

    private SlotGroup getGroup(class_2350 side) {
        try {
            if (this.blockDirection != null && side != null) {
                if (side.method_10166() != class_2350.class_2351.field_11052) {
                    switch (this.blockDirection) {
                        case field_11043: {
                            return this.slotGroups.get(this.indexSide[side.method_10153().method_10146()]);
                        }
                        case field_11039: {
                            return this.slotGroups.get(this.indexSide[side.method_10160().method_10146()]);
                        }
                        case field_11034: {
                            return this.slotGroups.get(this.indexSide[side.method_10170().method_10146()]);
                        }
                    }
                }
                return this.slotGroups.get(this.indexSide[side.method_10146()]);
            }
            return this.slotGroups.get(this.defaultIndex);
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    public int[] method_5494(class_2350 side) {
        return this.getGroup((class_2350)side).slots.keySet().stream().mapToInt(i -> i).toArray();
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 side) {
        if (Arrays.stream(this.method_5494(side)).anyMatch(value -> value == slot)) {
            return this.getGroup((class_2350)side).slots.getOrDefault(slot, Action.NEITHER).canInsert() && this.method_5437(slot, stack);
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        if (Arrays.stream(this.method_5494(side)).anyMatch(value -> value == slot)) {
            return this.getGroup((class_2350)side).slots.getOrDefault(slot, Action.NEITHER).canExtract();
        }
        return false;
    }

    public static class SlotGroup {
        private final class_2561 name;
        private final Map<Integer, Action> slots = new HashMap<Integer, Action>();

        public SlotGroup(String name) {
            this.name = class_2561.method_43471((String)name);
        }

        public SlotGroup(String blockKey, String slotKey) {
            this.name = class_2561.method_43471((String)blockKey).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)slotKey));
        }

        public SlotGroup(class_2561 name) {
            this.name = name;
        }

        public SlotGroup add(int slotId, boolean insert, boolean extract) {
            this.slots.put(slotId, insert ? (extract ? Action.BOTH : Action.INSERT) : (extract ? Action.EXTRACT : Action.NEITHER));
            return this;
        }

        public SlotGroup add(int startId, int endId, boolean insert, boolean extract) {
            for (int slotId = startId; slotId <= endId; ++slotId) {
                this.add(slotId, insert, extract);
            }
            return this;
        }

        public class_2561 getName() {
            return this.name;
        }
    }

    private static enum Action {
        INSERT,
        EXTRACT,
        BOTH,
        NEITHER;


        public boolean canInsert() {
            return this == BOTH || this == INSERT;
        }

        public boolean canExtract() {
            return this == BOTH || this == EXTRACT;
        }
    }
}

