/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class StringUtil {
    private static final Pattern STYLE_PATTERN = Pattern.compile("\u00a7([0-9a-fk-or])", 2);
    @Environment(value=EnvType.CLIENT)
    public static final LoadingCache<String, class_2561> TRANSLATION_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, class_2561>(){

        public class_2561 load(String key) {
            String text = class_1074.method_4662((String)key, (Object[])new Object[0]);
            return class_2561.method_43470((String)("\u00a7f" + text)).method_10862(StringUtil.computeStyleFrom(text));
        }
    });
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);

    /*
     * WARNING - void declaration
     */
    private static String[] prepAndSplit(String string) {
        string = string.replace("\\t", "   ");
        String[] lines = string.split("(?>\\r\\n|\\r|\\n|%n|<br>)", -1);
        if (STYLE_PATTERN.matcher(string).matches()) {
            String formatting = "";
            for (String string2 : lines) {
                void var6_6;
                if (!Strings.isNullOrEmpty((String)formatting)) {
                    String string3 = formatting + string2;
                }
                formatting = StringUtil.acquireFormattingFrom((String)var6_6);
            }
        }
        return lines;
    }

    public static void multiLineTooltip(String string, List<class_2561> list) {
        for (String line : StringUtil.prepAndSplit(string)) {
            list.add((class_2561)class_2561.method_43470((String)line));
        }
    }

    public static void multiLine(String string, List<String> list) {
        Collections.addAll(list, StringUtil.prepAndSplit(string));
    }

    @Environment(value=EnvType.CLIENT)
    public static void translateAndSplitTooltip(String string, List<class_2561> list) {
        StringUtil.multiLineTooltip(class_1074.method_4662((String)string, (Object[])new Object[0]), list);
    }

    @Environment(value=EnvType.CLIENT)
    public static void translateAndSplit(String string, List<String> list) {
        StringUtil.multiLine(class_1074.method_4662((String)string, (Object[])new Object[0]), list);
    }

    @Environment(value=EnvType.CLIENT)
    public static String[] translateAll(String ... keys) {
        String[] strings = new String[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            strings[index] = class_1074.method_4662((String)keys[index], (Object[])new Object[0]);
        }
        return strings;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2561 translateAndComputeStyle(String string) {
        return (class_2561)TRANSLATION_CACHE.getUnchecked((Object)string);
    }

    public static class_2583 computeStyleFrom(String string) {
        Matcher matcher = STYLE_PATTERN.matcher(string);
        HashSet set = new HashSet();
        matcher.results().forEach(matchResult -> {
            String value = matchResult.group().toLowerCase(Locale.ROOT);
            if (!value.matches("\u00a7[k-o]")) {
                set.clear();
            }
            if (!value.equals("\u00a7r")) {
                set.add(class_124.method_544((char)value.charAt(value.length() - 1)));
            }
        });
        set.remove(null);
        if (!set.isEmpty()) {
            return class_2583.field_24360.method_27705(set.toArray(new class_124[0]));
        }
        return class_2583.field_24360;
    }

    public static String acquireFormattingFrom(String string) {
        Matcher matcher = STYLE_PATTERN.matcher(string);
        StringBuilder builder = new StringBuilder();
        matcher.results().forEach(matchResult -> {
            String value = matchResult.group().toLowerCase(Locale.ROOT);
            if (!value.matches("\u00a7[k-o]")) {
                builder.setLength(0);
            }
            if (!value.equals("\u00a7r")) {
                builder.append(value);
            }
        });
        return builder.toString();
    }

    public static class_2561 newChatWithLinks(String string) {
        return StringUtil.newChatWithLinks(string, true);
    }

    public static class_2561 newChatWithLinks(String string, boolean allowMissingHeader) {
        class_5250 ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            class_5250 link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = class_2561.method_43470((String)part);
                    } else {
                        ichat.method_27693(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = class_2561.method_43470((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = class_2561.method_43470((String)url);
                            continue;
                        }
                        ichat.method_27693((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = class_2561.method_43470((String)url);
                        continue;
                    }
                    ichat.method_27693((String)url);
                    continue;
                }
            }
            class_2558 click = new class_2558(class_2558.class_2559.field_11749, (String)url);
            link.method_10862(link.method_10866().method_10958(click).method_30938(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1078)));
            if (ichat == null) {
                ichat = class_2561.method_43470((String)"");
            }
            ichat.method_10852((class_2561)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = class_2561.method_43470((String)end);
        } else if (end.length() > 0) {
            ichat.method_10852((class_2561)class_2561.method_43470((String)string.substring(lastEnd)));
        }
        return ichat;
    }
}

