/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import shetiphian.core.client.model.SimpleBakedModel;
import shetiphian.core.internal.ShetiPhianCore;

@Environment(value=EnvType.CLIENT)
public abstract class CompositeBakedModel
extends SimpleBakedModel
implements FabricBakedModel {
    private static long TIMER = 0L;

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(class_2680 state, class_2350 side, class_5819 rand) {
        if (TIMER + 60000L < System.currentTimeMillis()) {
            TIMER = System.currentTimeMillis();
            StringBuilder message = new StringBuilder("Model requires Fabric Rendering API, something is using the original method");
            StackTraceElement[] trace = new Throwable("WrongMethodCalled").getStackTrace();
            for (int index = 1; index < Math.min(6, trace.length); ++index) {
                message.append("\n\tat ").append(trace[index].toString());
            }
            ShetiPhianCore.LOGGER.error(message.toString());
            ShetiPhianCore.LOGGER.info("If Sodium is installed you must also install Indium. Otherwise another mod is breaking support");
        }
        return Collections.emptyList();
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Object modelData = ((RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos);
        class_5819 random = randomSupplier.get();
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        for (BlendMode blendMode : BlendMode.values()) {
            RenderMaterial material = renderer.materialFinder().blendMode(blendMode).find();
            renderer.materialFinder().clear();
            this.handleBlockState(state, blendMode.blockRenderLayer, random, modelData).forEach(model -> {
                if (model instanceof FabricBakedModel && !((FabricBakedModel)model).isVanillaAdapter()) {
                    ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                } else {
                    for (class_2350 side : class_2350.values()) {
                        model.method_4707(state, side, random).forEach(bakedQuad -> {
                            emitter.fromVanilla(bakedQuad, material, side);
                            emitter.emit();
                        });
                    }
                    model.method_4707(state, null, random).forEach(bakedQuad -> {
                        emitter.fromVanilla(bakedQuad, material, null);
                        emitter.emit();
                    });
                }
            });
            context.meshConsumer().accept(builder.build());
        }
    }

    protected abstract List<class_1087> handleBlockState(class_2680 var1, class_1921 var2, class_5819 var3, Object var4);

    @Override
    public class_806 method_4710() {
        return new class_806(null, null, Collections.emptyList()){

            public class_1087 method_3495(class_1087 model, class_1799 stack, class_638 world, class_1309 entity, int seed) {
                return CompositeBakedModel.this.handleItemState(model, stack, (class_1937)world, entity);
            }
        };
    }

    protected class_1087 handleItemState(class_1087 model, class_1799 stack, class_1937 world, class_1309 entity) {
        return model;
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_5819 random = randomSupplier.get();
        List<class_1087> models = this.handleItemState(stack, random);
        if (models.isEmpty()) {
            return;
        }
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        RenderMaterial material = renderer.materialFinder().blendMode(BlendMode.TRANSLUCENT).find();
        renderer.materialFinder().clear();
        models.forEach(model -> {
            if (model instanceof FabricBakedModel && !((FabricBakedModel)model).isVanillaAdapter()) {
                ((FabricBakedModel)model).emitItemQuads(stack, randomSupplier, context);
            } else {
                for (class_2350 side : class_2350.values()) {
                    model.method_4707(null, side, random).forEach(bakedQuad -> {
                        emitter.fromVanilla(bakedQuad, material, side);
                        emitter.emit();
                    });
                }
                model.method_4707(null, null, random).forEach(bakedQuad -> {
                    emitter.fromVanilla(bakedQuad, material, null);
                    emitter.emit();
                });
            }
            context.meshConsumer().accept(builder.build());
        });
    }

    protected List<class_1087> handleItemState(class_1799 stack, class_5819 random) {
        return Collections.emptyList();
    }
}

