/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpginventory.mixin.server.network;

import com.github.theredbrain.rpginventory.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.rpginventory.entity.player.DuckPlayerInventoryMixin;
import com.github.theredbrain.rpginventory.registry.ItemRegistry;
import com.github.theredbrain.rpginventory.registry.ServerPacketRegistry;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class}, priority=950)
public abstract class ServerPlayerEntityMixin
extends class_1657
implements DuckPlayerEntityMixin {
    @Unique
    class_1799 handSlotStack = class_1799.field_8037;
    @Unique
    class_1799 alternateHandSlotStack = class_1799.field_8037;
    @Unique
    class_1799 offHandSlotStack = class_1799.field_8037;
    @Unique
    class_1799 alternateOffHandSlotStack = class_1799.field_8037;
    @Unique
    boolean isHandWeaponSheathed = false;
    @Unique
    boolean isOffHandWeaponSheathed = false;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void rpginventory$tick(CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            boolean isOffHandWeaponSheathed;
            if (!((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getEmptyHand().method_31574(ItemRegistry.DEFAULT_EMPTY_HAND_WEAPON)) {
                ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$setEmptyHand(ItemRegistry.DEFAULT_EMPTY_HAND_WEAPON.method_7854());
            }
            if (!((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getEmptyOffhand().method_31574(ItemRegistry.DEFAULT_EMPTY_HAND_WEAPON)) {
                ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$setEmptyOffhand(ItemRegistry.DEFAULT_EMPTY_HAND_WEAPON.method_7854());
            }
            class_1799 newHandStack = ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getHand();
            class_1799 newAlternativeHandStack = ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getAlternativeHand();
            if (!class_1799.method_7984((class_1799)this.handSlotStack, (class_1799)newHandStack) || !class_1799.method_7984((class_1799)this.alternateHandSlotStack, (class_1799)newAlternativeHandStack)) {
                this.rpginventory$sendChangedHandSlotsPacket(true);
            }
            this.handSlotStack = newHandStack;
            this.alternateHandSlotStack = newAlternativeHandStack;
            class_1799 newOffHandStack = this.method_6118(class_1304.field_6171);
            class_1799 newAlternativeOffHandStack = ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getAlternativeOffhand();
            if (!class_1799.method_7984((class_1799)this.offHandSlotStack, (class_1799)newOffHandStack) || !class_1799.method_7984((class_1799)this.alternateOffHandSlotStack, (class_1799)newAlternativeOffHandStack)) {
                this.rpginventory$sendChangedHandSlotsPacket(false);
            }
            this.offHandSlotStack = newOffHandStack;
            this.alternateOffHandSlotStack = newAlternativeOffHandStack;
            boolean isHandWeaponSheathed = this.rpginventory$isHandStackSheathed();
            if (this.isHandWeaponSheathed != isHandWeaponSheathed) {
                this.rpginventory$sendSheathedWeaponsPacket(true, isHandWeaponSheathed);
                this.isHandWeaponSheathed = isHandWeaponSheathed;
            }
            if (this.isOffHandWeaponSheathed != (isOffHandWeaponSheathed = this.rpginventory$isOffhandStackSheathed())) {
                this.rpginventory$sendSheathedWeaponsPacket(false, isOffHandWeaponSheathed);
                this.isOffHandWeaponSheathed = isOffHandWeaponSheathed;
            }
        }
    }

    @Unique
    private void rpginventory$sendChangedHandSlotsPacket(boolean mainHand) {
        Collection players = PlayerLookup.tracking((class_3218)((class_3218)this.method_37908()), (class_2338)this.method_24515());
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.method_5628());
        data.writeBoolean(mainHand);
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ServerPacketRegistry.SWAPPED_HAND_ITEMS_PACKET, (class_2540)data));
    }

    @Unique
    private void rpginventory$sendSheathedWeaponsPacket(boolean mainHand, boolean isSheathed) {
        Collection players = PlayerLookup.tracking((class_3218)((class_3218)this.method_37908()), (class_2338)this.method_24515());
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.method_5628());
        data.writeBoolean(mainHand);
        data.writeBoolean(isSheathed);
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ServerPacketRegistry.SHEATHED_WEAPONS_PACKET, (class_2540)data));
    }
}

