/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpginventory.mixin.screen;

import com.github.theredbrain.rpginventory.RPGInventory;
import com.github.theredbrain.rpginventory.config.ServerConfig;
import com.github.theredbrain.rpginventory.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.rpginventory.registry.Tags;
import com.github.theredbrain.rpginventory.screen.DuckPlayerScreenHandlerMixin;
import com.github.theredbrain.rpginventory.screen.DuckSlotMixin;
import com.github.theredbrain.slotcustomizationapi.api.SlotCustomization;
import com.google.common.collect.ImmutableList;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.SurvivalTrinketSlot;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.mixin.accessor.ScreenHandlerAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1723.class})
public abstract class PlayerScreenHandlerMixin
extends class_1703
implements TrinketPlayerScreenHandler,
DuckPlayerScreenHandlerMixin {
    @Shadow
    @Final
    private class_1657 field_7828;
    @Unique
    private final Map<SlotGroup, Integer> groupNums = new HashMap<SlotGroup, Integer>();
    @Unique
    private final Map<SlotGroup, Point> groupPos = new HashMap<SlotGroup, Point>();
    @Unique
    private final Map<SlotGroup, List<Point>> slotHeights = new HashMap<SlotGroup, List<Point>>();
    @Unique
    private final Map<SlotGroup, List<SlotType>> slotTypes = new HashMap<SlotGroup, List<SlotType>>();
    @Unique
    private final Map<SlotGroup, Integer> slotWidths = new HashMap<SlotGroup, Integer>();
    @Unique
    private int trinketSlotStart = 0;
    @Unique
    private int trinketSlotEnd = 0;
    @Unique
    private int groupCount = 0;
    @Unique
    private class_1661 inventory;
    @Unique
    private boolean isAttributeScreenVisible = false;
    @Unique
    private int handSlotIndex = -1;
    @Unique
    private int sheathedHandSlotIndex = -1;
    @Unique
    private int sheathedOffhandSlotIndex = -1;
    @Unique
    private int alternativeHandSlotIndex = -1;
    @Unique
    private int alternativeOffHandSlotIndex = -1;

    public PlayerScreenHandlerMixin() {
        super(null, 0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void PlayerScreenHandler(class_1661 inventory, boolean onServer, class_1657 owner, CallbackInfo ci) {
        int i;
        this.inventory = inventory;
        ServerConfig serverConfig = RPGInventory.serverConfig;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                ((SlotCustomization)this.field_7761.get(j + (i + 1) * 9)).slotcustomizationapi$setY(138 + i * 18);
            }
        }
        for (i = 0; i < 9; ++i) {
            ((SlotCustomization)this.field_7761.get(i + 36)).slotcustomizationapi$setY(196);
        }
        if (serverConfig.disable_inventory_crafting_slots) {
            ((SlotCustomization)this.field_7761.get(0)).slotcustomizationapi$setDisabledOverride(true);
            ((SlotCustomization)this.field_7761.get(1)).slotcustomizationapi$setDisabledOverride(true);
            ((SlotCustomization)this.field_7761.get(2)).slotcustomizationapi$setDisabledOverride(true);
            ((SlotCustomization)this.field_7761.get(3)).slotcustomizationapi$setDisabledOverride(true);
            ((SlotCustomization)this.field_7761.get(4)).slotcustomizationapi$setDisabledOverride(true);
        } else {
            ((SlotCustomization)this.field_7761.get(0)).slotcustomizationapi$setX(serverConfig.inventory_crafting_slots_x_offset + 56);
            ((SlotCustomization)this.field_7761.get(0)).slotcustomizationapi$setY(serverConfig.inventory_crafting_slots_y_offset + 10);
            ((SlotCustomization)this.field_7761.get(1)).slotcustomizationapi$setX(serverConfig.inventory_crafting_slots_x_offset);
            ((SlotCustomization)this.field_7761.get(1)).slotcustomizationapi$setY(serverConfig.inventory_crafting_slots_y_offset);
            ((SlotCustomization)this.field_7761.get(2)).slotcustomizationapi$setX(serverConfig.inventory_crafting_slots_x_offset + 18);
            ((SlotCustomization)this.field_7761.get(2)).slotcustomizationapi$setY(serverConfig.inventory_crafting_slots_y_offset);
            ((SlotCustomization)this.field_7761.get(3)).slotcustomizationapi$setX(serverConfig.inventory_crafting_slots_x_offset);
            ((SlotCustomization)this.field_7761.get(3)).slotcustomizationapi$setY(serverConfig.inventory_crafting_slots_y_offset + 18);
            ((SlotCustomization)this.field_7761.get(4)).slotcustomizationapi$setX(serverConfig.inventory_crafting_slots_x_offset + 18);
            ((SlotCustomization)this.field_7761.get(4)).slotcustomizationapi$setY(serverConfig.inventory_crafting_slots_y_offset + 18);
        }
        ((SlotCustomization)this.field_7761.get(5)).slotcustomizationapi$setX(serverConfig.head_slot_x_offset);
        ((SlotCustomization)this.field_7761.get(5)).slotcustomizationapi$setY(serverConfig.head_slot_y_offset);
        ((SlotCustomization)this.field_7761.get(6)).slotcustomizationapi$setX(serverConfig.chest_slot_x_offset);
        ((SlotCustomization)this.field_7761.get(6)).slotcustomizationapi$setY(serverConfig.chest_slot_y_offset);
        ((SlotCustomization)this.field_7761.get(7)).slotcustomizationapi$setX(serverConfig.legs_slot_x_offset);
        ((SlotCustomization)this.field_7761.get(7)).slotcustomizationapi$setY(serverConfig.legs_slot_y_offset);
        ((SlotCustomization)this.field_7761.get(8)).slotcustomizationapi$setX(serverConfig.feet_slot_x_offset);
        ((SlotCustomization)this.field_7761.get(8)).slotcustomizationapi$setY(serverConfig.feet_slot_y_offset);
        ((SlotCustomization)this.field_7761.get(45)).slotcustomizationapi$setX(serverConfig.offhand_slot_x_offset);
        ((SlotCustomization)this.field_7761.get(45)).slotcustomizationapi$setY(serverConfig.offhand_slot_y_offset);
        ArrayList<class_2561> list5 = new ArrayList<class_2561>();
        list5.add((class_2561)class_2561.method_43471((String)"slot.tooltip.head"));
        ((DuckSlotMixin)this.field_7761.get(5)).rpginventory$setSlotTooltipText(list5);
        ArrayList<class_2561> list6 = new ArrayList<class_2561>();
        list6.add((class_2561)class_2561.method_43471((String)"slot.tooltip.chest"));
        ((DuckSlotMixin)this.field_7761.get(6)).rpginventory$setSlotTooltipText(list6);
        ArrayList<class_2561> list7 = new ArrayList<class_2561>();
        list7.add((class_2561)class_2561.method_43471((String)"slot.tooltip.legs"));
        ((DuckSlotMixin)this.field_7761.get(7)).rpginventory$setSlotTooltipText(list7);
        ArrayList<class_2561> list8 = new ArrayList<class_2561>();
        list8.add((class_2561)class_2561.method_43471((String)"slot.tooltip.feet"));
        ((DuckSlotMixin)this.field_7761.get(8)).rpginventory$setSlotTooltipText(list8);
        ArrayList<class_2561> list45 = new ArrayList<class_2561>();
        list45.add((class_2561)class_2561.method_43471((String)"slot.tooltip.offhand"));
        ((DuckSlotMixin)this.field_7761.get(45)).rpginventory$setSlotTooltipText(list45);
        this.trinkets$updateTrinketSlots(true);
    }

    public void trinkets$updateTrinketSlots(boolean slotsChanged) {
        ServerConfig serverConfig = RPGInventory.serverConfig;
        TrinketsApi.getTrinketComponent((class_1309)this.field_7828).ifPresent(trinkets -> {
            if (slotsChanged) {
                trinkets.update();
            }
            Map groups = trinkets.getGroups();
            this.groupPos.clear();
            while (this.trinketSlotStart < this.trinketSlotEnd) {
                this.field_7761.remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)this).getTrackedStacks().remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)this).getPreviousTrackedStacks().remove(this.trinketSlotStart);
                --this.trinketSlotEnd;
            }
            int groupNum = 0;
            int extraGroupCount = 0;
            for (SlotGroup slotGroup : groups.values().stream().sorted(Comparator.comparing(SlotGroup::getOrder)).toList()) {
                int y;
                int x;
                if (!this.rpginventory$hasSlots((TrinketComponent)trinkets, slotGroup)) continue;
                String groupName = slotGroup.getName();
                int id = slotGroup.getSlotId();
                if (id != -1) {
                    class_1735 slot;
                    if (this.field_7761.size() <= id || (slot = (class_1735)this.field_7761.get(id)) instanceof SurvivalTrinketSlot) continue;
                    this.groupPos.put(slotGroup, new Point(slot.field_7873, slot.field_7872));
                    this.groupNums.put(slotGroup, -id);
                    continue;
                }
                if (Objects.equals(groupName, "belts")) {
                    x = serverConfig.belts_group_x_offset;
                    y = serverConfig.belts_group_y_offset;
                } else if (Objects.equals(groupName, "shoulders")) {
                    x = serverConfig.shoulders_group_x_offset;
                    y = serverConfig.shoulders_group_y_offset;
                } else if (Objects.equals(groupName, "necklaces")) {
                    x = serverConfig.necklaces_group_x_offset;
                    y = serverConfig.necklaces_group_y_offset;
                } else if (Objects.equals(groupName, "rings_1")) {
                    x = serverConfig.rings_1_group_x_offset;
                    y = serverConfig.rings_1_group_y_offset;
                } else if (Objects.equals(groupName, "rings_2")) {
                    x = serverConfig.rings_2_group_x_offset;
                    y = serverConfig.rings_2_group_y_offset;
                } else if (Objects.equals(groupName, "gloves")) {
                    x = serverConfig.gloves_group_x_offset;
                    y = serverConfig.gloves_group_y_offset;
                } else if (Objects.equals(groupName, "hand")) {
                    x = serverConfig.hand_group_x_offset;
                    y = serverConfig.hand_group_y_offset;
                } else if (Objects.equals(groupName, "alternative_hand")) {
                    x = serverConfig.alternative_hand_group_x_offset;
                    y = serverConfig.alternative_hand_group_y_offset;
                } else if (Objects.equals(groupName, "alternative_offhand")) {
                    x = serverConfig.alternative_offhand_group_x_offset;
                    y = serverConfig.alternative_offhand_group_y_offset;
                } else if (Objects.equals(groupName, "spell_slot_1")) {
                    x = serverConfig.spell_slots_x_offset;
                    y = serverConfig.spell_slots_y_offset;
                } else if (Objects.equals(groupName, "spell_slot_2")) {
                    x = serverConfig.spell_slots_x_offset + 18;
                    y = serverConfig.spell_slots_y_offset;
                } else if (Objects.equals(groupName, "spell_slot_3")) {
                    x = serverConfig.spell_slots_x_offset + 36;
                    y = serverConfig.spell_slots_y_offset;
                } else if (Objects.equals(groupName, "spell_slot_4")) {
                    x = serverConfig.spell_slots_x_offset + 54;
                    y = serverConfig.spell_slots_y_offset;
                } else if (Objects.equals(groupName, "spell_slot_5")) {
                    x = serverConfig.spell_slots_x_offset;
                    y = serverConfig.spell_slots_y_offset + 18;
                } else if (Objects.equals(groupName, "spell_slot_6")) {
                    x = serverConfig.spell_slots_x_offset + 18;
                    y = serverConfig.spell_slots_y_offset + 18;
                } else if (Objects.equals(groupName, "spell_slot_7")) {
                    x = serverConfig.spell_slots_x_offset + 36;
                    y = serverConfig.spell_slots_y_offset + 18;
                } else if (Objects.equals(groupName, "spell_slot_8")) {
                    x = serverConfig.spell_slots_x_offset + 54;
                    y = serverConfig.spell_slots_y_offset + 18;
                } else if (Objects.equals(groupName, "sheathed_hand")) {
                    x = serverConfig.hand_group_x_offset;
                    y = serverConfig.hand_group_y_offset;
                } else if (Objects.equals(groupName, "sheathed_offhand")) {
                    x = serverConfig.offhand_slot_x_offset;
                    y = serverConfig.offhand_slot_y_offset;
                } else {
                    if (Objects.equals(groupName, "empty_hand") || Objects.equals(groupName, "empty_offhand")) continue;
                    x = -14 - extraGroupCount / 4 * 18;
                    y = 8 + extraGroupCount % 4 * 18;
                    ++extraGroupCount;
                }
                this.groupPos.put(slotGroup, new Point(x, y));
                this.groupNums.put(slotGroup, groupNum);
                ++groupNum;
            }
            this.groupCount = extraGroupCount;
            this.trinketSlotStart = this.field_7761.size();
            this.slotWidths.clear();
            this.slotHeights.clear();
            this.slotTypes.clear();
            for (Map.Entry entry : trinkets.getInventory().entrySet()) {
                String groupId = (String)entry.getKey();
                SlotGroup group = (SlotGroup)groups.get(groupId);
                int groupOffset = 1;
                if (group.getSlotId() != -1) {
                    ++groupOffset;
                }
                int width = 0;
                Point pos = this.trinkets$getGroupPos(group);
                if (pos == null) continue;
                for (Map.Entry slot : ((Map)entry.getValue()).entrySet().stream().sorted((a, b) -> Integer.compare(((TrinketInventory)a.getValue()).getSlotType().getOrder(), ((TrinketInventory)b.getValue()).getSlotType().getOrder())).toList()) {
                    TrinketInventory stacks = (TrinketInventory)slot.getValue();
                    if (stacks.method_5439() == 0) continue;
                    int slotOffset = 1;
                    int x = (int)((double)(groupOffset / 2 * 18) * Math.pow(-1.0, groupOffset));
                    this.slotHeights.computeIfAbsent(group, k -> new ArrayList()).add(new Point(x, stacks.method_5439()));
                    this.slotTypes.computeIfAbsent(group, k -> new ArrayList()).add(stacks.getSlotType());
                    for (int i = 0; i < stacks.method_5439(); ++i) {
                        int y = (int)((double)pos.y() + (double)(slotOffset / 2 * 18) * Math.pow(-1.0, slotOffset));
                        this.method_7621((class_1735)new SurvivalTrinketSlot(stacks, i, x + pos.x(), y, group, stacks.getSlotType(), i, groupOffset == 1 && i == 0));
                        ++slotOffset;
                    }
                    ++groupOffset;
                    ++width;
                }
                this.slotWidths.put(group, width);
            }
            this.trinketSlotEnd = this.field_7761.size();
        });
    }

    @Unique
    private boolean rpginventory$hasSlots(TrinketComponent comp, SlotGroup group) {
        for (TrinketInventory inv : ((Map)comp.getInventory().get(group.getName())).values()) {
            if (inv.method_5439() <= 0) continue;
            return true;
        }
        return false;
    }

    public int trinkets$getGroupNum(SlotGroup group) {
        return this.groupNums.getOrDefault(group, 0);
    }

    @Nullable
    public Point trinkets$getGroupPos(SlotGroup group) {
        return this.groupPos.get(group);
    }

    @NotNull
    public List<Point> trinkets$getSlotHeights(SlotGroup group) {
        return this.slotHeights.getOrDefault(group, (List<Point>)ImmutableList.of());
    }

    @Nullable
    public Point trinkets$getSlotHeight(SlotGroup group, int i) {
        List<Point> points = this.trinkets$getSlotHeights(group);
        return i < points.size() ? points.get(i) : null;
    }

    @NotNull
    public List<SlotType> trinkets$getSlotTypes(SlotGroup group) {
        return this.slotTypes.getOrDefault(group, (List<SlotType>)ImmutableList.of());
    }

    public int trinkets$getSlotWidth(SlotGroup group) {
        return this.slotWidths.getOrDefault(group, 0);
    }

    public int trinkets$getGroupCount() {
        return this.groupCount;
    }

    public int trinkets$getTrinketSlotStart() {
        return this.trinketSlotStart;
    }

    public int trinkets$getTrinketSlotEnd() {
        return this.trinketSlotEnd;
    }

    @Inject(at={@At(value="HEAD")}, method={"onClosed"})
    private void rpginventory$onClosed(class_1657 player, CallbackInfo info) {
        if (player.method_37908().field_9236) {
            TrinketsClient.activeGroup = null;
            TrinketsClient.activeType = null;
            TrinketsClient.quickMoveGroup = null;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"quickMove"}, cancellable=true)
    private void rpginventory$quickMove(class_1657 player, int slot, CallbackInfoReturnable<class_1799> cir) {
        class_1735 slot1 = (class_1735)this.field_7761.get(slot);
        if (slot1.method_7681()) {
            class_1799 stack = slot1.method_7677();
            if (slot >= this.trinketSlotStart && slot < this.trinketSlotEnd) {
                if (!this.method_7616(stack, 9, 45, false)) {
                    cir.setReturnValue((Object)class_1799.field_8037);
                    cir.cancel();
                } else {
                    cir.setReturnValue((Object)stack);
                    cir.cancel();
                }
            } else if (slot >= 9 && slot < 45) {
                boolean res;
                SlotReference ref;
                SlotType type;
                SurvivalTrinketSlot ts;
                class_1735 s;
                TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> {
                    for (int i = this.trinketSlotStart; i < this.trinketSlotEnd; ++i) {
                        class_1735 s = (class_1735)this.field_7761.get(i);
                        if (!(s instanceof SurvivalTrinketSlot) || !s.method_7680(stack)) continue;
                        SurvivalTrinketSlot ts = (SurvivalTrinketSlot)s;
                        SlotType type = ts.getType();
                        SlotReference ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                        if (Objects.equals(type.getGroup(), "spell_slot_1") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 1.0 || Objects.equals(type.getGroup(), "spell_slot_2") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 2.0 || Objects.equals(type.getGroup(), "spell_slot_3") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 3.0 || Objects.equals(type.getGroup(), "spell_slot_4") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 4.0 || Objects.equals(type.getGroup(), "spell_slot_5") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 5.0 || Objects.equals(type.getGroup(), "spell_slot_6") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 6.0 || Objects.equals(type.getGroup(), "spell_slot_7") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 7.0 || Objects.equals(type.getGroup(), "spell_slot_8") && player.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT) < 8.0) continue;
                        if (Objects.equals(type.getGroup(), "hand") && Objects.equals(type.getName(), "hand")) {
                            this.handSlotIndex = i;
                            continue;
                        }
                        if (Objects.equals(type.getGroup(), "sheathed_hand") && Objects.equals(type.getName(), "sheathed_hand")) {
                            this.sheathedHandSlotIndex = i;
                            continue;
                        }
                        if (Objects.equals(type.getGroup(), "sheathed_offhand") && Objects.equals(type.getName(), "sheathed_offhand")) {
                            this.sheathedOffhandSlotIndex = i;
                            continue;
                        }
                        if (Objects.equals(type.getGroup(), "alternative_hand") && Objects.equals(type.getName(), "alternative_hand")) {
                            this.alternativeHandSlotIndex = i;
                            continue;
                        }
                        if (Objects.equals(type.getGroup(), "alternative_offhand") && Objects.equals(type.getName(), "alternative_offhand")) {
                            this.alternativeOffHandSlotIndex = i;
                            continue;
                        }
                        boolean res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                        if (!res || !this.method_7616(stack, i, i + 1, false)) continue;
                        this.handSlotIndex = -1;
                        this.sheathedHandSlotIndex = -1;
                        this.sheathedOffhandSlotIndex = -1;
                        this.alternativeHandSlotIndex = -1;
                        this.alternativeOffHandSlotIndex = -1;
                        if (!player.method_37908().field_9236) continue;
                        TrinketsClient.quickMoveTimer = 20;
                        TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                        TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                    }
                });
                class_1304 equipmentSlot = class_1308.method_32326((class_1799)stack);
                if (((DuckPlayerEntityMixin)this.field_7828).rpginventory$isHandStackSheathed()) {
                    if (!stack.method_7960() && this.sheathedHandSlotIndex > -1 && stack.method_31573(Tags.HAND_ITEMS) && (s = (class_1735)this.field_7761.get(this.sheathedHandSlotIndex)) instanceof SurvivalTrinketSlot) {
                        ts = (SurvivalTrinketSlot)s;
                        if (s.method_7680(stack)) {
                            type = ts.getType();
                            ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                            res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                            if (res && this.method_7616(stack, this.sheathedHandSlotIndex, this.sheathedHandSlotIndex + 1, false) && player.method_37908().field_9236) {
                                TrinketsClient.quickMoveTimer = 20;
                                TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                                TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                            }
                        }
                    }
                } else if (!stack.method_7960() && this.handSlotIndex > -1 && stack.method_31573(Tags.HAND_ITEMS) && (s = (class_1735)this.field_7761.get(this.handSlotIndex)) instanceof SurvivalTrinketSlot) {
                    ts = (SurvivalTrinketSlot)s;
                    if (s.method_7680(stack)) {
                        type = ts.getType();
                        ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                        res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                        if (res && this.method_7616(stack, this.handSlotIndex, this.handSlotIndex + 1, false) && player.method_37908().field_9236) {
                            TrinketsClient.quickMoveTimer = 20;
                            TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                            TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                        }
                    }
                }
                if (((DuckPlayerEntityMixin)this.field_7828).rpginventory$isOffhandStackSheathed()) {
                    if (!stack.method_7960() && this.sheathedOffhandSlotIndex > -1 && (equipmentSlot == class_1304.field_6171 || stack.method_31573(Tags.OFFHAND_ITEMS)) && (s = (class_1735)this.field_7761.get(this.sheathedOffhandSlotIndex)) instanceof SurvivalTrinketSlot) {
                        ts = (SurvivalTrinketSlot)s;
                        if (s.method_7680(stack)) {
                            type = ts.getType();
                            ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                            res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                            if (res && this.method_7616(stack, this.sheathedOffhandSlotIndex, this.sheathedOffhandSlotIndex + 1, false) && player.method_37908().field_9236) {
                                TrinketsClient.quickMoveTimer = 20;
                                TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                                TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                            }
                        }
                    }
                } else if (!(stack.method_7960() || equipmentSlot != class_1304.field_6171 && !stack.method_31573(Tags.OFFHAND_ITEMS) || ((class_1735)this.field_7761.get(45)).method_7681() || this.method_7616(stack, 45, 46, false))) {
                    cir.setReturnValue((Object)class_1799.field_8037);
                    cir.cancel();
                }
                if (!stack.method_7960() && this.alternativeHandSlotIndex > -1 && stack.method_31573(Tags.HAND_ITEMS) && (s = (class_1735)this.field_7761.get(this.alternativeHandSlotIndex)) instanceof SurvivalTrinketSlot) {
                    ts = (SurvivalTrinketSlot)s;
                    if (s.method_7680(stack)) {
                        type = ts.getType();
                        ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                        res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                        if (res && this.method_7616(stack, this.alternativeHandSlotIndex, this.alternativeHandSlotIndex + 1, false) && player.method_37908().field_9236) {
                            TrinketsClient.quickMoveTimer = 20;
                            TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                            TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                        }
                    }
                }
                if (!stack.method_7960() && this.alternativeOffHandSlotIndex > -1 && (equipmentSlot == class_1304.field_6171 || stack.method_31573(Tags.OFFHAND_ITEMS)) && (s = (class_1735)this.field_7761.get(this.alternativeOffHandSlotIndex)) instanceof SurvivalTrinketSlot) {
                    ts = (SurvivalTrinketSlot)s;
                    if (s.method_7680(stack)) {
                        type = ts.getType();
                        ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                        res = TrinketsApi.evaluatePredicateSet((Set)type.getQuickMovePredicates(), (class_1799)stack, (SlotReference)ref, (class_1309)player);
                        if (res && this.method_7616(stack, this.alternativeOffHandSlotIndex, this.alternativeOffHandSlotIndex + 1, false) && player.method_37908().field_9236) {
                            TrinketsClient.quickMoveTimer = 20;
                            TrinketsClient.quickMoveGroup = (SlotGroup)TrinketsApi.getPlayerSlots((class_1657)this.field_7828).get(type.getGroup());
                            TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean rpginventory$isAttributeScreenVisible() {
        return this.isAttributeScreenVisible;
    }

    @Override
    public void rpginventory$setIsAttributeScreenVisible(boolean isAttributeScreenVisible) {
        this.isAttributeScreenVisible = isAttributeScreenVisible;
    }
}

