/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpginventory.mixin.entity.player;

import com.github.theredbrain.rpginventory.RPGInventory;
import com.github.theredbrain.rpginventory.entity.DuckLivingEntityMixin;
import com.github.theredbrain.rpginventory.entity.RendersSheathedWeapons;
import com.github.theredbrain.rpginventory.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.rpginventory.entity.player.DuckPlayerInventoryMixin;
import com.github.theredbrain.rpginventory.registry.GameRulesRegistry;
import com.github.theredbrain.rpginventory.registry.Tags;
import com.github.theredbrain.rpginventory.util.ItemUtils;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements DuckPlayerEntityMixin,
DuckLivingEntityMixin,
RendersSheathedWeapons {
    @Shadow
    @Final
    private class_1661 field_7514;
    @Shadow
    @Final
    public class_1723 field_7498;
    @Unique
    private boolean isAdventureHotbarCleanedUp = false;
    @Unique
    private static final class_2940<Boolean> IS_HAND_STACK_SHEATHED = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> IS_OFFHAND_STACK_SHEATHED = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Integer> OLD_ACTIVE_SPELL_SLOT_AMOUNT = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);

    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract boolean method_7337();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void rpginventory$createPlayerAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26868(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT, 1.0);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    protected void rpginventory$initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(IS_HAND_STACK_SHEATHED, (Object)false);
        this.field_6011.method_12784(IS_OFFHAND_STACK_SHEATHED, (Object)false);
        this.field_6011.method_12784(OLD_ACTIVE_SPELL_SLOT_AMOUNT, (Object)-1);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void rpginventory$tick(CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            this.rpginventory$ejectItemsFromInactiveSpellSlots();
            this.rpginventory$ejectSecondUniqueRing();
        }
    }

    @Inject(method={"updateTurtleHelmet"}, at={@At(value="TAIL")})
    private void rpginventory$updateTurtleHelmet(CallbackInfo ci) {
        class_1291 needs_two_handing_status_effect;
        boolean keep_inventory_on_death_item_equipped = false;
        Predicate<class_1799> keep_inventory_on_death_item_equipped_predicate = stack -> stack.method_31573(Tags.KEEPS_INVENTORY_ON_DEATH);
        Optional trinkets = TrinketsApi.getTrinketComponent((class_1309)this);
        if (trinkets.isPresent()) {
            keep_inventory_on_death_item_equipped = ((TrinketComponent)trinkets.get()).isEquipped(keep_inventory_on_death_item_equipped_predicate);
        }
        keep_inventory_on_death_item_equipped = keep_inventory_on_death_item_equipped || this.rpginventory$hasEquipped(keep_inventory_on_death_item_equipped_predicate);
        class_1291 keep_inventory_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.keep_inventory_status_effect_identifier));
        if (keep_inventory_status_effect != null) {
            if (keep_inventory_on_death_item_equipped) {
                if (!this.method_6059(keep_inventory_status_effect)) {
                    this.method_6092(new class_1293(keep_inventory_status_effect, -1, 0, false, false, false));
                }
            } else {
                this.method_6016(keep_inventory_status_effect);
            }
        }
        class_1799 itemStackMainHand = this.method_6118(class_1304.field_6173);
        class_1799 itemStackOffHand = this.method_6118(class_1304.field_6171);
        class_1291 adventure_building_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.building_mode_status_effect_identifier));
        boolean hasAdventureBuildingEffect = adventure_building_status_effect != null && this.method_6059(adventure_building_status_effect);
        class_1291 no_attack_item_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.no_attack_item_status_effect_identifier));
        if (no_attack_item_status_effect != null) {
            if (!(itemStackMainHand.method_31573(Tags.ATTACK_ITEMS) || this.method_7337() || hasAdventureBuildingEffect || RPGInventory.serverConfig.allow_attacking_with_non_attack_items)) {
                if (!this.method_6059(no_attack_item_status_effect)) {
                    this.method_6092(new class_1293(no_attack_item_status_effect, -1, 0, false, false, false));
                }
            } else {
                this.method_6016(no_attack_item_status_effect);
            }
        }
        if ((needs_two_handing_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.needs_two_handing_status_effect_identifier))) != null) {
            if (!(!itemStackMainHand.method_31573(Tags.TWO_HANDED_ITEMS) || !this.rpginventory$isHandStackSheathed() && this.rpginventory$isOffhandStackSheathed() || this.method_7337() || hasAdventureBuildingEffect)) {
                if (!this.method_6059(needs_two_handing_status_effect)) {
                    this.method_6092(new class_1293(needs_two_handing_status_effect, -1, 0, false, false, false));
                }
            } else {
                this.method_6016(needs_two_handing_status_effect);
            }
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void rpginventory$readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("is_hand_stack_sheathed", 1)) {
            this.rpginventory$setIsHandStackSheathed(nbt.method_10577("is_hand_stack_sheathed"));
        }
        if (nbt.method_10573("is_offhand_stack_sheathed", 1)) {
            this.rpginventory$setIsOffhandStackSheathed(nbt.method_10577("is_offhand_stack_sheathed"));
        }
        if (nbt.method_10573("old_active_spell_slot_amount", 3)) {
            this.rpginventory$setOldActiveSpellSlotAmount(nbt.method_10550("old_active_spell_slot_amount"));
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void rpginventory$writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        int old_active_spell_slot_amount;
        boolean is_offhand_stack_sheathed;
        boolean is_hand_stack_sheathed = this.rpginventory$isHandStackSheathed();
        if (is_hand_stack_sheathed) {
            nbt.method_10556("is_hand_stack_sheathed", this.rpginventory$isHandStackSheathed());
        }
        if (is_offhand_stack_sheathed = this.rpginventory$isOffhandStackSheathed()) {
            nbt.method_10556("is_offhand_stack_sheathed", this.rpginventory$isOffhandStackSheathed());
        }
        if ((old_active_spell_slot_amount = this.rpginventory$oldActiveSpellSlotAmount()) != -1) {
            nbt.method_10569("old_active_spell_slot_amount", old_active_spell_slot_amount);
        }
    }

    @Overwrite
    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        if (slot == class_1304.field_6173) {
            this.method_6116(slot, this.rpginventory$isHandStackSheathed() ? (class_1799)this.field_7514.field_7547.set(this.field_7514.field_7545, (Object)stack) : ((DuckPlayerInventoryMixin)this.field_7514).rpginventory$setHand(stack), stack);
        } else if (slot == class_1304.field_6171) {
            this.method_6116(slot, this.rpginventory$isHandStackSheathed() ? ((DuckPlayerInventoryMixin)this.field_7514).rpginventory$setSheathedOffhand(stack) : (class_1799)this.field_7514.field_7544.set(0, (Object)stack), stack);
        } else if (slot.method_5925() == class_1304.class_1305.field_6178) {
            this.method_6116(slot, (class_1799)this.field_7514.field_7548.set(slot.method_5927(), (Object)stack), stack);
        }
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;vanishCursedItems()V", ordinal=0)}, cancellable=true)
    private void rpginventory$pre_vanishCursedItems(CallbackInfo ci) {
        class_1291 keep_inventory_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.keep_inventory_status_effect_identifier));
        if (keep_inventory_status_effect != null && this.method_6059(keep_inventory_status_effect)) {
            this.rpginventory$breakKeepInventoryItems();
            ci.cancel();
        }
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V", ordinal=0)})
    private void rpginventory$pre_inventoryDropAll(CallbackInfo ci) {
        if (this.method_37908().method_8450().method_8355(GameRulesRegistry.DESTROY_DROPPED_ITEMS_ON_DEATH)) {
            this.field_7514.method_5448();
        }
    }

    @Inject(method={"getEquippedStack"}, at={@At(value="HEAD")}, cancellable=true)
    public void rpginventory$getEquippedStack(class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot == class_1304.field_6171) {
            cir.setReturnValue((Object)((DuckPlayerInventoryMixin)this.field_7514).rpginventory$getOffHandStack());
            cir.cancel();
        }
    }

    @Overwrite
    public Iterable<class_1799> method_5661() {
        return ((DuckPlayerInventoryMixin)this.field_7514).rpginventory$getArmor();
    }

    @Override
    public float rpginventory$getActiveSpellSlotAmount() {
        return (float)this.method_26825(RPGInventory.ACTIVE_SPELL_SLOT_AMOUNT);
    }

    @Override
    public class_1799 rpginventory$getSheathedHandItemStack() {
        class_1799 itemStack = ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getSheathedHand();
        return this.rpginventory$isHandStackSheathed() && !itemStack.method_31573(Tags.EMPTY_HAND_WEAPONS) && ItemUtils.isUsable(itemStack) ? itemStack : class_1799.field_8037;
    }

    @Override
    public class_1799 rpginventory$getSheathedOffHandItemStack() {
        class_1799 itemStack = ((DuckPlayerInventoryMixin)this.method_31548()).rpginventory$getSheathedOffhand();
        return this.rpginventory$isOffhandStackSheathed() && !itemStack.method_31573(Tags.EMPTY_HAND_WEAPONS) && ItemUtils.isUsable(itemStack) ? itemStack : class_1799.field_8037;
    }

    @Override
    public boolean rpginventory$isHandStackSheathed() {
        return (Boolean)this.field_6011.method_12789(IS_HAND_STACK_SHEATHED);
    }

    @Override
    public void rpginventory$setIsHandStackSheathed(boolean isHandStackSheathed) {
        this.field_6011.method_12778(IS_HAND_STACK_SHEATHED, (Object)isHandStackSheathed);
    }

    @Override
    public boolean rpginventory$isOffhandStackSheathed() {
        return (Boolean)this.field_6011.method_12789(IS_OFFHAND_STACK_SHEATHED);
    }

    @Override
    public void rpginventory$setIsOffhandStackSheathed(boolean isOffhandStackSheathed) {
        this.field_6011.method_12778(IS_OFFHAND_STACK_SHEATHED, (Object)isOffhandStackSheathed);
    }

    @Override
    public int rpginventory$oldActiveSpellSlotAmount() {
        return (Integer)this.field_6011.method_12789(OLD_ACTIVE_SPELL_SLOT_AMOUNT);
    }

    @Override
    public void rpginventory$setOldActiveSpellSlotAmount(int oldActiveSpellSlotAmount) {
        this.field_6011.method_12778(OLD_ACTIVE_SPELL_SLOT_AMOUNT, (Object)oldActiveSpellSlotAmount);
    }

    @Unique
    private void rpginventory$ejectItemsFromInactiveSpellSlots() {
        int activeSpellSlotAmount = (int)this.rpginventory$getActiveSpellSlotAmount();
        if (this.rpginventory$oldActiveSpellSlotAmount() != activeSpellSlotAmount) {
            class_1661 playerInventory = this.method_31548();
            for (int j = activeSpellSlotAmount + 1; j < 9; ++j) {
                if (((DuckPlayerInventoryMixin)playerInventory).rpginventory$getSpellSlotStack(j).method_7960()) continue;
                playerInventory.method_7398(((DuckPlayerInventoryMixin)playerInventory).rpginventory$setSpellSlotStack(class_1799.field_8037, j));
                class_1657 class_16572 = (class_1657)this;
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayerEntity = (class_3222)class_16572;
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"hud.message.spellsRemovedFromInactiveSpellSlots"), false);
            }
            this.rpginventory$setOldActiveSpellSlotAmount(activeSpellSlotAmount);
        }
    }

    @Unique
    private void rpginventory$ejectSecondUniqueRing() {
        class_1661 playerInventory = this.method_31548();
        class_1799 firstRingStack = ((DuckPlayerInventoryMixin)playerInventory).rpginventory$getRing1Stack();
        class_1799 secondRingStack = ((DuckPlayerInventoryMixin)playerInventory).rpginventory$getRing2Stack();
        if (firstRingStack.method_31573(Tags.UNIQUE_RINGS) && firstRingStack.method_7909() == secondRingStack.method_7909()) {
            playerInventory.method_7398(((DuckPlayerInventoryMixin)playerInventory).rpginventory$setRing2Stack(class_1799.field_8037));
        }
    }

    @Unique
    private void rpginventory$ejectNonHotbarItemsFromHotbar() {
        boolean canChangeEquipment;
        class_1291 adventure_building_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.building_mode_status_effect_identifier));
        boolean hasAdventureBuildingEffect = adventure_building_status_effect != null && this.method_6059(adventure_building_status_effect);
        class_1291 civilisation_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.civilisation_status_effect_identifier));
        boolean hasCivilisationEffect = civilisation_status_effect != null && this.method_6059(civilisation_status_effect);
        class_1291 wilderness_status_effect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_12829((String)RPGInventory.serverConfig.wilderness_status_effect_identifier));
        boolean hasWildernessEffect = wilderness_status_effect != null && this.method_6059(wilderness_status_effect);
        boolean bl = canChangeEquipment = this.method_5682() != null && this.method_5682().method_3767().method_8355(GameRulesRegistry.CAN_CHANGE_EQUIPMENT);
        if (!(this.method_7337() || hasAdventureBuildingEffect || canChangeEquipment && !hasWildernessEffect || hasCivilisationEffect)) {
            if (!this.isAdventureHotbarCleanedUp) {
                for (int i = 0; i < 9; ++i) {
                    class_1661 playerInventory = this.method_31548();
                    class_1735 slot = (class_1735)this.field_7498.field_7761.get(i + 36);
                    if (slot.field_7871.method_5438(slot.method_34266()).method_31573(Tags.ADVENTURE_HOTBAR_ITEMS)) continue;
                    playerInventory.method_7398(slot.field_7871.method_5441(slot.method_34266()));
                }
                this.isAdventureHotbarCleanedUp = true;
            }
        } else if (this.isAdventureHotbarCleanedUp) {
            this.isAdventureHotbarCleanedUp = false;
        }
    }

    @Unique
    private void rpginventory$breakKeepInventoryItems() {
        Optional trinkets = TrinketsApi.getTrinketComponent((class_1309)this);
        if (trinkets.isPresent()) {
            List trinketList = ((TrinketComponent)trinkets.get()).getAllEquipped();
            for (class_3545 trinket : trinketList) {
                if (!((class_1799)trinket.method_15441()).method_31573(Tags.KEEPS_INVENTORY_ON_DEATH)) continue;
                ((SlotReference)trinket.method_15442()).inventory().method_5448();
            }
        }
        for (int i = 0; i < this.field_7514.field_7548.size(); ++i) {
            if (!((class_1799)this.field_7514.field_7548.get(i)).method_31573(Tags.KEEPS_INVENTORY_ON_DEATH)) continue;
            this.field_7514.field_7548.set(i, (Object)class_1799.field_8037);
        }
        if (((class_1799)this.field_7514.field_7544.get(0)).method_31573(Tags.KEEPS_INVENTORY_ON_DEATH)) {
            this.field_7514.field_7544.set(0, (Object)class_1799.field_8037);
        }
    }
}

