/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpginventory.client.gui.screen.ingame;

import com.github.theredbrain.foodoverhaul.effect.FoodStatusEffect;
import com.github.theredbrain.rpginventory.RPGInventory;
import com.github.theredbrain.rpginventory.RPGInventoryClient;
import com.github.theredbrain.rpginventory.client.gui.widget.ToggleInventoryScreenWidget;
import com.github.theredbrain.rpginventory.config.ServerConfig;
import com.github.theredbrain.rpginventory.entity.player.DuckPlayerEntityMixin;
import com.github.theredbrain.rpginventory.screen.DuckPlayerScreenHandlerMixin;
import com.github.theredbrain.rpginventory.screen.DuckSlotMixin;
import com.github.theredbrain.slotcustomizationapi.api.SlotCustomization;
import com.google.common.collect.Ordering;
import dev.emi.trinkets.Point;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.api.SlotGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4074;
import net.minecraft.class_4081;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class RPGInventoryScreen
extends class_465<class_1723>
implements TrinketScreen {
    public static final class_2960 ADVENTURE_INVENTORY_SIDES_BACKGROUND_TEXTURE = RPGInventory.identifier("textures/gui/container/adventure_inventory/adventure_inventory_sides_background.png");
    private static final class_2960 INVENTORY_SLOT_TEXTURE = RPGInventory.identifier("textures/gui/container/adventure_inventory/adventure_inventory_spells_background_1.png");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_206_TEXTURE = RPGInventory.identifier("textures/gui/sprites/scroll_bar/scroll_bar_background_8_206.png");
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_32_TEXTURE = RPGInventory.identifier("textures/gui/sprites/scroll_bar/scroll_bar_background_8_32.png");
    private static final class_2960 SCROLLER_VERTICAL_6_7_TEXTURE = RPGInventory.identifier("textures/gui/sprites/scroll_bar/scroller_vertical_6_7.png");
    private static final class_2960 SCROLLER_VERTICAL_6_15_TEXTURE = RPGInventory.identifier("textures/gui/sprites/scroll_bar/scroller_vertical_6_15.png");
    private static final class_2561 CRAFTING_LABEL_TEXT = class_2561.method_43471((String)"gui.adventure_inventory_screen.crafting_label");
    private static final class_2561 SPELLS_LABEL_TEXT = class_2561.method_43471((String)"gui.adventure_inventory_screen.spells_label");
    private static final class_2561 TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF = class_2561.method_43471((String)"gui.adventureInventory.toggleShowAttributeScreenButton.off.tooltip");
    private static final class_2561 TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON = class_2561.method_43471((String)"gui.adventureInventory.toggleShowAttributeScreenButton.on.tooltip");
    private float mouseX;
    private float mouseY;
    private final int sidesBackgroundWidth = 130;
    private class_4185 toggleShowAttributeScreenButton;
    private boolean showAttributeScreen;
    private int attributeListSize = 0;
    private int oldEffectsListSize = 0;
    private List<class_1293> foodEffectsList = new ArrayList(Collections.emptyList());
    private List<class_1293> negativeEffectsList = new ArrayList(Collections.emptyList());
    private List<class_1293> positiveEffectsList = new ArrayList(Collections.emptyList());
    private List<class_1293> neutralEffectsList = new ArrayList(Collections.emptyList());
    private int attributeScrollPosition = 0;
    private int foodScrollPosition = 0;
    private int negativeScrollPosition = 0;
    private int positiveScrollPosition = 0;
    private int neutralScrollPosition = 0;
    private int foodEffectsRowAmount = 1;
    private int negativeEffectsRowAmount = 1;
    private int positiveEffectsRowAmount = 1;
    private int neutralEffectsRowAmount = 1;
    private float attributeScrollAmount = 0.0f;
    private float foodScrollAmount = 0.0f;
    private float negativeScrollAmount = 0.0f;
    private float positiveScrollAmount = 0.0f;
    private float neutralScrollAmount = 0.0f;
    private boolean foodMouseClicked = false;
    private boolean attributeMouseClicked = false;
    private boolean negativeMouseClicked = false;
    private boolean positiveMouseClicked = false;
    private boolean neutralMouseClicked = false;

    public RPGInventoryScreen(class_1657 player) {
        super((class_1703)player.field_7498, player.method_31548(), (class_2561)class_2561.method_43471((String)"gui.adventure_inventory_screen.equipment_label"));
        this.field_2792 = 176;
        this.field_2779 = 220;
        this.field_25267 = 8;
        this.field_25268 = 6;
        this.field_25269 = 8;
        this.field_25270 = this.field_2779 - 93;
    }

    public void method_37432() {
        TrinketScreenManager.tick();
    }

    private void updateEffectsLists(class_1657 player) {
        List effectsList = Ordering.natural().sortedCopy((Iterable)player.method_6026());
        ArrayList visibleEffectsList = new ArrayList(Collections.emptyList());
        for (class_1293 statusEffectInstance : effectsList) {
            if (!statusEffectInstance.method_5592()) continue;
            visibleEffectsList.add(statusEffectInstance);
        }
        int visibleEffectsListSize = visibleEffectsList.size();
        if (visibleEffectsListSize == 0) {
            this.oldEffectsListSize = 0;
            this.foodEffectsList.clear();
            this.negativeEffectsList.clear();
            this.positiveEffectsList.clear();
            this.neutralEffectsList.clear();
            return;
        }
        boolean bl = false;
        if (visibleEffectsListSize != this.oldEffectsListSize) {
            bl = true;
            this.oldEffectsListSize = visibleEffectsListSize;
        }
        if (bl) {
            this.foodEffectsList.clear();
            this.negativeEffectsList.clear();
            this.positiveEffectsList.clear();
            this.neutralEffectsList.clear();
            this.foodScrollPosition = 0;
            this.negativeScrollPosition = 0;
            this.positiveScrollPosition = 0;
            this.neutralScrollPosition = 0;
            this.foodScrollAmount = 0.0f;
            this.negativeScrollAmount = 0.0f;
            this.positiveScrollAmount = 0.0f;
            this.neutralScrollAmount = 0.0f;
            for (class_1293 statusEffectInstance : visibleEffectsList) {
                if (RPGInventory.isFoodOverhaulLoaded && statusEffectInstance.method_5579() instanceof FoodStatusEffect) {
                    this.foodEffectsList.add(statusEffectInstance);
                    continue;
                }
                if (statusEffectInstance.method_5579().method_18792() == class_4081.field_18272) {
                    this.negativeEffectsList.add(statusEffectInstance);
                    continue;
                }
                if (statusEffectInstance.method_5579().method_18792() == class_4081.field_18271) {
                    this.positiveEffectsList.add(statusEffectInstance);
                    continue;
                }
                if (statusEffectInstance.method_5579().method_18792() != class_4081.field_18273) continue;
                this.neutralEffectsList.add(statusEffectInstance);
            }
            this.foodEffectsRowAmount = Math.max(1, this.calculateStatusEffectRowAmount(this.foodEffectsList.size()));
            this.negativeEffectsRowAmount = Math.max(1, this.calculateStatusEffectRowAmount(this.negativeEffectsList.size()));
            this.positiveEffectsRowAmount = Math.max(1, this.calculateStatusEffectRowAmount(this.positiveEffectsList.size()));
            this.neutralEffectsRowAmount = Math.max(1, this.calculateStatusEffectRowAmount(this.neutralEffectsList.size()));
        }
        visibleEffectsList.clear();
    }

    private int calculateStatusEffectRowAmount(int statusEffectListSize) {
        return statusEffectListSize / 3 + (statusEffectListSize % 3 > 0 ? 1 : 0);
    }

    private void toggleShowAttributeScreen() {
        this.showAttributeScreen = !this.showAttributeScreen;
        ((ToggleInventoryScreenWidget)this.toggleShowAttributeScreenButton).setIsPressed(this.showAttributeScreen);
        this.toggleShowAttributeScreenButton.method_47400(this.showAttributeScreen ? class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON) : class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF));
        ((DuckPlayerScreenHandlerMixin)this.field_2797).rpginventory$setIsAttributeScreenVisible(this.showAttributeScreen);
    }

    protected void method_25426() {
        TrinketScreenManager.init((TrinketScreen)this);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (this.field_22787.field_1761 != null && this.field_22787.field_1761.method_2914()) {
                this.field_22787.method_1507((class_437)new class_481((class_1657)this.field_22787.field_1724, this.field_22787.field_1724.field_3944.method_45735(), ((Boolean)this.field_22787.field_1690.method_47395().method_41753()).booleanValue()));
                return;
            }
            ((SlotCustomization)((class_1723)this.field_2797).field_7761.get(45)).slotcustomizationapi$setDisabledOverride(((DuckPlayerEntityMixin)this.field_22787.field_1724).rpginventory$isOffhandStackSheathed());
        }
        super.method_25426();
        this.showAttributeScreen = RPGInventoryClient.clientConfig.show_attribute_screen_when_opening_inventory_screen;
        ((DuckPlayerScreenHandlerMixin)this.field_2797).rpginventory$setIsAttributeScreenVisible(this.showAttributeScreen);
        this.toggleShowAttributeScreenButton = (class_4185)this.method_37063((class_364)new ToggleInventoryScreenWidget(this.field_2776 + 6, this.field_2800 + 19, this.showAttributeScreen, button -> this.toggleShowAttributeScreen()));
        this.toggleShowAttributeScreenButton.method_47400(class_7919.method_47407((class_2561)(this.showAttributeScreen ? TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON : TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF)));
    }

    protected void method_2380(class_332 context, int x, int y) {
        DuckSlotMixin slotWithTooltip;
        List<class_2561> list;
        class_1735 class_17352;
        super.method_2380(context, x, y);
        if (RPGInventoryClient.clientConfig.show_slot_tooltips && ((class_1723)this.field_2797).method_34255().method_7960() && this.field_2787 != null && !this.field_2787.method_7681() && (class_17352 = this.field_2787) instanceof DuckSlotMixin && !(list = (slotWithTooltip = (DuckSlotMixin)class_17352).rpginventory$getSlotTooltipText()).isEmpty()) {
            context.method_51437(this.field_22793, list, Optional.empty(), x, y);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        TrinketScreenManager.update((float)mouseX, (float)mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawStatusEffects(context, mouseX, mouseY);
        this.drawAttributeScreen(context, mouseX, mouseY);
        this.method_2380(context, mouseX, mouseY);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        super.method_2388(context, mouseX, mouseY);
        TrinketScreenManager.drawActiveGroup((class_332)context);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int i = this.field_2776;
        int j = this.field_2800;
        int activeSpellSlotAmount = 0;
        ServerConfig serverConfig = RPGInventory.serverConfig;
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            activeSpellSlotAmount = (int)((DuckPlayerEntityMixin)this.field_22787.field_1724).rpginventory$getActiveSpellSlotAmount();
            this.updateEffectsLists((class_1657)this.field_22787.field_1724);
        }
        context.method_25290(RPGInventory.identifier("textures/gui/container/adventure_inventory/adventure_inventory_main_background.png"), i, j, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        if (!serverConfig.disable_inventory_crafting_slots) {
            context.method_51439(this.field_22793, CRAFTING_LABEL_TEXT, i + serverConfig.inventory_crafting_slots_x_offset, j + serverConfig.inventory_crafting_slots_y_offset - 11, 0x404040, false);
            context.method_25290(RPGInventory.identifier("textures/gui/container/adventure_inventory/adventure_inventory_crafting_background.png"), i + serverConfig.inventory_crafting_slots_x_offset - 1, j + serverConfig.inventory_crafting_slots_y_offset - 1, 0.0f, 0.0f, 74, 36, 74, 36);
        }
        if (activeSpellSlotAmount > 0) {
            context.method_51439(this.field_22793, SPELLS_LABEL_TEXT, i + serverConfig.spell_slots_x_offset, j + serverConfig.spell_slots_y_offset - 11, 0x404040, false);
            int width = activeSpellSlotAmount < 5 ? activeSpellSlotAmount % 5 * 18 : 72;
            int height = activeSpellSlotAmount < 5 ? 18 : 36;
            context.method_25290(RPGInventory.identifier("textures/gui/container/adventure_inventory/adventure_inventory_spells_background_" + activeSpellSlotAmount + ".png"), i + serverConfig.spell_slots_x_offset - 1, j + serverConfig.spell_slots_y_offset - 1, 0.0f, 0.0f, width, height, width, height);
        }
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.belts_group_x_offset - 1, j + serverConfig.belts_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.shoulders_group_x_offset - 1, j + serverConfig.shoulders_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.necklaces_group_x_offset - 1, j + serverConfig.necklaces_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.rings_1_group_x_offset - 1, j + serverConfig.rings_1_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.rings_2_group_x_offset - 1, j + serverConfig.rings_2_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.gloves_group_x_offset - 1, j + serverConfig.gloves_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.hand_group_x_offset - 1, j + serverConfig.hand_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.alternative_hand_group_x_offset - 1, j + serverConfig.alternative_hand_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_25290(INVENTORY_SLOT_TEXTURE, i + serverConfig.alternative_offhand_group_x_offset - 1, j + serverConfig.alternative_offhand_group_y_offset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        if (this.showAttributeScreen) {
            context.method_25290(ADVENTURE_INVENTORY_SIDES_BACKGROUND_TEXTURE, i - this.sidesBackgroundWidth, j, 0.0f, 0.0f, this.sidesBackgroundWidth, this.field_2779, this.sidesBackgroundWidth, this.field_2779);
        }
        if (this.oldEffectsListSize > 0) {
            context.method_25290(ADVENTURE_INVENTORY_SIDES_BACKGROUND_TEXTURE, i + this.field_2792, j, 0.0f, 0.0f, this.sidesBackgroundWidth, this.field_2779, this.sidesBackgroundWidth, this.field_2779);
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_490.method_2486((class_332)context, (int)(i + 51), (int)(j + 103), (int)30, (float)((float)(i + 51) - this.mouseX), (float)((float)(j + 103 - 50) - this.mouseY), (class_1309)this.field_22787.field_1724);
        }
        TrinketScreenManager.drawExtraGroups((class_332)context);
    }

    private void drawAttributeScreen(class_332 context, int mouseX, int mouseY) {
        if (!this.showAttributeScreen) {
            return;
        }
        int x = this.field_2776 - this.sidesBackgroundWidth + 7;
        int y = this.field_2800 + 7;
        List<class_2561> list = this.getAttributeList();
        this.attributeListSize = list.size();
        for (int i = this.attributeScrollPosition; i < Math.min(this.attributeListSize, this.attributeScrollPosition + 15); ++i) {
            context.method_51439(this.field_22793, list.get(i), x, y + (i - this.attributeScrollPosition) * 13, 0x404040, false);
        }
        if (list.size() > 15) {
            context.method_25290(SCROLL_BAR_BACKGROUND_8_206_TEXTURE, x + 108, y, 0.0f, 0.0f, 8, 206, 8, 206);
            int k = (int)(189.0f * this.attributeScrollAmount);
            context.method_25290(SCROLLER_VERTICAL_6_15_TEXTURE, x + 109, y + 1 + k, 0.0f, 0.0f, 6, 15, 6, 15);
        }
    }

    private void drawStatusEffects(class_332 context, int mouseX, int mouseY) {
        int k;
        int i = this.field_2776 + this.field_2792 + 7;
        int j = this.field_2800 + 7;
        if (this.oldEffectsListSize > 0) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.adventureInventory.status_effects"), i + 1, j, 0x404040, false);
        }
        j += 13;
        if (!this.foodEffectsList.isEmpty()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.adventureInventory.status_effects.food_effects"), i + 1, j, 0x404040, false);
            j += 13;
            for (k = 3 * this.foodScrollPosition; k < Math.min(this.foodEffectsList.size(), 3 * (1 + this.foodScrollPosition)); ++k) {
                this.drawStatusEffectTexturesAndToolTips(context, i, j, k, mouseX, mouseY, this.foodEffectsList.get(k));
            }
            if (this.foodEffectsRowAmount > 1) {
                context.method_25290(SCROLL_BAR_BACKGROUND_8_32_TEXTURE, i + 109, j, 0.0f, 0.0f, 8, 32, 8, 32);
                k = (int)(23.0f * this.foodScrollAmount);
                context.method_25290(SCROLLER_VERTICAL_6_7_TEXTURE, i + 110, j + 1 + k, 0.0f, 0.0f, 6, 7, 6, 7);
            }
            j += 37;
        } else {
            j += 50;
        }
        if (!this.negativeEffectsList.isEmpty()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.adventureInventory.status_effects.negative_effects"), i + 1, j, 0x404040, false);
            j += 13;
            for (k = 3 * this.negativeScrollPosition; k < Math.min(this.negativeEffectsList.size(), 3 * (1 + this.negativeScrollPosition)); ++k) {
                this.drawStatusEffectTexturesAndToolTips(context, i, j, k, mouseX, mouseY, this.negativeEffectsList.get(k));
            }
            if (this.negativeEffectsRowAmount > 1) {
                context.method_25290(SCROLL_BAR_BACKGROUND_8_32_TEXTURE, i + 109, j, 0.0f, 0.0f, 8, 32, 8, 32);
                k = (int)(23.0f * this.negativeScrollAmount);
                context.method_25290(SCROLLER_VERTICAL_6_7_TEXTURE, i + 110, j + 1 + k, 0.0f, 0.0f, 6, 7, 6, 7);
            }
            j += 37;
        } else {
            j += 50;
        }
        if (!this.positiveEffectsList.isEmpty()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.adventureInventory.status_effects.positive_effects"), i + 1, j, 0x404040, false);
            j += 13;
            for (k = 3 * this.positiveScrollPosition; k < Math.min(this.positiveEffectsList.size(), 3 * (1 + this.positiveScrollPosition)); ++k) {
                this.drawStatusEffectTexturesAndToolTips(context, i, j, k, mouseX, mouseY, this.positiveEffectsList.get(k));
            }
            if (this.positiveEffectsRowAmount > 1) {
                context.method_25290(SCROLL_BAR_BACKGROUND_8_32_TEXTURE, i + 109, j, 0.0f, 0.0f, 8, 32, 8, 32);
                k = (int)(23.0f * this.positiveScrollAmount);
                context.method_25290(SCROLLER_VERTICAL_6_7_TEXTURE, i + 110, j + 1 + k, 0.0f, 0.0f, 6, 7, 6, 7);
            }
            j += 37;
        } else {
            j += 50;
        }
        if (!this.neutralEffectsList.isEmpty()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.adventureInventory.status_effects.neutral_effects"), i + 1, j, 0x404040, false);
            j += 13;
            for (k = 3 * this.neutralScrollPosition; k < Math.min(this.neutralEffectsList.size(), 3 * (1 + this.neutralScrollPosition)); ++k) {
                this.drawStatusEffectTexturesAndToolTips(context, i, j, k, mouseX, mouseY, this.neutralEffectsList.get(k));
            }
            if (this.neutralEffectsRowAmount > 1) {
                context.method_25290(SCROLL_BAR_BACKGROUND_8_32_TEXTURE, i + 109, j, 0.0f, 0.0f, 8, 32, 8, 32);
                k = (int)(23.0f * this.neutralScrollAmount);
                context.method_25290(SCROLLER_VERTICAL_6_7_TEXTURE, i + 110, j + 1 + k, 0.0f, 0.0f, 6, 7, 6, 7);
            }
        }
    }

    private void drawStatusEffectTexturesAndToolTips(class_332 context, int x, int y, int z, int mouseX, int mouseY, class_1293 statusEffectInstance) {
        if (this.field_22787 != null) {
            class_4074 statusEffectSpriteManager = this.field_22787.method_18505();
            int i = x + 3 + z % 3 * 35;
            context.method_25302(field_2801, i, y, 0, 198, 32, 32);
            class_1058 sprite = statusEffectSpriteManager.method_18663(statusEffectInstance.method_5579());
            context.method_25298(i + 7, y + 7, 0, 18, 18, sprite);
            if (mouseX >= i && mouseX <= i + 32 && mouseY >= y && mouseY <= y + 32) {
                List<class_2561> list = this.getStatusEffectTooltip(statusEffectInstance);
                context.method_51437(this.field_22793, list, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private List<class_2561> getStatusEffectTooltip(class_1293 statusEffectInstance) {
        class_2561 description;
        ArrayList<class_2561> list = new ArrayList<class_2561>(List.of(this.getStatusEffectName(statusEffectInstance)));
        if (!statusEffectInstance.method_48559()) {
            list.add(class_1292.method_5577((class_1293)statusEffectInstance, (float)1.0f));
        }
        if (!(description = this.getStatusEffectDescription(statusEffectInstance)).getString().isEmpty()) {
            list.add(description);
        }
        return list;
    }

    private class_2561 getStatusEffectName(class_1293 statusEffectInstance) {
        class_5250 mutableText = statusEffectInstance.method_5579().method_5560().method_27661();
        if (statusEffectInstance.method_5578() >= 1 && statusEffectInstance.method_5578() <= 9) {
            mutableText.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (statusEffectInstance.method_5578() + 1))));
        }
        return mutableText;
    }

    private class_2561 getStatusEffectDescription(class_1293 statusEffectInstance) {
        String translationKey = statusEffectInstance.method_5579().method_5567() + ".description";
        class_5250 description = class_2561.method_43471((String)translationKey);
        if (description.getString().equals(translationKey)) {
            description = class_2561.method_43473();
        }
        return description;
    }

    private List<class_2561> getAttributeList() {
        String[] attribute_screen_configuration = RPGInventoryClient.clientConfig.attribute_screen_configuration;
        ArrayList<class_2561> list = new ArrayList<class_2561>(List.of());
        class_746 player = null;
        if (this.field_22787 != null) {
            player = this.field_22787.field_1724;
        }
        if (player == null) {
            return list;
        }
        for (String string : attribute_screen_configuration) {
            class_5250 mutableText;
            String[] stringArray = string.split(":");
            if (stringArray.length == 1) {
                if (!stringArray[0].equals("EMPTY_LINE")) continue;
                list.add((class_2561)class_2561.method_43473());
                continue;
            }
            if (stringArray.length == 2) {
                if (stringArray[0].equals("TRANSLATABLE_STRING")) {
                    list.add((class_2561)class_2561.method_43471((String)stringArray[1]));
                    continue;
                }
                if (!stringArray[0].equals("STRING")) continue;
                list.add(class_2561.method_30163((String)stringArray[1]));
                continue;
            }
            if (stringArray.length == 3) {
                class_2960 attributeId;
                class_1320 attribute;
                if (!stringArray[0].equals("ATTRIBUTE_VALUE") || (attribute = (class_1320)class_7923.field_41190.method_10223(attributeId = class_2960.method_43902((String)stringArray[1], (String)stringArray[2]))) == null || !player.method_6127().method_27306(attribute)) continue;
                class_5250 mutableText2 = class_2561.method_43471((String)attribute.method_26830());
                mutableText2.method_10852(class_2561.method_30163((String)": "));
                mutableText2.method_10852(class_2561.method_30163((String)Double.toString(player.method_26825(attribute))));
                list.add((class_2561)mutableText2);
                continue;
            }
            if (stringArray.length == 4) {
                if (!stringArray[0].equals("CUSTOM_ATTRIBUTE_VALUE")) continue;
                mutableText = class_2561.method_43471((String)stringArray[1]);
                class_2960 attributeId = class_2960.method_43902((String)stringArray[2], (String)stringArray[3]);
                class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(attributeId);
                if (attribute == null || !player.method_6127().method_27306(attribute)) continue;
                mutableText.method_10852(class_2561.method_30163((String)Double.toString(player.method_26825(attribute))));
                list.add((class_2561)mutableText);
                continue;
            }
            if (stringArray.length != 6 || !stringArray[0].equals("ATTRIBUTE_RELATION")) continue;
            mutableText = class_2561.method_43471((String)stringArray[1]);
            class_2960 firstAttributeId = class_2960.method_43902((String)stringArray[2], (String)stringArray[3]);
            class_2960 secondAttributeId = class_2960.method_43902((String)stringArray[4], (String)stringArray[5]);
            class_1320 firstAttribute = (class_1320)class_7923.field_41190.method_10223(firstAttributeId);
            class_1320 secondAttribute = (class_1320)class_7923.field_41190.method_10223(secondAttributeId);
            if (firstAttribute == null || secondAttribute == null || !player.method_6127().method_27306(firstAttribute) || !player.method_6127().method_27306(secondAttribute)) continue;
            mutableText.method_10852(class_2561.method_30163((String)Double.toString(player.method_26825(firstAttribute))));
            mutableText.method_10852(class_2561.method_30163((String)"/"));
            mutableText.method_10852(class_2561.method_30163((String)Double.toString(player.method_26825(secondAttribute))));
            list.add((class_2561)mutableText);
        }
        return list;
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        return super.method_2381(mouseX, mouseY, left, top, button) && !TrinketScreenManager.isClickInsideTrinketBounds((double)mouseX, (double)mouseY);
    }

    public void method_25410(class_310 client, int width, int height) {
        boolean bool = this.showAttributeScreen;
        int number = this.attributeScrollPosition;
        int number1 = this.foodScrollPosition;
        int number2 = this.negativeScrollPosition;
        int number3 = this.positiveScrollPosition;
        int number4 = this.neutralScrollPosition;
        float number5 = this.attributeScrollAmount;
        float number6 = this.foodScrollAmount;
        float number7 = this.negativeScrollAmount;
        float number8 = this.positiveScrollAmount;
        float number9 = this.neutralScrollAmount;
        this.method_25423(client, width, height);
        this.showAttributeScreen = bool;
        this.attributeScrollPosition = number;
        this.foodScrollPosition = number1;
        this.negativeScrollPosition = number2;
        this.positiveScrollPosition = number3;
        this.neutralScrollPosition = number4;
        this.attributeScrollAmount = number5;
        this.foodScrollAmount = number6;
        this.negativeScrollAmount = number7;
        this.positiveScrollAmount = number8;
        this.neutralScrollAmount = number9;
        ((ToggleInventoryScreenWidget)this.toggleShowAttributeScreenButton).setIsPressed(this.showAttributeScreen);
        this.toggleShowAttributeScreenButton.method_47400(this.showAttributeScreen ? class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON) : class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int j;
        this.attributeMouseClicked = false;
        this.foodMouseClicked = false;
        this.negativeMouseClicked = false;
        this.positiveMouseClicked = false;
        this.neutralMouseClicked = false;
        int i = this.field_2776 + this.field_2792 + this.sidesBackgroundWidth - 15;
        if (this.foodEffectsRowAmount > 1) {
            j = this.field_2800 + 34;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 30)) {
                this.foodMouseClicked = true;
            }
        }
        if (this.negativeEffectsRowAmount > 1) {
            j = this.field_2800 + 84;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 30)) {
                this.negativeMouseClicked = true;
            }
        }
        if (this.positiveEffectsRowAmount > 1) {
            j = this.field_2800 + 134;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 30)) {
                this.positiveMouseClicked = true;
            }
        }
        if (this.neutralEffectsRowAmount > 1) {
            j = this.field_2800 + 184;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 30)) {
                this.neutralMouseClicked = true;
            }
        }
        if (this.attributeListSize > 15 && this.showAttributeScreen) {
            i = this.field_2776 - 13;
            j = this.field_2800 + 7;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 206)) {
                this.attributeMouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float f;
        int i;
        if (this.foodEffectsRowAmount > 1 && this.foodMouseClicked) {
            i = this.foodEffectsRowAmount - 1;
            f = (float)deltaY / (float)i;
            this.foodScrollAmount = class_3532.method_15363((float)(this.foodScrollAmount + f), (float)0.0f, (float)1.0f);
            this.foodScrollPosition = (int)(this.foodScrollAmount * (float)i);
        }
        if (this.negativeEffectsRowAmount > 1 && this.negativeMouseClicked) {
            i = this.negativeEffectsRowAmount - 1;
            f = (float)deltaY / (float)i;
            this.negativeScrollAmount = class_3532.method_15363((float)(this.negativeScrollAmount + f), (float)0.0f, (float)1.0f);
            this.negativeScrollPosition = (int)(this.negativeScrollAmount * (float)i);
        }
        if (this.positiveEffectsRowAmount > 1 && this.positiveMouseClicked) {
            i = this.positiveEffectsRowAmount - 1;
            f = (float)deltaY / (float)i;
            this.positiveScrollAmount = class_3532.method_15363((float)(this.positiveScrollAmount + f), (float)0.0f, (float)1.0f);
            this.positiveScrollPosition = (int)(this.positiveScrollAmount * (float)i);
        }
        if (this.neutralEffectsRowAmount > 1 && this.neutralMouseClicked) {
            i = this.neutralEffectsRowAmount - 1;
            f = (float)deltaY / (float)i;
            this.neutralScrollAmount = class_3532.method_15363((float)(this.neutralScrollAmount + f), (float)0.0f, (float)1.0f);
            this.neutralScrollPosition = (int)(this.neutralScrollAmount * (float)i);
        }
        if (this.attributeListSize > 15 && this.attributeMouseClicked && this.showAttributeScreen) {
            i = this.attributeListSize - 15;
            f = (float)deltaY / (float)i;
            this.attributeScrollAmount = class_3532.method_15363((float)(this.attributeScrollAmount + f), (float)0.0f, (float)1.0f);
            this.attributeScrollPosition = (int)(this.attributeScrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        float f;
        int i;
        int scrollAreaStartX = this.field_2776 + this.field_2792 + 7;
        int scrollAreaWidth = 119;
        int scrollAreaStartY = this.field_2800 + 33;
        int scrollAreaHeight = 32;
        if (this.foodEffectsRowAmount > 1 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            i = this.foodEffectsRowAmount - 1;
            f = (float)verticalAmount / (float)i;
            this.foodScrollAmount = class_3532.method_15363((float)(this.foodScrollAmount - f), (float)0.0f, (float)1.0f);
            this.foodScrollPosition = (int)(this.foodScrollAmount * (float)i);
        }
        scrollAreaStartY = this.field_2800 + 83;
        if (this.negativeEffectsRowAmount > 1 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            i = this.negativeEffectsRowAmount - 1;
            f = (float)verticalAmount / (float)i;
            this.negativeScrollAmount = class_3532.method_15363((float)(this.negativeScrollAmount - f), (float)0.0f, (float)1.0f);
            this.negativeScrollPosition = (int)(this.negativeScrollAmount * (float)i);
        }
        scrollAreaStartY = this.field_2800 + 133;
        if (this.positiveEffectsRowAmount > 1 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            i = this.positiveEffectsRowAmount - 1;
            f = (float)verticalAmount / (float)i;
            this.positiveScrollAmount = class_3532.method_15363((float)(this.positiveScrollAmount - f), (float)0.0f, (float)1.0f);
            this.positiveScrollPosition = (int)(this.positiveScrollAmount * (float)i);
        }
        scrollAreaStartY = this.field_2800 + 183;
        if (this.neutralEffectsRowAmount > 1 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            i = this.neutralEffectsRowAmount - 1;
            f = (float)verticalAmount / (float)i;
            this.neutralScrollAmount = class_3532.method_15363((float)(this.neutralScrollAmount - f), (float)0.0f, (float)1.0f);
            this.neutralScrollPosition = (int)(this.neutralScrollAmount * (float)i);
        }
        scrollAreaStartX = this.field_2776 - this.sidesBackgroundWidth + 7;
        scrollAreaWidth = 116;
        scrollAreaStartY = this.field_2800 + 7;
        scrollAreaHeight = 206;
        if (this.attributeListSize > 15 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            i = this.attributeListSize - 15;
            f = (float)verticalAmount / (float)i;
            this.attributeScrollAmount = class_3532.method_15363((float)(this.attributeScrollAmount - f), (float)0.0f, (float)1.0f);
            this.attributeScrollPosition = (int)(this.attributeScrollAmount * (float)i);
        }
        return true;
    }

    public TrinketPlayerScreenHandler trinkets$getHandler() {
        return (TrinketPlayerScreenHandler)this.field_2797;
    }

    public class_768 trinkets$getGroupRect(SlotGroup group) {
        Point pos = ((TrinketPlayerScreenHandler)this.field_2797).trinkets$getGroupPos(group);
        if (pos != null) {
            return new class_768(pos.x() - 1, pos.y() - 1, 17, 17);
        }
        return new class_768(0, 0, 0, 0);
    }

    public class_1735 trinkets$getFocusedSlot() {
        return this.field_2787;
    }

    public int trinkets$getX() {
        return this.field_2776;
    }

    public int trinkets$getY() {
        return this.field_2800;
    }

    public boolean trinkets$isRecipeBookOpen() {
        return this.showAttributeScreen;
    }
}

