/*
 * Decompiled with CFR 0.152.
 */
package net.rewardz.mixin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.rewardz.access.RewardPlayerAccess;
import net.rewardz.util.RewardHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements RewardPlayerAccess {
    @Unique
    private int currentMonth = 0;
    @Unique
    private int currentDay = 0;
    @Unique
    private int rewardDayCount = 0;
    @Unique
    private Set<Integer> usedRewardDaySet = new HashSet<Integer>();

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.currentMonth = nbt.method_10550("RewardMonth");
        this.currentDay = nbt.method_10550("RewardDay");
        this.rewardDayCount = nbt.method_10550("RewardDayCount");
        this.usedRewardDaySet.clear();
        for (int value : nbt.method_10561("UsedRewardDayList")) {
            this.usedRewardDaySet.add(value);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        nbt.method_10569("RewardMonth", this.currentMonth);
        nbt.method_10569("RewardDay", this.currentDay);
        nbt.method_10569("RewardDayCount", this.rewardDayCount);
        nbt.method_10572("UsedRewardDayList", new ArrayList<Integer>(this.usedRewardDaySet));
    }

    @Override
    public void increaseRewardDay() {
        if (this.currentMonth != RewardHelper.getMonth()) {
            this.currentMonth = RewardHelper.getMonth();
            this.currentDay = RewardHelper.getDay();
            this.rewardDayCount = 1;
            this.usedRewardDaySet.clear();
        } else if (this.currentDay != RewardHelper.getDay()) {
            this.currentDay = RewardHelper.getDay();
            ++this.rewardDayCount;
        }
    }

    @Override
    public int getRewardDayCount() {
        return this.rewardDayCount;
    }

    @Override
    public void setRewardDayCount(int count) {
        this.rewardDayCount = count;
    }

    @Override
    public void addUsedRewardDay(int day) {
        this.usedRewardDaySet.add(day);
    }

    @Override
    public Set<Integer> getUsedRewardDays() {
        return this.usedRewardDaySet;
    }

    @Override
    public void setUsedRewardDays(Set<Integer> set) {
        this.usedRewardDaySet.clear();
        this.usedRewardDaySet.addAll(set);
    }
}

