/*
 * Decompiled with CFR 0.152.
 */
package net.rewardz.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.rewardz.RewardzMain;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardsDataLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"RewardZ");

    public class_2960 getFabricId() {
        return new class_2960("rewards", "rewards_loader");
    }

    public void method_14491(class_3300 resourceManager) {
        resourceManager.method_14488("rewards", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (int i = 1; i <= 12; ++i) {
                    HashMap monthMap = new HashMap();
                    if (data.has("month_" + i)) {
                        JsonObject jsonMonthObject = data.get("month_" + i).getAsJsonObject();
                        for (int u = 1; u <= 31; ++u) {
                            if (!jsonMonthObject.has("day_" + u)) continue;
                            ArrayList<Object> dayList = new ArrayList<Object>();
                            JsonObject jsonDayObject = jsonMonthObject.get("day_" + u).getAsJsonObject();
                            boolean exact = false;
                            if (jsonDayObject.has("exact")) {
                                exact = jsonDayObject.get("exact").getAsBoolean();
                            }
                            dayList.add(exact);
                            JsonObject jsonItemObject = jsonDayObject.get("item").getAsJsonObject();
                            class_1799 itemStack = ((class_1792)class_7923.field_41178.method_10223(new class_2960(jsonItemObject.get("item").getAsString()))).method_7854();
                            itemStack.method_7939(jsonItemObject.get("count").getAsInt());
                            if (jsonItemObject.has("nbt") && !jsonItemObject.get("nbt").isJsonNull()) {
                                try {
                                    class_2487 nbtCompound = class_2522.method_10718((String)jsonItemObject.get("nbt").getAsString());
                                    itemStack.method_7980(nbtCompound);
                                }
                                catch (CommandSyntaxException commandSyntaxException) {
                                    throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
                                }
                            }
                            dayList.add(itemStack);
                            if (jsonDayObject.has("tooltip")) {
                                dayList.add(jsonDayObject.get("tooltip").getAsJsonArray().size());
                                for (int j = 0; j < jsonDayObject.get("tooltip").getAsJsonArray().size(); ++j) {
                                    dayList.add(jsonDayObject.get("tooltip").getAsJsonArray().get(j).getAsString());
                                }
                            } else {
                                dayList.add(0);
                            }
                            if (jsonDayObject.has("commands")) {
                                dayList.add(jsonDayObject.get("commands").getAsJsonArray().size());
                                for (int j = 0; j < jsonDayObject.get("commands").getAsJsonArray().size(); ++j) {
                                    dayList.add(jsonDayObject.get("commands").getAsJsonArray().get(j).getAsString());
                                }
                            } else {
                                dayList.add(0);
                            }
                            monthMap.put(u, dayList);
                        }
                    }
                    RewardzMain.REWARD_MAP.put(i, monthMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }
}

