/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tocraft.skinshifter.SkinShifter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.RemorphedHelpScreen;
import tocraft.remorphed.screen.widget.EntityWidget;
import tocraft.remorphed.screen.widget.PlayerWidget;
import tocraft.remorphed.screen.widget.SearchWidget;
import tocraft.remorphed.screen.widget.ShapeWidget;
import tocraft.remorphed.screen.widget.SkinWidget;
import tocraft.remorphed.screen.widget.SpecialShapeWidget;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

@Environment(value=EnvType.CLIENT)
public class RemorphedScreen
extends class_437 {
    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList();
    private final List<PlayerProfile> unlockedSkins = new CopyOnWriteArrayList<PlayerProfile>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new ConcurrentHashMap();
    private final Map<PlayerProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<PlayerProfile, FakeClientPlayer>();
    private final List<ShapeWidget> shapeWidgets = new CopyOnWriteArrayList<ShapeWidget>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final class_4185 helpButton = this.createHelpButton();
    private final class_4185 variantsButton = this.createVariantsButton();
    private final class_4185 traitsButton = this.createTraitsButton();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = this.createSpecialShapeButton();
    private String lastSearchContents = "";

    public RemorphedScreen() {
        super((class_2561)TComponent.literal((String)""));
        super.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
    }

    public void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        if (this.field_22787.field_1724 == null) {
            this.method_25419();
            return;
        }
        this.method_37063((class_364)this.searchBar);
        this.method_37063((class_364)this.helpButton);
        this.method_37063((class_364)this.variantsButton);
        this.method_37063((class_364)this.traitsButton);
        this.method_37063((class_364)this.playerButton);
        if (Walkers.hasSpecialShape((UUID)this.field_22787.field_1724.method_5667())) {
            this.method_37063((class_364)this.specialShapeButton);
        }
        if (Remorphed.CONFIG.loadMenuAsynchronous) {
            CompletableFuture.runAsync(this::instantiate);
        } else {
            this.instantiate();
        }
    }

    private void instantiate() {
        this.populateUnlockedRenderEntities((class_1657)this.field_22787.field_1724);
        ShapeType currentShape = ShapeType.from((class_1309)PlayerShape.getCurrentShape((class_1657)this.field_22787.field_1724));
        this.unlockedShapes.sort((first, second) -> {
            boolean secondIsFav;
            if (Objects.equals(first, currentShape)) {
                return -1;
            }
            if (Objects.equals(second, currentShape)) {
                return 1;
            }
            boolean firstIsFav = PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(first);
            if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(second))) {
                return 0;
            }
            if (firstIsFav) {
                return -1;
            }
            return 1;
        });
        if (!Remorphed.displayVariantsInMenu) {
            ArrayList newUnlocked = new ArrayList();
            for (ShapeType<?> shapeType : this.unlockedShapes) {
                if (!shapeType.equals((Object)currentShape) && newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) continue;
                newUnlocked.add(shapeType);
            }
            this.unlockedShapes.clear();
            this.unlockedShapes.addAll(newUnlocked);
        }
        if (Remorphed.foundSkinShifter) {
            this.populateUnlockedRenderPlayers((class_1657)this.field_22787.field_1724);
            UUID currentSkin = SkinShifter.getCurrentSkin((class_1657)this.field_22787.field_1724);
            this.unlockedSkins.sort((first, second) -> {
                boolean secondIsFav;
                if (Objects.equals(first.id(), currentSkin) && currentShape != null) {
                    return -1;
                }
                if (Objects.equals(second.id(), currentSkin) && currentShape != null) {
                    return 1;
                }
                boolean firstIsFav = PlayerMorph.getFavoriteSkinIds((class_1657)this.field_22787.field_1724).contains(first.id());
                if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteSkinIds((class_1657)this.field_22787.field_1724).contains(second.id()))) {
                    return first.name().compareTo(second.name());
                }
                if (firstIsFav) {
                    return -1;
                }
                return 1;
            });
        }
        this.populateShapeWidgets(this.unlockedShapes, this.unlockedSkins);
        this.searchBar.method_1863(text -> {
            this.method_25395((class_364)this.searchBar);
            if (!this.lastSearchContents.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(button -> button instanceof EntityWidget);
                this.method_25396().removeIf(button -> button instanceof EntityWidget);
                List<ShapeType<?>> filteredShapes = this.unlockedShapes.stream().filter(type -> text.isEmpty() || ShapeType.createTooltipText((class_1309)this.renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || class_1299.method_5890((class_1299)type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase())).toList();
                List<PlayerProfile> filteredSkins = this.unlockedSkins.stream().filter(skin -> text.isEmpty() || skin.name().toUpperCase().contains(text.toUpperCase()) || skin.id().toString().contains(text.toUpperCase())).toList();
                this.populateShapeWidgets(filteredShapes, filteredSkins);
            }
            this.lastSearchContents = text;
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        this.searchBar.method_25394(context, mouseX, mouseY, delta);
        this.helpButton.method_25394(context, mouseX, mouseY, delta);
        this.variantsButton.method_25394(context, mouseX, mouseY, delta);
        this.traitsButton.method_25394(context, mouseX, mouseY, delta);
        this.playerButton.method_25394(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape((UUID)this.field_22787.field_1724.method_5667())) {
            this.specialShapeButton.method_25394(context, mouseX, mouseY, delta);
        }
        double scaledFactor = this.field_22787.method_22683().method_4495();
        int top = 35;
        context.method_51448().method_22903();
        RenderSystem.enableScissor((int)((int)(0.0 * scaledFactor)), (int)((int)(0.0 * scaledFactor)), (int)((int)((double)this.field_22789 * scaledFactor)), (int)((int)((double)(this.field_22790 - top) * scaledFactor)));
        for (ShapeWidget widget : this.shapeWidgets) {
            if (widget.method_46427() + widget.method_25364() <= top || widget.method_46427() >= this.getWindow().method_4502()) continue;
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        RenderSystem.disableScissor();
        context.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (!this.shapeWidgets.isEmpty()) {
            float firstPos = this.shapeWidgets.get(0).method_46427();
            ShapeWidget lastWidget = this.shapeWidgets.get(this.shapeWidgets.size() - 1);
            if (scrollY >= 0.0 && firstPos >= 35.0f || scrollY <= 0.0 && lastWidget.method_46427() <= this.getWindow().method_4502() - lastWidget.method_25364()) {
                return false;
            }
            for (class_6379 button : ((ScreenAccessor)((Object)this)).getSelectables()) {
                if (!(button instanceof ShapeWidget)) continue;
                ShapeWidget widget = (ShapeWidget)button;
                widget.method_48229(widget.method_46426(), (int)((double)widget.method_46427() + scrollY * 10.0));
            }
        }
        return false;
    }

    private void populateShapeWidgets(List<ShapeType<?>> rendered, List<PlayerProfile> skinProfiles) {
        this.shapeWidgets.clear();
        int x = 15;
        int y = 35;
        int rows = (int)Math.ceil((float)(rendered.size() + skinProfiles.size()) / 7.0f);
        ShapeType currentType = ShapeType.from((class_1309)PlayerShape.getCurrentShape((class_1657)this.field_22787.field_1724));
        for (int yIndex = 0; yIndex <= rows; ++yIndex) {
            for (int xIndex = 0; xIndex < 7; ++xIndex) {
                int listIndex = yIndex * 7 + xIndex;
                if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                    PlayerProfile skinProfile = skinProfiles.get(listIndex);
                    FakeClientPlayer fakePlayer = this.renderPlayers.get(skinProfile);
                    if (fakePlayer != null) {
                        SkinWidget skinWidget = new SkinWidget((float)(this.getWindow().method_4486() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().method_4502() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().method_4486() - 27) / 7.0f, (float)this.getWindow().method_4502() / 5.0f, skinProfile, new FakeClientPlayer(this.field_22787.field_1687, skinProfile), this, PlayerMorph.getFavoriteSkins((class_1657)this.field_22787.field_1724).contains(skinProfile), Objects.equals(SkinShifter.getCurrentSkin((class_1657)this.field_22787.field_1724), skinProfile.id()) && currentType == null);
                        this.method_37063((class_364)skinWidget);
                        this.shapeWidgets.add(skinWidget);
                        continue;
                    }
                    Remorphed.LOGGER.error("invalid skin profile: {}", (Object)skinProfile);
                    continue;
                }
                if (listIndex >= skinProfiles.size() + rendered.size()) continue;
                ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                class_1308 entity = this.renderEntities.get(type);
                if (entity != null) {
                    EntityWidget<class_1308> entityWidget = new EntityWidget<class_1308>((float)(this.getWindow().method_4486() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().method_4502() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().method_4486() - 27) / 7.0f, (float)this.getWindow().method_4502() / 5.0f, type, entity, this, PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(type), type.equals((Object)currentType));
                    this.method_37063((class_364)entityWidget);
                    this.shapeWidgets.add(entityWidget);
                    continue;
                }
                Remorphed.LOGGER.error("invalid shape type: {}", (Object)type.getEntityType().method_5882());
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(class_1657 player) {
        this.unlockedShapes.clear();
        this.renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            class_1309 entity = type.create((class_1937)class_310.method_1551().field_1687);
            if (!(entity instanceof class_1308)) continue;
            class_1308 living = (class_1308)entity;
            this.unlockedShapes.add(type);
            this.renderEntities.put(type, living);
        }
        Remorphed.LOGGER.info("Loaded {} entities for rendering", (Object)this.unlockedShapes.size());
    }

    public synchronized void populateUnlockedRenderPlayers(class_1657 player) {
        this.unlockedSkins.clear();
        this.renderPlayers.clear();
        List<PlayerProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (PlayerProfile profile : validUnlocked) {
            if (profile.id() == player.method_5667()) continue;
            FakeClientPlayer entity = new FakeClientPlayer(this.field_22787.field_1687, profile);
            this.unlockedSkins.add(profile);
            this.renderPlayers.put(profile, entity);
        }
        Remorphed.LOGGER.info("Loaded {} players for rendering", (Object)this.unlockedSkins.size());
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget((float)this.getWindow().method_4486() / 2.0f - (float)this.getWindow().method_4486() / 4.0f / 2.0f - 5.0f, 5.0f, (float)this.getWindow().method_4486() / 4.0f, 20.0f);
    }

    private class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"?"), widget -> class_310.method_1551().method_1507((class_437)new RemorphedHelpScreen()));
        int xOffset = Walkers.hasSpecialShape((UUID)class_310.method_1551().field_1724.method_5667()) ? 30 : 0;
        helpButton.method_46433((int)((float)this.getWindow().method_4486() / 2.0f + (float)this.getWindow().method_4486() / 8.0f + 35.0f + (float)xOffset), 5);
        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"remorphed.help")));
        return helpButton.method_46431();
    }

    private class_4185 createVariantsButton() {
        class_4185.class_7840 variantsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"remorphed.display_variants"), widget -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            class_310.method_1551().method_1507((class_437)new RemorphedScreen());
        });
        variantsButton.method_46433((int)((float)this.getWindow().method_4486() / 2.0f - (float)this.getWindow().method_4486() / 4.0f / 2.0f - 110.0f), 5);
        variantsButton.method_46437(100, 20);
        variantsButton.method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"remorphed.variants")));
        return variantsButton.method_46431();
    }

    private class_4185 createTraitsButton() {
        class_4185.class_7840 traitButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"remorphed.show_traits"), widget -> {
            Remorphed.displayTraitsInMenu = !Remorphed.displayTraitsInMenu;
        });
        int xOffset = Walkers.hasSpecialShape((UUID)class_310.method_1551().field_1724.method_5667()) ? 30 : 0;
        int xPos = (int)((float)this.getWindow().method_4486() / 2.0f + (float)this.getWindow().method_4486() / 8.0f + 65.0f + (float)xOffset);
        traitButton.method_46433(xPos, 5);
        traitButton.method_46437(Math.min(50, this.getWindow().method_4486() - xPos), 20);
        traitButton.method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"remorphed.traits")));
        return traitButton.method_46431();
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget((int)((float)this.getWindow().method_4486() / 2.0f + (float)this.getWindow().method_4486() / 8.0f + 5.0f), 5, 20, 20, this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget((int)((float)this.getWindow().method_4486() / 2.0f + (float)this.getWindow().method_4486() / 8.0f + 35.0f), 5, 20, 20, this);
    }

    private class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < 35.0) {
            return this.searchBar.method_25402(mouseX, mouseY, button) || this.helpButton.method_25402(mouseX, mouseY, button) || this.variantsButton.method_25402(mouseX, mouseY, button) || this.traitsButton.method_25402(mouseX, mouseY, button) || this.playerButton.method_25402(mouseX, mouseY, button) || this.specialShapeButton.method_25402(mouseX, mouseY, button);
        }
        for (ShapeWidget shapeWidget : this.shapeWidgets) {
            if (!shapeWidget.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395((class_364)shapeWidget);
            return true;
        }
        return false;
    }
}

