/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import dev.tocraft.skinshifter.SkinShifter;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class NetworkHandler {
    public static final class_2960 MORPH_REQUEST = Remorphed.id("morph_request");
    public static final class_2960 UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final class_2960 FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final class_2960 FAVORITE_UPDATE = Remorphed.id("favorite_update");
    public static final class_2960 RESET_SKIN = Remorphed.id("reset_skin");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)MORPH_REQUEST, NetworkHandler::handleMorphRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)RESET_SKIN, NetworkHandler::handleResetSkinPacket);
    }

    private static void handleResetSkinPacket(ModernNetworking.Context context, class_2487 data) {
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((class_3222)((class_3222)context.getPlayer()), null);
        }
    }

    public static void sendResetSkinPacket() {
        ModernNetworking.sendToServer((class_2960)RESET_SKIN, (class_2487)new class_2487());
    }

    public static <T extends class_1309> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        class_2487 compound = new class_2487();
        compound.method_10582("id", Walkers.getEntityTypeRegistry().method_10221((Object)type.getEntityType()).toString());
        compound.method_10569("variant", type.getVariantData());
        ModernNetworking.sendToServer((class_2960)MORPH_REQUEST, (class_2487)compound);
    }

    public static <T extends class_1309> void sendSwapSkinRequest(@NotNull PlayerProfile playerProfile) {
        class_2487 compound = new class_2487();
        compound.method_25927("playerUUID", playerProfile.id());
        ModernNetworking.sendToServer((class_2960)MORPH_REQUEST, (class_2487)compound);
    }

    private static void handleMorphRequestPacket(ModernNetworking.Context context, class_2487 compound) {
        context.getPlayer().method_5682().execute(() -> {
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().method_5667())) {
                context.getPlayer().method_7353((class_2561)TComponent.translatable((String)"walkers.player_blacklisted", (Object[])new Object[0]), true);
                return;
            }
            if (compound.method_10545("playerUUID") && Remorphed.foundSkinShifter) {
                UUID targetSkinUUID = compound.method_25926("playerUUID");
                SkinShifter.setSkin((class_3222)((class_3222)context.getPlayer()), (UUID)targetSkinUUID);
            } else {
                class_2960 typeId = Identifier.parse((String)compound.method_10558("id"));
                int typeVariant = compound.method_10550("variant");
                class_1299 eType = (class_1299)Walkers.getEntityTypeRegistry().method_10223(typeId);
                @Nullable ShapeType type = ShapeType.from((class_1299)eType, (int)typeVariant);
                boolean result = PlayerShapeChanger.change2ndShape((class_3222)((class_3222)context.getPlayer()), (ShapeType)type);
                if (result && type != null) {
                    PlayerShape.updateShapes((class_3222)((class_3222)context.getPlayer()), (class_1309)type.create(CEntity.level((class_1297)context.getPlayer())));
                }
                context.getPlayer().method_18382();
            }
        });
    }

    public static void sendFavoriteSync(class_3222 player) {
        Set<ShapeType<?>> favoriteShapes = PlayerMorph.getFavoriteShapes((class_1657)player);
        Set<UUID> favoriteSkins = PlayerMorph.getFavoriteSkinIds((class_1657)player);
        class_2487 tag = new class_2487();
        class_2499 shapeIdList = new class_2499();
        class_2499 skinIdList = new class_2499();
        favoriteShapes.forEach(type -> shapeIdList.add((Object)type.writeCompound()));
        favoriteSkins.forEach(skin -> skinIdList.add((Object)class_2512.method_25929((UUID)skin)));
        tag.method_10566("FavoriteShapes", (class_2520)shapeIdList);
        tag.method_10566("FavoriteSkins", (class_2520)skinIdList);
        ModernNetworking.sendToPlayer((class_3222)player, (class_2960)FAVORITE_SYNC, (class_2487)tag);
    }

    public static void sendFavoriteRequest(ShapeType<? extends class_1309> type, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_10582("id", Walkers.getEntityTypeRegistry().method_10221((Object)type.getEntityType()).toString());
        packet.method_10569("variant", type.getVariantData());
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer((class_2960)FAVORITE_UPDATE, (class_2487)packet);
    }

    public static void sendFavoriteRequest(PlayerProfile playerProfile, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_25927("playerUUID", playerProfile.id());
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer((class_2960)FAVORITE_UPDATE, (class_2487)packet);
    }

    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, class_2487 packet) {
        boolean favorite = packet.method_10577("favorite");
        if (packet.method_10545("playerUUID")) {
            UUID skinId = packet.method_25926("playerUUID");
            context.getPlayer().method_5682().execute(() -> {
                if (favorite) {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).add(skinId);
                } else {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).remove(skinId);
                }
                NetworkHandler.sendFavoriteSync((class_3222)context.getPlayer());
            });
        } else {
            class_1299 entityType = (class_1299)Walkers.getEntityTypeRegistry().method_10223(Identifier.parse((String)packet.method_10558("id")));
            int variant = packet.method_10550("variant");
            context.getPlayer().method_5682().execute(() -> {
                @Nullable ShapeType type = ShapeType.from((class_1299)entityType, (int)variant);
                if (type != null) {
                    if (favorite) {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).add(type);
                    } else {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).remove(type);
                    }
                    NetworkHandler.sendFavoriteSync((class_3222)context.getPlayer());
                }
            });
        }
    }
}

