/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.craftedcore.patched.Identifier;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

@Environment(value=EnvType.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, class_2487 compound) {
        UUID uuid = compound.method_25926("uuid");
        HashMap unlockedShapes = new HashMap();
        if (compound.method_10545("UnlockedShapes")) {
            compound.method_10554("UnlockedShapes", 10).forEach(entryTag -> {
                class_1299 eType = (class_1299)Walkers.getEntityTypeRegistry().method_10223(Identifier.parse((String)((class_2487)entryTag).method_10558("id")));
                int variant = ((class_2487)entryTag).method_10550("variant");
                int killAmount = ((class_2487)entryTag).method_10550("killAmount");
                unlockedShapes.put(ShapeType.from((class_1299)eType, (int)variant), killAmount);
            });
        }
        HashMap unlockedSkins = new HashMap();
        if (compound.method_10545("UnlockedSkins")) {
            compound.method_10554("UnlockedSkins", 10).forEach(entryTag -> {
                UUID unlockedSkinUUID = ((class_2487)entryTag).method_25926("uuid");
                int killAmount = ((class_2487)entryTag).method_10550("killAmount");
                unlockedSkins.put(unlockedSkinUUID, killAmount);
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_5770().method_18470(uuid);
            if (syncTarget != null) {
                PlayerMorph.getUnlockedShapes(player).clear();
                PlayerMorph.getUnlockedShapes(player).putAll(unlockedShapes);
                PlayerMorph.getUnlockedSkinIds(player).clear();
                PlayerMorph.getUnlockedSkinIds(player).putAll(unlockedSkins);
            }
        });
    }

    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, class_2487 tag) {
        ClientNetworking.runOrQueue(context, player -> {
            PlayerMorph.getFavoriteShapes(player).clear();
            PlayerMorph.getFavoriteSkinIds(player).clear();
            class_2499 shapeIds = tag.method_10554("FavoriteShapes", 10);
            class_2499 skinIds = tag.method_10554("FavoriteSkins", 11);
            shapeIds.forEach(compound -> PlayerMorph.getFavoriteShapes(player).add(ShapeType.from((class_2487)((class_2487)compound))));
            skinIds.forEach(skinId -> PlayerMorph.getFavoriteSkinIds(player).add(class_2512.method_25930((class_2520)skinId)));
        });
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

