/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends class_1309>, Integer> remorphed$unlockedShapes = new HashMap<ShapeType<? extends class_1309>, Integer>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<UUID>();
    @Unique
    private final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private final String FAVORITE_SKINS = "FavoriteSkins";

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        if (!CEntity.level((class_1297)this).field_9236) {
            Remorphed.sync((class_3222)this);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(class_2487 tag, CallbackInfo info) {
        this.remorphed$readData(tag.method_10562("remorphed"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        tag.method_10566("remorphed", (class_2520)this.remorphed$writeData());
    }

    @Unique
    private class_2487 remorphed$writeData() {
        class_2487 tag = new class_2487();
        class_2499 unlockedShapes = new class_2499();
        this.remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", Walkers.getEntityTypeRegistry().method_10221((Object)shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                entryTag.method_10569("killAmount", killAmount.intValue());
                unlockedShapes.add((Object)entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.method_10566("UnlockedShapes", (class_2520)unlockedShapes);
        }
        class_2499 favoriteShapes = new class_2499();
        this.remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", Walkers.getEntityTypeRegistry().method_10221((Object)shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                favoriteShapes.add((Object)entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.method_10566("FavoriteShapes", (class_2520)favoriteShapes);
        }
        class_2499 unlockedSkins = new class_2499();
        this.remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                entryTag.method_10569("killAmount", killAmount.intValue());
                unlockedSkins.add((Object)entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.method_10566("UnlockedSkins", (class_2520)unlockedSkins);
        }
        class_2499 favoriteSkins = new class_2499();
        this.remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                favoriteSkins.add((Object)entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.method_10566("FavoriteSkins", (class_2520)favoriteSkins);
        }
        return tag;
    }

    @Unique
    public void remorphed$readData(class_2487 tag) {
        this.remorphed$unlockedShapes.clear();
        this.remorphed$favoriteShapes.clear();
        this.remorphed$unlockedSkins.clear();
        this.remorphed$favoriteSkins.clear();
        class_2499 unlockedShapes = tag.method_10554("UnlockedShapes", 10);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = Identifier.parse((String)((class_2487)entry).method_10558("id"));
                int typeVariantId = ((class_2487)entry).method_10550("variant");
                int killAmount = ((class_2487)entry).method_10550("killAmount");
                this.remorphed$unlockedShapes.put((ShapeType<? extends class_1309>)ShapeType.from((class_1299)((class_1299)Walkers.getEntityTypeRegistry().method_10223(typeId)), (int)typeVariantId), killAmount);
            }
        });
        class_2499 favoriteShapes = tag.method_10554("FavoriteShapes", 10);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = Identifier.parse((String)((class_2487)entry).method_10558("id"));
                int typeVariantId = ((class_2487)entry).method_10550("variant");
                this.remorphed$favoriteShapes.add(ShapeType.from((class_1299)((class_1299)Walkers.getEntityTypeRegistry().method_10223(typeId)), (int)typeVariantId));
            }
        });
        class_2499 unlockedSkins = tag.method_10554("UnlockedSkins", 10);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487)entry).method_25926("uuid");
                int killAmount = ((class_2487)entry).method_10550("killAmount");
                this.remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        class_2499 favoriteSkins = tag.method_10554("FavoriteSkins", 10);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487)entry).method_25926("uuid");
                this.remorphed$favoriteSkins.add(skinId);
            }
        });
    }

    @Override
    @Unique
    public Map<ShapeType<? extends class_1309>, Integer> remorphed$getUnlockedShapes() {
        return this.remorphed$unlockedShapes;
    }

    @Override
    @Unique
    public void remorphed$addKill(ShapeType<? extends class_1309> type) {
        this.remorphed$unlockedShapes.put(type, this.remorphed$getKills(type) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (Integer i : this.remorphed$unlockedShapes.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i.intValue();
            }
            return killAmount;
        }
        return this.remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return this.remorphed$favoriteShapes;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return this.remorphed$unlockedSkins;
    }

    @Override
    @Unique
    public void remorphed$addKill(UUID skinId) {
        this.remorphed$unlockedSkins.put(skinId, this.remorphed$getKills(skinId) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(UUID skinId) {
        return this.remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public Set<UUID> remorphed$getFavoriteSkins() {
        return this.remorphed$favoriteSkins;
    }
}

