/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.skinshifter.SkinShifter;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remorphed").requires(source -> source.method_9259(2))).build();
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"removeShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)CEntitySummonArgument.id((class_7157)registry)).suggests(class_2321.field_10935).executes(context -> {
            RemorphedCommand.removeShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"addShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)CEntitySummonArgument.id((class_7157)registry)).suggests(class_2321.field_10935).executes(context -> {
            RemorphedCommand.addShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)class_2170.method_9247((String)"clearShapes").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
            RemorphedCommand.clearShapes((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"hasShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)CEntitySummonArgument.id((class_7157)registry)).suggests(class_2321.field_10935).executes(context -> RemorphedCommand.hasShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null))).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
        }))))).build();
        LiteralCommandNode removeSkin = ((LiteralArgumentBuilder)class_2170.method_9247((String)"removeSkin").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.removeSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
            String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.removeSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        LiteralCommandNode addSkin = ((LiteralArgumentBuilder)class_2170.method_9247((String)"addSkin").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.addSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
            String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.addSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        LiteralCommandNode clearSkins = ((LiteralArgumentBuilder)class_2170.method_9247((String)"clearSkins").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            RemorphedCommand.clearSkins((class_2168)context.getSource(), player);
            return 1;
        }))).build();
        LiteralCommandNode hasSkin = ((LiteralArgumentBuilder)class_2170.method_9247((String)"hasSkin").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofId((UUID)playerUUID);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), (boolean)true);
                } else {
                    RemorphedCommand.hasSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
            String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            CompletableFuture.runAsync(() -> {
                PlayerProfile playerProfile = PlayerProfile.ofName((String)playerName);
                if (playerProfile == null) {
                    CCommandSourceStack.sendSuccess((class_2168)((class_2168)context.getSource()), (class_2561)TComponent.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), (boolean)true);
                } else {
                    RemorphedCommand.hasSkin((class_2168)context.getSource(), player, playerProfile);
                }
            });
            return 1;
        })))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        if (Remorphed.foundSkinShifter) {
            rootNode.addChild((CommandNode)removeSkin);
            rootNode.addChild((CommandNode)addSkin);
            rootNode.addChild((CommandNode)clearSkins);
            rootNode.addChild((CommandNode)hasSkin);
        }
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int hasShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = TComponent.translatable((String)type.getEntityType().method_5882(), (Object[])new Object[0]);
        if (PlayerMorph.getUnlockedShapes((class_1657)player).containsKey(type)) {
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.hasShape_success", (Object[])new Object[]{player.method_5476(), name}), (boolean)true);
            return 1;
        }
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.hasShape_fail", (Object[])new Object[]{player.method_5476(), name}), (boolean)true);
        return 0;
    }

    private static void removeShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = TComponent.translatable((String)type.getEntityType().method_5882(), (Object[])new Object[0]);
        PlayerMorph.getUnlockedShapes((class_1657)player).remove(type);
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.removeShape", (Object[])new Object[]{name, player.method_5476()}), (boolean)true);
    }

    private static void addShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = TComponent.translatable((String)type.getEntityType().method_5882(), (Object[])new Object[0]);
        PlayerMorph.getUnlockedShapes((class_1657)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.addShape", (Object[])new Object[]{player.method_5476(), name}), (boolean)true);
    }

    private static void clearShapes(class_2168 source, class_3222 player) {
        PlayerMorph.getUnlockedShapes((class_1657)player).clear();
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.clearShapes", (Object[])new Object[]{player.method_5476()}), (boolean)true);
        PlayerShapeChanger.change2ndShape((class_3222)player, null);
    }

    private static ShapeType<class_1309> getType(class_3218 serverLevel, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType type = ShapeType.from((class_1299)((class_1299)Walkers.getEntityTypeRegistry().method_10223(id)));
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverLevel, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    private static void hasSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        if (PlayerMorph.getUnlockedSkinIds((class_1657)player).containsKey(playerProfile.id())) {
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.hasSkin_success", (Object[])new Object[]{player.method_5476(), playerProfile.name()}), (boolean)true);
        } else {
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.hasSkin_fail", (Object[])new Object[]{player.method_5476(), playerProfile.name()}), (boolean)true);
        }
    }

    private static void removeSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds((class_1657)player).remove(playerProfile.id());
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.removeSkin", (Object[])new Object[]{playerProfile.name(), player.method_5476()}), (boolean)true);
    }

    private static void addSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds((class_1657)player).put(playerProfile.id(), Remorphed.CONFIG.killToUnlockPlayers);
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.addSkin", (Object[])new Object[]{player.method_5476(), playerProfile.name()}), (boolean)true);
    }

    private static void clearSkins(class_2168 source, class_3222 player) {
        PlayerMorph.getUnlockedSkinIds((class_1657)player).clear();
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"remorphed.clearSkins", (Object[])new Object[]{player.method_5476()}), (boolean)true);
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((class_3222)player, null);
        }
    }
}

