/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.remorphed.RemorphedClient;
import tocraft.remorphed.command.RemorphedCommand;
import tocraft.remorphed.config.RemorphedConfig;
import tocraft.remorphed.handler.LivingDeathHandler;
import tocraft.remorphed.handler.PlayerRespawnHandler;
import tocraft.remorphed.handler.ShapeEventsCallback;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;

public class Remorphed {
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = (RemorphedConfig)ConfigLoader.read((String)"remorphed", RemorphedConfig.class);
    public static boolean displayVariantsInMenu = true;
    public static boolean displayTraitsInMenu = true;
    public static final boolean foundSkinShifter = PlatformData.isModLoaded((String)"skinshifter");

    public void initialize() {
        ShapeEvents.UNLOCK_SHAPE.register((Object)new ShapeEventsCallback());
        if (!Remorphed.CONFIG.unlockFriendlyNormal) {
            ApiLevel.setApiLevel((ApiLevel)ApiLevel.MORPHING_AND_VARIANTS_MENU_ONLY);
        }
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (class_2561)TComponent.literal((String)"Remorphed"));
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            new RemorphedClient().initialize();
        }
        NetworkHandler.registerPacketReceiver();
        CommandEvents.REGISTRATION.register((Object)new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register((Object)new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register((Object)new PlayerRespawnHandler());
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(class_1657 player) {
        return player.method_7337() && Remorphed.CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(class_1657 player, ShapeType<?> type) {
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(type.getEntityType()));
    }

    public static List<ShapeType<?>> getUnlockedShapes(class_1657 player) {
        if (Remorphed.canUseEveryShape(player)) {
            return ShapeType.getAllTypes((class_1937)CEntity.level((class_1297)player));
        }
        if (Walkers.CONFIG.unlockEveryVariant) {
            ArrayList unlocked = new ArrayList();
            for (ShapeType shapeType : ShapeType.getAllTypes((class_1937)CEntity.level((class_1297)player))) {
                if (unlocked.contains(shapeType) || !Remorphed.canUseShape(player, shapeType)) continue;
                unlocked.add(shapeType);
            }
            return unlocked;
        }
        return new ArrayList(PlayerMorph.getUnlockedShapes(player).keySet().stream().filter(type -> Remorphed.canUseShape(player, type)).toList());
    }

    public static List<PlayerProfile> getUnlockedSkins(class_1657 player) {
        return new ArrayList<PlayerProfile>(PlayerMorph.getUnlockedSkinIds(player).keySet().stream().filter(skinId -> (PlayerMorph.getPlayerKills(player, skinId) >= Remorphed.CONFIG.killToUnlockPlayers || Remorphed.CONFIG.killToUnlockPlayers == 0) && Remorphed.CONFIG.killToUnlockPlayers != -1).map(PlayerProfile::ofId).filter(Objects::nonNull).toList());
    }

    public static int getKillToUnlock(class_1299<?> entityType) {
        String id = Walkers.getEntityTypeRegistry().method_10221(entityType).toString();
        if (Remorphed.CONFIG.killToUnlockByType.containsKey(id)) {
            return Remorphed.CONFIG.killToUnlockByType.get(id);
        }
        return Remorphed.CONFIG.killToUnlock;
    }

    public static void sync(class_3222 player) {
        Remorphed.sync(player, player);
    }

    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2487 compoundTag = new class_2487();
        Map<ShapeType<? extends class_1309>, Integer> unlockedShapes = PlayerMorph.getUnlockedShapes((class_1657)changed);
        class_2499 shapesList = new class_2499();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 compound = new class_2487();
                compound.method_10582("id", Walkers.getEntityTypeRegistry().method_10221((Object)shape.getEntityType()).toString());
                compound.method_10569("variant", shape.getVariantData());
                compound.method_10569("killAmount", killAmount.intValue());
                shapesList.add((Object)compound);
            }
        });
        if (!shapesList.isEmpty()) {
            compoundTag.method_10566("UnlockedShapes", (class_2520)shapesList);
        }
        Map<UUID, Integer> unlockedSkins = PlayerMorph.getUnlockedSkinIds((class_1657)changed);
        class_2499 skinsList = new class_2499();
        unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 compound = new class_2487();
                compound.method_25927("uuid", skinId);
                compound.method_10569("killAmount", killAmount.intValue());
                skinsList.add((Object)compound);
            }
        });
        if (!skinsList.isEmpty()) {
            compoundTag.method_10566("UnlockedSkins", (class_2520)skinsList);
        }
        compoundTag.method_25927("uuid", changed.method_5667());
        ModernNetworking.sendToPlayer((class_3222)packetTarget, (class_2960)NetworkHandler.UNLOCKED_SYNC, (class_2487)compoundTag);
    }

    public static class_2960 id(String name) {
        return Identifier.parse((String)MODID, (String)name);
    }
}

