/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import questsadditions.events.StructurePlacementClient;
import questsadditions.tasks.TasksRegistry;

public class StructureTask
extends Task {
    public String name = "";
    public boolean hasCustomPicture;
    public boolean layer = true;
    public class_1799 item = class_1799.field_8037;
    public boolean rightclick_validation;
    public boolean ignoreState;

    public StructureTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return TasksRegistry.STRUCTURE;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("name", this.name);
        nbt.method_10556("hasCustomPicture", this.hasCustomPicture);
        nbt.method_10556("layer", this.layer);
        nbt.method_10556("ignoreState", this.ignoreState);
        nbt.method_10556("rightclick", this.rightclick_validation);
        if (this.rightclick_validation) {
            NBTUtils.write((class_2487)nbt, (String)"item", (class_1799)this.item);
        }
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.name = nbt.method_10558("name");
        this.hasCustomPicture = nbt.method_10577("hasCustomPicture");
        this.layer = nbt.method_10577("layer");
        this.ignoreState = nbt.method_10577("ignoreState");
        this.rightclick_validation = nbt.method_10577("rightclick");
        if (this.rightclick_validation) {
            this.item = NBTUtils.read((class_2487)nbt, (String)"item");
        }
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.name, Short.MAX_VALUE);
        buffer.writeBoolean(this.hasCustomPicture);
        buffer.writeBoolean(this.layer);
        buffer.writeBoolean(this.ignoreState);
        buffer.writeBoolean(this.rightclick_validation);
        if (this.rightclick_validation) {
            FTBQuestsNetHandler.writeItemType((class_2540)buffer, (class_1799)this.item);
        }
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.name = buffer.method_10800(Short.MAX_VALUE);
        this.hasCustomPicture = buffer.readBoolean();
        this.layer = buffer.readBoolean();
        this.ignoreState = buffer.readBoolean();
        this.rightclick_validation = buffer.readBoolean();
        if (this.rightclick_validation) {
            this.item = FTBQuestsNetHandler.readItemType((class_2540)buffer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("name", this.name, v -> {
            this.name = v;
        }, "");
        config.addBool("hasCustomPicture", this.hasCustomPicture, v -> {
            this.hasCustomPicture = v;
        }, false);
        config.addBool("layer", this.layer, v -> {
            this.layer = v;
        }, true);
        config.addBool("ignoreState", this.ignoreState, v -> {
            this.ignoreState = v;
        }, false);
        config.addBool("rightclick", this.rightclick_validation, v -> {
            this.rightclick_validation = v;
        }, false);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, class_1799.field_8037, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return class_2561.method_43469((String)"questsadditions.task.structure.title", (Object[])new Object[]{this.name});
    }

    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.blankLine();
        if (StructurePlacementClient.isLocked()) {
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.task.click_to_submit").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else {
            list.add((class_2561)class_2561.method_43471((String)"questsadditions.structure_task.show").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.hasCustomPicture) {
            return Icon.getIcon((String)("questsadditions:textures/structure_icons/" + this.name + ".png"));
        }
        return super.getAltIcon();
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        if (!ClientQuestFile.INSTANCE.selfTeamData.isCompleted((QuestObject)this)) {
            StructurePlacementClient.toggleShowStructure(this.name, this.layer, this);
        }
    }
}

