/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import questsadditions.mixinutils.IMixinQuest;

@Mixin(value={Quest.class})
public abstract class MixinQuest
implements IMixinQuest {
    boolean secret;
    int minRequiredTasks;
    public List<QuestObject> incompatible_quests = new ArrayList<QuestObject>(0);
    boolean isRepeatable;

    @Override
    public int getMinRequiredTasks() {
        return this.minRequiredTasks;
    }

    @Override
    public List<QuestObject> getIncompatibleQuests() {
        return this.incompatible_quests;
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Inject(method={"writeData(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="RETURN")}, remap=true)
    private void writeData(class_2487 nbt, CallbackInfo callback) {
        if (this.secret) {
            nbt.method_10556("secret", this.secret);
        }
        if (this.isRepeatable) {
            nbt.method_10556("repeatable", this.isRepeatable);
        }
        if (this.minRequiredTasks > 0) {
            nbt.method_10569("min_required_tasks", this.minRequiredTasks);
        }
        if (!this.incompatible_quests.isEmpty()) {
            this.incompatible_quests.removeIf(o -> o == null || !o.isValid() || o == this.This());
        }
        if (!this.incompatible_quests.isEmpty()) {
            class_2499 quests = new class_2499();
            for (QuestObject quest : this.incompatible_quests) {
                quests.add((Object)class_2519.method_23256((String)quest.getCodeString()));
            }
            nbt.method_10566("incompatible", (class_2520)quests);
        }
    }

    @Inject(method={"readData(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="RETURN")}, remap=true)
    private void readData(class_2487 nbt, CallbackInfo callback) {
        this.secret = nbt.method_10577("secret");
        this.isRepeatable = nbt.method_10577("repeatable");
        this.minRequiredTasks = nbt.method_10550("min_required_tasks");
        this.incompatible_quests.clear();
        class_2499 quests = nbt.method_10554("incompatible", 8);
        Quest quest = this.This();
        for (int i = 0; i < quests.size(); ++i) {
            QuestObject object = quest.getChapter().file.get(quest.getChapter().file.getID((Object)quests.method_10608(i)));
            if (object == null) continue;
            this.incompatible_quests.add(object);
        }
    }

    @Inject(method={"writeNetData(Lnet/minecraft/network/PacketByteBuf;)V"}, at={@At(value="RETURN")}, remap=true)
    public void writeNetData(class_2540 buffer, CallbackInfo callback) {
        buffer.writeBoolean(this.secret);
        buffer.writeBoolean(this.isRepeatable);
        buffer.method_10804(this.minRequiredTasks);
        buffer.method_10804(this.incompatible_quests.size());
        for (QuestObject quest : this.incompatible_quests) {
            if (!quest.isValid()) {
                buffer.writeLong(0L);
                continue;
            }
            buffer.writeLong(quest.id);
        }
    }

    @Inject(method={"readNetData(Lnet/minecraft/network/PacketByteBuf;)V"}, at={@At(value="RETURN")}, remap=true)
    public void readNetData(class_2540 buffer, CallbackInfo callback) {
        this.secret = buffer.readBoolean();
        this.isRepeatable = buffer.readBoolean();
        this.minRequiredTasks = buffer.method_10816();
        this.incompatible_quests.clear();
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            QuestObject object = this.This().getChapter().file.get(buffer.readLong());
            if (object == null) continue;
            this.incompatible_quests.add(object);
        }
    }

    @Inject(method={"isVisible(Ldev/ftb/mods/ftbquests/quest/TeamData;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void isVisible(TeamData team, CallbackInfoReturnable<Boolean> cir) {
        Quest quest;
        if (this.secret && !team.isCompleted((QuestObject)(quest = this.This()))) {
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"fillConfigGroup(Ldev/ftb/mods/ftblibrary/config/ConfigGroup;)V"}, at={@At(value="TAIL")}, remap=false)
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config, CallbackInfo callback) {
        config.addBool("is_secret", this.secret, v -> {
            this.secret = v;
        }, false).setNameKey("questsadditions.is_secret");
        config.addInt("min_required_tasks", this.minRequiredTasks, v -> {
            this.minRequiredTasks = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("questsadditions.min_required_tasks");
        Quest quest = this.This();
        Predicate<QuestObjectBase> depTypes = object -> object != quest.getChapter().file && object != quest.getChapter() && object instanceof QuestObject;
        this.incompatible_quests.removeIf(Objects::isNull);
        config.addList("incompatible_quests", this.incompatible_quests, (ConfigValue)new ConfigQuestObject(depTypes), null).setNameKey("questsadditions.incompatible_quests");
    }

    @Inject(method={"isCompletedRaw(Ldev/ftb/mods/ftbquests/quest/TeamData;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void isCompletedRaw(TeamData data, CallbackInfoReturnable<Boolean> cir) {
        if (this.minRequiredTasks > 0) {
            Quest quest = this.This();
            int completed = 0;
            for (QuestObject child : quest.getChildren()) {
                if (!data.isCompleted(child) || ++completed != this.minRequiredTasks) continue;
                if (data.canStartTasks(quest)) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getRelativeProgressFromChildren(Ldev/ftb/mods/ftbquests/quest/TeamData;)I"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getRelativeProgressFromChildren(TeamData data, CallbackInfoReturnable<Integer> cir) {
        if (!this.incompatible_quests.isEmpty()) {
            for (QuestObject object : this.incompatible_quests) {
                if (!object.isValid() || !data.isCompleted(object)) continue;
                cir.setReturnValue((Object)0);
                return;
            }
        }
    }

    private Quest This() {
        return (Quest)this;
    }
}

