/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.BlockCondition;
import net.puffish.skillsmod.calculation.operation.builtin.BlockStateCondition;
import net.puffish.skillsmod.calculation.operation.builtin.DamageTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EntityTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ItemCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ItemStackCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ScoreboardOperation;
import net.puffish.skillsmod.calculation.operation.builtin.StatCondition;
import net.puffish.skillsmod.calculation.operation.builtin.StatTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.SwitchOperation;
import net.puffish.skillsmod.calculation.operation.builtin.TagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyBlockTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyDamageTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyEntityTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyItemTagCondition;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.OpenCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.config.ModConfig;
import net.puffish.skillsmod.config.PackConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.config.reader.FileConfigReader;
import net.puffish.skillsmod.config.reader.PackConfigReader;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.experience.source.builtin.CraftItemExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.EatFoodExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.FishItemExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.IncreaseStatExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.MineBlockExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.impl.config.ConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardUpdateContextImpl;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.reward.builtin.AttributeReward;
import net.puffish.skillsmod.reward.builtin.CommandReward;
import net.puffish.skillsmod.reward.builtin.ScoreboardReward;
import net.puffish.skillsmod.reward.builtin.TagReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.OpenScreenOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowToastOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUpdateOutPacket;
import net.puffish.skillsmod.server.setup.ServerRegistrar;
import net.puffish.skillsmod.server.setup.SkillsArgumentTypes;
import net.puffish.skillsmod.server.setup.SkillsGameRules;
import net.puffish.skillsmod.util.ChangeListener;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.PathUtils;
import net.puffish.skillsmod.util.PrefixedLogger;
import net.puffish.skillsmod.util.ToastType;
import net.puffish.skillsmod.util.VersionedConfigContext;

public class SkillsMod {
    public static final int MIN_CONFIG_VERSION = 1;
    public static final int MAX_CONFIG_VERSION = 3;
    private static SkillsMod instance;
    private final PrefixedLogger logger = new PrefixedLogger("puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private final ChangeListener<Optional<Map<class_2960, CategoryConfig>>> categories = new ChangeListener(Optional.empty(), () -> {});

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instance = new SkillsMod(modConfigDir, packetSender);
        registrar.registerInPacket(Packets.SKILL_CLICK, SkillClickInPacket::read, instance::onSkillClickPacket);
        registrar.registerOutPacket(Packets.SHOW_CATEGORY);
        registrar.registerOutPacket(Packets.HIDE_CATEGORY);
        registrar.registerOutPacket(Packets.SKILL_UPDATE);
        registrar.registerOutPacket(Packets.POINTS_UPDATE);
        registrar.registerOutPacket(Packets.EXPERIENCE_UPDATE);
        registrar.registerOutPacket(Packets.SHOW_TOAST);
        registrar.registerOutPacket(Packets.OPEN_SCREEN);
        eventReceiver.registerListener(instance.new EventListener());
        SkillsGameRules.register(registrar);
        SkillsArgumentTypes.register(registrar);
        AttributeReward.register();
        CommandReward.register();
        ScoreboardReward.register();
        TagReward.register();
        LegacyBlockTagCondition.register();
        LegacyDamageTypeTagCondition.register();
        LegacyEntityTypeTagCondition.register();
        LegacyItemTagCondition.register();
        AttributeOperation.register();
        BlockCondition.register();
        BlockStateCondition.register();
        DamageTypeCondition.register();
        EffectOperation.register();
        EntityTypeCondition.register();
        ItemCondition.register();
        ItemStackCondition.register();
        ScoreboardOperation.register();
        StatCondition.register();
        StatTypeCondition.register();
        SwitchOperation.register();
        TagCondition.register();
        CraftItemExperienceSource.register();
        DealDamageExperienceSource.register();
        EatFoodExperienceSource.register();
        FishItemExperienceSource.register();
        HealExperienceSource.register();
        IncreaseStatExperienceSource.register();
        KillEntityExperienceSource.register();
        MineBlockExperienceSource.register();
        SharedKillEntityExperienceSource.register();
        TakeDamageExperienceSource.register();
        LegacyBuiltinPrototypes.register();
    }

    public static class_2960 createIdentifier(String path) {
        return new class_2960("puffish_skills", path);
    }

    public static class_2960 convertIdentifier(class_2960 id) {
        if (id.method_12836().equals("minecraft")) {
            return SkillsMod.createIdentifier(id.method_12832());
        }
        return id;
    }

    public static class_5250 createTranslatable(String type, String path, Object ... args) {
        return class_2561.method_43469((String)class_156.method_646((String)type, (class_2960)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public PrefixedLogger getLogger() {
        return this.logger;
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "config.json"), this.modConfigDir.resolve("config.json"));
    }

    private void loadModConfig(MinecraftServer server) {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        FileConfigReader reader = new FileConfigReader(this.modConfigDir);
        ConfigContextImpl context = new ConfigContextImpl(server);
        reader.read(Path.of("config.json", new String[0])).andThen(rootElement -> ModConfig.parse(rootElement, (ConfigContext)context)).andThen(modConfig -> this.loadCategories(reader, (Config)modConfig, "puffish_skills", context).ifSuccess(map -> {
            LinkedHashMap<class_2960, CategoryConfig> cumulatedMap = new LinkedHashMap<class_2960, CategoryConfig>((Map<class_2960, CategoryConfig>)map);
            this.showSuccess("Mod configuration", modConfig.getShowWarnings(), context);
            if (this.loadPackConfig(server, cumulatedMap, modConfig.getShowWarnings())) {
                this.categories.set(Optional.of(cumulatedMap), () -> {
                    for (CategoryConfig category : cumulatedMap.values()) {
                        category.dispose(new DisposeContext(server));
                    }
                });
            } else {
                this.categories.set(Optional.empty(), () -> {});
            }
        })).ifFailure(problem -> {
            this.categories.set(Optional.empty(), () -> {});
            this.showFailure("Mod configuration", (Problem)problem);
        });
    }

    private Result<Map<class_2960, CategoryConfig>, Problem> loadCategories(ConfigReader reader, Config config, String namespace, ConfigContext context) {
        VersionedConfigContext versionedContext = new VersionedConfigContext(context, config.getVersion());
        return reader.readCategories(namespace, config.getCategories(), versionedContext);
    }

    private boolean loadPackConfig(MinecraftServer server, Map<class_2960, CategoryConfig> cumulatedMap, boolean showWarning) {
        class_3300 resourceManager = server.method_34864();
        Map resources = resourceManager.method_14488("puffish_skills", id -> id.method_12832().endsWith("config.json"));
        boolean allSuccess = true;
        for (Map.Entry entry : resources.entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            class_2960 id2 = (class_2960)entry.getKey();
            String namespace = id2.method_12836();
            PackConfigReader reader = new PackConfigReader(resourceManager, namespace);
            ConfigContextImpl context = new ConfigContextImpl(server);
            if (!reader.readResource(id2, resource).andThen(rootElement -> PackConfig.parse(namespace, rootElement, (ConfigContext)context)).andThen(packConfig -> this.loadCategories(reader, (Config)packConfig, namespace, context)).andThen(map -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                for (class_2960 key : map.keySet()) {
                    if (!cumulatedMap.containsKey(key)) continue;
                    problems.add(Problem.message("Category `" + String.valueOf(key) + "` already exists."));
                }
                if (problems.isEmpty()) {
                    return Result.success(map);
                }
                return Result.failure(Problem.combine(problems));
            }).ifFailure(problem -> this.showFailure("Data pack `" + namespace + "`", (Problem)problem)).ifSuccess(map -> {
                cumulatedMap.putAll((Map<class_2960, CategoryConfig>)map);
                this.showSuccess("Data pack `" + namespace + "`", showWarning, context);
            }).getSuccess().isEmpty()) continue;
            allSuccess = false;
        }
        return allSuccess;
    }

    private void showSuccess(String name, boolean showWarnings, ConfigContextImpl context) {
        if (showWarnings && !context.warnings().isEmpty()) {
            this.logger.warn(name + " loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
        } else {
            this.logger.info(name + " loaded successfully!");
        }
    }

    private void showFailure(String name, Problem problem) {
        this.logger.error(name + " could not be loaded:" + System.lineSeparator() + String.valueOf(problem));
    }

    private void onSkillClickPacket(class_3222 player, SkillClickInPacket packet) {
        if (player.method_7325()) {
            return;
        }
        this.tryUnlockSkill(player, packet.getCategoryId(), packet.getSkillId(), false);
    }

    public void unlockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.tryUnlockSkill(player, categoryId, skillId, true);
    }

    private void tryUnlockSkill(class_3222 player, class_2960 categoryId, String skillId, boolean force) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            if (categoryData.tryUnlockSkill((CategoryConfig)category, player, skillId, force)) {
                this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, true));
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            }
        }));
    }

    public void lockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.lockSkill(skillId);
            this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, false));
            this.syncRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void resetSkills(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.resetSkills();
            this.syncRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncCategory(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void eraseCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.unlockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void lockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.lockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public Optional<Boolean> hasExperience(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.getExperience().isPresent());
    }

    public void addExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.addExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public void setExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.setEarnedExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public Optional<Integer> getExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (category.getExperience().isEmpty()) {
                return Optional.empty();
            }
            return this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getEarnedExperience);
        });
    }

    public void addExtraPoints(class_3222 player, class_2960 categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.addExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void setExtraPoints(class_3222 player, class_2960 categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.setExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public Optional<Integer> getExtraPoints(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).flatMap(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExtraPoints));
    }

    public Optional<Integer> getPointsLeft(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentLevel(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentLevel((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentExperience((CategoryConfig)category);
        });
    }

    public Optional<Integer> getRequiredExperience(class_3222 player, class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Integer> getRequiredTotalExperience(class_3222 player, class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredTotalExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Skill.State> getSkillState(class_3222 player, class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).flatMap(category -> category.getSkills().getById(skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId()).map(definition -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getSkillState((CategoryConfig)category, (SkillConfig)skill, (SkillDefinitionConfig)definition);
        })));
    }

    public Collection<class_2960> getUnlockedCategories(class_3222 player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::getId).toList();
    }

    public Collection<class_2960> getCategories(boolean onlyWithExperience) {
        return this.getAllCategories().stream().filter(category -> !onlyWithExperience || category.getExperience().isPresent()).map(CategoryConfig::getId).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getAll().stream().map(SkillConfig::getId).toList());
    }

    public boolean hasCategory(class_2960 categoryId) {
        return this.getCategory(categoryId).isPresent();
    }

    public boolean hasSkill(class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getById(skillId).isPresent()).orElse(false);
    }

    private void showCategory(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new ShowCategoryOutPacket(category, categoryData));
    }

    private void hideCategory(class_3222 player, CategoryConfig category) {
        this.packetSender.send(player, new HideCategoryOutPacket(category.getId()));
    }

    private void syncPoints(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new PointsUpdateOutPacket(category.getId(), categoryData.getSpentPoints(category), categoryData.getEarnedPoints(category), player.method_37908().method_8450().method_8355(SkillsGameRules.ANNOUNCE_NEW_POINTS)));
    }

    private void syncExperience(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        int level = categoryData.getCurrentLevel(category);
        this.packetSender.send(player, new ExperienceUpdateOutPacket(category.getId(), level, categoryData.getCurrentExperience(category), categoryData.getRequiredExperience(category, level)));
    }

    public void updateRewards(class_3222 player, Predicate<SkillRewardConfig> reward) {
        for (CategoryConfig category : this.getAllCategories()) {
            this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> categoryData.updateRewards(category, player, reward));
        }
    }

    public void visitExperienceSources(class_3222 player, Function<ExperienceSource, Integer> function) {
        for (CategoryConfig category : this.getAllCategories()) {
            category.getExperience().ifPresent(experience -> this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> {
                int amount = 0;
                for (ExperienceSourceConfig experienceSource : experience.getExperienceSources()) {
                    amount += ((Integer)function.apply(experienceSource.getInstance())).intValue();
                }
                if (amount != 0) {
                    categoryData.addExperience(amount);
                    this.syncExperience(player, category, (CategoryData)categoryData);
                    this.syncPoints(player, category, (CategoryData)categoryData);
                }
            }));
        }
    }

    private void syncRewards(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        categoryData.updateRewards(category, player, reward -> true);
    }

    private void resetRewards(class_3222 player, CategoryConfig category) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(new RewardUpdateContextImpl(player, 0, false));
            }
        }
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(class_3222 player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getCategoryData(category));
        }
        return Optional.empty();
    }

    public Optional<Boolean> isCategoryUnlocked(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> this.getPlayerData(player).isCategoryUnlocked((CategoryConfig)category));
    }

    private Optional<CategoryConfig> getCategory(class_2960 categoryId) {
        return this.categories.get().flatMap(map -> Optional.ofNullable((CategoryConfig)map.get(categoryId)));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().map(Map::values).orElseGet(Collections::emptyList);
    }

    private void syncCategory(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.syncRewards(player, category, categoryData);
        this.showCategory(player, category, categoryData);
    }

    private void syncCategory(class_3222 player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.syncCategory(player, category, (CategoryData)categoryData), () -> {
            this.resetRewards(player, category);
            this.hideCategory(player, category);
        });
    }

    public void syncAllCategories(class_3222 player) {
        if (this.isConfigValid()) {
            Collection<CategoryConfig> categories = this.getAllCategories();
            if (categories.isEmpty()) {
                this.showToast(player, ToastType.MISSING_CONFIG);
            } else {
                for (CategoryConfig category : categories) {
                    this.syncCategory(player, category);
                }
            }
        } else {
            this.showToast(player, ToastType.INVALID_CONFIG);
        }
    }

    private void showToast(class_3222 player, ToastType type) {
        if (this.isOperatorOrHost(player)) {
            this.packetSender.send(player, new ShowToastOutPacket(type));
        }
    }

    public void openScreen(class_3222 player, Optional<class_2960> categoryId) {
        this.packetSender.send(player, new OpenScreenOutPacket(categoryId));
    }

    private boolean isConfigValid() {
        return this.categories.get().isPresent();
    }

    private PlayerData getPlayerData(class_3222 player) {
        return ServerData.getOrCreate(this.getPlayerServer(player)).getPlayerData(player);
    }

    private MinecraftServer getPlayerServer(class_3222 player) {
        return Objects.requireNonNull(player.method_5682());
    }

    private boolean isOperatorOrHost(class_3222 player) {
        MinecraftServer server = this.getPlayerServer(player);
        return server.method_19466(player.method_7334()) || server.method_3760().method_14569(player.method_7334());
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.loadModConfig(server);
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (class_3222 player : server.method_3760().method_14571()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadModConfig(server);
            for (class_3222 player : server.method_3760().method_14571()) {
                SkillsMod.this.syncAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(class_3222 player) {
            SkillsMod.this.syncAllCategories(player);
        }

        @Override
        public void onPlayerLeave(class_3222 player) {
            for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                SkillsMod.this.resetRewards(player, category);
            }
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create())).then(OpenCommand.create()));
        }
    }
}

