/*
 * Decompiled with CFR 0.152.
 */
package tk.meowmc.portalgun.items;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2881;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_756;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LimitedLogger;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import tk.meowmc.portalgun.PortalGunMod;
import tk.meowmc.portalgun.PortalGunRecord;
import tk.meowmc.portalgun.client.renderer.PortalGunItemRenderer;
import tk.meowmc.portalgun.entities.CustomPortal;
import tk.meowmc.portalgun.misc.BlockList;

public class PortalGunItem
extends class_1792
implements GeoItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(100);
    public static final int COOLDOWN_TICKS = 4;
    public static final double SIZE_MULTIPLIER = 0.96875;
    public final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SHOOT_ANIM = RawAnimation.begin().thenPlay("portal_shoot");
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public PortalGunItem(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final PortalGunItemRenderer renderer = new PortalGunItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "portalGunController", 1, state -> PlayState.CONTINUE).triggerableAnim("shoot_anim", SHOOT_ANIM)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (world.method_8608()) {
            return class_1271.method_22431((Object)itemStack);
        }
        boolean success = this.interact((class_3222)player, hand, PortalGunRecord.PortalGunSide.orange);
        if (success) {
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_22431((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.portalgun.portal_gun_desc").method_27692(class_124.field_1065));
        class_2487 tag = stack.method_7948();
        ItemInfo itemInfo = ItemInfo.fromTag(tag);
        if (!itemInfo.allowedBlocks.list().isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"portal_gun.limit_allowed_blocks"));
            int displayLimit = 5;
            List<class_2248> allowedBlocks = itemInfo.allowedBlocks.asStream().limit(displayLimit + 1).toList();
            for (int i = 0; i < displayLimit; ++i) {
                if (i >= allowedBlocks.size()) continue;
                class_2248 block = allowedBlocks.get(i);
                tooltip.add((class_2561)block.method_9518().method_27692(class_124.field_1076));
            }
            if (allowedBlocks.size() > displayLimit) {
                tooltip.add((class_2561)class_2561.method_43470((String)"..."));
            }
        }
    }

    public class_1269 onAttack(class_1657 player, class_1937 world, class_1268 hand) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        boolean success = this.interact((class_3222)player, hand, PortalGunRecord.PortalGunSide.blue);
        if (success) {
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public boolean interact(class_3222 player, class_1268 hand, PortalGunRecord.PortalGunSide side) {
        class_1297 entity;
        class_1799 itemStack = player.method_5998(hand);
        player.method_7357().method_7906((class_1792)this, 4);
        PortalUtils.PortalAwareRaytraceResult raytraceResult = PortalUtils.portalAwareRayTrace((class_1297)player, (double)100.0);
        if (raytraceResult == null) {
            return false;
        }
        class_3965 blockHit = raytraceResult.hitResult();
        class_3218 world = (class_3218)raytraceResult.world();
        class_2350 wallFacing = blockHit.method_17780();
        if (!PortalGunItem.checkAction(player, world)) {
            return false;
        }
        Validate.isTrue((blockHit.method_17783() == class_239.class_240.field_1332 ? 1 : 0) != 0);
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), side == PortalGunRecord.PortalGunSide.blue ? PortalGunMod.PORTAL1_SHOOT_EVENT : PortalGunMod.PORTAL2_SHOOT_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        PortalGunRecord.PortalGunKind kind = PortalGunRecord.PortalGunKind._2x1;
        PortalGunRecord.PortalDescriptor descriptor = new PortalGunRecord.PortalDescriptor(player.method_5667(), kind, side);
        ItemInfo itemInfo = ItemInfo.fromTag(itemStack.method_7948());
        BiPredicate<class_1937, class_2338> wallPredicate = itemInfo.allowedBlocks.getWallPredicate();
        PortalPlacement placement = PortalGunItem.findPortalPlacement(player, kind, raytraceResult, descriptor, wallPredicate);
        if (placement == null) {
            return false;
        }
        class_2350 rightDir = placement.rotation.transformedX;
        class_2350 upDir = placement.rotation.transformedY;
        this.triggerAnim((class_1297)player, GeoItem.getOrAssignId((class_1799)player.method_5998(hand), (class_3218)((class_3218)player.method_37908())), "portalGunController", "shoot_anim");
        PortalGunRecord record = PortalGunRecord.get();
        PortalGunRecord.PortalDescriptor otherSideDescriptor = descriptor.getTheOtherSide();
        PortalGunRecord.PortalInfo thisSideInfo = record.data.get(descriptor);
        PortalGunRecord.PortalInfo otherSideInfo = record.data.get(otherSideDescriptor);
        class_243 wallFacingVec = class_243.method_24954((class_2382)wallFacing.method_10163());
        class_243 newPortalOrigin = Helper.getBoxSurface((class_238)placement.areaBox.toRealNumberBox(), (class_2350)wallFacing.method_10153()).method_1005().method_1019(wallFacingVec.method_1021(0.001));
        CustomPortal portal = null;
        boolean isExistingPortal = false;
        if (thisSideInfo != null && (entity = world.method_14190(thisSideInfo.portalId())) instanceof CustomPortal) {
            CustomPortal customPortal;
            portal = customPortal = (CustomPortal)entity;
            isExistingPortal = true;
        }
        if (portal == null) {
            portal = (CustomPortal)CustomPortal.entityType.method_5883((class_1937)world);
            Validate.notNull((Object)((Object)portal));
        }
        portal.setOriginPos(newPortalOrigin);
        portal.setOrientationAndSize(class_243.method_24954((class_2382)rightDir.method_10163()), class_243.method_24954((class_2382)upDir.method_10163()), (double)kind.getWidth() * 0.96875, (double)kind.getHeight() * 0.96875);
        portal.descriptor = descriptor;
        portal.wallBox = placement.wallBox;
        portal.airBox = placement.areaBox;
        portal.setAllowedBlocks(itemInfo.allowedBlocks);
        portal.thisSideUpdateCounter = thisSideInfo == null ? 0 : thisSideInfo.updateCounter();
        portal.otherSideUpdateCounter = otherSideInfo == null ? 0 : otherSideInfo.updateCounter();
        PortalManipulation.makePortalRound((Portal)portal, (int)20);
        portal.disableDefaultAnimation();
        if (otherSideInfo == null) {
            portal.setDestinationDimension(world.method_27983());
            portal.setDestination(newPortalOrigin.method_1031(0.0, 10.0, 0.0));
            portal.setIsVisible(false);
            portal.teleportable = false;
        } else {
            portal.setDestinationDimension(otherSideInfo.portalDim());
            portal.setDestination(otherSideInfo.portalPos());
            portal.setOtherSideOrientation(otherSideInfo.portalOrientation());
            portal.setIsVisible(true);
            portal.teleportable = true;
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), PortalGunMod.PORTAL_OPEN_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
        ++portal.thisSideUpdateCounter;
        thisSideInfo = new PortalGunRecord.PortalInfo(portal.method_5667(), (class_5321<class_1937>)world.method_27983(), newPortalOrigin, portal.getOrientationRotation(), portal.thisSideUpdateCounter);
        record.data.put(descriptor, thisSideInfo);
        record.method_80();
        if (!isExistingPortal) {
            McHelper.spawnServerEntity((class_1297)portal);
        } else {
            portal.reloadAndSyncToClient();
        }
        return true;
    }

    private static boolean checkAction(class_3222 player, class_3218 world) {
        class_2881 endDragonFight;
        if (world.method_27983() == class_1937.field_25181 && (endDragonFight = world.method_29198()) != null && !endDragonFight.method_12536()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Using portal gun in end before killing any ender dragon is not allowed"), true);
            return false;
        }
        return true;
    }

    @Nullable
    private static PortalPlacement findPortalPlacement(class_3222 player, PortalGunRecord.PortalGunKind kind, PortalUtils.PortalAwareRaytraceResult raytraceResult, PortalGunRecord.PortalDescriptor descriptor, BiPredicate<class_1937, class_2338> wallPredicate) {
        class_3965 blockHit = raytraceResult.hitResult();
        class_3218 world = (class_3218)raytraceResult.world();
        class_2338 interactingAirPos = blockHit.method_17777().method_10093(blockHit.method_17780());
        class_2350 wallFacing = blockHit.method_17780();
        class_2350 playerGravity = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
        class_2350 transformedGravity = raytraceResult.portalsPassingThrough().stream().reduce(playerGravity, (gravity, portal) -> portal.getTeleportedGravityDirection(gravity), (g1, g2) -> {
            throw new RuntimeException();
        });
        class_243 viewVector = player.method_5828(1.0f);
        class_243 transformedViewVector = raytraceResult.portalsPassingThrough().stream().reduce(viewVector, (v, portal) -> portal.transformLocalVec(v), (v1, v2) -> {
            throw new RuntimeException();
        });
        class_243 viewVectorLocal = GravityChangerInterface.invoker.transformWorldToPlayer(transformedGravity, transformedViewVector);
        class_2350 wallFacingLocal = GravityChangerInterface.invoker.transformDirWorldToPlayer(transformedGravity, wallFacing);
        class_2350[] upDirCandidates = Helper.getAnotherFourDirections((class_2350.class_2351)wallFacingLocal.method_10166());
        Arrays.sort(upDirCandidates, Comparator.comparingDouble(dir -> {
            if (dir == class_2350.field_11036) {
                return 1.0;
            }
            return (double)dir.method_10163().method_10263() * viewVectorLocal.field_1352 + (double)dir.method_10163().method_10260() * viewVectorLocal.field_1350;
        }).reversed());
        class_2338 portalAreaSize = new class_2338(kind.getWidth(), kind.getHeight(), 1);
        for (class_2350 upDir : upDirCandidates) {
            AARotation rot = AARotation.getAARotationFromYZ((class_2350)upDir, (class_2350)wallFacing);
            class_2338 transformedSize = rot.transform((class_2382)portalAreaSize);
            IntBox portalArea = IntBox.getBoxByPosAndSignedSize((class_2338)interactingAirPos, (class_2338)transformedSize);
            IntBox wallArea = portalArea.getMoved(wallFacing.method_10153().method_10163());
            if (!PortalGunMod.isAreaClear((class_1937)world, portalArea) || !wallArea.fastStream().allMatch(p -> wallPredicate.test((class_1937)world, (class_2338)p)) || PortalGunItem.otherPortalExistsInArea((class_1937)world, wallArea, wallFacing, descriptor)) continue;
            return new PortalPlacement(rot, portalArea, wallArea);
        }
        return null;
    }

    private static boolean otherPortalExistsInArea(class_1937 world, IntBox wallArea, class_2350 wallFacing, PortalGunRecord.PortalDescriptor descriptor) {
        List portals = McHelper.findEntitiesByBox(CustomPortal.class, (class_1937)world, (class_238)wallArea.toRealNumberBox().method_1014(0.1), (double)IPGlobal.maxNormalPortalRadius, p -> p.getApproximateFacingDirection() == wallFacing && IntBox.getIntersect((IntBox)p.wallBox, (IntBox)wallArea) != null && !Objects.equals(p.descriptor, descriptor));
        return !portals.isEmpty();
    }

    public record ItemInfo(BlockList allowedBlocks) {
        public static ItemInfo fromTag(class_2487 tag) {
            return new ItemInfo(BlockList.fromTag(tag.method_10554("allowedBlocks", 8)));
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10566("allowedBlocks", (class_2520)this.allowedBlocks.toTag());
            return tag;
        }
    }

    private record PortalPlacement(AARotation rotation, IntBox areaBox, IntBox wallBox) {
    }
}

