/*
 * Decompiled with CFR 0.152.
 */
package tk.meowmc.portalgun;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalGunRecord
extends class_18 {
    private static Logger LOGGER = LogManager.getLogger();
    public final Map<PortalDescriptor, PortalInfo> data;

    public PortalGunRecord(Map<PortalDescriptor, PortalInfo> data) {
        this.data = data;
    }

    public static PortalGunRecord get() {
        class_3218 overworld = MiscHelper.getServer().method_30002();
        return (PortalGunRecord)overworld.method_17983().method_17924(PortalGunRecord::load, () -> {
            Helper.log((Object)"Portal gun record initialized ");
            return new PortalGunRecord(new HashMap<PortalDescriptor, PortalInfo>());
        }, "portal_gun_record");
    }

    public class_2487 method_75(class_2487 compoundTag) {
        class_2499 dataTag = new class_2499();
        this.data.forEach((key, value) -> {
            class_2487 entryTag = new class_2487();
            entryTag.method_10566("key", (class_2520)key.toTag());
            entryTag.method_10566("value", (class_2520)value.toTag());
            dataTag.add((Object)entryTag);
        });
        compoundTag.method_10566("data", (class_2520)dataTag);
        return compoundTag;
    }

    public static PortalGunRecord load(class_2487 compoundTag) {
        class_2499 dataTag = compoundTag.method_10554("data", 10);
        try {
            Map<PortalDescriptor, PortalInfo> data = dataTag.stream().map(class_2487.class::cast).collect(Collectors.toMap(entryTag -> PortalDescriptor.fromTag(entryTag.method_10562("key")), entryTag -> PortalInfo.fromTag(entryTag.method_10562("value"))));
            return new PortalGunRecord(data);
        }
        catch (Exception e) {
            LOGGER.error("Failed to deserialize portal gun info", (Throwable)e);
            return new PortalGunRecord(new HashMap<PortalDescriptor, PortalInfo>());
        }
    }

    public record PortalInfo(UUID portalId, class_5321<class_1937> portalDim, class_243 portalPos, DQuaternion portalOrientation, int updateCounter) {
        class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_25927("portalId", this.portalId);
            tag.method_10582("portalDim", this.portalDim.method_29177().toString());
            tag.method_10549("portalPosX", this.portalPos.field_1352);
            tag.method_10549("portalPosY", this.portalPos.field_1351);
            tag.method_10549("portalPosZ", this.portalPos.field_1350);
            tag.method_10566("portalOrientation", this.portalOrientation.toTag());
            tag.method_10569("updateCounter", this.updateCounter);
            return tag;
        }

        static PortalInfo fromTag(class_2487 tag) {
            return new PortalInfo(tag.method_25926("portalId"), (class_5321<class_1937>)DimId.idToKey((class_2960)new class_2960(tag.method_10558("portalDim"))), new class_243(tag.method_10574("portalPosX"), tag.method_10574("portalPosY"), tag.method_10574("portalPosZ")), DQuaternion.fromTag((class_2520)tag.method_10562("portalOrientation")), tag.method_10550("updateCounter"));
        }
    }

    public record PortalDescriptor(UUID playerId, PortalGunKind kind, PortalGunSide side) {
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_25927("playerId", this.playerId);
            tag.method_10582("kind", this.kind.name());
            tag.method_10582("side", this.side.name());
            return tag;
        }

        public static PortalDescriptor fromTag(class_2487 tag) {
            return new PortalDescriptor(tag.method_25926("playerId"), PortalGunKind.fromString(tag.method_10558("kind")), PortalGunSide.fromString(tag.method_10558("side")));
        }

        public PortalDescriptor getTheOtherSide() {
            return new PortalDescriptor(this.playerId, this.kind, this.side.getTheOtherSide());
        }
    }

    public static enum PortalGunSide {
        blue,
        orange;


        public static PortalGunSide fromString(String c) {
            return switch (c) {
                case "orange" -> orange;
                case "blue" -> blue;
                default -> orange;
            };
        }

        public PortalGunSide getTheOtherSide() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case orange -> blue;
                case blue -> orange;
            };
        }

        public int getColorInt() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case orange -> 15630107;
                case blue -> 24031;
            };
        }
    }

    public static enum PortalGunKind {
        _2x1;


        public static PortalGunKind fromString(String c) {
            return switch (c) {
                case "_2x1" -> _2x1;
                default -> _2x1;
            };
        }

        public int getWidth() {
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case _2x1: 
            }
            return 1;
        }

        public int getHeight() {
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case _2x1: 
            }
            return 2;
        }
    }
}

