/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.playerattributescreen.mixin.client.gui.screen.ingame;

import com.github.theredbrain.playerattributescreen.PlayerAttributeScreen;
import com.github.theredbrain.playerattributescreen.PlayerAttributeScreenClient;
import com.github.theredbrain.playerattributescreen.config.ClientConfig;
import com.github.theredbrain.playerattributescreen.gui.screen.ingame.DuckAbstractInventoryScreenMixin;
import com.github.theredbrain.playerattributescreen.gui.widget.ToggleInventoryScreenWidget;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_518;
import net.minecraft.class_7919;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin
extends class_485<class_1723>
implements class_518,
DuckAbstractInventoryScreenMixin {
    @Unique
    private static final class_2960 INVENTORY_SIDES_BACKGROUND_TEXTURE = PlayerAttributeScreen.identifier("textures/gui/container/inventory_sides_background.png");
    @Unique
    private static final class_2960 SCROLL_BAR_BACKGROUND_8_206_TEXTURE = PlayerAttributeScreen.identifier("textures/gui/sprites/scroll_bar/scroll_bar_background_8_152.png");
    @Unique
    private static final class_2960 SCROLLER_VERTICAL_6_15_TEXTURE = PlayerAttributeScreen.identifier("textures/gui/sprites/scroll_bar/scroller_vertical_6_15.png");
    @Unique
    private static final class_2561 TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF = class_2561.method_43471((String)"gui.inventory.toggleShowAttributeScreenButton.off.tooltip");
    @Unique
    private static final class_2561 TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON = class_2561.method_43471((String)"gui.inventory.toggleShowAttributeScreenButton.on.tooltip");
    @Unique
    private static final int MAX_ATTRIBUTE_SCREEN_LINES = 12;
    @Shadow
    @Final
    private class_507 field_2929;
    @Unique
    private class_4185 toggleShowAttributeScreenButton;
    @Unique
    private final int sidesBackgroundWidth = 130;
    @Unique
    private boolean showAttributeScreen;
    @Unique
    private int attributeListSize = 0;
    @Unique
    private int attributeScrollPosition = 0;
    @Unique
    private float attributeScrollAmount = 0.0f;
    @Unique
    private boolean attributeMouseClicked = false;

    public InventoryScreenMixin(class_1723 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    protected void playerattributescreen$init(CallbackInfo ci) {
        ClientConfig clientConfig = PlayerAttributeScreenClient.CLIENT_CONFIG;
        this.showAttributeScreen = (Boolean)clientConfig.show_attribute_screen_when_opening_inventory_screen.get() != false && (Boolean)PlayerAttributeScreen.SERVER_CONFIG.disable_player_attribute_screen.get() == false;
        this.toggleShowAttributeScreenButton = (class_4185)this.method_37063((class_364)new ToggleInventoryScreenWidget(this.field_2776 + (Integer)clientConfig.attribute_screen_button_x.get(), this.field_2800 + (Integer)clientConfig.attribute_screen_button_y.get(), this.showAttributeScreen, true, button -> {
            if (!this.field_2929.method_2605()) {
                this.playerattributescreen$toggleShowAttributeScreen();
            }
        }));
        this.toggleShowAttributeScreenButton.method_47400(class_7919.method_47407((class_2561)(this.showAttributeScreen ? TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON : TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF)));
        this.attributeScrollPosition = 0;
        this.attributeScrollAmount = 0.0f;
        this.attributeMouseClicked = false;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void playerattributescreen$render_head(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.playerattributescreen$calculateRenderState();
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void playerattributescreen$render_tail(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.playerattributescreen$drawAttributeScreen(context, mouseX, mouseY);
    }

    @Inject(method={"drawBackground"}, at={@At(value="TAIL")})
    protected void playerattributescreen$drawBackground(class_332 context, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        if (this.showAttributeScreen) {
            context.method_25290(INVENTORY_SIDES_BACKGROUND_TEXTURE, this.field_2776 + this.field_2792, this.field_2800, 0.0f, 0.0f, this.sidesBackgroundWidth, this.field_2779, this.sidesBackgroundWidth, this.field_2779);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        int number = this.attributeScrollPosition;
        float number1 = this.attributeScrollAmount;
        boolean bool = this.attributeMouseClicked;
        boolean bool1 = this.showAttributeScreen;
        this.method_25423(client, width, height);
        this.attributeScrollPosition = number;
        this.attributeScrollAmount = number1;
        this.attributeMouseClicked = bool;
        this.showAttributeScreen = bool1;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    public void playerattributescreen$mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.attributeListSize > 12 && this.showAttributeScreen) {
            int i = this.field_2776 + this.field_2792 + this.sidesBackgroundWidth - 7;
            int j = this.field_2800 + 7;
            if (mouseX >= (double)i && mouseX < (double)(i + 6) && mouseY >= (double)j && mouseY < (double)(j + 152)) {
                this.attributeMouseClicked = true;
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.attributeListSize > 12 && this.attributeMouseClicked && this.showAttributeScreen) {
            int i = this.attributeListSize - 12;
            float f = (float)deltaY / (float)i;
            this.attributeScrollAmount = class_3532.method_15363((float)(this.attributeScrollAmount + f), (float)0.0f, (float)1.0f);
            this.attributeScrollPosition = (int)(this.attributeScrollAmount * (float)i);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        int scrollAreaStartX = this.field_2776 + this.field_2792 + 7;
        int scrollAreaWidth = 116;
        int scrollAreaStartY = this.field_2800 + 7;
        int scrollAreaHeight = 152;
        if (this.showAttributeScreen && this.attributeListSize > 12 && mouseX >= (double)scrollAreaStartX && mouseX <= (double)(scrollAreaStartX + scrollAreaWidth) && mouseY >= (double)scrollAreaStartY && mouseY <= (double)(scrollAreaStartY + scrollAreaHeight)) {
            int i = this.attributeListSize - 12;
            float f = (float)verticalAmount / (float)i;
            this.attributeScrollAmount = class_3532.method_15363((float)(this.attributeScrollAmount - f), (float)0.0f, (float)1.0f);
            this.attributeScrollPosition = (int)(this.attributeScrollAmount * (float)i);
        }
        return true;
    }

    @Unique
    private void playerattributescreen$calculateRenderState() {
        if (this.field_2929.method_2605() || ((Boolean)PlayerAttributeScreen.SERVER_CONFIG.disable_player_attribute_screen.get()).booleanValue()) {
            if (this.showAttributeScreen) {
                this.playerattributescreen$toggleShowAttributeScreen();
            }
            if (this.toggleShowAttributeScreenButton.field_22764) {
                this.toggleShowAttributeScreenButton.field_22764 = false;
            }
        } else if (!this.toggleShowAttributeScreenButton.field_22764) {
            this.toggleShowAttributeScreenButton.field_22764 = true;
        }
        this.toggleShowAttributeScreenButton.method_48229(this.field_2776 + (Integer)PlayerAttributeScreenClient.CLIENT_CONFIG.attribute_screen_button_x.get(), this.field_2800 + (Integer)PlayerAttributeScreenClient.CLIENT_CONFIG.attribute_screen_button_y.get());
    }

    @Unique
    private void playerattributescreen$toggleShowAttributeScreen() {
        this.showAttributeScreen = !this.showAttributeScreen;
        ((ToggleInventoryScreenWidget)this.toggleShowAttributeScreenButton).setIsPressed(this.showAttributeScreen);
        this.toggleShowAttributeScreenButton.method_47400(this.showAttributeScreen ? class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_ON) : class_7919.method_47407((class_2561)TOGGLE_SHOW_ATTRIBUTES_BUTTON_TOOLTIP_TEXT_OFF));
        this.attributeScrollPosition = 0;
        this.attributeScrollAmount = 0.0f;
        this.attributeMouseClicked = false;
    }

    @Unique
    private void playerattributescreen$drawAttributeScreen(class_332 context, int mouseX, int mouseY) {
        if (!this.showAttributeScreen) {
            return;
        }
        int x = this.field_2776 + this.field_2792 + 7;
        int y = this.field_2800 + 7;
        List<MutablePair<class_2561, List<class_2561>>> list = PlayerAttributeScreenClient.getPlayerAttributeScreenData(this.field_22787);
        this.attributeListSize = list.size();
        for (int i = this.attributeScrollPosition; i < Math.min(this.attributeListSize, this.attributeScrollPosition + 12); ++i) {
            List tooltipList;
            int currentY = y + (i - this.attributeScrollPosition) * 13;
            context.method_51439(this.field_22793, (class_2561)list.get((int)i).left, x, currentY, 0x404040, false);
            if (mouseX < x || mouseX > x + this.sidesBackgroundWidth - 7 || mouseY < currentY || mouseY > currentY + 13 || (tooltipList = (List)list.get((int)i).right).isEmpty()) continue;
            context.method_51437(this.field_22793, tooltipList, Optional.empty(), mouseX, mouseY);
        }
        if (list.size() > 12) {
            context.method_25290(SCROLL_BAR_BACKGROUND_8_206_TEXTURE, x + 108, y, 0.0f, 0.0f, 8, 152, 8, 152);
            int k = (int)(135.0f * this.attributeScrollAmount);
            context.method_25290(SCROLLER_VERTICAL_6_15_TEXTURE, x + 109, y + 1 + k, 0.0f, 0.0f, 6, 15, 6, 15);
        }
    }

    @Override
    public boolean playerattributescreen$hideStatusEffects() {
        return this.showAttributeScreen;
    }
}

