/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2577;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;

public abstract class TileEntityPlatformBase
extends TileEntityBase
implements RenderAttachmentBlockEntity {
    private class_1799 itemBaseFrame = class_1799.field_8037;
    private class_1799 itemBaseCover = class_1799.field_8037;
    private class_1799 itemRail = class_1799.field_8037;
    private class_1799 itemCovering = class_1799.field_8037;
    private EnumCovering covering = EnumCovering.NONE;
    private class_1799 itemRailFrame = class_1799.field_8037;
    private class_1799 itemRailCover = class_1799.field_8037;
    private class_2498 soundBase = null;
    private class_2498 soundRail = null;
    private final boolean[] isColorCached = new boolean[5];
    private final int[] materialColor = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    private class_2487 cachedRenderData;

    public TileEntityPlatformBase(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void buildNBT(class_2487 nbtTag) {
        class_2487 stack;
        if (!this.itemBaseFrame.method_7960()) {
            stack = new class_2487();
            this.itemBaseFrame.method_7953(stack);
            nbtTag.method_10566("frame_texture_item", (class_2520)stack);
        }
        if (!this.itemBaseCover.method_7960()) {
            stack = new class_2487();
            this.itemBaseCover.method_7953(stack);
            nbtTag.method_10566("cover_texture_item", (class_2520)stack);
        }
        if (!this.itemRail.method_7960()) {
            stack = new class_2487();
            this.itemRail.method_7953(stack);
            nbtTag.method_10566("rail_item", (class_2520)stack);
        }
        if (this.covering != EnumCovering.NONE) {
            nbtTag.method_10582("covering", this.covering.method_15434());
            if (!this.itemCovering.method_7960()) {
                stack = new class_2487();
                this.itemCovering.method_7953(stack);
                nbtTag.method_10566("covering_item", (class_2520)stack);
            }
        }
    }

    protected void processNBT(class_2487 nbtTag) {
        if (nbtTag.method_10545("frame_texture_item")) {
            this.itemBaseFrame = class_1799.method_7915((class_2487)nbtTag.method_10562("frame_texture_item"));
        }
        if (nbtTag.method_10545("cover_texture_item")) {
            this.itemBaseCover = class_1799.method_7915((class_2487)nbtTag.method_10562("cover_texture_item"));
        }
        if (nbtTag.method_10545("rail_item")) {
            this.setRailItem(class_1799.method_7915((class_2487)nbtTag.method_10562("rail_item")));
        }
        if (nbtTag.method_10545("covering")) {
            this.covering = EnumCovering.byName(nbtTag.method_10558("covering"));
            if (nbtTag.method_10545("covering_item")) {
                this.setCoveringTexture(class_1799.method_7915((class_2487)nbtTag.method_10562("covering_item")));
            }
            if (this.itemCovering.method_7960()) {
                this.covering = EnumCovering.NONE;
            }
        }
        this.updateRenderData();
    }

    public void copySettingsFrom(class_2586 tile) {
        if (tile instanceof TileEntityPlatformBase) {
            class_2487 nbtTag = new class_2487();
            ((TileEntityPlatformBase)tile).buildNBT(nbtTag);
            this.processNBT(nbtTag);
        }
    }

    public void setTextureInfo(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemBlockPlatform) {
            this.setFrameTextureBlock(ItemBlockPlatform.getFrameTextureStack(stack));
            this.setCoverTextureBlock(ItemBlockPlatform.getCoverTextureStack(stack));
        }
    }

    public void setFrameTextureBlock(class_1799 stack) {
        this.itemBaseFrame = stack;
    }

    public class_1799 getFrameTextureBlock() {
        return this.itemBaseFrame;
    }

    public void setCoverTextureBlock(class_1799 stack) {
        this.itemBaseCover = stack;
    }

    public class_1799 getCoverTextureBlock() {
        return this.itemBaseCover;
    }

    public class_1799 getRailFrameTextureBlock() {
        return this.itemRailFrame;
    }

    public class_1799 getRailCoverTextureBlock() {
        return this.itemRailCover;
    }

    public class_2498 getSoundType() {
        if (this.soundBase == null) {
            this.soundBase = this.merge(this.getSoundType(this.itemBaseFrame), this.getSoundType(this.itemBaseCover));
        }
        return this.soundBase;
    }

    public class_2498 getRailSound() {
        if (this.soundRail == null) {
            this.soundRail = this.merge(this.getSoundType(this.itemRailFrame), this.getSoundType(this.itemRailCover));
        }
        return this.soundRail;
    }

    private class_2498 getSoundType(class_1799 stack) {
        class_2498 soundType = null;
        if (!stack.method_7960() && stack.method_7909() instanceof class_1747 && this.field_11863 != null) {
            class_2680 state = UseContext.getBlockPlacementStateFor((class_1799)stack, (class_1937)this.field_11863);
            soundType = ((class_1747)stack.method_7909()).method_7711().method_9573(state);
        }
        return soundType;
    }

    private class_2498 merge(class_2498 frame, class_2498 cover) {
        if (frame == cover) {
            return frame != null ? frame : class_2498.field_11547;
        }
        frame = frame != null ? frame : class_2498.field_11547;
        cover = cover != null ? cover : class_2498.field_11547;
        return new class_2498(1.0f, 1.0f, frame.method_10595(), cover.method_10594(), frame.method_10598(), frame.method_10596(), cover.method_10593());
    }

    public boolean hasRail() {
        return !this.itemRail.method_7960();
    }

    public void removeRail() {
        this.itemRail = class_1799.field_8037;
        this.itemRailFrame = class_1799.field_8037;
        this.itemRailCover = class_1799.field_8037;
        this.isColorCached[2] = false;
        this.isColorCached[3] = false;
        this.materialColor[2] = 0xFFFFFF;
        this.materialColor[3] = 0xFFFFFF;
        this.updateLightValue();
    }

    public boolean setRailItem(class_1799 stack) {
        ItemBlockPlatform platform;
        class_1792 class_17922;
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)class_17922).getPlatformType().isAddon()) {
            this.itemRail = stack.method_7972().method_7971(1);
            this.itemRailFrame = ItemBlockPlatform.getFrameTextureStack(stack);
            this.itemRailCover = ItemBlockPlatform.getCoverTextureStack(stack);
            this.updateLightValue();
            return true;
        }
        return false;
    }

    public class_1799 getRailItem() {
        return this.itemRail;
    }

    public EnumPlatformType getRailType() {
        if (this.hasRail()) {
            ItemBlockPlatform platform;
            class_1792 class_17922;
            if (!this.itemRail.method_7960() && (class_17922 = this.itemRail.method_7909()) instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)class_17922).getPlatformType().isAddon()) {
                return platform.getPlatformType();
            }
            this.removeRail();
        }
        return null;
    }

    public EnumCovering getCovering() {
        return this.covering;
    }

    public void setCovering(EnumCovering covering) {
        this.covering = covering;
        if (covering == EnumCovering.NONE) {
            this.removeCoveringTexture();
        } else {
            this.updateLightValue();
            this.updateRenderData();
        }
        Function.syncTile((class_2586)this);
    }

    public void copyCovering(TileEntityPlatformBase tile) {
        this.covering = tile.covering;
        this.itemCovering = tile.itemCovering;
        this.isColorCached[4] = tile.isColorCached[4];
        this.materialColor[4] = tile.materialColor[4];
        this.updateLightValue();
        this.updateRenderData();
        Function.syncTile((class_2586)this);
    }

    public void removeCoveringTexture() {
        this.itemCovering = class_1799.field_8037;
        this.isColorCached[4] = false;
        this.materialColor[4] = 0xFFFFFF;
        this.updateLightValue();
        this.updateRenderData();
    }

    protected boolean canApplyCovering(EnumCovering covering) {
        return true;
    }

    private EnumCovering setCoveringTexture(class_1799 stack, EnumCovering covering) {
        if (this.canApplyCovering(covering)) {
            this.itemCovering = stack;
            this.isColorCached[4] = false;
            this.materialColor[4] = 0xFFFFFF;
            return covering;
        }
        return EnumCovering.NONE;
    }

    public EnumCovering setCoveringTexture(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof class_1747) {
            return this.setCoveringTexture(((class_1747)stack.method_7909()).method_7711());
        }
        return EnumCovering.NONE;
    }

    private EnumCovering setCoveringTexture(class_2248 block) {
        if (TagHelper.isBlockInTag((class_2248)block, (class_6862)class_3481.field_29823) || TagHelper.isBlockInTag((class_2248)block, (class_6862)class_3481.field_15466) || block instanceof class_2346 && block.method_9520() <= 0.8f) {
            return this.setCoveringTexture(new class_1799((class_1935)block), EnumCovering.F3);
        }
        if (block instanceof class_2577) {
            return this.setCoveringTexture(new class_1799((class_1935)block), EnumCovering.S2);
        }
        return EnumCovering.NONE;
    }

    public void playCoveringSound(class_1657 player, boolean place) {
        if (this.field_11863 != null && !this.itemCovering.method_7960() && player != null) {
            if (this.itemCovering.method_7909() instanceof class_1747) {
                class_2248 block = ((class_1747)this.itemCovering.method_7909()).method_7711();
                if (place) {
                    this.field_11863.method_8396(player, this.field_11867, block.method_9573(block.method_9564()).method_10598(), class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
                } else {
                    this.field_11863.method_8396(player, this.field_11867, block.method_9573(block.method_9564()).method_10595(), class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
                }
            } else {
                this.removeCoveringTexture();
            }
        }
    }

    public class_1799 getCoveringStack() {
        return this.itemCovering;
    }

    public class_2248 getCoveringBlock() {
        if (!this.itemCovering.method_7960() && this.itemCovering.method_7909() instanceof class_1747) {
            return ((class_1747)this.itemCovering.method_7909()).method_7711();
        }
        this.removeCoveringTexture();
        return class_2246.field_10124;
    }

    public class_2248 getBiomeCovering(class_6880<class_1959> biomeRegistryEntry) {
        class_1959 biome = (class_1959)biomeRegistryEntry.comp_349();
        return biome.method_33599(this.field_11867) ? class_2246.field_10491 : BlockPlatformBase.getBiomeTopBlock(biomeRegistryEntry);
    }

    public void addExtraDrops(List<class_1799> drops) {
        if (this.hasRail()) {
            drops.add(this.itemRail);
        }
    }

    public int getTint(int index) {
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            if (index >= 0 && index < 5 && !this.isColorCached[index]) {
                class_1799 material;
                class_1799 class_17992 = index == 4 ? this.itemCovering : (index == 3 ? this.itemRailCover : (index == 2 ? this.itemRailFrame : (material = index == 1 ? this.itemBaseCover : this.itemBaseFrame)));
                if (!material.method_7960() && this.field_11863 != null) {
                    this.materialColor[index] = class_310.method_1551().method_1505().method_1697(UseContext.getBlockPlacementStateFor((class_1799)material, (class_1937)this.field_11863), (class_1920)this.field_11863, this.field_11867, 0);
                    this.isColorCached[index] = true;
                }
            }
        });
        return index >= 0 && index < 5 ? this.materialColor[index] : 0xFFFFFF;
    }

    protected void updateLightValue() {
        if (this.field_11863 != null) {
            BlockPlatformBase.updateLighting(this.method_11010(), this.field_11863, this.field_11867, this);
        }
    }

    public void updateRenderData() {
        this.cachedRenderData = null;
    }

    public Object getRenderAttachmentData() {
        if (this.cachedRenderData == null) {
            class_2487 nbtTag = new class_2487();
            if (this.itemCovering.method_7960() && this.field_11863 != null) {
                this.setCoveringTexture(this.getBiomeCovering((class_6880<class_1959>)this.field_11863.method_23753(this.field_11867)));
            }
            this.buildNBT(nbtTag);
            this.cachedRenderData = nbtTag;
        }
        return this.cachedRenderData;
    }
}

