/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.ISideAssignableWrapper;
import shetiphian.core.common.inventory.InventorySideAssignable;
import shetiphian.core.common.tileentity.IDetachedSidedInventory;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Roster;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.inventory.InventoryPlatFormer;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISideAssignableWrapper,
IOutputSlot,
IDetachedSidedInventory {
    public InventorySideAssignable inventory;
    public EnumPlatformType platformType = EnumPlatformType.FLAT;
    private final class_1799[] deconstructCache = new class_1799[]{class_1799.field_8037, class_1799.field_8037, class_1799.field_8037};
    private EntityGuiItem displayItem = null;
    private class_1799 outputItem = class_1799.field_8037;

    public TileEntityPlatFormer(class_2338 pos, class_2680 state) {
        super(Roster.Tiles.PLATFORMER, pos, state);
        this.inventory = new InventoryPlatFormer(this);
    }

    protected void buildNBT(class_2487 nbtTag) {
        nbtTag.method_10582("platform_type", this.platformType.method_15434());
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT(class_2487 nbtTag) {
        this.platformType = EnumPlatformType.byName(nbtTag.method_10558("platform_type"));
        this.inventory.readFromNBT(nbtTag, nbtTag.method_10545("items") ? "items" : "inventory");
    }

    @NotNull
    public InventorySideAssignable getInventory() {
        return this.inventory;
    }

    @NotNull
    public InventorySideAssignable getSideAssignableInventory() {
        return this.inventory;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TileEntityPlatFormer tile) {
        Optional<EnumPlatformType> optional;
        class_1799 deconStack;
        if (tile.outputItem.method_7960()) {
            tile.updateOutput();
        }
        if (!(deconStack = tile.inventory.method_5438(5)).method_7960() && (optional = EnumPlatformType.findOrFail(deconStack.method_7909())).isPresent()) {
            int needed = tile.getCraftedAmount(optional.get(), deconStack);
            if (deconStack.method_7947() >= needed) {
                tile.deconstruct(needed);
            }
        }
    }

    private void deconstruct(int needed) {
        class_1799 deconStack = this.inventory.method_5438(5);
        if (deconStack.method_7960()) {
            return;
        }
        if (!Function.areItemStacksEqual((class_1799)this.deconstructCache[0], (class_1799)deconStack)) {
            this.deconstructCache[0] = deconStack;
            this.deconstructCache[1] = ItemBlockPlatform.getFrameTextureStack(deconStack);
            this.deconstructCache[2] = ItemBlockPlatform.getCoverTextureStack(deconStack);
        }
        if (this.deconstructCache[1].method_7960() || this.deconstructCache[2].method_7960()) {
            return;
        }
        int[] slots = new int[]{-1, -1};
        HashMap<Byte, class_1799> changes = new HashMap<Byte, class_1799>();
        block0: for (int item = 0; item < 2; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 6; slot < 15; slot = (byte)((byte)(slot + 1))) {
                    class_1799 stack;
                    class_1799 class_17992 = stack = changes.containsKey(slot) ? (class_1799)changes.get(slot) : this.inventory.getContents()[slot];
                    if (!stack.method_7960()) {
                        if (stack.method_7947() >= stack.method_7914() || !Function.areItemStacksEqual((class_1799)stack, (class_1799)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        stack = stack.method_7972();
                        stack.method_7933(1);
                        changes.put(slot, stack);
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    changes.put(slot, this.deconstructCache[1 + item].method_7972());
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1) {
            for (Map.Entry entry : changes.entrySet()) {
                this.inventory.getContents()[((Byte)entry.getKey()).byteValue()] = (class_1799)entry.getValue();
            }
            if (deconStack.method_7947() - needed < 1) {
                deconStack = class_1799.field_8037;
            } else {
                deconStack.method_7934(needed);
            }
            this.inventory.method_5447(5, deconStack);
            this.method_5431();
        }
    }

    public void addExtraDrops(List<class_1799> drops) {
        for (int slotId = 4; slotId < this.inventory.getContents().length; ++slotId) {
            class_1799 stack = this.inventory.method_5438(slotId);
            if (stack.method_7960()) continue;
            drops.add(stack);
        }
    }

    private int getCraftedAmount(EnumPlatformType platformType, class_1799 stack) {
        int multiplier = 0;
        if (this.isStorageBlock(ItemBlockPlatform.getFrameTextureStack(stack))) {
            ++multiplier;
        }
        if (this.isStorageBlock(ItemBlockPlatform.getCoverTextureStack(stack))) {
            ++multiplier;
        }
        multiplier = multiplier == 0 ? 1 : multiplier * Platforms.CONFIG.COMMON.CRAFTING.blockMultiplier;
        return class_3532.method_15340((int)(platformType.getCraftAmount() * multiplier), (int)1, (int)stack.method_7914());
    }

    private boolean isStorageBlock(class_1799 stack) {
        return !stack.method_7960() && TagHelper.isItemInTag((class_1799)stack, (String)"c:storage_blocks");
    }

    public void updateOutput() {
        if (this.method_10997() == null) {
            return;
        }
        this.setGhostSlot(0, this.inventory.method_5438(0));
        this.setGhostSlot(1, this.inventory.method_5438(1));
        this.outputItem = ItemBlockPlatform.createStack((class_2248)Values.getPlatform(this.platformType), this.inventory.method_5438(1), this.inventory.method_5438(0));
        if (!this.outputItem.method_7960()) {
            this.outputItem.method_7939(this.getCraftedAmount(this.platformType, this.outputItem));
            class_1799 displayStack = this.outputItem.method_7972();
            displayStack.method_7939(1);
            DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
                this.displayItem = new EntityGuiItem(this.method_10997(), 0.0, 0.0, 0.0, displayStack);
            });
            if (this.inventory.method_5438(0).method_7960() || this.inventory.method_5438(1).method_7960()) {
                this.inventory.method_5447(3, class_1799.field_8037);
            } else {
                this.inventory.method_5447(3, this.outputItem.method_7972());
            }
        }
    }

    public EntityGuiItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        class_1799[] craftStacks = new class_1799[]{this.inventory.method_5438(0), this.inventory.method_5438(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            class_1799 stack = this.inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((class_1799)stack, (class_1799)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((class_1799)craftStacks[0], (class_1799)craftStacks[1]) || stack.method_7947() <= 1) continue;
                hasItem[1] = true;
            }
            if (hasItem[1] || !Function.areItemStacksEqual((class_1799)stack, (class_1799)craftStacks[1])) continue;
            hasItem[1] = true;
        }
        return hasItem[0] && hasItem[1];
    }

    public void doCraft() {
        class_1799[] craftStacks = new class_1799[]{this.inventory.method_5438(0), this.inventory.method_5438(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            class_1799 stack = this.inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            for (int part = 0; part < 2; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((class_1799)stack, (class_1799)craftStacks[part])) continue;
                hasItem[part] = true;
                if (stack.method_7947() == 1) {
                    this.inventory.method_5447(slot, class_1799.field_8037);
                    continue;
                }
                stack.method_7934(1);
            }
        }
    }

    public void setGhostSlot(int slotId, class_1799 stack) {
        if (stack.method_7960() || !(stack.method_7909() instanceof class_1747)) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory.method_5447(slotId, class_1799.field_8037);
            }
            return;
        }
        boolean itemOK = false;
        if (slotId == 0 || slotId == 1) {
            boolean bl = itemOK = !(((class_1747)stack.method_7909()).method_7711() instanceof class_2343);
        }
        if (itemOK) {
            this.inventory.method_5447(slotId, stack.method_7972().method_7971(1));
        } else {
            this.inventory.method_5447(slotId, class_1799.field_8037);
        }
    }

    public boolean canTakeFromOutputSlot(int slotId, class_1657 player) {
        return slotId != 3 || player.method_31549().field_7477 || this.canCraft();
    }

    public class_1799 shrinkStackSize(int slotId, class_1657 player, int amount) {
        if (slotId == 3 && player.method_31549().field_7477) {
            return this.inventory.method_5438(3).method_7972();
        }
        return class_1799.field_8037;
    }

    public void onPickupFromOutputSlot(int slotId, class_1657 player, class_1799 stack) {
    }

    public class_1799 getOutputItem() {
        return this.outputItem != null ? this.outputItem.method_7972() : class_1799.field_8037;
    }
}

