/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import shetiphian.core.common.Function;
import shetiphian.core.common.network.PacketBase;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class PacketWrenchEdit
extends PacketBase {
    private class_2487 changes;
    private Set<class_2338> edit;
    private Set<class_2338> place;
    private int cachedSlot = -1;

    public PacketWrenchEdit() {
    }

    public PacketWrenchEdit(class_2487 changes, Set<class_2338> edit, Set<class_2338> place) {
        this.changes = changes;
        this.edit = edit;
        this.place = place;
    }

    public void toBytes(class_2540 buffer) {
        buffer.method_10794(this.changes);
        buffer.method_10804(this.edit.size());
        this.edit.forEach(arg_0 -> ((class_2540)buffer).method_10807(arg_0));
        buffer.method_10804(this.place.size());
        this.place.forEach(arg_0 -> ((class_2540)buffer).method_10807(arg_0));
    }

    public void fromBytes(class_2540 buffer) {
        this.changes = buffer.method_10798();
        this.edit = PacketWrenchEdit.readSet(buffer);
        this.place = PacketWrenchEdit.readSet(buffer);
    }

    private static Set<class_2338> readSet(class_2540 buffer) {
        int entries = buffer.method_10816();
        if (entries > 0) {
            HashSet<class_2338> set = new HashSet<class_2338>();
            for (int count = 0; count < entries; ++count) {
                set.add(buffer.method_10811());
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClientSide(class_310 client, class_746 player) {
    }

    public void handleServerSide(MinecraftServer server, class_3222 player) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        HashMap<String, List> map = new HashMap<String, List>();
        this.edit.forEach(pos -> {
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (block instanceof BlockPlatformBase) {
                String type = ((BlockPlatformBase)block).getPlatformType().method_15434();
                if (map.containsKey(type)) {
                    ((List)map.get(type)).add(pos);
                } else {
                    ArrayList<class_2338> list = new ArrayList<class_2338>();
                    list.add((class_2338)pos);
                    map.put(type, list);
                }
            }
        });
        ArrayList drops = new ArrayList();
        AtomicReference<class_1799> placeStack = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicReference<Object> placeState = new AtomicReference<Object>(null);
        map.forEach((type, listPos) -> {
            class_2487 data = this.changes.method_10562(type);
            if (!data.method_33133()) {
                EnumSubType subType;
                class_2350 direction = data.method_10545("direction") ? class_2350.method_10139((int)data.method_10571("direction")) : null;
                EnumPlatformType platformType = data.method_10545("type") ? EnumPlatformType.byIndex(data.method_10571("type")) : null;
                EnumSubType enumSubType = subType = data.method_10545("subtype") ? EnumSubType.byIndex(data.method_10571("subtype")) : null;
                if (data.method_10577("remove")) {
                    class_1799 stack = data.method_10545("stack") ? class_1799.method_7915((class_2487)data.method_10562("stack")) : class_1799.field_8037;
                    class_2680 state = this.buildState(stack, direction, platformType, subType);
                    boolean place = data.method_10577("place");
                    if (place) {
                        placeStack.set(stack);
                        placeState.set(state);
                    }
                    listPos.forEach(pos -> {
                        drops.addAll(class_2248.method_9562((class_2680)world.method_8320(pos), (class_3218)world, (class_2338)pos, (class_2586)world.method_8321(pos)));
                        if (place && state != null) {
                            if (this.hasStack((class_1657)player, stack)) {
                                class_2586 tile;
                                class_2586 original = world.method_8321(pos);
                                if (world.method_8652(pos, state, 11) && (tile = world.method_8321(pos)) instanceof TileEntityPlatformBase) {
                                    ((TileEntityPlatformBase)tile).copySettingsFrom(original);
                                    ((TileEntityPlatformBase)tile).setTextureInfo((class_1799)placeStack.get());
                                }
                            }
                        } else {
                            world.method_8650(pos, false);
                        }
                    });
                } else {
                    if (platformType != null) {
                        listPos.forEach(pos -> {
                            class_2586 tile;
                            class_2680 state = world.method_8320(pos);
                            class_1799 stack = state.method_26204().method_9574((class_1922)world, pos, state);
                            class_2586 original = world.method_8321(pos);
                            if (world.method_8652(pos, this.buildState(state, direction, platformType, subType), 3) && (tile = world.method_8321(pos)) instanceof TileEntityPlatformBase) {
                                ((TileEntityPlatformBase)tile).copySettingsFrom(original);
                                ((TileEntityPlatformBase)tile).setTextureInfo(stack);
                            }
                        });
                    }
                    listPos.forEach(pos -> world.method_8652(pos, this.buildState(world.method_8320(pos), direction, null, subType), 3));
                }
            }
        });
        if (!this.place.isEmpty()) {
            if (placeState.get() == null) {
                for (String key : this.changes.method_10541()) {
                    EnumSubType subType;
                    EnumPlatformType platformType;
                    class_2350 direction;
                    class_2680 state;
                    class_1799 stack2;
                    class_2487 data = this.changes.method_10562(key);
                    if (!data.method_10577("place") || data.method_10577("remove")) continue;
                    class_1799 class_17992 = stack2 = data.method_10545("stack") ? class_1799.method_7915((class_2487)data.method_10562("stack")) : class_1799.field_8037;
                    if (stack2.method_7960() || (state = this.buildState(stack2, direction = data.method_10545("direction") ? class_2350.method_10139((int)data.method_10571("direction")) : null, platformType = data.method_10545("type") ? EnumPlatformType.byIndex(data.method_10571("type")) : null, subType = data.method_10545("subtype") ? EnumSubType.byIndex(data.method_10571("subtype")) : null)) == null) break;
                    placeStack.set(stack2);
                    placeState.set(state);
                    break;
                }
            }
            if (placeState.get() != null) {
                this.place.forEach(pos -> {
                    if (this.hasStack((class_1657)player, (class_1799)placeStack.get())) {
                        world.method_8652(pos, (class_2680)placeState.get(), 3);
                        class_2586 tile = world.method_8321(pos);
                        if (tile instanceof TileEntityPlatformBase) {
                            ((TileEntityPlatformBase)tile).setTextureInfo((class_1799)placeStack.get());
                        }
                    }
                });
            }
        }
        if (!player.method_31549().field_7477) {
            drops.forEach(stack -> Function.giveItem((class_1657)player, (class_1799)stack));
        }
    }

    private class_2680 buildState(class_1799 stack, class_2350 direction, EnumPlatformType platformType, EnumSubType subType) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemBlockPlatform) {
            return this.buildState(((ItemBlockPlatform)stack.method_7909()).method_7711().method_9564(), direction, platformType, subType);
        }
        return null;
    }

    private class_2680 buildState(class_2680 state, class_2350 direction, EnumPlatformType platformType, EnumSubType subType) {
        BlockPlatformBase block;
        if (platformType != null && (block = Values.getPlatform(platformType)) != null) {
            class_2680 build = block.method_9564();
            try {
                for (class_2769 property : state.method_28501()) {
                    if (!build.method_28498(property)) continue;
                    build = (class_2680)build.method_11657(property, state.method_11654(property));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            state = build;
        }
        if (direction != null && state.method_28498((class_2769)BlockPlatformBase.FACING)) {
            state = (class_2680)state.method_11657((class_2769)BlockPlatformBase.FACING, (Comparable)direction);
        }
        try {
            if (subType != null) {
                state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private boolean hasStack(class_1657 player, class_1799 stack) {
        int slot;
        if (player.method_31549().field_7477) {
            return true;
        }
        if (this.cachedSlot > -1) {
            class_1799 stack2 = player.method_31548().method_5438(this.cachedSlot);
            if (class_1799.method_7984((class_1799)stack2, (class_1799)stack)) {
                stack2.method_7934(1);
                return true;
            }
            this.cachedSlot = -1;
        }
        if ((slot = player.method_31548().method_7371(stack)) > -1) {
            this.cachedSlot = slot;
            player.method_31548().method_5438(slot).method_7934(1);
            return true;
        }
        return false;
    }
}

