/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformIncline;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public class TileHelper {
    public static TileEntityPlatformBase getPlatformTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public static boolean hasRail(TileEntityPlatformBase tile) {
        return tile != null && tile.hasRail();
    }

    public static EnumPlatformType getRail(TileEntityPlatformBase tile) {
        class_1799 rail;
        if (TileHelper.hasRail(tile) && !(rail = tile.getRailItem()).method_7960() && rail.method_7909() instanceof ItemBlockPlatform) {
            return ((ItemBlockPlatform)rail.method_7909()).getPlatformType();
        }
        return null;
    }

    public static boolean setRail(TileEntityPlatformBase tile, class_1799 stack) {
        if (!stack.method_7960()) {
            return tile.setRailItem(stack);
        }
        return false;
    }

    public static boolean removeRail(TileEntityPlatformBase tile) {
        if (TileHelper.hasRail(tile)) {
            tile.removeRail();
            return true;
        }
        return false;
    }

    public static boolean hasTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).getTorch() != EnumTorchType.NONE;
    }

    public static EnumTorchType getTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame ? ((TileEntityPlatformFrame)tile).getTorch() : null;
    }

    public static boolean setTorch(TileEntityPlatformBase tile, EnumTorchType torchType) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).setTorch(torchType);
    }

    public static boolean removeTorch(TileEntityPlatformBase tile) {
        if (TileHelper.hasTorch(tile)) {
            ((TileEntityPlatformFrame)tile).removeTorch();
            return true;
        }
        return false;
    }

    public static byte getAltSupport(class_2586 tile) {
        if (tile instanceof TileEntityPlatformIncline) {
            return ((TileEntityPlatformIncline)tile).getSupport();
        }
        if (tile instanceof TileEntityPlatformFloor) {
            return ((TileEntityPlatformFloor)tile).getSupport();
        }
        return 0;
    }

    public static void setAltSupport(class_2586 tile, int altSupport) {
        if (tile instanceof TileEntityPlatformIncline) {
            ((TileEntityPlatformIncline)tile).setSupport(altSupport);
        } else if (tile instanceof TileEntityPlatformFloor) {
            ((TileEntityPlatformFloor)tile).setSupport(altSupport);
        } else if (tile instanceof TileEntityPlatformRoof) {
            ((TileEntityPlatformRoof)tile).setSupport(altSupport);
        }
    }

    public static Optional<Boolean> isTranslucent(TileEntityPlatformBase tile) {
        if (tile != null) {
            boolean isRoof = tile instanceof TileEntityPlatformRoof;
            return TileHelper.isTranslucent(tile.getCoverTextureBlock(), isRoof ? class_1799.field_8037 : tile.getFrameTextureBlock());
        }
        return Optional.empty();
    }

    public static Optional<Boolean> isTranslucent(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemBlockPlatform) {
            boolean isRoof = ((ItemBlockPlatform)stack.method_7909()).getPlatformType().isRoof();
            return TileHelper.isTranslucent(ItemBlockPlatform.getCoverTextureStack(stack), isRoof ? class_1799.field_8037 : ItemBlockPlatform.getFrameTextureStack(stack));
        }
        return Optional.empty();
    }

    private static Optional<Boolean> isTranslucent(class_1799 itemBaseCover, class_1799 itemBaseFrame) {
        if (!itemBaseCover.method_7960()) {
            if (BlockLightingHelper.isTransmissive((class_1799)itemBaseCover)) {
                if (itemBaseFrame.method_7960()) {
                    return Optional.of(true);
                }
                return Optional.of(BlockLightingHelper.isTransmissive((class_1799)itemBaseFrame));
            }
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static int getLightValue(TileEntityPlatformBase tile) {
        if (tile != null) {
            int value = TileHelper.getMax(tile.getCoverTextureBlock(), tile.getFrameTextureBlock(), tile.getRailCoverTextureBlock(), tile.getRailFrameTextureBlock(), tile.getCoveringStack());
            return tile instanceof TileEntityPlatformFrame ? Math.max(value, ((TileEntityPlatformFrame)tile).getLightValue()) : value;
        }
        return 0;
    }

    public static int getLightValue(class_1799 stack) {
        if (!stack.method_7960()) {
            if (stack.method_7909() instanceof ItemBlockPlatform) {
                return TileHelper.getMax(ItemBlockPlatform.getCoverTextureStack(stack), ItemBlockPlatform.getFrameTextureStack(stack));
            }
            return class_3532.method_15340((int)BlockLightingHelper.getLuminosity((class_1799)stack), (int)0, (int)15);
        }
        return 0;
    }

    private static int getMax(class_1799 ... stacks) {
        int value = 0;
        for (class_1799 stack : stacks) {
            if ((value = Math.max(value, BlockLightingHelper.getLuminosity((class_1799)stack))) < 15) continue;
            return 15;
        }
        return value;
    }
}

