/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import shetiphian.core.common.DistExecutor;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class PlatformDataSet {
    private final EnumPlatformType type;
    private final String worldDirection;
    private final String worldSubType;
    private final String worldVariant;
    public final class_1799 itemStack;
    public final class_2960 texture;
    private final boolean isWalkway;
    private boolean isEdge;
    private final boolean[] hasChanges = new boolean[3];
    private String newDirection;
    private String newSubType;
    private String newVariant;
    public boolean toRemove;
    public boolean toPlace;

    public PlatformDataSet(EnumPlatformType type, class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        this.type = type;
        this.worldDirection = ((class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING)).method_15434();
        String subType = BlockPlatformBase.getPlatformSubType(state).method_15434();
        this.isWalkway = type == EnumPlatformType.FLAT || type == EnumPlatformType.FLOOR;
        this.isEdge = subType.startsWith("edge");
        if (this.isWalkway) {
            if (subType.contains("_")) {
                String[] split = subType.split("_");
                this.worldSubType = split[0];
                this.worldVariant = split[1].length() == 2 ? split[1] : String.format("%c%c", Character.valueOf(split[1].charAt(0)), Character.valueOf(split[1].charAt(0)));
            } else {
                this.worldSubType = subType;
                this.worldVariant = "nn";
            }
        } else {
            this.worldSubType = subType;
            this.worldVariant = type.method_15434();
        }
        this.itemStack = state.method_26204().method_9574((class_1922)world, pos, state);
        AtomicReference<class_2960> location = new AtomicReference<class_2960>(new class_2960("block/oak_planks"));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> location.set(this.getTexture()));
        this.texture = new class_2960(location.get().method_12836(), "textures/" + location.get().method_12832() + ".png");
    }

    @Environment(value=EnvType.CLIENT)
    private class_2960 getTexture() {
        return CacheBuilder.INSTANCE.getTextureSprite(ItemBlockPlatform.getCoverTextureStack(this.itemStack)).method_45851().method_45816();
    }

    public boolean isWalkway() {
        return this.isWalkway;
    }

    public boolean isEdge() {
        return this.isEdge;
    }

    public boolean hasAlternatives() {
        return this.type.hasAlternatives();
    }

    public EnumPlatformType[] getAlternatives() {
        return this.type.getAlternatives();
    }

    public String getDirection() {
        return this.newDirection != null ? this.newDirection : this.worldDirection;
    }

    public void setDirection(String direction) {
        if (direction != null && class_2350.method_10168((String)direction) != null) {
            this.newDirection = direction;
            this.hasChanges[0] = true;
        } else {
            this.hasChanges[0] = false;
            this.newDirection = null;
        }
    }

    public String getSubType() {
        return this.newSubType != null ? this.newSubType : this.worldSubType;
    }

    public void setSubType(String subType) {
        if (subType != null && subType.contains("_")) {
            subType = subType.substring(0, subType.indexOf("_"));
        }
        if (subType != null && EnumSubType.SIMPLE_LOOKUP.get(subType) != null) {
            this.newSubType = subType;
            this.hasChanges[1] = true;
        } else {
            this.hasChanges[1] = false;
            this.newSubType = null;
        }
        this.isEdge = this.getSubType().startsWith("edge");
    }

    public String getVariant() {
        return this.newVariant != null ? this.newVariant : this.worldVariant;
    }

    public void setVariant(String variant) {
        if (this.isWalkway) {
            if (variant != null) {
                if (variant.contains("_")) {
                    variant = variant.substring(variant.lastIndexOf("_"));
                }
                String string = variant.length() == 2 ? variant : (variant = String.format("%c%c", Character.valueOf(variant.charAt(0)), Character.valueOf(variant.charAt(variant.length() > 2 ? 1 : 0))));
            }
            if (variant != null && variant.matches("[nsew][nsew]")) {
                this.newVariant = variant;
                this.hasChanges[2] = true;
            } else {
                this.hasChanges[2] = false;
                this.newVariant = null;
            }
        } else if (this.hasAlternatives()) {
            if (variant != null) {
                this.newVariant = variant;
                this.hasChanges[2] = true;
            } else {
                this.hasChanges[2] = false;
                this.newVariant = null;
            }
        }
    }

    public boolean hasChanges() {
        return this.hasChanges[0] || this.hasChanges[1] || this.hasChanges[2];
    }

    public boolean isChanged(int index) {
        return this.hasChanges[index];
    }

    public void reset() {
        this.hasChanges[2] = false;
        this.hasChanges[1] = false;
        this.hasChanges[0] = false;
        this.newDirection = null;
        this.newSubType = null;
        this.newVariant = null;
        this.isEdge = this.getSubType().startsWith("edge");
    }

    public class_2487 write(class_2487 nbt) {
        class_2350 direction;
        if (this.toRemove) {
            nbt.method_10556("remove", true);
        }
        if (this.toPlace) {
            nbt.method_10556("place", true);
            nbt.method_10566("stack", (class_2520)this.itemStack.method_7953(new class_2487()));
        }
        if ((this.toPlace || this.hasChanges[0]) && (direction = class_2350.method_10168((String)this.getDirection())) != null) {
            nbt.method_10567("direction", (byte)direction.method_10161());
        }
        if (this.toPlace || this.hasChanges[1] || (this.isWalkway || this.hasAlternatives()) && this.hasChanges[2]) {
            Object subType = this.getSubType();
            String variant = this.getVariant();
            if (!Strings.isNullOrEmpty((String)subType)) {
                EnumSubType enumSubType;
                if (this.isWalkway) {
                    if (variant != null && !variant.equals("nn") && variant.length() == 2) {
                        subType = (String)subType + "_" + (Serializable)(variant.charAt(0) == variant.charAt(1) ? Character.valueOf(variant.charAt(0)) : variant);
                    }
                    enumSubType = EnumSubType.WALKWAY_LOOKUP.get(subType);
                } else if (this.hasAlternatives()) {
                    enumSubType = EnumSubType.SIMPLE_LOOKUP.get(subType);
                    EnumPlatformType enumPlatformType = EnumPlatformType.LOOKUP.get(variant);
                    if (enumPlatformType != null) {
                        nbt.method_10567("type", (byte)enumPlatformType.ordinal());
                    }
                } else {
                    enumSubType = EnumSubType.SIMPLE_LOOKUP.get(subType);
                }
                if (enumSubType != null) {
                    nbt.method_10567("subtype", (byte)enumSubType.ordinal());
                }
            }
        }
        return nbt;
    }
}

