/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_3542;
import shetiphian.platforms.common.misc.EnumPlatformType;

public enum EnumSubType implements class_3542
{
    NONE(EnumStyle.NONE, EnumBase.NORMAL, ""),
    RIGHT(EnumStyle.RIGHT, EnumBase.NORMAL, "north"),
    RIGHT_S(EnumStyle.RIGHT, EnumBase.NORMAL, "south"),
    RIGHT_W(EnumStyle.RIGHT, EnumBase.NORMAL, "west"),
    RIGHT_E(EnumStyle.RIGHT, EnumBase.NORMAL, "east"),
    LEFT(EnumStyle.LEFT, EnumBase.NORMAL, "north"),
    LEFT_S(EnumStyle.LEFT, EnumBase.NORMAL, "south"),
    LEFT_W(EnumStyle.LEFT, EnumBase.NORMAL, "west"),
    LEFT_E(EnumStyle.LEFT, EnumBase.NORMAL, "east"),
    EDGE(EnumStyle.EDGE, EnumBase.NORMAL, "north"),
    EDGE_S(EnumStyle.EDGE, EnumBase.NORMAL, "south"),
    EDGE_W(EnumStyle.EDGE, EnumBase.NORMAL, "west"),
    EDGE_E(EnumStyle.EDGE, EnumBase.NORMAL, "east"),
    MIDDLE(EnumStyle.MIDDLE, EnumBase.NORMAL, "north"),
    MIDDLE_S(EnumStyle.MIDDLE, EnumBase.NORMAL, "south"),
    MIDDLE_W(EnumStyle.MIDDLE, EnumBase.NORMAL, "west"),
    MIDDLE_E(EnumStyle.MIDDLE, EnumBase.NORMAL, "east"),
    MIDDLE_NS(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_north", "top_south", "sides", "strip"),
    MIDDLE_WE(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_west", "top_east", "sides", "strip"),
    MIDDLE_SN(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_south", "top_north", "sides", "strip"),
    MIDDLE_EW(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_east", "top_west", "sides", "strip"),
    MIDDLE_NW(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_north", "top_west", "sides", "strip"),
    MIDDLE_ES(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_east", "top_south", "sides", "strip"),
    MIDDLE_SE(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_south", "top_east", "sides", "strip"),
    MIDDLE_WN(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_west", "top_north", "sides", "strip"),
    MIDDLE_NE(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_north", "top_east", "sides", "strip"),
    MIDDLE_EN(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_east", "top_north", "sides", "strip"),
    MIDDLE_SW(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_south", "top_west", "sides", "strip"),
    MIDDLE_WS(EnumStyle.MIDDLE, EnumBase.CORNER, "bottom_west", "top_south", "sides", "strip"),
    INSIDE(EnumStyle.INSIDE, EnumBase.CORNER, "north", "sides"),
    INSIDE_S(EnumStyle.INSIDE, EnumBase.CORNER, "south", "sides"),
    INSIDE_W(EnumStyle.INSIDE, EnumBase.CORNER, "west", "sides"),
    INSIDE_E(EnumStyle.INSIDE, EnumBase.CORNER, "east", "sides"),
    INSIDE_NS(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_north", "top_south", "sides", "strip"),
    INSIDE_WE(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_west", "top_east", "sides", "strip"),
    INSIDE_SN(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_south", "top_north", "sides", "strip"),
    INSIDE_EW(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_east", "top_west", "sides", "strip"),
    INSIDE_NW(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_north", "top_west", "sides", "strip"),
    INSIDE_ES(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_east", "top_south", "sides", "strip"),
    INSIDE_SE(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_south", "top_east", "sides", "strip"),
    INSIDE_WN(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_west", "top_north", "sides", "strip"),
    INSIDE_NE(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_north", "top_east", "sides", "strip"),
    INSIDE_EN(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_east", "top_north", "sides", "strip"),
    INSIDE_SW(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_south", "top_west", "sides", "strip"),
    INSIDE_WS(EnumStyle.INSIDE, EnumBase.CORNER, "bottom_west", "top_south", "sides", "strip"),
    OUTSIDE(EnumStyle.OUTSIDE, EnumBase.CORNER, "north", "sides"),
    OUTSIDE_S(EnumStyle.OUTSIDE, EnumBase.CORNER, "south", "sides"),
    OUTSIDE_W(EnumStyle.OUTSIDE, EnumBase.CORNER, "west", "sides"),
    OUTSIDE_E(EnumStyle.OUTSIDE, EnumBase.CORNER, "east", "sides"),
    OUTSIDE_NS(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_north", "top_south", "sides", "strip"),
    OUTSIDE_WE(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_west", "top_east", "sides", "strip"),
    OUTSIDE_SN(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_south", "top_north", "sides", "strip"),
    OUTSIDE_EW(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_east", "top_west", "sides", "strip"),
    OUTSIDE_NW(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_north", "top_west", "sides", "strip"),
    OUTSIDE_ES(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_east", "top_south", "sides", "strip"),
    OUTSIDE_SE(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_south", "top_east", "sides", "strip"),
    OUTSIDE_WN(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_west", "top_north", "sides", "strip"),
    OUTSIDE_NE(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_north", "top_east", "sides", "strip"),
    OUTSIDE_EN(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_east", "top_north", "sides", "strip"),
    OUTSIDE_SW(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_south", "top_west", "sides", "strip"),
    OUTSIDE_WS(EnumStyle.OUTSIDE, EnumBase.CORNER, "bottom_west", "top_south", "sides", "strip");

    private static final EnumSubType[] WALKWAY_VALUES;
    private static final EnumSubType[] SIMPLE_VALUES;
    private static final EnumSubType[] INCLINE_VALUES;
    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final String[] parts;
    private final EnumStyle style;
    private final EnumBase base;
    public static final Map<String, EnumSubType> INCLINE_LOOKUP;
    public static final Map<String, EnumSubType> SIMPLE_LOOKUP;
    public static final Map<String, EnumSubType> WALKWAY_LOOKUP;

    private EnumSubType(EnumStyle style, EnumBase base, String ... parts) {
        this.parts = parts;
        this.style = style;
        this.base = base;
    }

    public String method_15434() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public EnumBase getBaseType() {
        return this.base;
    }

    public String getStyleName() {
        return this.style.method_15434();
    }

    public EnumStyle getStyleType() {
        return this.style;
    }

    public String[] getParts() {
        return this.parts;
    }

    public boolean supportsRail(EnumPlatformType type) {
        return !type.isAddon();
    }

    public boolean usesSpecialRail(EnumPlatformType type) {
        return type.isIncline() && this != RIGHT && this != LEFT || type.isRoof();
    }

    public static EnumSubType byIndex(int index) {
        EnumSubType[] values = EnumSubType.values();
        return index < 0 || index >= values.length ? MIDDLE : values[index];
    }

    public static EnumSubType byName(String name) {
        for (EnumSubType entry : EnumSubType.values()) {
            if (!entry.name().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return MIDDLE;
    }

    public static EnumSubType[] getWalkwayValues() {
        return WALKWAY_VALUES;
    }

    public static EnumSubType[] getSimpleValues() {
        return SIMPLE_VALUES;
    }

    public static EnumSubType[] getInclineValues() {
        return INCLINE_VALUES;
    }

    static {
        WALKWAY_VALUES = (EnumSubType[])Arrays.stream(EnumSubType.values()).filter(enumSubType -> enumSubType.style != EnumStyle.RIGHT && enumSubType.style != EnumStyle.LEFT && enumSubType != NONE).toArray(EnumSubType[]::new);
        SIMPLE_VALUES = new EnumSubType[]{RIGHT, LEFT, EDGE, MIDDLE, INSIDE, OUTSIDE};
        INCLINE_VALUES = new EnumSubType[]{RIGHT, LEFT, MIDDLE, INSIDE, OUTSIDE};
        INCLINE_LOOKUP = Arrays.stream(INCLINE_VALUES).collect(Collectors.toMap(EnumSubType::method_15434, subType -> subType));
        SIMPLE_LOOKUP = Arrays.stream(SIMPLE_VALUES).collect(Collectors.toMap(EnumSubType::method_15434, subType -> subType));
        WALKWAY_LOOKUP = Arrays.stream(WALKWAY_VALUES).collect(Collectors.toMap(EnumSubType::method_15434, subType -> subType));
    }

    public static enum EnumStyle implements class_3542
    {
        NONE("none"),
        EDGE("edge"),
        RIGHT("right"),
        LEFT("left"),
        MIDDLE("middle"),
        INSIDE("inside"),
        OUTSIDE("outside");

        private final String name;

        private EnumStyle(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum EnumBase implements class_3542
    {
        NORMAL("normal"),
        CORNER("corner");

        private final String name;

        private EnumBase(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

