/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3542;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Roster;

public enum EnumPlatformType implements class_3542
{
    FLAT("flat"),
    FLOOR("floor"),
    FRAME("frame"),
    RAMP("ramp"),
    STAIRS("stairs"),
    STEPS("steps"),
    SHINGLES("shingles"),
    TILES("tiles"),
    RISE("rise"),
    RAIL("rail");

    public static final Map<String, EnumPlatformType> LOOKUP;
    private static final EnumPlatformType[] INCLINES;
    private static final EnumPlatformType[] ROOFS;
    private static final EnumPlatformType[] RAILINGS;
    private static final EnumPlatformType[] EMPTY;
    private final String name;

    private EnumPlatformType(String name) {
        this.name = name;
    }

    public String method_15434() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAddon() {
        return this == RISE || this == RAIL;
    }

    public boolean isIncline() {
        return this == RAMP || this == STAIRS || this == STEPS;
    }

    public boolean isRoof() {
        return this == SHINGLES || this == TILES;
    }

    public boolean isInclineOrRoof() {
        return this.isIncline() || this.isRoof();
    }

    public boolean hasAlternatives() {
        return this.isAddon() || this.isIncline() || this.isRoof();
    }

    public EnumPlatformType[] getAlternatives() {
        return this.isAddon() ? RAILINGS : (this.isIncline() ? INCLINES : (this.isRoof() ? ROOFS : EMPTY));
    }

    public int getCraftAmount() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FLAT -> Platforms.CONFIG.COMMON.CRAFTING.flat;
            case FLOOR -> Platforms.CONFIG.COMMON.CRAFTING.floor;
            case FRAME -> Platforms.CONFIG.COMMON.CRAFTING.frame;
            case RAMP, STAIRS, STEPS -> Platforms.CONFIG.COMMON.CRAFTING.inclines;
            case SHINGLES, TILES -> Platforms.CONFIG.COMMON.CRAFTING.roofs;
            case RISE, RAIL -> Platforms.CONFIG.COMMON.CRAFTING.railings;
        };
    }

    public static EnumPlatformType byName(String name) {
        for (EnumPlatformType entry : EnumPlatformType.values()) {
            if (!entry.method_15434().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return FLAT;
    }

    public static EnumPlatformType byIndex(int index) {
        EnumPlatformType[] values = EnumPlatformType.values();
        return index < 0 || index >= values.length ? FLAT : values[index];
    }

    public static Optional<EnumPlatformType> findOrFail(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            if (block == Roster.Blocks.FLAT) {
                return Optional.of(FLAT);
            }
            if (block == Roster.Blocks.FLOOR) {
                return Optional.of(FLOOR);
            }
            if (block == Roster.Blocks.FRAME) {
                return Optional.of(FRAME);
            }
            if (block == Roster.Blocks.RAMP) {
                return Optional.of(RAMP);
            }
            if (block == Roster.Blocks.STAIRS) {
                return Optional.of(STAIRS);
            }
            if (block == Roster.Blocks.STEPS) {
                return Optional.of(STEPS);
            }
            if (block == Roster.Blocks.SHINGLES) {
                return Optional.of(SHINGLES);
            }
            if (block == Roster.Blocks.TILES) {
                return Optional.of(TILES);
            }
            if (block == Roster.Blocks.RISE) {
                return Optional.of(RISE);
            }
            if (block == Roster.Blocks.RAIL) {
                return Optional.of(RAIL);
            }
        }
        return Optional.empty();
    }

    static {
        LOOKUP = Arrays.stream(EnumPlatformType.values()).collect(Collectors.toMap(EnumPlatformType::method_15434, type -> type));
        INCLINES = new EnumPlatformType[]{RAMP, STAIRS, STEPS};
        ROOFS = new EnumPlatformType[]{SHINGLES, TILES};
        RAILINGS = new EnumPlatformType[]{RISE, RAIL};
        EMPTY = new EnumPlatformType[0];
    }
}

