/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.client.ClientAccessors;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.PlatformsClient;
import shetiphian.platforms.client.misc.TextureInfoHelper;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class ItemBlockPlatform
extends class_1747
implements ITabFiller,
IColored {
    private final EnumPlatformType platformType;

    public ItemBlockPlatform(EnumPlatformType platformType, class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
        this.platformType = platformType;
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> PlatformsClient.colorize(this));
    }

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        entries.method_45420(ItemBlockPlatform.createStack(this.method_7711(), new class_1799((class_1935)class_2246.field_10161), new class_1799((class_1935)class_2246.field_10161)));
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        class_2487 texture;
        class_1799 textureStack;
        class_2487 tag = ItemBlockPlatform.getNBTTag(stack);
        if (!tag.method_10545(ItemBlockPlatform.getFrameTextureKey())) {
            textureStack = new class_1799((class_1935)class_2246.field_10161);
            texture = new class_2487();
            textureStack.method_7953(texture);
            tag.method_10566(ItemBlockPlatform.getFrameTextureKey(), (class_2520)texture);
        }
        if (!tag.method_10545(ItemBlockPlatform.getCoverTextureKey())) {
            textureStack = new class_1799((class_1935)class_2246.field_10161);
            texture = new class_2487();
            textureStack.method_7953(texture);
            tag.method_10566(ItemBlockPlatform.getCoverTextureKey(), (class_2520)texture);
        }
    }

    public class_1269 method_7884(class_1838 context) {
        Optional<class_2338> optional;
        class_1271<class_2338> holder;
        class_2350 face;
        class_2338 pos;
        class_1937 world;
        class_1657 player = context.method_8036();
        if (ItemBlockPlatform.canExtend(this.platformType, player, world = context.method_8045(), pos = context.method_8037(), face = context.method_8038()) && (holder = ItemBlockPlatform.getExtensionPos(this.platformType, player, world, pos, face)).method_5467() != class_1269.field_5811) {
            if (holder.method_5467() == class_1269.field_5812) {
                class_2338 extPos = (class_2338)holder.method_5466();
                UseContext.Item extContext = new UseContext.Item(world, player, context.method_20287(), context.method_8041(), new class_3965(context.method_17698(), class_2350.field_11036, extPos, context.method_17699()));
                class_1269 actionResult = this.method_7712(new class_1750((class_1838)extContext));
                if (actionResult.method_23665()) {
                    class_2680 state = world.method_8320(pos);
                    class_2680 extState = world.method_8320(extPos);
                    if (state.method_26204() == extState.method_26204() && state.method_26204() instanceof BlockPlatformBase) {
                        Function.setBlock((class_1945)world, (class_2338)extPos, (class_2680)((class_2680)BlockPlatformBase.getStateWithPlatformSubType(extState, BlockPlatformBase.getPlatformSubType(state)).method_11657((class_2769)BlockPlatformBase.FACING, (Comparable)((class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING)))), (boolean)true);
                    }
                    return actionResult;
                }
            }
            return class_1269.field_5814;
        }
        if (ItemBlockPlatform.canDropRamp(this.platformType, player, face) && (optional = ItemBlockPlatform.getRampDropPos(player, world, pos)).isPresent()) {
            class_2338 placePos = optional.get();
            UseContext.Item extContext = new UseContext.Item(world, context.method_8036(), context.method_20287(), context.method_8041(), new class_3965(context.method_17698(), class_2350.field_11036, placePos, context.method_17699()));
            class_1269 actionResult = this.method_7712(new class_1750((class_1838)extContext));
            if (actionResult.method_23665()) {
                class_2680 state = world.method_8320(placePos);
                if (state.method_26204() instanceof BlockPlatformBase) {
                    EnumSubType subType = BlockPlatformBase.getPlatformSubType(state = (class_2680)state.method_11657((class_2769)BlockPlatformBase.FACING, (Comparable)((class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING)).method_10153()));
                    state = BlockPlatformBase.getStateWithPlatformSubType(state, subType == EnumSubType.RIGHT ? EnumSubType.LEFT : (subType == EnumSubType.LEFT ? EnumSubType.RIGHT : EnumSubType.MIDDLE));
                    Function.setBlock((class_1945)world, (class_2338)placePos, (class_2680)state, (boolean)true);
                }
                return actionResult;
            }
            return class_1269.field_5814;
        }
        return super.method_7884(context);
    }

    public static boolean canExtend(EnumPlatformType platformType, class_1657 player, class_1937 world, class_2338 pos, class_2350 face) {
        BlockPlatformBase platform;
        class_2680 state;
        class_2248 class_22482;
        if (player != null && !player.method_5715() && ToolHelper.isWrench((class_1799)player.method_6079()) && (class_22482 = (state = world.method_8320(pos)).method_26204()) instanceof BlockPlatformBase && (platform = (BlockPlatformBase)class_22482).getPlatformType() == platformType) {
            return switch (platformType) {
                default -> throw new IncompatibleClassChangeError();
                case EnumPlatformType.FLAT, EnumPlatformType.FLOOR -> {
                    if (face == class_2350.field_11036) {
                        yield true;
                    }
                    yield false;
                }
                case EnumPlatformType.FRAME -> true;
                case EnumPlatformType.RAIL, EnumPlatformType.RISE -> false;
                case EnumPlatformType.RAMP, EnumPlatformType.STAIRS, EnumPlatformType.STEPS, EnumPlatformType.SHINGLES, EnumPlatformType.TILES -> {
                    if (face == class_2350.field_11036) {
                        yield true;
                    }
                    class_2350 platformFacing = (class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING);
                    if (face == platformFacing.method_10153() && platformFacing.method_10166() == player.method_5735().method_10166()) {
                        yield true;
                    }
                    yield false;
                }
            };
        }
        return false;
    }

    public static class_1271<class_2338> getExtensionPos(EnumPlatformType platformType, class_1657 player, class_1937 world, class_2338 pos, class_2350 face) {
        BlockPlatformBase platform;
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BlockPlatformBase && (platform = (BlockPlatformBase)class_22482).getPlatformType() == platformType && BlockPlatformBase.getPlatformSubType(state).getBaseType() == EnumSubType.EnumBase.NORMAL) {
            class_2350 playerFacing = player.method_5735();
            class_2350 platformFacing = (class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING);
            if (platformType == EnumPlatformType.FRAME || platformFacing.method_10166() == playerFacing.method_10166()) {
                class_2338.class_2339 sPos = pos.method_25503();
                int counter = 0;
                while (counter < 16) {
                    BlockPlatformBase sPlatform;
                    ++counter;
                    switch (platformType) {
                        case FLAT: 
                        case FLOOR: {
                            sPos.method_10098(playerFacing);
                            break;
                        }
                        case FRAME: {
                            sPos.method_10098(face == class_2350.field_11036 ? playerFacing : class_2350.field_11036);
                            break;
                        }
                        case RAIL: 
                        case RISE: {
                            return class_1271.method_22430((Object)class_2338.field_10980);
                        }
                        case RAMP: 
                        case STAIRS: 
                        case STEPS: 
                        case SHINGLES: 
                        case TILES: {
                            sPos.method_10098(playerFacing).method_10098(playerFacing == platformFacing ? class_2350.field_11036 : class_2350.field_11033);
                        }
                    }
                    class_2680 sState = world.method_8320((class_2338)sPos);
                    if (sState.method_45474()) {
                        return class_1271.method_22427((Object)sPos.method_10062());
                    }
                    class_2248 class_22483 = sState.method_26204();
                    if (class_22483 instanceof BlockPlatformBase && (sPlatform = (BlockPlatformBase)class_22483).getPlatformType() == platformType) continue;
                }
                return class_1271.method_22431((Object)class_2338.field_10980);
            }
        }
        return class_1271.method_22430((Object)class_2338.field_10980);
    }

    public static boolean canDropRamp(EnumPlatformType platformType, class_1657 player, class_2350 face) {
        return player != null && !player.method_5715() && ToolHelper.isWrench((class_1799)player.method_6079()) && platformType.isInclineOrRoof() && face == class_2350.field_11036;
    }

    public static Optional<class_2338> getRampDropPos(class_1657 player, class_1937 world, class_2338 pos) {
        class_2338.class_2339 placePos = pos.method_25503().method_10098(player.method_5735());
        if (world.method_8320(pos).method_45474()) {
            placePos.method_10098(class_2350.field_11033);
        }
        if (world.method_8320((class_2338)placePos).method_45474()) {
            return Optional.of(placePos.method_10062());
        }
        return Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (!stack.method_7960()) {
            if (context.method_8035() || class_437.method_25442()) {
                class_2487 tag = ItemBlockPlatform.getNBTTag(stack);
                TextureInfoHelper.addTextureInfo(tooltip, tag, ItemBlockPlatform.getFrameTextureKey());
                TextureInfoHelper.addTextureInfo(tooltip, tag, ItemBlockPlatform.getCoverTextureKey());
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"info.shetiphian.holdshift"));
            }
        }
    }

    public static class_1799 createStack(EnumPlatformType platformType, class_1799 textures) {
        return ItemBlockPlatform.createStack(platformType, ItemBlockPlatform.getFrameTextureStack(textures), ItemBlockPlatform.getCoverTextureStack(textures));
    }

    public static class_1799 createStack(EnumPlatformType platformType, class_1799 texFrame, class_1799 texCover) {
        return ItemBlockPlatform.createStack((class_2248)Values.getPlatform(platformType), texFrame, texCover);
    }

    public static class_1799 createStack(class_2248 block, class_1799 texFrame, class_1799 texCover) {
        class_1799 stack;
        if (block != null && !(stack = new class_1799((class_1935)block)).method_7960()) {
            class_2487 tag = ItemBlockPlatform.getNBTTag(stack);
            if (texFrame.method_7960()) {
                texFrame = new class_1799((class_1935)class_2246.field_10161);
            }
            class_2487 texture = new class_2487();
            texFrame.method_7953(texture);
            tag.method_10566(ItemBlockPlatform.getFrameTextureKey(), (class_2520)texture);
            if (texCover.method_7960()) {
                texCover = new class_1799((class_1935)class_2246.field_10161);
            }
            texture = new class_2487();
            texCover.method_7953(texture);
            tag.method_10566(ItemBlockPlatform.getCoverTextureKey(), (class_2520)texture);
            return stack;
        }
        return class_1799.field_8037;
    }

    public static class_1799 getFrameTextureStack(class_1799 stack) {
        class_2487 tag;
        if (!stack.method_7960() && (tag = ItemBlockPlatform.getNBTTag(stack)).method_10545(ItemBlockPlatform.getFrameTextureKey())) {
            return class_1799.method_7915((class_2487)tag.method_10562(ItemBlockPlatform.getFrameTextureKey()));
        }
        return new class_1799((class_1935)class_2246.field_10161);
    }

    public static class_1799 getCoverTextureStack(class_1799 stack) {
        class_2487 tag;
        if (!stack.method_7960() && (tag = ItemBlockPlatform.getNBTTag(stack)).method_10545(ItemBlockPlatform.getCoverTextureKey())) {
            return class_1799.method_7915((class_2487)tag.method_10562(ItemBlockPlatform.getCoverTextureKey()));
        }
        return new class_1799((class_1935)class_2246.field_10161);
    }

    public static void setSubType(class_1799 stack, EnumSubType subtype) {
        if (!stack.method_7960()) {
            class_2487 tag = ItemBlockPlatform.getNBTTag(stack);
            tag.method_10582("subtype", subtype.method_15434());
        }
    }

    public static EnumSubType getSubType(class_1799 stack) {
        class_2487 tag;
        if (!stack.method_7960() && stack.method_7909() instanceof ItemBlockPlatform && (tag = ItemBlockPlatform.getNBTTag(stack)).method_10545("subtype")) {
            return EnumSubType.byName(tag.method_10558("subtype"));
        }
        return EnumSubType.NONE;
    }

    public static String getFrameTextureKey() {
        return "frame_texture_item";
    }

    public static String getCoverTextureKey() {
        return "cover_texture_item";
    }

    public static class_2487 getNBTTag(class_1799 stack) {
        return stack.method_7911("BlockEntityTag");
    }

    @Environment(value=EnvType.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index >= 1 && index <= 4) {
            return ClientAccessors.getItemColors().method_1704(index == 1 || index == 3 ? ItemBlockPlatform.getFrameTextureStack(data.stack) : ItemBlockPlatform.getCoverTextureStack(data.stack), 0);
        }
        return 0xFFFFFF;
    }
}

