/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2544;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3749;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public class BlockPlatformRoof
extends BlockPlatformType.Inclines {
    public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getSimpleValues());
    public static final class_2754<ParticleToggle> PARTICLES = class_2754.method_11850((String)"particles", ParticleToggle.class);

    public static BlockPlatformRoof Shingles() {
        return new BlockPlatformRoof(EnumPlatformType.SHINGLES);
    }

    public static BlockPlatformRoof Tiles() {
        return new BlockPlatformRoof(EnumPlatformType.TILES);
    }

    private BlockPlatformRoof(EnumPlatformType type) {
        super(type);
        this.method_9590((class_2680)this.method_9564().method_11657(PARTICLES, (Comparable)((Object)ParticleToggle.ENABLED)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{PARTICLES});
    }

    @Override
    public PropertySubType getPropertySubType() {
        return SUBTYPE;
    }

    @Override
    protected class_265 buildShape(EnumSubType subType, class_2350 direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            class_265[] parts = new class_265[2];
            parts[0] = (class_265)HITBOXES.get((Object)("roof_" + subType.getStyleName() + (collision ? "_collide" : "_select")), (Object)direction);
            if (railType != null) {
                parts[1] = (class_265)HITBOXES.get((Object)(railType.method_15434() + "_roof" + (collision ? "_collide" : "_select")), (Object)direction);
            }
            return class_259.method_17786((class_265)class_259.method_1073(), (class_265[])((class_265[])Arrays.stream(parts).filter(Objects::nonNull).toArray(class_265[]::new)));
        }
        return null;
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, class_2680 state, class_1937 world, class_2338 pos) {
        class_2350 newFacing;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        int altSupport = this.getSupports(world, pos, facing);
        TileHelper.setAltSupport((class_2586)tile, altSupport);
        if (tile instanceof TileEntityPlatformRoof && (newFacing = ((TileEntityPlatformRoof)tile).updateEdgeType(((EnumSubType)((Object)state.method_11654((class_2769)SUBTYPE))).getStyleType(), facing)) != null && facing != newFacing) {
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)newFacing)), (boolean)true);
        }
        Function.syncTile((class_2586)tile);
    }

    protected int getSupports(class_1937 world, class_2338 pos, class_2350 facing) {
        int support;
        if (world.method_22347(pos.method_10074())) {
            support = 2;
        } else {
            class_2680 stateDown = world.method_8320(pos.method_10074());
            class_2248 blockDown = stateDown.method_26204();
            if (blockDown instanceof class_2354 || blockDown instanceof class_2544 || blockDown instanceof class_3749) {
                support = 1;
            } else if (blockDown instanceof class_2310) {
                support = 2;
                if (((Boolean)stateDown.method_11654((class_2769)class_2310.field_10905)).booleanValue() || ((Boolean)stateDown.method_11654((class_2769)class_2310.field_10904)).booleanValue()) {
                    support += facing.method_10166() == class_2350.class_2351.field_11048 ? 1 : 2;
                }
                if (((Boolean)stateDown.method_11654((class_2769)class_2310.field_10907)).booleanValue() || ((Boolean)stateDown.method_11654((class_2769)class_2310.field_10903)).booleanValue()) {
                    support += facing.method_10166() == class_2350.class_2351.field_11051 ? 1 : 2;
                }
            } else {
                class_238 aabbDown = this.getShapeBoundingBox(stateDown.method_26218((class_1922)world, pos.method_10074()));
                support = aabbDown != null && aabbDown.field_1325 >= 1.0 ? (aabbDown.field_1323 < 0.25 && aabbDown.field_1321 < 0.25 && aabbDown.field_1320 > 0.75 && aabbDown.field_1324 > 0.75 ? 0 : (aabbDown.field_1323 >= 0.25 && aabbDown.field_1321 >= 0.25 && aabbDown.field_1320 <= 0.75 && aabbDown.field_1324 <= 0.75 ? 1 : 2)) : 2;
            }
        }
        return support;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.toggleParticles(state, world, pos, player)) {
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        this.toggleParticles(state, world, pos, player);
        super.method_9606(state, world, pos, player);
    }

    private boolean toggleParticles(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (player != null && player.method_6047().method_7960() && TileHelper.getRail(BlockPlatformRoof.getTile((class_1922)world, pos)) != null) {
            ParticleToggle toggle = ((ParticleToggle)((Object)state.method_11654(PARTICLES))).next(player.method_5715());
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(PARTICLES, (Comparable)((Object)toggle))), (boolean)true);
            player.method_7353((class_2561)class_2561.method_43471((String)("info.platforms.particle." + toggle.method_15434())), true);
            return true;
        }
        return false;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
        super.method_9496(state, world, pos, rand);
        ParticleToggle toggle = (ParticleToggle)((Object)state.method_11654(PARTICLES));
        if (toggle != ParticleToggle.DISABLED && world.method_22347(pos.method_10084())) {
            EnumPlatformType rail;
            TileEntityPlatformBase tile;
            boolean enabled;
            boolean bl = toggle == ParticleToggle.ENABLED || (world.method_49803(pos) ? toggle == ParticleToggle.WITH_REDSTONE : toggle == ParticleToggle.WITHOUT_REDSTONE) ? true : (enabled = false);
            if (enabled && (tile = BlockPlatformRoof.getTile((class_1922)world, pos)) != null && (rail = TileHelper.getRail(tile)) != null) {
                if (rail == EnumPlatformType.RAIL) {
                    if (rand.method_43048(10) == 0) {
                        world.method_17452((class_2394)class_2398.field_11225, false, (double)pos.method_10263() + 0.5 + rand.method_43058() / 5.0 * (double)(rand.method_43056() ? 1 : -1), (double)pos.method_10264() + (double)0.8f + rand.method_43058(), (double)pos.method_10260() + 0.5 + rand.method_43058() / 5.0 * (double)(rand.method_43056() ? 1 : -1), 0.0, 0.07, 0.0);
                    }
                } else if (rail == EnumPlatformType.RISE) {
                    world.method_17452((class_2394)class_2398.field_17430, true, (double)pos.method_10263() + 0.5 + rand.method_43058() / 3.0 * (double)(rand.method_43056() ? 1 : -1), (double)pos.method_10264() + (double)1.15f + rand.method_43058() + rand.method_43058(), (double)pos.method_10260() + 0.5 + rand.method_43058() / 3.0 * (double)(rand.method_43056() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
        }
    }

    static {
        BlockPlatformRoof.addHitBoxData("roof_right_select", new double[][]{{0.0, 0.0, 0.0, 12.0, 4.0, 18.0}, {0.0, 4.0, 0.0, 12.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 12.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 12.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_right_collide", new double[][]{{0.0, 0.0, 0.0, 12.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 12.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 12.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 12.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_left_select", new double[][]{{4.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {4.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {4.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_left_collide", new double[][]{{4.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {4.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {4.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_edge_select", new double[][]{{-2.0, 0.0, -2.0, 18.0, 4.0, 18.0}, {2.0, 4.0, 2.0, 14.0, 8.0, 14.0}});
        BlockPlatformRoof.addHitBoxData("roof_edge_collide", new double[][]{{0.0, -3.0, 0.0, 16.0, 0.0, 16.0}, {0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 4.0, 12.0, 8.0, 12.0}});
        BlockPlatformRoof.addHitBoxData("roof_middle_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_middle_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_inside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 6.0}, {2.0, 4.0, 14.0, 16.0, 8.0, 16.0}, {6.0, 8.0, 10.0, 16.0, 12.0, 16.0}, {10.0, 12.0, 6.0, 16.0, 16.0, 16.0}});
        BlockPlatformRoof.addHitBoxData("roof_inside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 4.0}, {4.0, 4.0, 12.0, 16.0, 8.0, 16.0}, {8.0, 8.0, 8.0, 16.0, 12.0, 16.0}, {12.0, 12.0, 4.0, 16.0, 16.0, 16.0}});
        BlockPlatformRoof.addHitBoxData("roof_outside_select", new double[][]{{-2.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {2.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {6.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {10.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_outside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {8.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {12.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("rail_roof_select", new double[][]{{6.0, 0.0, 6.0, 10.0, 14.0, 10.0}, {5.0, 14.0, 5.0, 11.0, 16.0, 11.0}});
        BlockPlatformRoof.addHitBoxData("rail_roof_collide", new double[][]{{6.0, 0.0, 6.0, 10.0, 15.0, 10.0}, {5.0, 14.0, 5.0, 11.0, 16.0, 11.0}});
        BlockPlatformRoof.addHitBoxData("rise_roof_select", new double[][]{{3.98, 0.0, 3.98, 12.02, 21.0, 12.02}, {3.0, 21.0, 3.0, 13.0, 24.0, 13.0}});
        BlockPlatformRoof.addHitBoxData("rise_roof_collide", new double[][]{{4.0, 0.0, 4.0, 12.0, 21.0, 12.0}, {3.0, 21.0, 3.0, 13.0, 24.0, 13.0}});
    }

    static enum ParticleToggle implements class_3542
    {
        ENABLED("enabled"),
        DISABLED("disabled"),
        WITH_REDSTONE("with_redstone"),
        WITHOUT_REDSTONE("without_redstone");

        private final String name;

        private ParticleToggle(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        ParticleToggle next(boolean back) {
            int index = this.ordinal() + (back ? -1 : 1);
            if (index < 0 || index >= ParticleToggle.values().length) {
                index = index < 0 ? ParticleToggle.values().length - 1 : 0;
            }
            return ParticleToggle.values()[index];
        }
    }
}

