/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2468;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.HitBoxData;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.block.ILocationAwareRotation;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.PlatformsClient;
import shetiphian.platforms.common.block.BlockPlatformFloor;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformIncline;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRailing;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public abstract class BlockPlatformBase
extends class_2237
implements IColored,
class_3737,
ILocationAwareRotation {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected final EnumPlatformType platformType;
    protected static Table<String, class_2350, class_265> HITBOXES = HashBasedTable.create();
    private static final Map<String, class_265> BOXCACHE = new HashMap<String, class_265>();
    private static final Cache<class_1297, class_2338> WALK_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.SECONDS).build();

    public BlockPlatformBase(EnumPlatformType type) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51369().method_22488().method_50012(class_3619.field_15975).method_9626(class_2498.field_11547).method_9629(3.0f, 0.5f).method_9640().method_26235((state, world, pos, entity) -> false).method_9631(BlockLightingHelper::getLightValue));
        this.platformType = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            PlatformsClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23583());
        });
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, BlockLightingHelper.LIGHTING});
        if (this.getPropertySubType() != null) {
            builder.method_11667(new class_2769[]{this.getPropertySubType()});
        }
    }

    @Nullable
    protected abstract PropertySubType getPropertySubType();

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public Collection<EnumSubType> getAllowedValues() {
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return ImmutableSet.of((Object)((Object)EnumSubType.NONE));
        }
        return propertySubType.method_11898();
    }

    public static EnumSubType getPlatformSubType(class_2680 state) {
        BlockPlatformBase block;
        PropertySubType propertySubType;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)class_22482).getPropertySubType()) != null) {
            return (EnumSubType)((Object)state.method_11654((class_2769)propertySubType));
        }
        return EnumSubType.NONE;
    }

    public static class_2680 getStateWithPlatformSubType(class_2680 state, EnumSubType subType) {
        Collection subTypes;
        BlockPlatformBase block;
        PropertySubType propertySubType;
        class_2248 class_22482;
        if (subType != null && subType != EnumSubType.NONE && (class_22482 = state.method_26204()) instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)class_22482).getPropertySubType()) != null && (subTypes = propertySubType.method_11898()).contains((Object)subType)) {
            return (class_2680)state.method_11657((class_2769)propertySubType, (Comparable)((Object)subType));
        }
        return state;
    }

    public static boolean setPlatformSubType(class_1936 world, class_2338 pos, EnumSubType subType) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BlockPlatformBase) {
            BlockPlatformBase block = (BlockPlatformBase)class_22482;
            class_2680 result = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            if (result != state && Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)result, (boolean)true)) {
                TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
                if (tile instanceof TileEntityPlatformIncline) {
                    block.editLinkedRail(result, world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    block.editLinkedRail(result, world, pos, tile, false);
                }
                return true;
            }
        }
        return false;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return switch (this.getPlatformType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumPlatformType.FLAT -> new TileEntityPlatformFlat(pos, state);
            case EnumPlatformType.FLOOR -> new TileEntityPlatformFloor(pos, state);
            case EnumPlatformType.FRAME -> new TileEntityPlatformFrame(pos, state);
            case EnumPlatformType.RAMP, EnumPlatformType.STAIRS, EnumPlatformType.STEPS -> new TileEntityPlatformIncline(pos, state);
            case EnumPlatformType.SHINGLES, EnumPlatformType.TILES -> new TileEntityPlatformRoof(pos, state);
            case EnumPlatformType.RAIL, EnumPlatformType.RISE -> new TileEntityPlatformRailing(pos, state);
        };
    }

    protected static TileEntityPlatformBase getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float value = state.method_26214(world, pos);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            try {
                class_2248 block = ((class_1747)tile.getFrameTextureBlock().method_7909()).method_7711();
                value = block.method_9564().method_26214(world, pos);
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        int i = player.method_7305(state) ? 30 : 100;
        return player.method_7351(state) / value / (float)i;
    }

    protected void setLighting(class_2680 state, class_1937 world, class_2338 pos, TileEntityPlatformBase tile) {
        if (state.method_11654((class_2769)BlockLightingHelper.LIGHTING) == BlockLightingHelper.PackedData.UNKNOWEN) {
            BlockPlatformBase.updateLighting(state, world, pos, tile);
        }
    }

    public static void updateLighting(class_2680 state, class_1937 world, class_2338 pos, TileEntityPlatformBase tile) {
        if (world != null && !world.method_8608() && tile != null) {
            BlockLightingHelper.PackedData current = (BlockLightingHelper.PackedData)state.method_11654((class_2769)BlockLightingHelper.LIGHTING);
            Optional<Boolean> translucent = TileHelper.isTranslucent(tile);
            if (translucent.isPresent() && (state = BlockLightingHelper.setLighting((class_2680)state, (int)TileHelper.getLightValue(tile), (boolean)translucent.get())).method_11654((class_2769)BlockLightingHelper.LIGHTING) != current) {
                world.method_8652(pos, state, 3);
            }
        }
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return this.platformType.isAddon() || BlockLightingHelper.doesLightPassThrough((class_2680)state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        String cacheKey = "collision:" + this.platformType.method_15434() + ":" + subType.name() + ":" + direction.method_10151();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.method_15434();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            class_265 result = this.buildShape(subType, direction, railType, linked, true);
            if (result == null) {
                return class_259.method_1073();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        String cacheKey = this.platformType.method_15434() + ":" + subType.name() + ":" + direction.method_10151();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.method_15434();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            class_265 result = this.buildShape(subType, direction, railType, linked, false);
            if (result == null) {
                return class_259.method_1077();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    protected static void addHitBoxData(String key, double[][] cordsets) {
        Map map = HitBoxData.build((double[][])cordsets, (boolean)false);
        map.forEach((direction, shape) -> HITBOXES.put((Object)key, direction, shape));
    }

    protected class_265 buildShape(EnumSubType subType, class_2350 direction, EnumPlatformType railType, String linked, boolean collision) {
        return null;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        TileEntityPlatformBase oTile;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
        if (tile != null && (this.platformType.isIncline() || this.platformType == EnumPlatformType.FLOOR) && tile.hasRail()) {
            world.method_8650(pos.method_10084(), false);
        }
        if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked() && (oTile = BlockPlatformBase.getTile((class_1922)world, pos.method_10074())) != null) {
            oTile.removeRail();
        }
        super.method_9585(world, pos, state);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        class_2586 tile = (class_2586)builder.method_51873(class_181.field_1228);
        if (tile instanceof TileEntityPlatformBase) {
            ((TileEntityPlatformBase)tile).addExtraDrops(drops);
        }
        return drops;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (player == null || !player.method_5715()) {
            return;
        }
        class_1799 currentItem = player.method_6047();
        if (currentItem.method_7960()) {
            return;
        }
        if (!ToolHelper.isWrench((class_1799)currentItem)) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAIL || this.platformType == EnumPlatformType.RISE) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
        if (tile == null || !TileHelper.hasRail(tile) && !TileHelper.hasTorch(tile)) {
            return;
        }
        class_1799 stack = null;
        if (this.platformType == EnumPlatformType.FRAME) {
            EnumTorchType torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile.hasRail()) {
            stack = tile.getRailItem();
        }
        if (stack != null) {
            Function.giveItem((class_1657)player, (class_1799)stack);
            if (this.platformType == EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.method_8408(pos, (class_2248)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformIncline) {
                    this.editLinkedRail(state, (class_1936)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (class_1936)world, pos, tile, false);
                }
            }
            Function.syncTile((class_2586)tile);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960()) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
            if (tile != null) {
                return this.onBlockActivated(stack, tile, state, world, pos, player, hand, hit);
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    protected class_1269 onBlockActivated(class_1799 heldItem, TileEntityPlatformBase tile, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (heldItem.method_7909() instanceof ItemBlockPlatform && ((ItemBlockPlatform)heldItem.method_7909()).getPlatformType().isAddon() && BlockPlatformBase.canPlaceRailOn(state, (class_1936)world, pos, tile) && TileHelper.setRail(tile, heldItem)) {
            if (!player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            if (tile.hasRail()) {
                world.method_8396(player, pos, tile.getRailSound().method_10598(), class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                Function.syncTile((class_2586)tile);
                if (tile instanceof TileEntityPlatformIncline) {
                    this.editLinkedRail(state, (class_1936)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (class_1936)world, pos, tile, false);
                }
                return class_1269.field_5812;
            }
        }
        if (tile.getCovering() != EnumCovering.NONE && ToolHelper.isShovel((class_1799)heldItem)) {
            tile.playCoveringSound(player, false);
            this.changeCovering(state, world, pos, tile.getCovering().decrement());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean canPlaceRailOn(class_2680 state, class_1936 world, class_2338 pos, TileEntityPlatformBase tile) {
        if (!tile.hasRail() && state.method_26204() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.method_26204()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            if (subType.supportsRail(type)) {
                if (tile instanceof TileEntityPlatformIncline && !subType.usesSpecialRail(type)) {
                    return world.method_8320(pos.method_10084()).method_45474();
                }
                return true;
            }
        }
        return false;
    }

    private void editLinkedRail(class_2680 state, class_1936 world, class_2338 pos, TileEntityPlatformBase tile, boolean isIncline) {
        if (state.method_26204() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.method_26204()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            class_2338 posUp = pos.method_10084();
            class_2680 above = world.method_8320(posUp);
            if (subType.supportsRail(type) && tile.hasRail()) {
                TileEntityPlatformBase oTile;
                class_2680 oState;
                if (subType.usesSpecialRail(type)) {
                    TileEntityPlatformRailing railing;
                    TileEntityPlatformBase oTile2 = BlockPlatformBase.getTile((class_1922)world, posUp);
                    if (oTile2 instanceof TileEntityPlatformRailing && (railing = (TileEntityPlatformRailing)oTile2).isLinked()) {
                        world.method_8650(posUp, false);
                    }
                    return;
                }
                if (above.method_26204() != this && above.method_45474()) {
                    EnumPlatformType platform = tile.getRailType();
                    if (platform == null) {
                        return;
                    }
                    Function.setBlock((class_1945)world, (class_2338)posUp, (class_2680)Values.getPlatform(platform).method_9564(), (boolean)false);
                }
                if ((oState = world.method_8320(posUp)).method_26204() instanceof BlockPlatformBase) {
                    oState = BlockPlatformBase.getStateWithPlatformSubType(oState, EnumSubType.byName(subType.getStyleName()));
                    Function.setBlock((class_1945)world, (class_2338)posUp, (class_2680)((class_2680)oState.method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))), (boolean)true);
                }
                if ((oTile = BlockPlatformBase.getTile((class_1922)world, posUp)) instanceof TileEntityPlatformRailing) {
                    TileEntityPlatformRailing railing = (TileEntityPlatformRailing)oTile;
                    oTile.setTextureInfo(tile.getRailItem());
                    if (isIncline) {
                        railing.setLinkedToRamp(true);
                    } else {
                        railing.setLinkedToFloor(true);
                    }
                    oTile.copyCovering(tile);
                }
            } else {
                TileEntityPlatformRailing railing;
                TileEntityPlatformBase oTile = BlockPlatformBase.getTile((class_1922)world, posUp);
                if (oTile instanceof TileEntityPlatformRailing && (railing = (TileEntityPlatformRailing)oTile).isLinked()) {
                    world.method_8650(posUp, false);
                }
            }
        }
    }

    public void changeCovering(class_2680 state, class_1937 world, class_2338 pos, EnumCovering covering) {
        if (state.method_26204() instanceof BlockPlatformBase) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
            if (((BlockPlatformBase)state.method_26204()).platformType.isAddon() && tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked()) {
                TileEntityPlatformBase oTile;
                state = world.method_8320(pos = pos.method_10074());
                if (!(state.method_26204() instanceof BlockPlatformBase)) {
                    return;
                }
                if (tile.getCovering() == EnumCovering.NONE && (oTile = BlockPlatformBase.getTile((class_1922)world, pos)) != null) {
                    oTile.copyCovering(tile);
                }
            }
            if (tile != null) {
                tile.setCovering(covering);
                this.editLinkedRail(state, (class_1936)world, pos, tile, tile instanceof TileEntityPlatformIncline);
            }
        }
    }

    public class_2680 method_9605(class_1750 context) {
        Optional<Boolean> translucent;
        class_2350 direction = context.method_8042();
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction);
        class_2338 pos = context.method_8037();
        if (!(this instanceof BlockPlatformType.Singles)) {
            class_2680 oState;
            class_2248 class_22482;
            boolean zAxis;
            EnumSubType subType = null;
            class_2350 face = context.method_8038();
            class_243 hitVec = context.method_17698();
            boolean bl = zAxis = direction.method_10166() == class_2350.class_2351.field_11051;
            if ((this instanceof BlockPlatformType.Walkways && face.method_10166() != class_2350.class_2351.field_11052 || this instanceof BlockPlatformType.Railings) && (class_22482 = (oState = context.method_8045().method_8320(pos.method_10093(face.method_10153()))).method_26204()) instanceof BlockPlatformBase) {
                BlockPlatformBase oBlock = (BlockPlatformBase)class_22482;
                if (oBlock.platformType == this.platformType) {
                    state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)oState.method_11654((class_2769)FACING)));
                    subType = BlockPlatformBase.getPlatformSubType(oState);
                } else if (face == class_2350.field_11036 && this instanceof BlockPlatformType.Railings) {
                    subType = EnumSubType.byName(BlockPlatformBase.getPlatformSubType(oState).getStyleName());
                    if (subType.supportsRail(oBlock.platformType)) {
                        state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)oState.method_11654((class_2769)FACING)));
                    } else {
                        subType = null;
                    }
                }
            }
            if (subType == null) {
                boolean railOnStep = false;
                if (this instanceof BlockPlatformType.Railings) {
                    double hitX = hitVec.field_1352 - (double)pos.method_10263();
                    double hitZ = hitVec.field_1350 - (double)pos.method_10260();
                    class_2680 down = context.method_8045().method_8320(pos.method_10074());
                    if (down.method_26204() instanceof class_2510) {
                        railOnStep = true;
                        direction = (class_2350)down.method_11654((class_2769)class_2510.field_11571);
                        subType = direction.method_10166() == class_2350.class_2351.field_11051 ? (direction == class_2350.field_11043 ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT)) : (direction == class_2350.field_11034 ? (hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                    } else {
                        if (face.method_10166() == class_2350.class_2351.field_11052) {
                            if (hitX <= 0.5 && hitZ < 0.5) {
                                direction = hitX < hitZ ? class_2350.field_11043 : class_2350.field_11034;
                            } else if (hitX > 0.5 && hitZ <= 0.5) {
                                direction = 1.0 - hitX < hitZ ? class_2350.field_11035 : class_2350.field_11034;
                            } else if (hitX <= 0.5 && hitZ > 0.5) {
                                direction = hitX < 1.0 - hitZ ? class_2350.field_11043 : class_2350.field_11039;
                            } else if (hitX > 0.5 && hitZ >= 0.5) {
                                direction = hitX > hitZ ? class_2350.field_11035 : class_2350.field_11039;
                            }
                        } else {
                            direction = face.method_10160();
                        }
                        subType = EnumSubType.EDGE;
                    }
                    state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction);
                } else if (zAxis) {
                    double hitX = hitVec.field_1352 - (double)pos.method_10263();
                    subType = hitX > (double)0.4f && hitX < (double)0.6f ? EnumSubType.MIDDLE : (direction == class_2350.field_11035 ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                } else {
                    double hitZ = hitVec.field_1350 - (double)pos.method_10260();
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        subType = EnumSubType.MIDDLE;
                    } else if (direction == class_2350.field_11039) {
                        subType = hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT;
                    } else {
                        EnumSubType enumSubType = subType = hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT;
                    }
                }
                if (!railOnStep && !this.platformType.isInclineOrRoof()) {
                    if (subType == EnumSubType.RIGHT) {
                        state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction.method_10153());
                        EnumSubType enumSubType = subType = this.platformType.isAddon() ? EnumSubType.EDGE : EnumSubType.EDGE_S;
                    }
                    if (subType == EnumSubType.LEFT) {
                        subType = EnumSubType.EDGE;
                    }
                }
            }
            state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
        }
        if ((translucent = TileHelper.isTranslucent(context.method_8041())).isPresent()) {
            state = BlockLightingHelper.setLighting((class_2680)state, (int)TileHelper.getLightValue(context.method_8041()), (boolean)translucent.get());
        }
        return (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(pos).method_15772() == class_3612.field_15910));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
        if (tile != null) {
            tile.setTextureInfo(stack);
            Function.syncTile((class_2586)tile);
            this.updateBlock(tile, state, world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        TileEntityPlatformBase tile;
        if (state.method_26204() == newState.method_26204() && (tile = BlockPlatformBase.getTile((class_1922)world, pos)) != null) {
            this.updateBlock(tile, newState, world, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (world.method_8608() || !Platforms.CONFIG.COMMON.COVERING.isEnvironmentReactive || !(state.method_26204() instanceof BlockPlatformBase) || ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
        if (tile != null) {
            EnumCovering covering = tile.getCovering();
            if (!covering.isWorldReactive()) {
                return;
            }
            class_6880 biomeRegistryEntry = world.method_23753(pos);
            boolean canIncreaseLevel = this.canIncreaseLevel(tile, (class_6880<class_1959>)biomeRegistryEntry, covering);
            if (world.method_8419()) {
                class_1959 biome = (class_1959)biomeRegistryEntry.comp_349();
                switch (biome.method_48162(pos)) {
                    case field_9384: {
                        if (!world.method_8546() || !canIncreaseLevel || !this.getChance(world.field_9229, Platforms.CONFIG.COMMON.COVERING.chanceSandStorm) || !this.isSandBiome((class_1937)world, pos) || !this.isOutdoors((class_1937)world, pos, true)) break;
                        this.changeCovering(state, (class_1937)world, pos, covering.increment());
                        break;
                    }
                    case field_9382: {
                        if (biome.method_39927(pos)) {
                            int chance = Platforms.CONFIG.COMMON.COVERING.chanceRainWash;
                            if (covering == EnumCovering.NONE || !this.getChance(world.field_9229, chance - (world.method_8546() ? chance / 3 : 0)) || !this.isSandBiome((class_1937)world, pos) || !this.isOutdoors((class_1937)world, pos, false)) break;
                            this.changeCovering(state, (class_1937)world, pos, covering.decrement());
                            break;
                        }
                    }
                    case field_9383: {
                        if (!canIncreaseLevel || !this.getChance(world.field_9229, Platforms.CONFIG.COMMON.COVERING.chanceSnow) || !this.isOutdoors((class_1937)world, pos, false)) break;
                        this.changeCovering(state, (class_1937)world, pos, covering.increment());
                    }
                }
            } else if (canIncreaseLevel && covering == EnumCovering.NONE && this.getChance(world.field_9229, Platforms.CONFIG.COMMON.COVERING.chanceSand) && this.isSandBiome((class_1937)world, pos) && this.isOutdoors((class_1937)world, pos, true)) {
                this.changeCovering(state, (class_1937)world, pos, EnumCovering.A1);
            }
        }
        this.setLighting(state, (class_1937)world, pos, tile);
    }

    private boolean canIncreaseLevel(TileEntityPlatformBase tile, class_6880<class_1959> biomeRegistryEntry, EnumCovering covering) {
        if (covering == EnumCovering.NONE || covering.isWorldReactive() && covering.canIncrement()) {
            class_2248 coveringBlock = tile.getCoveringBlock();
            class_2248 biomeCovering = tile.getBiomeCovering(biomeRegistryEntry);
            if (covering == EnumCovering.NONE && coveringBlock != class_2246.field_10124 && coveringBlock != biomeCovering) {
                tile.removeCoveringTexture();
                coveringBlock = tile.getCoveringBlock();
            }
            if (coveringBlock == class_2246.field_10124) {
                return tile.setCoveringTexture(new class_1799((class_1935)biomeCovering)) != EnumCovering.NONE;
            }
            return biomeCovering == coveringBlock;
        }
        return false;
    }

    private boolean getChance(class_5819 random, int odds) {
        return odds > 0 && random.method_43048(odds) == 0;
    }

    private boolean isSandBiome(class_1937 world, class_2338 pos) {
        return BlockPlatformBase.getBiomeTopBlock((class_6880<class_1959>)world.method_23753(pos)) instanceof class_2468;
    }

    public static class_2248 getBiomeTopBlock(class_6880<class_1959> biome) {
        if (biome.method_40220(class_6908.field_36513) || biome.method_40220(ConventionalBiomeTags.MESA)) {
            return class_2246.field_10534;
        }
        if (biome.method_40220(class_6908.field_36510) || biome.method_40220(ConventionalBiomeTags.DESERT)) {
            return class_2246.field_10102;
        }
        if (biome.method_40220(class_6908.field_36512) || biome.method_40220(ConventionalBiomeTags.UNDERGROUND)) {
            return class_2246.field_10255;
        }
        if (biome.method_40220(ConventionalBiomeTags.MUSHROOM)) {
            return class_2246.field_10402;
        }
        if (biome.method_40220(ConventionalBiomeTags.ICY)) {
            return class_2246.field_10225;
        }
        if (biome.method_40220(class_6908.field_36518)) {
            return class_2246.field_10515;
        }
        if (biome.method_40220(class_6908.field_37394)) {
            return class_2246.field_10471;
        }
        return class_2246.field_10219;
    }

    private boolean isOutdoors(class_1937 world, class_2338 pos, boolean addingSand) {
        if (addingSand) {
            class_2338.class_2339 mPos = new class_2338.class_2339();
            int layers = 0;
            boolean isRaining = world.method_8419();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x == 0 && z == 0 && y == 0) continue;
                        mPos.method_10103(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z);
                        if (world.method_22347((class_2338)mPos)) continue;
                        class_2680 state = world.method_8320((class_2338)mPos);
                        class_2248 block = state.method_26204();
                        if (block instanceof BlockPlatformBase) {
                            TileEntityPlatformBase tile;
                            if (y < 0 && !isRaining || (tile = BlockPlatformBase.getTile((class_1922)world, (class_2338)mPos)) == null) continue;
                            layers += Math.max(0, tile.getCovering().getLayer() - 1);
                            continue;
                        }
                        if (!state.method_26164(class_3481.field_15466)) continue;
                        return true;
                    }
                }
            }
            return layers > 3;
        }
        if (world.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260()) <= pos.method_10264() + 1) {
            return true;
        }
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                mPos.method_10103(pos.method_10263() + x, pos.method_10264(), pos.method_10260() + z);
                if (world.method_8624(class_2902.class_2903.field_13197, mPos.method_10263(), mPos.method_10260()) > pos.method_10264() + 1) continue;
                return true;
            }
        }
        return false;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_2338 cached;
        super.method_9591(world, pos, state, entity);
        if (!(world.method_8608() || !Platforms.CONFIG.COMMON.COVERING.isEntityReactive || (cached = (class_2338)WALK_CACHE.getIfPresent((Object)entity)) != null && cached.equals((Object)pos))) {
            EnumCovering covering;
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
            EnumCovering enumCovering = covering = tile != null ? tile.getCovering() : EnumCovering.NONE;
            if (covering.isWorldReactive() && covering.canDecrement() && world.method_8409().method_43048(4) == 0) {
                this.changeCovering(state, world, pos, covering.decrement());
            }
            WALK_CACHE.put((Object)entity, (Object)pos);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        super.method_9612(state, world, pos, block, fromPos, notify);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((class_1922)world, pos);
        if (tile != null) {
            this.updateBlock(tile, state, world, pos);
        }
        this.setLighting(state, world, pos, tile);
    }

    protected abstract void updateBlock(TileEntityPlatformBase var1, class_2680 var2, class_1937 var3, class_2338 var4);

    protected class_238 getShapeBoundingBox(class_265 shape) {
        return shape.method_1110() ? null : shape.method_1107();
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return super.method_9598(state, rotation);
    }

    public class_2680 rotate(class_2680 state, class_1937 world, class_2338 pos, class_2470 rotation) {
        return this.rotateBlock(state, world, pos, BlockPlatformBase.getTile((class_1922)world, pos), rotation);
    }

    public class_2680 rotateBlock(class_2680 state, class_1937 world, class_2338 pos, TileEntityPlatformBase tile, class_2470 rotation) {
        if (tile == null || state.method_26204() != this) {
            return state;
        }
        if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked()) {
            class_2680 newStateDown;
            class_2338 posDown = pos.method_10074();
            class_2680 stateDown = world.method_8320(posDown);
            if ((stateDown.method_26204() instanceof BlockPlatformFloor || stateDown.method_26204() instanceof BlockPlatformType.Inclines) && stateDown != (newStateDown = ((ILocationAwareRotation)stateDown.method_26204()).rotate(stateDown, world, posDown, rotation))) {
                Function.setBlock((class_1945)world, (class_2338)posDown, (class_2680)newStateDown, (boolean)true);
            }
            return world.method_8320(pos);
        }
        if (tile instanceof TileEntityPlatformRoof) {
            ((TileEntityPlatformRoof)tile).preRotateFacing = (class_2350)state.method_11654((class_2769)FACING);
        }
        if (this.platformType == EnumPlatformType.FRAME && rotation == class_2470.field_11467) {
            rotation = class_2470.field_11463;
        }
        if (rotation != class_2470.field_11467) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
            switch (rotation) {
                case field_11463: {
                    direction = direction.method_10170();
                    break;
                }
                case field_11465: {
                    direction = direction.method_10160();
                    break;
                }
                case field_11464: {
                    direction = direction.method_10153();
                }
            }
            class_2680 rotatedState = (class_2680)state.method_11657((class_2769)FACING, (Comparable)direction);
            if (tile.hasRail() && (tile instanceof TileEntityPlatformIncline || tile instanceof TileEntityPlatformFloor)) {
                this.editLinkedRail(rotatedState, (class_1936)world, pos, tile, tile instanceof TileEntityPlatformIncline);
            }
            return rotatedState;
        }
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return state;
        }
        Collection subTypes = propertySubType.method_11898();
        EnumSubType newType = null;
        EnumSubType[] types = subTypes.toArray(new EnumSubType[0]);
        int current = 100;
        for (int index = 0; index < types.length; ++index) {
            if (types[index] == subType) {
                current = index;
            }
            if (current >= index) continue;
            newType = types[index];
            break;
        }
        if (newType == null && current > 0) {
            newType = types[0];
        }
        if (newType != null && BlockPlatformBase.setPlatformSubType((class_1936)world, pos, newType)) {
            return world.method_8320(pos);
        }
        return state;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityPlatformBase tile;
        if ((index > 0 && index < 5 || index == 9) && data.world != null && data.pos != null && (tile = BlockPlatformBase.getTile((class_1922)data.world, data.pos)) != null) {
            if (index == 9) {
                return tile.getTint(4);
            }
            if (this.platformType.isAddon()) {
                index -= 2;
            }
            return tile.getTint(index - 1);
        }
        return 0xFFFFFF;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            class_1799 platform = ItemBlockPlatform.createStack((class_2248)this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
            return (class_1799)DistExecutor.runForDist(() -> () -> this.getPickStack(tile, platform), () -> () -> platform);
        }
        return new class_1799((class_1935)this);
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 getPickStack(TileEntityPlatformBase tile, class_1799 platform) {
        class_746 player = class_310.method_1551().field_1724;
        return player != null && player.method_5715() && TileHelper.hasRail(tile) ? tile.getRailItem() : platform;
    }
}

