/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import shetiphian.core.client.model.IPartData;
import shetiphian.platforms.client.model.PartData;
import shetiphian.platforms.common.misc.EnumTorchType;

public class Parts {
    static final List<class_2960> TEXTURES = Parts.getTextures();
    static final List<IPartData> MODELS = Parts.getModels();

    static String getBrazierTexture() {
        return "platforms:block/brazier";
    }

    static String getBrazierFillTexture(EnumTorchType torch) {
        return "platforms:block/" + torch.toString();
    }

    static String getPlacementTexture() {
        return "platforms:block/placement";
    }

    private static List<class_2960> getTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        list.add(new class_2960(Parts.getBrazierTexture()));
        list.add(new class_2960(Parts.getPlacementTexture()));
        for (EnumTorchType torch : EnumTorchType.values()) {
            if (torch == EnumTorchType.NONE || torch == EnumTorchType.MIGRATED) continue;
            list.add(new class_2960(Parts.getBrazierFillTexture(torch)));
        }
        return list;
    }

    private static List<IPartData> getModels() {
        String[] handrails;
        String[] covers = new String[]{"lvl-", "lvl1", "lvl2", "lvl3"};
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        String[] platforms = new String[]{"flat", "floor"};
        list.add(new PartData("flat/base_corner", true));
        list.add(new PartData("flat/base_normal", true));
        list.add(new PartData("floor/base_corner_inside", true));
        list.add(new PartData("floor/base_corner_middle", true));
        list.add(new PartData("floor/base_corner_outside", true));
        list.add(new PartData("floor/base_normal_edge", true));
        list.add(new PartData("floor/base_normal_middle", true));
        for (String type : platforms) {
            list.add(new PartData(type + "/edge_east", false));
            list.add(new PartData(type + "/edge_north", false));
            list.add(new PartData(type + "/edge_south", false));
            list.add(new PartData(type + "/edge_west", false));
            list.add(new PartData(type + "/middle_east", false));
            list.add(new PartData(type + "/middle_north", false));
            list.add(new PartData(type + "/middle_south", false));
            list.add(new PartData(type + "/middle_west", false));
            list.add(new PartData(type + "/middle_corner_sides", false));
            list.add(new PartData(type + "/middle_corner_strip", false));
            list.add(new PartData(type + "/middle_corner_bottom_east", false));
            list.add(new PartData(type + "/middle_corner_bottom_north", false));
            list.add(new PartData(type + "/middle_corner_bottom_south", false));
            list.add(new PartData(type + "/middle_corner_bottom_west", false));
            list.add(new PartData(type + "/middle_corner_top_east", false));
            list.add(new PartData(type + "/middle_corner_top_north", false));
            list.add(new PartData(type + "/middle_corner_top_south", false));
            list.add(new PartData(type + "/middle_corner_top_west", false));
            list.add(new PartData(type + "/inside_corner_sides", false));
            list.add(new PartData(type + "/inside_corner_strip", false));
            list.add(new PartData(type + "/inside_corner_east", false));
            list.add(new PartData(type + "/inside_corner_north", false));
            list.add(new PartData(type + "/inside_corner_south", false));
            list.add(new PartData(type + "/inside_corner_west", false));
            list.add(new PartData(type + "/inside_corner_bottom_east", false));
            list.add(new PartData(type + "/inside_corner_bottom_north", false));
            list.add(new PartData(type + "/inside_corner_bottom_south", false));
            list.add(new PartData(type + "/inside_corner_bottom_west", false));
            list.add(new PartData(type + "/inside_corner_top_east", false));
            list.add(new PartData(type + "/inside_corner_top_north", false));
            list.add(new PartData(type + "/inside_corner_top_south", false));
            list.add(new PartData(type + "/inside_corner_top_west", false));
            list.add(new PartData(type + "/outside_corner_sides", false));
            list.add(new PartData(type + "/outside_corner_strip", false));
            list.add(new PartData(type + "/outside_corner_east", false));
            list.add(new PartData(type + "/outside_corner_north", false));
            list.add(new PartData(type + "/outside_corner_south", false));
            list.add(new PartData(type + "/outside_corner_west", false));
            list.add(new PartData(type + "/outside_corner_bottom_east", false));
            list.add(new PartData(type + "/outside_corner_bottom_north", false));
            list.add(new PartData(type + "/outside_corner_bottom_south", false));
            list.add(new PartData(type + "/outside_corner_bottom_west", false));
            list.add(new PartData(type + "/outside_corner_top_east", false));
            list.add(new PartData(type + "/outside_corner_top_north", false));
            list.add(new PartData(type + "/outside_corner_top_south", false));
            list.add(new PartData(type + "/outside_corner_top_west", false));
            for (String cover : covers) {
                list.add(new PartData(type + "/covering/" + cover + "_edge", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_middle", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_inside_corner", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_outside_corner", "minecraft:block/snow"));
            }
        }
        list.add(new PartData("floor/support_legs", true));
        list.add(new PartData("floor/support_post_corner_inside", true));
        list.add(new PartData("floor/support_post_corner_outside", true));
        list.add(new PartData("floor/support_post_extension", true));
        list.add(new PartData("floor/support_post_normal_edge", true));
        list.add(new PartData("frame/bar", false));
        list.add(new PartData("frame/support", true));
        list.add(new PartData("frame/brazier_base", "platforms:block/brazier"));
        list.add(new PartData("frame/brazier_fill", "platforms:block/light"));
        for (String cover : covers) {
            list.add(new PartData("frame/covering/" + cover, "minecraft:block/snow"));
        }
        for (String type : new String[]{"ramp", "steps", "stairs", "shingles", "tiles"}) {
            list.add(new PartData(type + "/right", false));
            list.add(new PartData(type + "/left", false));
            list.add(new PartData(type + "/middle", false));
            list.add(new PartData(type + "/inside", false));
            list.add(new PartData(type + "/outside", false));
        }
        for (String type : new String[]{"shingles", "tiles"}) {
            list.add(new PartData(type + "/peak_cap", false));
            list.add(new PartData(type + "/peak_end", false));
            list.add(new PartData(type + "/peak_l", false));
            list.add(new PartData(type + "/peak_middle", false));
            list.add(new PartData(type + "/peak_sides", false));
            list.add(new PartData(type + "/peak_t", false));
            list.add(new PartData(type + "/peak_x", false));
        }
        list.add(new PartData("shingles/peak_dn", false).lockUV());
        list.add(new PartData("shingles/peak_sides_dn", false).lockUV());
        for (String type : new String[]{"ramp", "steps"}) {
            list.add(new PartData(type + "/base_normal", true));
            list.add(new PartData(type + "/base_corner_inside", true));
            list.add(new PartData(type + "/base_corner_outside", true));
            list.add(new PartData(type + "/support_normal_legs", true));
            list.add(new PartData(type + "/support_corner_inside_legs", true));
            list.add(new PartData(type + "/support_corner_outside_legs", true));
            list.add(new PartData(type + "/support_normal_post", true));
            list.add(new PartData(type + "/support_corner_inside_post", true));
            list.add(new PartData(type + "/support_corner_outside_post", true));
        }
        list.add(new PartData("ramp/support_beam_right_lb", true));
        list.add(new PartData("ramp/support_beam_right_sb", true));
        list.add(new PartData("ramp/support_beam_left_lb", true));
        list.add(new PartData("ramp/support_beam_left_sb", true));
        list.add(new PartData("ramp/support_beam_middle", true));
        list.add(new PartData("ramp/support_beam_inside", true));
        list.add(new PartData("ramp/support_beam_outside", true));
        list.add(new PartData("ramp/support_brace_right", true));
        list.add(new PartData("ramp/support_brace_left", true));
        list.add(new PartData("ramp/support_brace_middle", true));
        list.add(new PartData("ramp/support_brace_inside", true));
        list.add(new PartData("ramp/support_brace_outside", true));
        list.add(new PartData("shingles/base_corner_inside", true));
        list.add(new PartData("shingles/base_corner_inside_full", true));
        list.add(new PartData("shingles/base_corner_outside", true));
        list.add(new PartData("shingles/base_corner_outside_full", true));
        list.add(new PartData("shingles/base_full", true));
        list.add(new PartData("shingles/base_left", true));
        list.add(new PartData("shingles/base_middle", true));
        list.add(new PartData("shingles/base_right", true));
        list.add(new PartData("shingles/base_peak", true).lockUV());
        list.add(new PartData("shingles/base_peak_sides", true).lockUV());
        list.add(new PartData("shingles/base_peak_up", true).lockUV());
        list.add(new PartData("shingles/base_peak_sides_up", true).lockUV());
        list.add(new PartData("shingles/support_beam_inside", true));
        list.add(new PartData("shingles/support_beam_outside", true));
        list.add(new PartData("shingles/support_beam_outside_purlin", true));
        for (String type : new String[]{"middle", "left", "right"}) {
            list.add(new PartData("shingles/support_beam_" + type, true));
            list.add(new PartData("shingles/support_beam_" + type + "_cap_lower", true));
            list.add(new PartData("shingles/support_beam_" + type + "_cap_upper", true));
            list.add(new PartData("shingles/support_beam_" + type + "_purlin_lower", true));
            list.add(new PartData("shingles/support_beam_" + type + "_purlin_upper", true));
        }
        list.add(new PartData("shingles/support_beam_peak", true).lockUV());
        list.add(new PartData("shingles/support_beam_peak_sides", true).lockUV());
        list.add(new PartData("shingles/support_plane_inside", true));
        list.add(new PartData("shingles/support_plane_middle", true));
        list.add(new PartData("shingles/support_plane_outside", true));
        list.add(new PartData("shingles/support_plane_slope", true));
        list.add(new PartData("shingles/support_plane_peak_end", true).lockUV());
        list.add(new PartData("shingles/support_plane_peak_middle", true).lockUV());
        list.add(new PartData("shingles/support_plane_peak_sides", true).lockUV());
        for (String cover : covers) {
            for (String type : new String[]{"ramp", "steps", "stairs", "shingles", "tiles"}) {
                list.add(new PartData(type + "/covering/" + cover + "_right", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_left", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_middle", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_inside", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_outside", "minecraft:block/snow"));
            }
            for (String type : new String[]{"shingles", "tiles"}) {
                list.add(new PartData(type + "/covering/" + cover + "_peak_cap", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_end", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_l", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_middle", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_sides", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_t", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_peak_x", "minecraft:block/snow"));
            }
        }
        for (String type : handrails = new String[]{"rise", "rail"}) {
            list.add(new PartData(type + "/bar_inside_corner", false));
            list.add(new PartData(type + "/bar_outside_corner", false));
            list.add(new PartData(type + "/bar_edge", false));
            list.add(new PartData(type + "/support_inside_corner", true));
            list.add(new PartData(type + "/support_inside_corner_extended", true));
            list.add(new PartData(type + "/support_outside_corner", true));
            list.add(new PartData(type + "/support_outside_corner_extended", true));
            list.add(new PartData(type + "/support_edge", true));
            list.add(new PartData(type + "/support_edge_extended", true));
            list.add(new PartData(type + "/bar_left_tall", false));
            list.add(new PartData(type + "/bar_right_tall", false));
            list.add(new PartData(type + "/support_left_tall", true));
            list.add(new PartData(type + "/support_right_tall", true));
            list.add(new PartData(type + "/bar_middle", false));
            list.add(new PartData(type + "/bar_ramp_middle", false));
            list.add(new PartData(type + "/bar_ramp_inside", false));
            list.add(new PartData(type + "/bar_ramp_outside", false));
            list.add(new PartData(type + "/support_middle", true));
            list.add(new PartData(type + "/support_ramp_middle", true));
            list.add(new PartData(type + "/support_ramp_inside", true));
            list.add(new PartData(type + "/support_ramp_outside", true));
            list.add(new PartData(type + "/support_middle_extended", true));
            list.add(new PartData(type + "/bar_roof", false));
            list.add(new PartData(type + "/support_roof_middle", true));
            list.add(new PartData(type + "/support_roof_full", true));
            list.add(new PartData(type + "/support_roof_inside", true));
            list.add(new PartData(type + "/support_roof_outside", true));
            for (String cover : covers) {
                list.add(new PartData(type + "/covering/" + cover + "_edge", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_inside_corner", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_outside_corner", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_right_tall", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_left_tall", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_middle", "minecraft:block/snow"));
                list.add(new PartData(type + "/covering/" + cover + "_middle_lower", "minecraft:block/snow"));
            }
            list.add(new PartData(type + "/covering/roof", "minecraft:block/snow"));
        }
        return list;
    }
}

