/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import joptsimple.internal.Strings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4696;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.common.UseContext;
import shetiphian.core.internal.client.SPC_ExtraRenderData;
import shetiphian.platforms.client.misc.TextureInfoHelper;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.client.model.Parts;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;

@Environment(value=EnvType.CLIENT)
public class ModelPlatform {
    public static final class_1100 INSTANCE = new Unbaked();

    private static String getTextureForRenderLayer(class_1799 stack, class_1921 layer) {
        boolean doRender;
        if (layer == null || stack.method_7909() == class_1802.field_8077) {
            return Parts.getPlacementTexture();
        }
        class_2680 materialState = UseContext.getBlockPlacementStateFor((class_1799)stack);
        boolean bl = doRender = layer == class_1921.method_23577();
        doRender = class_4696.method_23679((class_2680)materialState) == class_1921.method_23583() ? layer == class_1921.method_23583() : (class_4696.method_23679((class_2680)materialState) == class_1921.method_23581() || class_4696.method_23679((class_2680)materialState) == class_1921.method_23579() ? layer == class_1921.method_23581() : doRender);
        return doRender ? CacheBuilder.INSTANCE.getTexture(stack) : null;
    }

    private static void addParts_Flat(List<class_1087> list, EnumSubType subType, String[] textures, String particle, class_2350 facing, EnumPlatformType railType, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
        ModelPlatform.add(list, "flat/base_" + baseType, textures[0], styleType == EnumSubType.EnumStyle.INSIDE ? facing.method_10153() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "flat/" + name + "_" + part, textures[1], facing, particle);
        }
        if (railType != null) {
            if (styleType != EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.addParts_Rise(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, false, coveringData);
            } else {
                ModelPlatform.addParts_SpecialAddon(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, "flat", coveringData);
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCoverings(list, "flat", "_" + (String)(styleType == EnumSubType.EnumStyle.MIDDLE ? "middle" : name), facing, coveringData);
        }
    }

    private static void addParts_Floor(List<class_1087> list, EnumSubType subType, String[] textures, String particle, class_2350 facing, int support, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        String leg_base = baseType + "_" + styleType;
        String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
        ModelPlatform.add(list, "floor/base_" + leg_base, textures[0], facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "floor/" + name + "_" + part, textures[1], facing, particle);
        }
        if (support == 0) {
            ModelPlatform.add(list, "floor/support_legs", textures[0], facing, particle);
        } else if (support == 1) {
            if (styleType != EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.add(list, "floor/support_post_" + leg_base, textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "floor/support_post_extension", textures[0], facing, particle);
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCoverings(list, "floor", "_" + (String)(styleType == EnumSubType.EnumStyle.MIDDLE ? "middle" : name), facing, coveringData);
        }
    }

    private static void addParts_Ramps(List<class_1087> list, EnumPlatformType type, EnumSubType subType, String[] textures, String particle, class_2350 facing, EnumPlatformType railType, int support, Pair<EnumCovering, String> coveringData) {
        String base;
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        ModelPlatform.add(list, type + "/" + styleType, textures[1], facing, particle);
        String string = base = baseType == EnumSubType.EnumBase.NORMAL ? "normal" : baseType + "_" + styleType;
        if (type == EnumPlatformType.RAMP || type == EnumPlatformType.STAIRS) {
            ModelPlatform.add(list, "ramp/base_" + base, textures[0], facing, particle);
            if (support % 3 < 2) {
                ModelPlatform.add(list, "ramp/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
            }
            if (support > 2 && type == EnumPlatformType.RAMP) {
                String extra = styleType == EnumSubType.EnumStyle.RIGHT || styleType == EnumSubType.EnumStyle.LEFT ? (support % 3 != 1 ? "_sb" : "_lb") : "";
                ModelPlatform.add(list, "ramp/support_beam_" + styleType + extra, textures[0], facing, particle);
                ModelPlatform.add(list, "ramp/support_brace_" + styleType, textures[0], facing, particle);
            }
        } else {
            ModelPlatform.add(list, type + "/base_" + base, textures[0], facing, particle);
            if (support % 3 < 2) {
                ModelPlatform.add(list, type + "/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
            }
        }
        if (railType != null && (subType == EnumSubType.MIDDLE || baseType == EnumSubType.EnumBase.CORNER)) {
            ModelPlatform.addParts_SpecialAddon(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, type.method_15434(), coveringData);
        }
        if (coveringData != null) {
            ModelPlatform.addCoverings(list, type.method_15434(), "_" + styleType, facing, coveringData);
        }
    }

    private static void addParts_Roofs(List<class_1087> list, EnumPlatformType type, EnumSubType subType, String edgeType, String[] textures, String particle, class_2350 facing, EnumPlatformType railType, int support, boolean skylight, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        boolean bl = skylight = skylight && support > 0;
        if (!skylight || type == EnumPlatformType.TILES) {
            ModelPlatform.add(list, "shingles/" + styleType, textures[1], facing, particle);
        }
        if (!skylight) {
            ModelPlatform.add(list, type + "/" + styleType, textures[1], facing, particle);
        }
        if (support == 0 && (baseType == EnumSubType.EnumBase.CORNER || styleType == EnumSubType.EnumStyle.MIDDLE)) {
            if (styleType == EnumSubType.EnumStyle.MIDDLE) {
                ModelPlatform.add(list, "shingles/base_full", textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "shingles/base_" + baseType + "_" + styleType + "_full", textures[0], facing, particle);
            }
        } else {
            if (edgeType == null) {
                edgeType = "";
            }
            Object base = baseType == EnumSubType.EnumBase.NORMAL ? "" + styleType : baseType + "_" + styleType;
            ModelPlatform.add(list, "shingles/base_" + (String)base, textures[skylight ? 1 : 0], facing, particle);
            if (styleType == EnumSubType.EnumStyle.OUTSIDE && edgeType.contains("lower")) {
                ModelPlatform.add(list, "shingles/support_beam_outside_purlin", textures[0], facing, particle);
            } else {
                ModelPlatform.add(list, "shingles/support_beam_" + styleType, textures[0], facing, particle);
            }
            if (baseType == EnumSubType.EnumBase.NORMAL) {
                String ends = edgeType.contains("lower") ? "_purlin_lower" : "_cap_lower";
                ModelPlatform.add(list, "shingles/support_beam_" + styleType + ends, textures[0], facing, particle);
                ends = edgeType.contains("upper") ? "_purlin_upper" : "_cap_upper";
                ModelPlatform.add(list, "shingles/support_beam_" + styleType + ends, textures[0], facing, particle);
            }
            if (support == 1 && railType == null) {
                base = baseType == EnumSubType.EnumBase.NORMAL ? "normal" : baseType + "_" + styleType;
                ModelPlatform.add(list, "ramp/support_" + (String)base + "_post", textures[0], facing, particle);
            } else if (support >= 3) {
                if (support != 4 && (baseType == EnumSubType.EnumBase.CORNER || styleType == EnumSubType.EnumStyle.MIDDLE)) {
                    ModelPlatform.add(list, "shingles/support_plane_" + styleType, textures[0], facing, particle);
                }
                if (support != 3 && baseType == EnumSubType.EnumBase.NORMAL) {
                    ModelPlatform.add(list, "shingles/support_plane_slope", textures[skylight ? 1 : 0], facing, particle);
                }
            }
        }
        if (railType != null) {
            String name = support == 1 ? "full" : (baseType == EnumSubType.EnumBase.NORMAL ? "middle" : subType.getStyleName());
            ModelPlatform.add(list, railType + "/support_roof_" + name, textures[2], facing, particle);
            ModelPlatform.add(list, railType + "/bar_roof", textures[3], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
                ModelPlatform.add(list, railType + "/covering/roof", (String)coveringData.getRight(), facing, (String)coveringData.getRight());
            }
        }
        if (coveringData != null) {
            if (skylight) {
                if (type == EnumPlatformType.TILES) {
                    ModelPlatform.addCoverings(list, "shingles", "_" + styleType, facing, (Pair<EnumCovering, String>)Pair.of((Object)((Object)((EnumCovering)((Object)coveringData.getLeft())).min()), (Object)((String)coveringData.getRight())));
                }
            } else {
                ModelPlatform.addCoverings(list, type.method_15434(), "_" + styleType, facing, coveringData);
            }
        }
    }

    private static void addParts_RoofCaps(List<class_1087> list, EnumPlatformType type, String edgeType, String[] textures, String particle, class_2350 facing, EnumPlatformType railType, boolean skylight, boolean diwhy, Pair<EnumCovering, String> coveringData) {
        Object suffix;
        if (Strings.isNullOrEmpty((String)edgeType)) {
            edgeType = "cap";
        }
        Object object = suffix = ((String)(edgeType = "peak_" + (String)edgeType)).endsWith("_sides") ? edgeType : ((String)edgeType).substring(0, 4);
        if (!skylight || type == EnumPlatformType.TILES) {
            ModelPlatform.add(list, "shingles/" + (String)edgeType, textures[1], facing, particle);
            if (diwhy) {
                ModelPlatform.add(list, "shingles/" + (String)suffix + "_dn", textures[1], facing, particle);
            }
        }
        if (!skylight) {
            ModelPlatform.add(list, type + "/" + (String)edgeType, textures[1], facing, particle);
            if (((String)edgeType).matches(".*_(end|middle|sides)")) {
                ModelPlatform.add(list, "shingles/support_plane_" + (String)edgeType, textures[diwhy ? 1 : 0], facing, particle);
            }
        }
        ModelPlatform.add(list, "shingles/base_" + (String)suffix, textures[skylight ? 1 : 0], facing, particle);
        if (skylight) {
            ModelPlatform.add(list, "shingles/base_" + (String)suffix + "_up", textures[1], facing, particle);
        }
        ModelPlatform.add(list, "shingles/support_beam_" + (String)suffix, textures[0], facing, particle);
        if (railType != null) {
            ModelPlatform.add(list, railType + "/support_roof_full", textures[2], facing, particle);
            ModelPlatform.add(list, railType + "/bar_roof", textures[3], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
                ModelPlatform.add(list, railType + "/covering/roof", (String)coveringData.getRight(), facing, (String)coveringData.getRight());
            }
        }
        if (coveringData != null) {
            ModelPlatform.addCoverings(list, type.method_15434(), "_" + (String)edgeType, facing, coveringData);
        }
    }

    private static void addParts_SpecialAddon(List<class_1087> list, EnumSubType subType, String[] textures, String particle, class_2350 facing, boolean isRail, String suffix, Pair<EnumCovering, String> coveringData) {
        String variant = isRail ? "rail" : "rise";
        boolean isRamp = suffix.startsWith("ramp") || suffix.startsWith("steps") || suffix.startsWith("stairs");
        String name = subType.getStyleName();
        if (isRamp) {
            ModelPlatform.add(list, variant + "/bar_ramp_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_ramp_" + name, textures[0], facing, particle);
            name = "middle";
        } else {
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name, textures[0], facing, particle);
        }
        if (suffix.equals("")) {
            ModelPlatform.add(list, variant + "/support_" + name + "_extended", textures[0], facing, particle);
        }
        if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) {
            ModelPlatform.addCoverings(list, variant, "_" + name, facing, coveringData);
            if (!isRamp) {
                ModelPlatform.addCoverings(list, variant, "_" + name + "_lower", facing, coveringData);
            }
        }
    }

    private static void addParts_Rise(List<class_1087> list, EnumSubType subType, String[] textures, String particle, class_2350 facing, boolean isRail, boolean isLinkedToFloor, Pair<EnumCovering, String> coveringData) {
        EnumSubType.EnumBase baseType = subType.getBaseType();
        EnumSubType.EnumStyle styleType = subType.getStyleType();
        if (styleType != EnumSubType.EnumStyle.MIDDLE) {
            String variant = isRail ? "rail" : "rise";
            String name = styleType + (baseType == EnumSubType.EnumBase.CORNER ? "_corner" : "");
            if (name.equals("left") || name.equals("right")) {
                name = name + "_tall";
            }
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name + (isLinkedToFloor ? "_extended" : ""), textures[0], facing, particle);
            if (coveringData != null && ((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) {
                ModelPlatform.addCoverings(list, variant, "_" + name, facing, coveringData);
            }
        } else {
            ModelPlatform.addParts_SpecialAddon(list, subType, textures, particle, facing, isRail, "", coveringData);
        }
    }

    private static void addCoverings(List<class_1087> list, String type, String part, class_2350 facing, Pair<EnumCovering, String> coveringData) {
        if (((EnumCovering)((Object)coveringData.getLeft())).renderSides()) {
            ModelPlatform.add(list, type + "/covering/lvl-" + part, (String)coveringData.getRight(), facing, (String)coveringData.getRight());
        }
        ModelPlatform.add(list, type + "/covering/lvl" + ((EnumCovering)((Object)coveringData.getLeft())).getLayer() + part, (String)coveringData.getRight(), facing, (String)coveringData.getRight());
    }

    private static void add(List<class_1087> list, String part, String key, class_2350 facing, String particle) {
        class_1087 model;
        if (!Strings.isNullOrEmpty((String)key) && (model = CacheBuilder.get(part, key, facing, particle)) != null) {
            list.add(model);
        }
    }

    private static class Unbaked
    implements class_1100 {
        private Unbaked() {
        }

        public Collection<class_2960> method_4755() {
            ArrayList list = new ArrayList();
            Parts.MODELS.forEach(partData -> list.add(partData.getLocation()));
            return ImmutableList.copyOf(list);
        }

        public void method_45785(Function<class_2960, class_1100> modelLoader) {
        }

        public class_1087 method_4753(class_7775 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 settings, class_2960 modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return Baked.INSTANCE;
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static final Table<EnumPlatformType, EnumSubType.EnumStyle, class_809> SPECIAL_TRANSFORMS = HashBasedTable.create();
        private static final Map<EnumPlatformType, class_809> TRANSFORMS = ItemHandler.buildTransforms();

        private ItemHandler() {
        }

        class_1087 getModel(class_1799 stack, class_1087 original) {
            if (!stack.method_7960() && stack.method_7909() instanceof ItemBlockPlatform) {
                String modelKey;
                EnumPlatformType platformType = ((ItemBlockPlatform)stack.method_7909()).getPlatformType();
                class_809 transforms = TRANSFORMS.getOrDefault((Object)platformType, class_809.field_4301);
                class_1799 itemFrame = ItemBlockPlatform.getFrameTextureStack(stack);
                class_1799 itemCover = ItemBlockPlatform.getCoverTextureStack(stack);
                String key1 = CacheBuilder.INSTANCE.getTexture(itemFrame);
                String key2 = CacheBuilder.INSTANCE.getTexture(itemCover);
                EnumSubType subType = ItemBlockPlatform.getSubType(stack);
                if (SPECIAL_TRANSFORMS.contains((Object)platformType, (Object)subType.getStyleType())) {
                    transforms = (class_809)SPECIAL_TRANSFORMS.get((Object)platformType, (Object)subType.getStyleType());
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey = platformType + "::" + subType + "::" + key1 + "::" + key2)) {
                    ArrayList<class_1087> list = new ArrayList<class_1087>();
                    switch (platformType) {
                        case FLAT: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "flat/edge_north", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "flat/base_normal", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Flat(list, subType, new String[]{key1, key2}, key2, class_2350.field_11043, null, null);
                            break;
                        }
                        case FLOOR: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "floor/edge_north", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "floor/base_normal_edge", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Floor(list, subType, new String[]{key1, key2}, key2, class_2350.field_11043, 0, null);
                            break;
                        }
                        case FRAME: {
                            ModelPlatform.add(list, "frame/bar", key2, class_2350.field_11043, key2);
                            ModelPlatform.add(list, "frame/support", key1, class_2350.field_11043, key2);
                            break;
                        }
                        case RAMP: 
                        case STAIRS: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, platformType + "/left", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "ramp/base_normal", key1, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "ramp/base_normal_strut", key1, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "ramp/support_normal_post", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Ramps(list, platformType, subType, new String[]{key1, key2}, key2, class_2350.field_11043, null, 1, null);
                            break;
                        }
                        case STEPS: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "steps/left", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "steps/base_normal", key1, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "steps/base_normal_strut", key1, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "steps/support_normal_post", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Ramps(list, platformType, subType, new String[]{key1, key2}, key2, class_2350.field_11043, null, 1, null);
                            break;
                        }
                        case SHINGLES: 
                        case TILES: {
                            boolean skylight;
                            boolean bl = skylight = class_4696.method_23679((class_2680)UseContext.getBlockPlacementStateFor((class_1799)itemCover)) == class_1921.method_23583();
                            if (subType == EnumSubType.NONE || subType.getStyleType() == EnumSubType.EnumStyle.EDGE) {
                                String part;
                                String string = part = subType == EnumSubType.NONE ? "left" : "peak_cap";
                                if (!skylight || platformType == EnumPlatformType.TILES) {
                                    ModelPlatform.add(list, "shingles/" + part, key2, class_2350.field_11043, key2);
                                }
                                if (subType == EnumSubType.NONE) {
                                    ModelPlatform.add(list, "shingles/base_left", skylight ? key2 : key1, class_2350.field_11043, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left", key1, class_2350.field_11043, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left_cap_lower", key1, class_2350.field_11043, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_left_cap_upper", key1, class_2350.field_11043, key2);
                                } else {
                                    ModelPlatform.add(list, "shingles/base_peak", skylight ? key2 : key1, class_2350.field_11043, key2);
                                    ModelPlatform.add(list, "shingles/support_beam_peak", key1, class_2350.field_11043, key2);
                                }
                                if (skylight || platformType != EnumPlatformType.TILES) break;
                                ModelPlatform.add(list, "tiles/" + part, key2, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Roofs(list, platformType, subType, "", new String[]{key1, key2}, key2, class_2350.field_11043, null, 1, skylight, null);
                            break;
                        }
                        case RISE: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "rise/bar_edge", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "rise/support_edge", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, class_2350.field_11043, false, false, null);
                            break;
                        }
                        case RAIL: {
                            if (subType == EnumSubType.NONE) {
                                ModelPlatform.add(list, "rail/bar_edge", key2, class_2350.field_11043, key2);
                                ModelPlatform.add(list, "rail/support_edge", key1, class_2350.field_11043, key2);
                                break;
                            }
                            ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, class_2350.field_11043, true, false, null);
                        }
                    }
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new class_809[]{transforms}));
                }
                return (class_1087)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        private static Map<EnumPlatformType, class_809> buildTransforms() {
            HashMap<EnumPlatformType, class_809> transforms = new HashMap<EnumPlatformType, class_809>();
            transforms.put(EnumPlatformType.FLAT, ItemHandler.getFlatTransforms());
            transforms.put(EnumPlatformType.FLOOR, ItemHandler.getFloorTransforms());
            transforms.put(EnumPlatformType.FRAME, ItemHandler.getFrameTransforms());
            class_809 inclines = ItemHandler.getInclineTransforms();
            transforms.put(EnumPlatformType.RAMP, inclines);
            transforms.put(EnumPlatformType.STAIRS, inclines);
            transforms.put(EnumPlatformType.STEPS, inclines);
            class_809 roofs = ItemHandler.getRoofTransforms();
            transforms.put(EnumPlatformType.SHINGLES, roofs);
            transforms.put(EnumPlatformType.TILES, roofs);
            class_809 railings = ItemHandler.getRailingTransforms(false);
            transforms.put(EnumPlatformType.RISE, railings);
            transforms.put(EnumPlatformType.RAIL, railings);
            SPECIAL_TRANSFORMS.clear();
            railings = ItemHandler.getRailingTransforms(true);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RISE, (Object)EnumSubType.EnumStyle.LEFT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RISE, (Object)EnumSubType.EnumStyle.RIGHT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RAIL, (Object)EnumSubType.EnumStyle.LEFT, (Object)railings);
            SPECIAL_TRANSFORMS.put((Object)EnumPlatformType.RAIL, (Object)EnumSubType.EnumStyle.RIGHT, (Object)railings);
            return transforms;
        }

        private static class_809 getFlatTransforms() {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_809 getInclineTransforms() {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_809 getRoofTransforms() {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.52f, 0.52f, 0.52f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_809 getFloorTransforms() {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = ItemHandler.create(30.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_809 getFrameTransforms() {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = ItemHandler.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_809 getRailingTransforms(boolean tall) {
            class_804 thirdperson_left = ItemHandler.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            class_804 thirdperson_right = ItemHandler.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            class_804 firstperson_left = ItemHandler.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 firstperson_right = ItemHandler.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            class_804 head = class_804.field_4284;
            class_804 gui = tall ? ItemHandler.create(30.0f, 315.0f, 0.0f, 0.25f, 2.75f, 0.0f, 0.55f, 0.4f, 0.4f) : ItemHandler.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            class_804 ground = ItemHandler.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            class_804 fixed = ItemHandler.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new class_809(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private static class_804 create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(class_3532.method_15363((float)translation.x, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.y, (float)-5.0f, (float)5.0f), class_3532.method_15363((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(class_3532.method_15363((float)scale.x, (float)-4.0f, (float)4.0f), class_3532.method_15363((float)scale.y, (float)-4.0f, (float)4.0f), class_3532.method_15363((float)scale.z, (float)-4.0f, (float)4.0f));
            return new class_804(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<class_1087> getList(class_2680 state, class_1921 layer, Object modelData) {
            if (!(state.method_26204() instanceof BlockPlatformBase)) {
                return Collections.emptyList();
            }
            EnumPlatformType platformType = ((BlockPlatformBase)state.method_26204()).getPlatformType();
            class_2350 facing = (class_2350)state.method_11654((class_2769)BlockPlatformBase.FACING);
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            class_1799 itemBaseFrame = TextureInfoHelper.DEFAULT_TEXTURE;
            class_1799 itemBaseCover = TextureInfoHelper.DEFAULT_TEXTURE;
            EnumPlatformType railType = null;
            class_1799 itemRailFrame = TextureInfoHelper.DEFAULT_TEXTURE;
            class_1799 itemRailCover = TextureInfoHelper.DEFAULT_TEXTURE;
            EnumTorchType torch = EnumTorchType.NONE;
            byte support = 0;
            boolean linkedToFloor = false;
            String edgeType = null;
            Pair coveringData = null;
            if (modelData instanceof class_2487) {
                EnumCovering covering;
                ItemBlockPlatform platform;
                class_1792 class_17922;
                class_1799 itemRail;
                class_2487 nbtTag = (class_2487)modelData;
                if (nbtTag.method_10545("frame_texture_item")) {
                    itemBaseFrame = class_1799.method_7915((class_2487)nbtTag.method_10562("frame_texture_item"));
                }
                if (nbtTag.method_10545("cover_texture_item")) {
                    itemBaseCover = class_1799.method_7915((class_2487)nbtTag.method_10562("cover_texture_item"));
                }
                if (nbtTag.method_10545("rail_item") && !(itemRail = class_1799.method_7915((class_2487)nbtTag.method_10562("rail_item"))).method_7960() && (class_17922 = itemRail.method_7909()) instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)class_17922).getPlatformType().isAddon()) {
                    railType = platform.getPlatformType();
                    itemRailFrame = ItemBlockPlatform.getFrameTextureStack(itemRail);
                    itemRailCover = ItemBlockPlatform.getCoverTextureStack(itemRail);
                }
                if (nbtTag.method_10545("torch")) {
                    torch = EnumTorchType.byIndex(nbtTag.method_10571("torch"));
                }
                if (nbtTag.method_10545("support")) {
                    support = nbtTag.method_10571("support");
                }
                if (nbtTag.method_10545("linkedToFloor")) {
                    linkedToFloor = nbtTag.method_10577("linkedToFloor");
                }
                if (nbtTag.method_10545("edge_type")) {
                    edgeType = nbtTag.method_10558("edge_type");
                }
                if (nbtTag.method_10545("covering") && (covering = EnumCovering.byName(nbtTag.method_10558("covering"))) != EnumCovering.NONE && nbtTag.method_10545("covering_item")) {
                    String texture = ModelPlatform.getTextureForRenderLayer(class_1799.method_7915((class_2487)nbtTag.method_10562("covering_item")), layer);
                    coveringData = Pair.of((Object)((Object)covering), (Object)texture);
                }
            }
            String particle = CacheBuilder.INSTANCE.getTexture(itemBaseCover);
            String[] textures = new String[4];
            textures[0] = ModelPlatform.getTextureForRenderLayer(itemBaseFrame, layer);
            textures[1] = ModelPlatform.getTextureForRenderLayer(itemBaseCover, layer);
            if (railType != null) {
                textures[2] = ModelPlatform.getTextureForRenderLayer(itemRailFrame, layer);
                textures[3] = ModelPlatform.getTextureForRenderLayer(itemRailCover, layer);
            }
            ArrayList<class_1087> list = new ArrayList<class_1087>();
            switch (platformType) {
                case FLAT: {
                    ModelPlatform.addParts_Flat(list, subType, textures, particle, facing, railType, coveringData);
                    break;
                }
                case FLOOR: {
                    ModelPlatform.addParts_Floor(list, subType, textures, particle, facing, support, coveringData);
                    break;
                }
                case FRAME: {
                    ModelPlatform.add(list, "frame/bar", textures[1], facing, particle);
                    ModelPlatform.add(list, "frame/support", textures[0], facing, particle);
                    if (torch != null && torch != EnumTorchType.NONE && layer == class_1921.method_23577()) {
                        ModelPlatform.add(list, "frame/brazier_base", Parts.getBrazierTexture(), facing, particle);
                        ModelPlatform.add(list, "frame/brazier_fill", Parts.getBrazierFillTexture(torch), facing, particle);
                    }
                    if (coveringData == null || !((EnumCovering)((Object)coveringData.getLeft())).renderOnRails()) break;
                    ModelPlatform.addCoverings(list, "frame", "", facing, (Pair<EnumCovering, String>)coveringData);
                    break;
                }
                case RAMP: 
                case STAIRS: 
                case STEPS: {
                    ModelPlatform.addParts_Ramps(list, platformType, subType, textures, particle, facing, railType, support, coveringData);
                    break;
                }
                case SHINGLES: 
                case TILES: {
                    boolean skylight;
                    boolean bl = skylight = class_4696.method_23679((class_2680)UseContext.getBlockPlacementStateFor((class_1799)itemBaseCover)) == class_1921.method_23583();
                    if (subType.getStyleType() == EnumSubType.EnumStyle.EDGE) {
                        boolean diwhy = class_4696.method_23679((class_2680)UseContext.getBlockPlacementStateFor((class_1799)itemBaseFrame)) != class_1921.method_23577();
                        ModelPlatform.addParts_RoofCaps(list, platformType, edgeType, textures, particle, facing, railType, skylight, diwhy, (Pair<EnumCovering, String>)coveringData);
                        break;
                    }
                    ModelPlatform.addParts_Roofs(list, platformType, subType, edgeType, textures, particle, facing, railType, support, skylight, coveringData);
                    break;
                }
                case RISE: {
                    ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, false, linkedToFloor, coveringData);
                    break;
                }
                case RAIL: {
                    ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, true, linkedToFloor, coveringData);
                }
            }
            return list;
        }
    }

    private static class Baked
    extends CompositeBakedModel {
        private static final class_1087 INSTANCE = new Baked();
        private class_1058 particle;

        private Baked() {
        }

        public class_1058 method_4711() {
            if (this.particle == null) {
                this.particle = CacheBuilder.INSTANCE.getTextureSprite(new class_1799((class_1935)class_2246.field_10033));
            }
            return this.particle;
        }

        protected List<class_1087> handleBlockState(class_2680 state, class_1921 layer, class_5819 random, Object modelData) {
            Object overrideData;
            if (layer == null) {
                return Collections.emptyList();
            }
            Object object = overrideData = state instanceof SPC_ExtraRenderData ? ((SPC_ExtraRenderData)state).getRenderData() : null;
            if (modelData == null || overrideData instanceof class_2487) {
                if (layer != class_1921.method_23583()) {
                    return Collections.emptyList();
                }
                return CacheBuilder.INSTANCE.getOrBuildModelList(state, overrideData, null, () -> BlockHandler.INSTANCE.getList(state, null, overrideData));
            }
            return CacheBuilder.INSTANCE.getOrBuildModelList(state, modelData, layer, () -> BlockHandler.INSTANCE.getList(state, layer, modelData));
        }

        protected class_1087 handleItemState(class_1087 model, class_1799 stack, class_1937 world, class_1309 entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }
}

