/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.common.network.PacketPlatformSelect;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

@Environment(value=EnvType.CLIENT)
public class GuiPlatformSelect
extends class_437 {
    private final String TEXT_BACK = class_1074.method_4662((String)"gui.platforms.wrench.select.back", (Object[])new Object[0]);
    private final String TEXT_NEXT = class_1074.method_4662((String)"gui.platforms.wrench.select.next", (Object[])new Object[0]);
    private final String TEXT_FIRST = class_1074.method_4662((String)"gui.platforms.wrench.select.first", (Object[])new Object[0]);
    private final String TEXT_SAVE = class_1074.method_4662((String)"gui.platforms.wrench.select.save", (Object[])new Object[0]);
    private final class_1657 player;
    private final class_1937 world;
    private final class_2338 pos;
    private EntityGuiItem displayItem = null;
    private final List<class_1799> types;
    private int start;
    private int index;
    private final int listSize;
    private final int xSize = 182;
    private final int ySize = 110;
    private int guiLeft;
    private int guiTop;
    private final long debounce = System.currentTimeMillis();

    public GuiPlatformSelect(class_1657 player, class_1937 world, class_2338 pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        super((class_2561)class_2561.method_43473());
        this.player = player;
        this.world = world;
        this.pos = pos;
        Collection<EnumSubType> subTypes = null;
        class_2248 block = tile.method_11010().method_26204();
        EnumSubType subType = null;
        if (block instanceof BlockPlatformBase) {
            subTypes = ((BlockPlatformBase)block).getAllowedValues();
            subType = BlockPlatformBase.getPlatformSubType(tile.method_11010());
        }
        if (subTypes == null) {
            throw new Error("Unexpected Platform");
        }
        this.start = 0;
        int index = 0;
        for (EnumSubType type : subTypes) {
            if (type == subType) {
                this.start = index;
                break;
            }
            ++index;
        }
        this.index = this.start;
        class_1799 basePlatform = ItemBlockPlatform.createStack(platformType, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        this.types = new ArrayList<class_1799>();
        for (EnumSubType type : subTypes) {
            class_1799 stack = basePlatform.method_7972();
            ItemBlockPlatform.setSubType(stack, type);
            this.types.add(stack);
        }
        this.listSize = this.types.size();
        this.updateDisplayItem();
    }

    public void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - this.xSize) / 2;
        this.guiTop = (this.field_22790 - this.ySize) / 2;
    }

    private void updateDisplayItem() {
        this.displayItem = new EntityGuiItem(this.world, 0.0, 0.0, 0.0, this.types.get(this.index));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int count;
        this.method_25420(graphics);
        GuiHelper.drawTexture((class_332)graphics, (double)this.guiLeft, (double)this.guiTop, (int)0, (int)0, (int)182, (int)110, (class_2960)Textures.WRENCH_SELECT.get());
        int centerX = this.guiLeft + this.xSize / 2;
        int centerY = this.guiTop + this.ySize / 2;
        graphics.method_25300(this.field_22793, this.index + 1 + " / " + this.listSize, centerX, centerY + 5, -30720);
        graphics.method_25300(this.field_22793, this.TEXT_BACK, centerX, centerY + 14, -7631989);
        graphics.method_25300(this.field_22793, this.TEXT_NEXT, centerX, centerY + 22, -7631989);
        graphics.method_25300(this.field_22793, this.TEXT_FIRST, centerX, centerY + 30, -7631989);
        graphics.method_25300(this.field_22793, this.TEXT_SAVE, centerX, centerY + 38, -7631989);
        if (this.displayItem != null) {
            this.displayItem.render(graphics, true, 130.0f, 0.0f, 0.0f, (float)(this.guiLeft + 91), (float)(this.guiTop + 52), 50.0f, -90.0f, 90.0f, 90.0f);
        }
        if ((count = this.types.size()) > 1) {
            graphics.method_51427(this.types.get(this.getOffsetIndex(-1)), this.guiLeft + 52, this.guiTop + 34);
            graphics.method_51427(this.types.get(this.getOffsetIndex(1)), this.guiLeft + 114, this.guiTop + 34);
        }
        if (count > 4) {
            graphics.method_51427(this.types.get(this.getOffsetIndex(-2)), this.guiLeft + 34, this.guiTop + 34);
            graphics.method_51427(this.types.get(this.getOffsetIndex(2)), this.guiLeft + 132, this.guiTop + 34);
        }
        if (count > 6) {
            graphics.method_51427(this.types.get(this.getOffsetIndex(-3)), this.guiLeft + 16, this.guiTop + 34);
            graphics.method_51427(this.types.get(this.getOffsetIndex(3)), this.guiLeft + 150, this.guiTop + 34);
        }
    }

    private int getOffsetIndex(int offset) {
        int value = this.index + offset;
        int max = this.listSize - 1;
        return value < 0 ? max : (value > max ? 0 : value);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.index = this.getOffsetIndex(1);
            this.updateDisplayItem();
        } else if (scroll > 0.0) {
            this.index = this.getOffsetIndex(-1);
            this.updateDisplayItem();
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && System.currentTimeMillis() > this.debounce + 25L) {
            this.setPlatform();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                this.setPlatform();
                return true;
            }
            case 263: 
            case 264: {
                this.index = this.getOffsetIndex(-1);
                this.updateDisplayItem();
                return true;
            }
            case 262: 
            case 265: {
                this.index = this.getOffsetIndex(1);
                this.updateDisplayItem();
                return true;
            }
            case 32: {
                this.index = this.start;
                this.updateDisplayItem();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void setPlatform() {
        if (this.index != this.start) {
            NetworkHandler.sendToServer(new PacketPlatformSelect(ItemBlockPlatform.getSubType(this.types.get(this.index)).ordinal(), this.pos));
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = this.player.method_5998(hand);
            if (!ToolHelper.isWrench((class_1799)stack)) continue;
            this.player.method_6104(hand);
            break;
        }
        this.field_22787.field_1724.method_3137();
    }

    public boolean method_25421() {
        return false;
    }
}

