/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.network.NetworkHandler;

@Config(name="platforms")
public class Configuration
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public ClientFile CLIENT = new ClientFile();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public CommonFile COMMON = new CommonFile();

    public static void sync() {
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> class_310.method_1551().execute(() -> {
            try {
                NetworkHandler.sendToServer((PacketBase)PacketPlayerConfig.sync((class_2960)Values.CONFIGKEY_SELECT, (int)Platforms.CONFIG.CLIENT.selection_mode.ordinal()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    @Config(name="client")
    public static class ClientFile
    implements ConfigData {
        @Comment(value="Changes what sneak right-clicking on a platform with a wrench will do \r\nGUI: opens the platform selector GUI \r\nCYCLE: cycles through the options \r\nMIXED: uses the GUI if the is more then 5 options")
        public PlatformSelect selection_mode = PlatformSelect.MIXED;
        @Comment(value="Select A GUI Style")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_GUI GUI_STYLE = new Menu_GUI();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static enum PlatformSelect {
            GUI,
            CYCLE,
            MIXED;

        }

        public static class Menu_GUI {
            @Comment(value="Platform Builder \r\n#Allowed Values: DEFAULT, VANILLA")
            public STYLE platformer = STYLE.DEFAULT;
            @Comment(value="Platform Select Menu \r\n#Allowed Values: DEFAULT, VANILLA")
            public STYLE platform_select = STYLE.DEFAULT;

            public static enum STYLE {
                DEFAULT,
                VANILLA;

            }
        }
    }

    @Config(name="common")
    public static class CommonFile
    implements ConfigData {
        @Comment(value="Sets Frame climbing behaviour \r\nNONE: Can not be climbed \r\nLADDER: Ascend via walking. Descends automatically. Sneak holds position. \r\nSCAFFOLD: Ascend via jumping. Descend via sneaking. Automatically holds position. \r\nHYBRID: Ascend via walking. Descend via sneaking. Automatically holds position.")
        public ClimbMode frame_climb_mode = ClimbMode.HYBRID;
        @Comment(value="Craft Output Control")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Crafting CRAFTING = new Menu_Crafting();
        @Comment(value="Platform Dust Covering Options")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_DustCovering COVERING = new Menu_DustCovering();

        public static enum ClimbMode {
            NONE,
            LADDER,
            SCAFFOLD,
            HYBRID;


            public boolean sneakDescend() {
                return this == SCAFFOLD || this == HYBRID;
            }
        }

        public static class Menu_Crafting {
            @Comment(value="Multiplies the craft amount by the given value if a 'compressed' block is used (2x value if two are used) \r\nSee 'data/c/tags/items/storage_blocks.json' to know what qualifies \r\nNote: Final value will be capped at a full stack")
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int blockMultiplier = 4;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int flat = 4;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int floor = 2;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int frame = 2;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int inclines = 2;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int roofs = 2;
            @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
            public int railings = 4;
        }

        public static class Menu_DustCovering {
            @Comment(value="Enables the manual placement of sand, snow, and gravel via sneak place \r\nOther blocks are supported as long as the extend FallingBlock and use Material.SAND")
            public boolean canManuallyAdd = true;
            @Comment(value="When enabled the amount of snow/sand built up on platforms will change with the weather")
            public boolean isEnvironmentReactive = true;
            @Comment(value="When enabled walking on platforms will disturb the collected snow/sand \r\nRegardless of setting you can still remove layers by right clicking with a shovel")
            public boolean isEntityReactive = true;
            @Comment(value="1 in x chance sand will passively accumulate \r\nDisabled when set to zero, or when 'isEnvironmentReactive' is disabled")
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int chanceSand = 4;
            @Comment(value="1 in x chance sand will accumulate during a storm \r\nDisabled when set to zero, or when 'isEnvironmentReactive' is disabled")
            @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
            public int chanceSandStorm = 3;
            @Comment(value="1 in x chance snow will accumulate while snowing \r\nDisabled when set to zero, or when 'isEnvironmentReactive' is disabled")
            @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
            public int chanceSnow = 3;
            @Comment(value="1 in x chance rain will wash away dust layers \r\nDisabled when set to zero, or when 'isEnvironmentReactive' is disabled")
            @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
            public int chanceRainWash = 3;
        }
    }
}

