/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.philter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.simplx.mcgui.Horizontal;
import net.simplx.mcgui.Layout;
import net.simplx.mcgui.RadioButtonWidget;
import net.simplx.mcgui.RadioButtons;
import net.simplx.mcgui.Vertical;
import net.simplx.philter.FilterDesc;
import net.simplx.philter.FilterMode;
import net.simplx.philter.FilterScreenHandler;
import net.simplx.philter.PhilterMod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FilterScreen
extends class_465<FilterScreenHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterScreen.class);
    private static final class_2960 TEXTURE = new class_2960("philter", "textures/gui/container/filter.png");
    public static final int TEXTURE_WIDTH = 512;
    public static final int TEXTURE_HEIGHT = 256;
    private static final class_2960 FILTER_DOWN_FACING_TOP = new class_2960("philter", "textures/block/filter_down_facing_top.png");
    private static final class_2960 FILTER_DOWN_FILTER_TOP = new class_2960("philter", "textures/block/filter_down_filter_top_on.png");
    private static final class_2960 FILTER_SIDE_FACING_TOP = new class_2960("philter", "textures/block/filter_side_facing_top.png");
    private static final class_2960 FILTER_SIDE_FILTER_TOP = new class_2960("philter", "textures/block/filter_side_filter_top_on.png");
    public static final int TOP_SIZE = 32;
    public static final int TOP_MID = 16;
    private static final int TITLE_TEXT_COLOR = 0x404040;
    private static final int SCREEN_H = 227;
    private static final int SCREEN_W = 346;
    private static final int EXAMPLES_W = 92;
    private static final int EXAMPLES_H = 92;
    private static final int EXAMPLES_BORDER = 10;
    private static final int MODE_X = 176;
    private static final Pattern RESOURCE_PAT = Pattern.compile("!?#[-a-z0-9_./]+");
    private RadioButtons<class_2350> directionButtons;
    private final FilterDesc desc;
    private class_5250 titleText;
    private class_5676<Boolean> exactButton;
    private List<class_342> matchesFields;
    private final int hopperWidth;
    private final int hopperHeight;
    private Layout layout;
    private class_5676<Boolean> allButton;
    private class_4185 saveButton;
    private class_7940 exampleText;
    private boolean initializing;
    private Layout.Placer titlePlace;
    private Layout.Placer topP;
    private Layout.Placer examplesP;
    private Layout.Placer exampleBgP;
    private Layout.Placer dirP;

    public FilterScreen(FilterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 346;
        this.field_2779 = 227;
        this.hopperWidth = 176;
        this.hopperHeight = 133;
        this.field_25270 = this.hopperHeight - 94;
        this.desc = handler.getFilterDesc();
    }

    protected void method_25426() {
        Layout.Placer p;
        this.initializing = true;
        super.method_25426();
        this.layout = new Layout(this);
        this.layout.setPrefix("philter.filter");
        class_5250 saveText = this.layout.text("save");
        this.titleText = this.layout.text("name").method_27693(":");
        this.titlePlace = this.layout.placer().withText((class_2561)this.titleText).x(this.field_2776 + 176).y(Vertical.ABOVE);
        Function<FilterMode, class_2561> modeTextGen = mode -> this.layout.text("mode." + mode.toString().toLowerCase());
        Layout.Placer modeP = p = this.layout.placer().withTexts(Arrays.stream(FilterMode.values()).map(modeTextGen).toList()).inButton().x(Horizontal.RIGHT, this.titlePlace).y(Vertical.ABOVE);
        this.titlePlace.y(Vertical.MID, modeP);
        class_5676 modeButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(modeTextGen).method_32624((Object[])FilterMode.values()).method_32616().method_32619((Object)this.desc.mode).method_32618(value -> this.layout.tooltip("mode." + value.toString().toLowerCase() + ".tooltip")).method_32617(p.x(), p.y(), p.w(), p.h(), null, (button, m) -> this.setMode((FilterMode)((Object)m))));
        class_5250 allText = this.layout.text("all");
        class_5250 anyText = this.layout.text("any");
        p = this.layout.placer().withTexts((class_2561)anyText, new class_2561[]{allText}).inButton().x(Horizontal.RIGHT, modeP).y(Vertical.ABOVE);
        this.allButton = (class_5676)this.method_37063((class_364)class_5676.method_32607((class_2561)anyText, (class_2561)allText).method_32619((Object)true).method_32616().method_32618(value -> this.layout.tooltip((value != false ? "all" : "any") + ".tooltip")).method_32617(p.x(), p.y(), p.w(), p.h(), null, (button, all) -> this.setAll((Boolean)all)));
        class_5250 exactText = this.layout.text("exact");
        Layout.Placer exactP = p = this.layout.placer().w(this.layout.onOffButtonW((class_2561)exactText)).h(this.layout.textH).inButton().x(this.titlePlace.x()).y(Vertical.BELOW, this.layout.placer((class_339)modeButton));
        this.exactButton = (class_5676)this.method_37063((class_364)class_5676.method_32613((boolean)this.desc.exact).method_32618(value -> this.layout.tooltip("exact." + value + ".tooltip")).method_32617(p.x(), p.y(), p.w(), p.h(), (class_2561)exactText, (button, exact) -> this.setExact((boolean)exact)));
        p = this.layout.placer().withText((class_2561)saveText).inButton().x(Horizontal.RIGHT).y(Vertical.MID, this.layout.placer((class_339)this.exactButton));
        this.saveButton = (class_4185)this.method_37063((class_364)new class_4185.class_7840((class_2561)saveText, this::save).method_46434(p.x(), p.y(), p.w(), p.h()).method_46436(this.layout.tooltip("save.tooltip")).method_46431());
        Layout.Placer changing = this.layout.placer().from(Horizontal.LEFT, this.titlePlace).to(Horizontal.RIGHT).from(Vertical.BELOW, exactP).to(Vertical.BELOW);
        Layout.Placer first = changing.clone().h(this.layout.textH + 3).w(changing.w() / 2);
        Layout.Placer bottom = first.y(Vertical.BELOW);
        this.matchesFields = new ArrayList<class_342>();
        boolean foundFocus = false;
        class_342 field = null;
        int i = 0;
        while (true) {
            int col = i % 2;
            int row = i / 2;
            p = first.clone().x(changing.x() + col * first.w()).y(changing.y() + row * (first.h() + 2));
            if (p.y() > bottom.y()) break;
            field = (class_342)this.method_37063((class_364)new class_342(this.field_22793, p.x(), p.y(), p.w(), p.h(), (class_2561)class_2561.method_43473()));
            this.matchesFields.add(field);
            int index = i;
            field.method_1863(text -> this.matchChanged(index, (String)text));
            String match = this.desc.match(i);
            field.method_1852(match);
            if (!foundFocus && match.isEmpty()) {
                foundFocus = true;
                this.method_48265((class_364)field);
            }
            field.field_22764 = false;
            ++i;
        }
        if (!foundFocus) {
            this.method_48265((class_364)field);
        }
        this.setMatchesVisible(false);
        Layout.Placer hopperP = this.layout.placer().from(Horizontal.LEFT).to(this.field_2776 + this.hopperWidth).from(Vertical.ABOVE).to(this.hopperHeight - this.layout.borderH);
        Layout.Placer mid = this.layout.placer().w(hopperP.w()).from(Vertical.BELOW, hopperP).to(Vertical.BELOW).x(hopperP.x()).y(Vertical.BELOW, hopperP);
        this.topP = this.layout.placer().size(32, 32).x(Horizontal.CENTER, mid).y(Vertical.BOTTOM);
        this.topP.y(this.topP.y() - this.layout.placer().inCheckbox().h() - this.layout.gapH);
        this.examplesP = this.layout.placer().size(92, 92).x(Horizontal.CENTER, changing).y(Vertical.TOP_EDGE, changing);
        this.examplesP.y(this.examplesP.y() - 12);
        int examplesX = this.examplesP.x() - this.field_2776 + 10 + 1;
        int examplesY = this.examplesP.y() - this.field_2800 + 10 + 1;
        if (examplesX != 223 || examplesY != 51) {
            LOGGER.warn(String.format("Filter misalignment: expected at (%d, %d), not (%d, %d)", 223, 51, examplesX, examplesY));
        }
        p = this.layout.placer().w(changing.w() * 3 / 4).x(Horizontal.CENTER, this.examplesP).y(Vertical.BELOW, this.examplesP);
        int width1 = changing.w() * 3 / 4;
        class_7940 exampleText = new class_7940((class_2561)this.layout.text("examples"), this.field_22793);
        exampleText.method_48984(width1);
        exampleText.method_48981(true);
        this.exampleText = (class_7940)this.method_37063((class_364)p.place(exampleText));
        int bgBorder = 3;
        this.exampleBgP = this.layout.placer().size(this.exampleText.method_25368() + 2 * bgBorder, this.exampleText.method_25364() + 2 * bgBorder).at(this.exampleText.method_46426() - bgBorder, this.exampleText.method_46427() - bgBorder);
        class_2350 dir = ((FilterScreenHandler)this.field_2797).userFacingDir;
        this.directionButtons = new RadioButtons();
        this.dirP = this.layout.placer().withText("filter_dir").x(Horizontal.LEFT);
        for (int i2 = 0; i2 < 4; ++i2) {
            class_2350 toDir = dir == ((FilterScreenHandler)this.field_2797).facing ? class_2350.field_11033 : dir;
            Layout.Placer q = this.layout.placer().inCheckbox();
            switch (i2) {
                case 1: {
                    q.x(Horizontal.RIGHT, this.topP).y(Vertical.MID, this.topP);
                    break;
                }
                case 2: {
                    q.x(Horizontal.CENTER, this.topP).y(Vertical.BELOW, this.topP);
                    break;
                }
                case 3: {
                    q.x(Horizontal.LEFT, this.topP).y(Vertical.MID, this.topP);
                    break;
                }
                case 0: {
                    q.x(Horizontal.CENTER, this.topP).y(Vertical.ABOVE, this.topP);
                }
            }
            this.directionButtons.add((RadioButtonWidget)this.method_37063((class_364)new RadioButtonWidget<class_2350>(toDir, q.x(), q.y(), q.w(), q.h(), null)));
            dir = dir.method_35833(class_2350.class_2351.field_11052);
            if (i2 != 0) continue;
            this.dirP.y(q.y() + this.layout.gapH);
        }
        this.directionButtons.setUpdateCallback(this::setFilterDir);
        this.directionButtons.findButton(((FilterScreenHandler)this.field_2797).filter).setChecked(true);
        this.initializing = false;
        this.adjustToMode();
    }

    private Void setFilterDir(RadioButtons<class_2350> unused, class_2350 dir) {
        ((FilterScreenHandler)this.field_2797).filter = dir;
        return null;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        super.method_2388(context, mouseX, mouseY);
        this.layout.drawText(context, this.field_22793, this.titlePlace, (class_2561)this.titleText, 0x404040);
    }

    private void matchChanged(int i, String text) {
        String spec = text.trim();
        class_342 field = this.matchesFields.get(i);
        if (!spec.equals(text)) {
            field.method_1852(spec);
            return;
        }
        field.method_1868(0xFFFFFF);
        field.method_47400(null);
        if (!spec.isEmpty() && !RESOURCE_PAT.matcher(spec).matches()) {
            try {
                Pattern.compile(spec, 2);
            }
            catch (PatternSyntaxException e) {
                field.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)e.getMessage())));
                field.method_1868(0xFF0000);
            }
        }
        this.adjustToMode();
    }

    private void setMode(FilterMode mode) {
        this.desc.mode = mode;
        this.adjustToMode();
    }

    private void setExact(boolean exact) {
        this.desc.exact = exact;
        this.sendFilterDesc();
    }

    private void setAll(Boolean all) {
        this.desc.matchAll = all;
        this.sendFilterDesc();
    }

    private void adjustToMode() {
        if (this.initializing) {
            return;
        }
        this.exactButton.field_22764 = this.desc.mode != FilterMode.NONE;
        this.allButton.field_22764 = this.desc.mode == FilterMode.MATCHES;
        this.saveButton.field_22764 = this.allButton.field_22764 && this.anyMatchChanged();
        this.exampleText.field_22764 = this.desc.mode == FilterMode.SAME_AS;
        Arrays.stream(((FilterScreenHandler)this.field_2797).filterSlots).forEach(slot -> slot.setEnabled(this.desc.mode == FilterMode.SAME_AS));
        boolean wasVisible = this.matchesFields.get((int)0).field_22764;
        boolean newVisible = this.desc.mode == FilterMode.MATCHES;
        this.setMatchesVisible(newVisible);
        if (!wasVisible && newVisible) {
            this.method_48265((class_364)this.matchesFields.get(0));
        } else if (wasVisible && !newVisible && this.matchesFields.stream().anyMatch(class_339::method_25370)) {
            class_342 lastField = this.matchesFields.get(this.matchesFields.size() - 1);
            this.method_48265((class_364)lastField);
            lastField.method_25365(true);
        }
        this.sendFilterDesc();
    }

    private boolean anyMatchChanged() {
        if (this.matchesFields == null) {
            return false;
        }
        for (int i = 0; i < this.matchesFields.size(); ++i) {
            String orig = this.desc.match(i);
            if (this.matchesFields.get(i).method_1882().equals(orig)) continue;
            return true;
        }
        return false;
    }

    private void setMatchesVisible(boolean newVisible) {
        this.matchesFields.forEach(field -> {
            field.field_22764 = newVisible;
        });
    }

    private void storeText() {
        this.desc.matches = (ImmutableList)this.matchesFields.stream().map(class_342::method_1882).filter(text -> !text.isBlank()).collect(ImmutableList.toImmutableList());
    }

    private void save(class_4185 unused) {
        this.storeText();
        this.sendFilterDesc();
        this.adjustToMode();
    }

    private void sendFilterDesc() {
        try {
            ClientPlayNetworking.send((class_2960)PhilterMod.FILTER_ID, (class_2540)this.desc.packetBuf(((FilterScreenHandler)this.field_2797).getPos(), ((FilterScreenHandler)this.field_2797).facing, ((FilterScreenHandler)this.field_2797).filter));
        }
        catch (NullPointerException e) {
            LOGGER.error("Unexpected null", (Throwable)e);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    public void method_25419() {
        if (this.anyMatchChanged()) {
            this.storeText();
        }
        this.sendFilterDesc();
        super.method_25419();
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int midX = (this.field_22789 - this.field_2792) / 2;
        int midY = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(TEXTURE, midX, midY, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
        if (this.desc.mode == FilterMode.SAME_AS) {
            Layout.Placer p = this.examplesP;
            context.method_25290(TEXTURE, p.x(), p.y(), 346.0f, 0.0f, p.w(), p.h(), 512, 256);
            p = this.exampleBgP;
            context.method_25294(p.x(), p.y(), p.endX(), p.endY(), -12566464);
        }
        context.method_51439(this.field_22793, (class_2561)this.layout.text("filter_dir"), this.dirP.x(), this.dirP.y(), 0x404040, false);
        this.drawTop(context, ((FilterScreenHandler)this.field_2797).facing, FILTER_DOWN_FACING_TOP, FILTER_SIDE_FACING_TOP);
        RadioButtonWidget<class_2350> button = this.directionButtons.getOn();
        this.drawTop(context, button.getValue(), FILTER_DOWN_FILTER_TOP, FILTER_SIDE_FILTER_TOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawTop(class_332 context, class_2350 dir, class_2960 down, class_2960 side) {
        class_4587 matrices = context.method_51448();
        try {
            matrices.method_22903();
            matrices.method_46416((float)(this.topP.x() + 16), (float)(this.topP.y() + 16), 0.0f);
            class_2960 texture = down;
            if (dir != class_2350.field_11033) {
                int rot = (dir.method_10161() - ((FilterScreenHandler)this.field_2797).userFacingDir.method_10161()) * 90;
                matrices.method_22907(class_7833.field_40718.rotationDegrees((float)rot));
                texture = side;
            }
            matrices.method_46416(-16.0f, -16.0f, 0.0f);
            context.method_25290(texture, 0, 0, 0.0f, 0.0f, this.topP.w(), this.topP.h(), this.topP.w(), this.topP.h());
        }
        finally {
            matrices.method_22909();
        }
    }

    private void drawBox(class_332 context, Layout.Placer p, int color) {
        if (p != null) {
            this.drawBox(context, p.x(), p.y(), p.w(), p.h(), color);
        }
    }

    private void drawBox(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25292(x, x + width, y, color);
        context.method_25292(x, x + width, y + height, color);
        context.method_25301(x, y, y + height, color);
        context.method_25301(x + width, y, y + height, color);
    }
}

