/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.philter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5626;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class FilterMatches {
    public final ImmutableList<String> input;
    public final ImmutableList<class_2960> tagsYes;
    public final ImmutableList<class_2960> tagsNo;
    public final ImmutableList<Pattern> patternsYes;
    public final ImmutableList<Pattern> patternsNo;

    public FilterMatches(ImmutableList<String> input) {
        this.input = input;
        ImmutableList.Builder tagsYes = ImmutableList.builder();
        ImmutableList.Builder tagsNo = ImmutableList.builder();
        ImmutableList.Builder patternsYes = ImmutableList.builder();
        ImmutableList.Builder patternsNo = ImmutableList.builder();
        for (String spec : input) {
            boolean yes;
            boolean bl = yes = spec.charAt(0) != '!';
            if (!yes) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("#")) {
                class_2960 id = class_2960.method_12829((String)(spec = spec.substring(1)));
                if (id == null) continue;
                (yes ? tagsYes : tagsNo).add((Object)id);
                continue;
            }
            (yes ? patternsYes : patternsNo).add((Object)Pattern.compile(spec, 2));
        }
        this.tagsYes = tagsYes.build();
        this.tagsNo = tagsNo.build();
        this.patternsYes = patternsYes.build();
        this.patternsNo = patternsNo.build();
    }

    public boolean matchAny(class_1799 item, boolean exact, boolean matchAll) {
        return this.checkTags((List<class_2960>)this.tagsYes, true, item, matchAll) || this.checkTags((List<class_2960>)this.tagsNo, false, item, matchAll) || this.checkPatterns((List<Pattern>)this.patternsYes, true, item, exact, matchAll) || this.checkPatterns((List<Pattern>)this.patternsNo, false, item, exact, matchAll);
    }

    public boolean matchAll(class_1799 item, boolean exact, boolean matchAll) {
        return this.checkTags((List<class_2960>)this.tagsYes, true, item, matchAll) && this.checkTags((List<class_2960>)this.tagsNo, false, item, matchAll) && this.checkPatterns((List<Pattern>)this.patternsYes, true, item, exact, matchAll) && this.checkPatterns((List<Pattern>)this.patternsNo, false, item, exact, matchAll);
    }

    private boolean checkTags(List<class_2960> tags, boolean yes, class_1799 item, boolean matchAll) {
        for (class_2960 tag : tags) {
            class_6862 t = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag);
            boolean isIn = item.method_31573(t);
            if (!matchAll && isIn == yes) {
                return true;
            }
            if (!matchAll || isIn == yes) continue;
            return false;
        }
        return matchAll;
    }

    private boolean checkPatterns(List<Pattern> patterns, boolean yes, class_1799 item, boolean exact, boolean matchAll) {
        for (Pattern pattern : patterns) {
            boolean isIn;
            class_1792 it = item.method_7909();
            Optional key = it.method_40131().method_40230();
            if (key.isEmpty()) continue;
            class_2960 id = ((class_5321)key.get()).method_29177();
            String nbtStr = "";
            if (exact) {
                class_2487 nbt = item.method_7969();
                nbtStr = nbt == null ? "{}" : new class_5626().method_32288((class_2520)nbt);
            }
            boolean bl = isIn = pattern.matcher(id.toString() + nbtStr).find() == yes || id.method_12836().equals("minecraft") && pattern.matcher(id.method_12832() + nbtStr).matches() == yes;
            if (!matchAll && isIn == yes) {
                return true;
            }
            if (!matchAll || isIn == yes) continue;
            return false;
        }
        return matchAll;
    }
}

