/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.philter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.simplx.philter.FilterMode;

public class FilterDesc {
    private static final String MATCHES = "Matches";
    private static final String MODE = "Mode";
    private static final String EXACT = "Exact";
    private static final String MATCH_ALL = "MatchAll";
    public FilterMode mode;
    public ImmutableList<String> matches;
    public boolean exact;
    public boolean matchAll;

    public FilterDesc(FilterMode mode, List<String> matches, boolean exact) {
        this.mode = mode;
        this.matches = ImmutableList.copyOf(matches);
        this.exact = exact;
    }

    public FilterDesc(class_2540 buf) {
        this(Objects.requireNonNull(buf.method_10798()));
    }

    public FilterDesc(class_2487 nbt) {
        try {
            this.mode = FilterMode.SAME_AS;
            if (nbt.method_10573(MODE, 8)) {
                this.mode = FilterMode.valueOf(nbt.method_10558(MODE));
            }
            if (!nbt.method_10573(MATCHES, 9)) {
                this.matches = ImmutableList.of();
            } else {
                class_2499 nbtList = nbt.method_10554(MATCHES, 8);
                ImmutableList.Builder matches = ImmutableList.builder();
                for (int i = 0; i < nbtList.size(); ++i) {
                    matches.add((Object)nbtList.method_10608(i));
                }
                this.matches = matches.build();
            }
            this.matchAll = nbt.method_10573(MATCH_ALL, 1) ? nbt.method_10577(EXACT) : false;
            this.exact = nbt.method_10573(EXACT, 1) ? nbt.method_10577(EXACT) : false;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.mode = FilterMode.SAME_AS;
            this.matches = ImmutableList.of();
            this.exact = true;
        }
    }

    public class_2540 packetBuf(class_2338 pos, class_2350 facing, class_2350 filter) {
        class_2540 buf = PacketByteBufs.create();
        this.write(buf, pos, facing, filter);
        return buf;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10582(MODE, this.mode.toString());
        if (this.matches.size() > 0) {
            class_2499 nbtList = new class_2499();
            for (int i = 0; i < this.matches.size(); ++i) {
                nbtList.add((Object)class_2519.method_23256((String)((String)this.matches.get(i))));
            }
            nbt.method_10566(MATCHES, (class_2520)nbtList);
            if (this.matchAll) {
                nbt.method_10556(MATCH_ALL, true);
            }
        }
        nbt.method_10556(EXACT, this.exact);
    }

    public String match(int index) {
        return index >= this.matches.size() ? "" : (String)this.matches.get(index);
    }

    public void write(class_2540 buf, class_2338 pos, class_2350 facing, class_2350 filter) {
        class_2487 nbt = new class_2487();
        this.writeNbt(nbt);
        buf.method_10794(nbt);
        buf.method_10807(pos);
        buf.method_10817((Enum)facing);
        buf.method_10817((Enum)filter);
    }
}

