/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.philter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.simplx.philter.FilterBlock;
import net.simplx.philter.FilterDesc;
import net.simplx.philter.FilterMatches;
import net.simplx.philter.FilterMode;
import net.simplx.philter.FilterScreenHandler;
import net.simplx.philter.PhilterMod;
import org.jetbrains.annotations.Nullable;

public class FilterBlockEntity
extends class_2614
implements class_1278,
ExtendedScreenHandlerFactory {
    static final int EXAMPLES_COUNT = 16;
    static final int EXAMPLES_START = 5;
    static final int EXAMPLES_END = 21;
    private static final int[] INVENTORY_INDEXES = new int[]{0, 1, 2, 3, 4};
    private FilterDesc desc;
    private FilterMatches filterMatches;
    private int flicker;
    private class_2350 userFacingDir;

    protected FilterBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state);
        this.method_11281(class_2371.method_10213((int)21, (Object)class_1799.field_8037));
        this.field_11864 = PhilterMod.FILTER_BLOCK_ENTITY;
        this.desc = new FilterDesc(FilterMode.SAME_AS, (List<String>)ImmutableList.of(), false);
        this.filterMatches = new FilterMatches((ImmutableList<String>)ImmutableList.of());
        this.flicker = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntity(class_1657 player, class_2540 buf) {
        FilterDesc filterDesc = new FilterDesc(buf);
        class_2338 pos = buf.method_10811();
        class_2586 rawEntity = player.method_37908().method_8321(pos);
        if (rawEntity instanceof FilterBlockEntity) {
            try {
                ((FilterBlockEntity)rawEntity).setFilterDesc(filterDesc);
                buf.method_10818(class_2350.class);
                class_2350 newFilterDir = (class_2350)buf.method_10818(class_2350.class);
                if (rawEntity.method_11010().method_11654((class_2769)FilterBlock.FILTER) != newFilterDir) {
                    player.method_37908().method_8501(pos, (class_2680)rawEntity.method_11010().method_11657((class_2769)FilterBlock.FILTER, (Comparable)newFilterDir));
                }
                rawEntity.method_5431();
            }
            finally {
                buf.release();
            }
        }
    }

    public boolean method_5442() {
        this.method_11289(null);
        return this.method_11282().subList(0, 5).stream().allMatch(class_1799::method_7960);
    }

    public boolean method_11256() {
        class_2371 invStackList = this.method_11282();
        for (int i = 0; i < 5; ++i) {
            class_1799 itemStack = (class_1799)invStackList.get(i);
            if (!itemStack.method_7960() && itemStack.method_7947() == itemStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.desc = new FilterDesc(nbt);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.desc.writeNbt(nbt);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"philter.filter.name");
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, FilterBlockEntity blockEntity) {
        blockEntity.doServerTick(world, pos, state);
    }

    private void doServerTick(class_1937 world, class_2338 pos, class_2680 state) {
        --this.field_12023;
        this.field_12022 = world.method_8510();
        if (!this.method_11239()) {
            this.method_11238(0);
            this.insertAndExtract(world, pos, state);
        }
        if (this.flicker > 0) {
            int curState;
            --this.flicker;
            int newState = this.flicker > 0 ? 1 : 0;
            if (newState != (curState = ((Integer)state.method_11654((class_2769)FilterBlock.FILTERED)).intValue())) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)FilterBlock.FILTERED, (Comparable)Integer.valueOf(newState)), 2);
            }
        }
    }

    private void insertAndExtract(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        if (this.method_11239() || !((Boolean)state.method_11654((class_2769)class_2377.field_11126)).booleanValue() || this.method_5442()) {
            return;
        }
        class_1263 facingOut = FilterBlockEntity.method_11250((class_1937)world, (class_2338)pos.method_10093((class_2350)state.method_11654((class_2769)FilterBlock.FACING)));
        class_2350 facingSide = ((class_2350)state.method_11654((class_2769)FilterBlock.FACING)).method_10153();
        class_1263 filterOut = FilterBlockEntity.method_11250((class_1937)world, (class_2338)pos.method_10093((class_2350)state.method_11654((class_2769)FilterBlock.FILTER)));
        class_2350 filterSide = ((class_2350)state.method_11654((class_2769)FilterBlock.FILTER)).method_10153();
        if (facingOut == null && filterOut == null) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < 5; ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            class_1799 toTransfer = stack.method_7972().method_7971(1);
            if (filterOut != null && this.inFilter(stack, filterOut) && (changed = this.tryTransfer(filterOut, filterSide, stack, toTransfer))) {
                this.flicker = 8;
            }
            if (!changed && facingOut != null) {
                changed = this.tryTransfer(facingOut, facingSide, stack, toTransfer);
            }
            if (changed) break;
        }
        if (changed) {
            this.method_11238(8);
            class_2614.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private boolean tryTransfer(class_1263 out, class_2350 filterSide, class_1799 stack, class_1799 toTransfer) {
        class_1799 after = class_2614.method_11260((class_1263)this, (class_1263)out, (class_1799)toTransfer, (class_2350)filterSide);
        if (after.method_7960()) {
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    private boolean inFilter(class_1799 hopperStack, class_1263 targetInv) {
        if (hopperStack.method_7947() == 0) {
            return false;
        }
        return switch (this.desc.mode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.NONE -> false;
            case FilterMode.SAME_AS -> this.filterSameAs(hopperStack, targetInv);
            case FilterMode.MATCHES -> this.filterMatches(hopperStack);
        };
    }

    private boolean filterSameAs(class_1799 item, class_1263 targetInv) {
        List<class_1799> examples = this.getExamples(targetInv);
        if (examples == null) {
            return false;
        }
        for (class_1799 invStack : examples) {
            if (!(this.desc.exact ? FilterBlockEntity.method_11254((class_1799)invStack, (class_1799)item) : class_1799.method_7984((class_1799)invStack, (class_1799)item))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private List<class_1799> getExamples(class_1263 targetInv) {
        class_1799 itemStack;
        int i;
        ArrayList<class_1799> examples = new ArrayList<class_1799>();
        class_2371 exampleInv = this.method_11282();
        for (i = 5; i < 21; ++i) {
            itemStack = (class_1799)exampleInv.get(i);
            if (itemStack.method_7960()) continue;
            examples.add(itemStack);
        }
        if (examples.isEmpty()) {
            if (targetInv == null) {
                return null;
            }
            for (i = 0; i < targetInv.method_5439(); ++i) {
                itemStack = targetInv.method_5438(i);
                if (itemStack.method_7960()) continue;
                examples.add(itemStack);
            }
        }
        return examples;
    }

    private boolean filterMatches(class_1799 item) {
        if (!this.filterMatches.input.equals(this.desc.matches)) {
            this.filterMatches = new FilterMatches(this.desc.matches);
        }
        return this.desc.matchAll ? this.filterMatches.matchAll(item, this.desc.exact, true) : this.filterMatches.matchAny(item, this.desc.exact, false);
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new FilterScreenHandler(syncId, playerInventory, (class_1263)this, this.desc, this.field_11867, (class_2350)this.method_11010().method_11654((class_2769)FilterBlock.FACING), (class_2350)this.method_11010().method_11654((class_2769)FilterBlock.FILTER), true);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        class_2680 state = player.method_37908().method_8320(this.field_11867);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FilterBlock.FACING);
        class_2350 filter = (class_2350)state.method_11654((class_2769)FilterBlock.FILTER);
        this.desc.write(buf, this.field_11867, facing, filter);
        buf.method_10817((Enum)this.userFacingDir);
    }

    public void setFilterDesc(FilterDesc desc) {
        this.desc = desc;
        this.method_5431();
    }

    public void setActionDir(class_2350 userFacingDir) {
        this.userFacingDir = userFacingDir;
    }

    public int[] method_5494(class_2350 side) {
        return INVENTORY_INDEXES;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public static void onEntityCollided(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity, class_2614 blockEntity) {
    }
}

