/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.mcgui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.simplx.mcgui.RadioButtonWidget;

public class RadioButtons<T> {
    private final List<RadioButtonWidget<T>> buttons;
    private RadioButtonWidget<T> on;
    private BiFunction<RadioButtons<T>, T, Void> updateCallback;

    public RadioButtons() {
        this(null);
    }

    public RadioButtons(BiFunction<RadioButtons<T>, T, Void> updateCallback) {
        this.updateCallback = updateCallback;
        this.buttons = new ArrayList<RadioButtonWidget<T>>();
    }

    public BiFunction<RadioButtons<T>, T, Void> getUpdateCallback() {
        return this.updateCallback != null ? this.updateCallback : null;
    }

    public void setUpdateCallback(BiFunction<RadioButtons<T>, T, Void> updateCallback) {
        this.updateCallback = updateCallback;
    }

    public RadioButtonWidget<T> add(RadioButtonWidget<T> button) {
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
            if (button.method_20372() || this.buttons.size() == 1) {
                this.setChecked(button);
            }
        }
        button.setButtonsInternal(this, this.buttons.size() - 1);
        return button;
    }

    public void setChecked(RadioButtonWidget<T> button) {
        for (RadioButtonWidget<T> b : this.buttons) {
            b.setCheckedInternal(b == button);
        }
        if (this.on != button) {
            this.on = button;
            if (this.updateCallback != null) {
                this.updateCallback.apply(this, (RadioButtons)button.getValue());
            }
        }
    }

    public void remove(RadioButtonWidget<T> button) {
        this.buttons.remove((Object)button);
        button.setButtonsInternal(null, -1);
        if (this.on == button) {
            this.on = null;
        }
    }

    public T getValue() {
        if (this.on == null) {
            return null;
        }
        return this.on.getValue();
    }

    public RadioButtonWidget<T> getOn() {
        return this.on;
    }

    public RadioButtonWidget<T> getButton(int index) {
        return this.buttons.get(index);
    }

    public RadioButtonWidget<T> findButton(T value) {
        for (RadioButtonWidget<T> button : this.buttons) {
            if (!button.getValue().equals(value)) continue;
            return button;
        }
        return null;
    }

    public List<RadioButtonWidget<T>> findAllButtons(T value) {
        ArrayList<RadioButtonWidget<T>> results = new ArrayList<RadioButtonWidget<T>>();
        for (RadioButtonWidget<T> button : this.buttons) {
            if (!button.getValue().equals(value)) continue;
            results.add(button);
        }
        return results;
    }
}

