/*
 * Decompiled with CFR 0.152.
 */
package net.simplx.mcgui;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_347;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import net.simplx.mcgui.Graphics;
import net.simplx.mcgui.Horizontal;
import net.simplx.mcgui.MinecraftGraphics;
import net.simplx.mcgui.Vertical;

public class Layout {
    public static final int DEFAULT_GAP = 2;
    public static final int DEFAULT_BORDER = 6;
    public static final int UNKNOWN = Integer.MIN_VALUE;
    public final int enW;
    public final int fontH;
    public final int textH;
    public final int leadingH;
    public final int borderW;
    public final int borderH;
    public final int gapW;
    public final int gapH;
    public final int slotW;
    public final int slotH;
    private final Graphics graphics;
    private final int screenX;
    private final int screenY;
    private final int screenW;
    private final int screenH;
    private final int buttonBorderW;
    private final int buttonBorderH;
    private int lockButtonW = Integer.MIN_VALUE;
    private int lockButtonH = Integer.MIN_VALUE;
    private String prefix;

    private void ensureLockButtonData() {
        if (this.lockButtonW == Integer.MIN_VALUE) {
            class_347 lb = new class_347(0, 0, null);
            this.lockButtonW = lb.method_25368();
            this.lockButtonH = lb.method_25364();
        }
    }

    public Layout(class_465<?> screen) {
        this(screen, 6, 6);
    }

    public Layout(class_465<?> screen, int gap, int border) {
        this(screen, gap, gap, border, border);
    }

    public Layout(class_465<?> screen, int gapW, int gapH, int borderW, int borderH) {
        this(new MinecraftGraphics(screen), gapW, gapH, borderW, borderH);
    }

    Layout(Graphics graphics) {
        this(graphics, 2, 2, 6, 6);
    }

    Layout(Graphics graphics, int gapW, int gapH, int borderW, int borderH) {
        this.graphics = graphics;
        this.gapW = gapW;
        this.gapH = gapH;
        this.borderW = borderW;
        this.borderH = borderH;
        this.enW = graphics.getWidth("n");
        this.fontH = graphics.getFontHeight();
        this.leadingH = Math.round((float)this.fontH * 0.2f);
        this.textH = this.fontH + this.leadingH;
        this.screenX = graphics.getScreenX();
        this.screenY = graphics.getScreenY();
        this.screenW = graphics.getScreenW();
        this.screenH = graphics.getScreenH();
        this.buttonBorderW = this.enW;
        this.buttonBorderH = Math.round((float)this.fontH * 0.3f);
        this.slotW = 18;
        this.slotH = 18;
        this.prefix = "";
    }

    public Placer placer() {
        return new Placer();
    }

    public Placer placer(class_339 widget) {
        Placer placer = new Placer();
        return placer.w(widget.method_25368()).h(widget.method_25364()).x(widget.method_46426()).y(widget.method_46427());
    }

    public void setPrefix(String prefix) {
        if (!((String)(prefix = ((String)prefix).trim())).isEmpty() && ((String)prefix).charAt(((String)prefix).length() - 1) != '.') {
            prefix = (String)prefix + ".";
        }
        this.prefix = prefix;
    }

    public int textStrW(String str) {
        return this.graphics.getWidth(str);
    }

    public int textW(String keyName) {
        return this.textW((class_2561)this.text(keyName));
    }

    public int textW(class_2561 text) {
        return this.graphics.getWidth(text);
    }

    public Collection<class_2561> texts(Iterable<String> strs) {
        return Streams.stream(strs).map(str -> this.text((String)str)).toList();
    }

    public int maxTextStrW(Iterable<String> texts) {
        return Streams.stream(texts).map(this::textStrW).max(Integer::compare).orElse(0);
    }

    public Collection<class_2561> texts(String keyName, String ... others) {
        return this.texts(Lists.asList((Object)keyName, (Object[])others));
    }

    public int maxTextW(Iterable<class_2561> texts) {
        return Streams.stream(texts).map(this::textW).max(Integer::compare).orElse(0);
    }

    public int maxTextW(class_2561 first, class_2561 ... others) {
        return this.maxTextW(Lists.asList((Object)first, (Object[])others));
    }

    public int buttonW(String text) {
        return this.buttonW((class_2561)this.text(text));
    }

    public int buttonW(class_2561 text) {
        return this.textW(text) + 2 * this.enW;
    }

    public class_5250 text(String keyName) {
        if (!this.prefix.isEmpty()) {
            keyName = this.prefix + (String)keyName;
        }
        return class_2561.method_43471((String)keyName);
    }

    public class_5250 literal(String str) {
        return class_2561.method_43470((String)str);
    }

    public class_7919 tooltip(String keyName) {
        return class_7919.method_47407((class_2561)this.text(keyName));
    }

    public int buttonW(Iterable<class_2561> texts) {
        int maxW = 0;
        for (class_2561 t : texts) {
            maxW = Math.max(this.buttonW(t), maxW);
        }
        return maxW;
    }

    public int onOffButtonW(class_2561 text) {
        int onOffW = this.buttonW(List.of(class_2561.method_43471((String)"options.on"), class_2561.method_43471((String)"options.off")));
        return this.textW(text) + this.textW((class_2561)class_2561.method_43470((String)": ")) + onOffW;
    }

    public void drawBackground(class_4587 matrices, class_2960 texture, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        int x = (this.graphics.getWindowW() - this.graphics.getScreenW()) / 2;
        int y = (this.graphics.getWindowH() - this.graphics.getScreenH()) / 2;
        this.graphics.drawTexture(matrices, x, y, 0, 0, this.graphics.getScreenW(), this.graphics.getScreenH());
    }

    public void drawText(class_332 context, class_327 renderer, Placer placer, class_2561 text, int color) {
        context.method_51439(renderer, text, placer.relX(), placer.relY(), color, false);
    }

    public <T extends class_364 & class_4068> T addDrawableChild(T element) {
        return this.graphics.addDrawableChild(element);
    }

    public Placer screenPlace() {
        return this.placer().size(this.screenW, this.screenH).at(this.screenX, this.screenY);
    }

    public class Placer
    implements Cloneable {
        private int x;
        private int y;
        private int w;
        private int h = Integer.MIN_VALUE;

        Placer() {
            this.w = Integer.MIN_VALUE;
            this.y = Integer.MIN_VALUE;
            this.x = Integer.MIN_VALUE;
        }

        public Placer clone() {
            try {
                return (Placer)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Placer placer = (Placer)o;
            return this.x == placer.x && this.y == placer.y && this.w == placer.w && this.h == placer.h;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.w, this.h);
        }

        int rawX() {
            return this.x;
        }

        int rawY() {
            return this.y;
        }

        int rawW() {
            return this.w;
        }

        int rawH() {
            return this.h;
        }

        boolean hasX() {
            return this.x != Integer.MIN_VALUE;
        }

        boolean hasY() {
            return this.y != Integer.MIN_VALUE;
        }

        boolean hasW() {
            return this.w != Integer.MIN_VALUE;
        }

        boolean hasH() {
            return this.h != Integer.MIN_VALUE;
        }

        public int x() {
            this.validate(this.x, "x");
            return this.x;
        }

        public int y() {
            this.validate(this.y, "y");
            return this.y;
        }

        public int relX() {
            this.validate(this.x, "x");
            return this.x - Layout.this.screenX;
        }

        public int relY() {
            this.validate(this.y, "y");
            return this.y - Layout.this.screenY;
        }

        public int endX() {
            return this.x() + this.w();
        }

        public int endY() {
            return this.y() + this.h();
        }

        public int w() {
            this.validate(this.w, "w");
            return this.w;
        }

        public int h() {
            this.validate(this.h, "h");
            return this.h;
        }

        public Placer x(int x) {
            this.x = x;
            return this;
        }

        public Placer y(int y) {
            this.y = y;
            return this;
        }

        public Placer at(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Placer relX(int x) {
            this.x = x + Layout.this.screenX;
            return this;
        }

        public Placer relY(int y) {
            this.y = y + Layout.this.screenY;
            return this;
        }

        public Placer w(int w) {
            this.w = w;
            return this;
        }

        public Placer h(int h) {
            this.h = h;
            return this;
        }

        public Placer size(int w, int h) {
            this.w = w;
            this.h = h;
            return this;
        }

        public Placer withText(String keyName) {
            return this.withText((class_2561)Layout.this.text(keyName));
        }

        public Placer withText(class_2561 text) {
            return this.w(Layout.this.textW(text)).h(Layout.this.textH);
        }

        public Placer withTexts(String keyName, String ... keyNames) {
            return this.withTexts(Layout.this.texts(keyName, keyNames));
        }

        public Placer withTexts(class_2561 text, class_2561 ... others) {
            return this.withTexts(Lists.asList((Object)text, (Object[])others));
        }

        public Placer withTexts(Iterable<class_2561> texts) {
            return this.w(Layout.this.maxTextW(texts)).h(Layout.this.textH);
        }

        private void validate(int val, String name) {
            if (val == Integer.MIN_VALUE) {
                throw new IllegalArgumentException(name + ": Not yet set");
            }
        }

        public Placer x(Horizontal dir, Placer to) {
            this.x = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Horizontal.LEFT -> to.x() - Layout.this.gapW - this.w();
                case Horizontal.CENTER -> to.x() + (to.w() - this.w()) / 2;
                case Horizontal.RIGHT -> to.x() + to.w() + Layout.this.gapW;
                case Horizontal.LEFT_EDGE -> to.x();
                case Horizontal.RIGHT_EDGE -> to.x() + to.w() - this.w();
            };
            return this;
        }

        public Placer y(Vertical dir, Placer to) {
            this.y = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Vertical.ABOVE -> to.y() - Layout.this.gapH - this.h();
                case Vertical.TOP_EDGE -> to.y();
                case Vertical.TOP -> to.y();
                case Vertical.MID -> to.y() + (to.h() - this.h()) / 2;
                case Vertical.BOTTOM -> to.y() + to.h();
                case Vertical.BOTTOM_EDGE -> to.y() + to.h() - this.h();
                case Vertical.BELOW -> to.y() + to.h() + Layout.this.gapH;
            };
            return this;
        }

        public Placer x(Horizontal dir) {
            this.x = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Horizontal.LEFT, Horizontal.LEFT_EDGE -> Layout.this.screenX + Layout.this.borderW;
                case Horizontal.CENTER -> Layout.this.screenX + (Layout.this.screenW - this.w()) / 2;
                case Horizontal.RIGHT, Horizontal.RIGHT_EDGE -> Layout.this.screenX + Layout.this.screenW - Layout.this.borderW - this.w();
            };
            return this;
        }

        public Placer y(Vertical dir) {
            this.y = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Vertical.ABOVE, Vertical.TOP_EDGE, Vertical.TOP -> Layout.this.screenY + Layout.this.borderH;
                case Vertical.MID -> Layout.this.screenY + (Layout.this.screenH - this.h()) / 2;
                case Vertical.BOTTOM, Vertical.BOTTOM_EDGE, Vertical.BELOW -> Layout.this.screenY + Layout.this.screenH - Layout.this.borderH - this.h();
            };
            return this;
        }

        private void validateDims() {
            this.validate(this.w, "w");
            this.validate(this.h, "h");
        }

        public Placer inButton() {
            if (this.w != Integer.MIN_VALUE) {
                this.w += 2 * Layout.this.buttonBorderW;
            }
            this.h = this.h != Integer.MIN_VALUE ? (this.h += 2 * Layout.this.buttonBorderH) : 20;
            return this;
        }

        public Placer inTextField() {
            if (this.w != Integer.MIN_VALUE) {
                this.w += 2;
            }
            this.h = this.h == Integer.MIN_VALUE ? 20 : (this.h += 2);
            return this;
        }

        public Placer inLabel() {
            if (this.w != Integer.MIN_VALUE) {
                this.w += 2;
            }
            this.h = this.h == Integer.MIN_VALUE ? Layout.this.textH : (this.h += 2);
            return this;
        }

        public Placer lockButton() {
            Layout.this.ensureLockButtonData();
            this.w = Layout.this.lockButtonW;
            this.h = Layout.this.lockButtonH;
            return this;
        }

        public Placer inCheckbox() {
            this.h = 20;
            this.w = 20;
            return this;
        }

        public <T extends class_339> T place(T widget) {
            if (this.hasX()) {
                widget.method_46421(this.x());
            }
            if (this.hasY()) {
                widget.method_46419(this.y());
            }
            if (this.hasW()) {
                widget.method_25358(this.w());
            }
            if (this.hasH()) {
                widget.field_22759 = this.h();
            }
            return widget;
        }

        private int coord(Horizontal dir, Placer placer) {
            return switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Horizontal.LEFT, Horizontal.LEFT_EDGE -> placer.x();
                case Horizontal.CENTER -> placer.x() + placer.w() / 2;
                case Horizontal.RIGHT -> placer.x() + placer.w();
                case Horizontal.RIGHT_EDGE -> placer.x() + placer.w() - this.w();
            };
        }

        private int coord(Horizontal dir) {
            return switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Horizontal.LEFT, Horizontal.LEFT_EDGE -> Layout.this.screenX + Layout.this.borderW;
                case Horizontal.CENTER -> Layout.this.screenX + Layout.this.screenW / 2;
                case Horizontal.RIGHT, Horizontal.RIGHT_EDGE -> Layout.this.screenX + Layout.this.screenW - Layout.this.borderW;
            };
        }

        public _ToClauseHoriz from(Horizontal dir, Placer placer) {
            return new _ToClauseHoriz(this, this.coord(dir, placer));
        }

        public _ToClauseHoriz from(Horizontal dir) {
            return new _ToClauseHoriz(this, this.coord(dir));
        }

        private int coord(Vertical dir, Placer placer) {
            return switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Vertical.ABOVE -> placer.y() - Layout.this.gapH;
                case Vertical.TOP -> placer.y();
                case Vertical.TOP_EDGE -> placer.y() + this.h();
                case Vertical.MID -> placer.y() + placer.h() / 2;
                case Vertical.BOTTOM -> placer.y() + placer.h();
                case Vertical.BELOW -> placer.y() + placer.h() + Layout.this.gapH;
                case Vertical.BOTTOM_EDGE -> placer.y() + placer.h() - this.w();
            };
        }

        private int coord(Vertical dir) {
            return switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Vertical.ABOVE, Vertical.TOP_EDGE, Vertical.TOP -> Layout.this.screenY + Layout.this.borderH;
                case Vertical.MID -> Layout.this.screenY + Layout.this.screenH / 2;
                case Vertical.BOTTOM, Vertical.BELOW -> Layout.this.screenY + Layout.this.screenH - Layout.this.borderH;
                case Vertical.BOTTOM_EDGE -> Layout.this.screenY + Layout.this.screenH - Layout.this.borderH - this.h();
            };
        }

        public _ToClauseVert from(Vertical dir, Placer placer) {
            return new _ToClauseVert(this.coord(dir, placer));
        }

        public _ToClauseVert from(Vertical dir) {
            return new _ToClauseVert(this.coord(dir));
        }

        public class _ToClauseHoriz {
            private final int startX;

            public _ToClauseHoriz(Placer thisPlacer, int startX) {
                this.startX = startX;
            }

            private Placer extract(int x) {
                Placer.this.w(Math.abs(x - this.startX));
                if (Placer.this.x == Integer.MIN_VALUE) {
                    Placer.this.x(Math.min(x, this.startX));
                }
                return Placer.this;
            }

            public Placer to(Horizontal dir, Placer placer) {
                return this.extract(Placer.this.coord(dir, placer));
            }

            public Placer to(Horizontal dir) {
                return this.extract(Placer.this.coord(dir));
            }

            public Placer to(int x) {
                return this.extract(x);
            }
        }

        public class _ToClauseVert {
            private final int startY;

            _ToClauseVert(int startY) {
                this.startY = startY;
            }

            private Placer extract(int y) {
                Placer.this.h(Math.abs(y - this.startY));
                if (Placer.this.y == Integer.MIN_VALUE) {
                    Placer.this.y(Math.min(y, this.startY));
                }
                return Placer.this;
            }

            public Placer to(Vertical dir, Placer placer) {
                return this.extract(Placer.this.coord(dir, placer));
            }

            public Placer to(Vertical dir) {
                return this.extract(Placer.this.coord(dir));
            }

            public Placer to(int y) {
                return this.extract(y);
            }
        }
    }
}

