/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.entities.util;

import net.id.paradiselost.api.BlockLikeSet;
import net.id.paradiselost.api.FloatingBlockHelper;
import net.id.paradiselost.entities.block.FloatingBlockEntity;
import net.id.paradiselost.tag.ParadiseLostBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class FloatingBlockHelperImpls {

    public static final class Pusher
    implements FloatingBlockHelper {
        private static final Pusher INSTANCE = new Pusher();

        private Pusher() {
        }

        public static Pusher getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean tryCreate(class_1937 world, class_2338 pos, boolean force) {
            boolean dropping = FloatingBlockHelper.willBlockDrop(world, pos, world.method_8320(pos), true);
            if (!force && FloatingBlockHelper.isBlockBlacklisted(world, pos) || dropping || !this.isSuitableFor(world.method_8320(pos))) {
                return false;
            }
            BlockLikeSet structure = Pusher.construct(world, pos, force);
            if (structure != null) {
                structure.spawn(world);
                return true;
            }
            return false;
        }

        @Override
        public boolean isSuitableFor(class_2680 state) {
            return state.method_26164(ParadiseLostBlockTags.PUSH_FLOATERS);
        }

        @Override
        @Deprecated(forRemoval=false)
        public boolean isBlocked(boolean shouldDrop, class_1937 world, class_2338 pos) {
            if (shouldDrop) {
                return !class_2346.method_10128((class_2680)world.method_8320(pos.method_10074()));
            }
            BlockLikeSet structure = Pusher.construct(world, pos, false);
            if (structure == null) {
                return true;
            }
            structure.remove();
            return false;
        }

        @Nullable
        private static BlockLikeSet construct(class_1937 world, class_2338 pos, boolean force) {
            FloatingBlockHelper.SetBuilder builder = new FloatingBlockHelper.SetBuilder(world, pos);
            if (world.method_8320(pos).method_26164(ParadiseLostBlockTags.PUSH_FLOATERS) && Pusher.continueTree(world, pos.method_10084(), builder, force) && builder.size() > 1) {
                return builder.build();
            }
            return null;
        }

        private static boolean continueTree(class_1937 world, class_2338 pos, FloatingBlockHelper.SetBuilder builder, boolean overrideBlacklist) {
            if (builder.size() > 13) {
                return false;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_26215() || !overrideBlacklist && FloatingBlockHelper.isBlockBlacklisted(world, pos) || builder.isAlreadyInSet(pos)) {
                return true;
            }
            builder.add(pos);
            if (!overrideBlacklist && FloatingBlockHelper.isBlockBlacklisted(world, pos)) {
                return false;
            }
            if (!Pusher.continueTree(world, pos.method_10084(), builder, overrideBlacklist)) {
                return false;
            }
            if (state.method_27852(class_2246.field_10030) || state.method_27852(class_2246.field_21211)) {
                for (class_2338 newPos : new class_2338[]{pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067(), pos.method_10074()}) {
                    class_2680 adjacentState = world.method_8320(newPos);
                    if (!Pusher.isAdjacentBlockStuck(state, adjacentState) || Pusher.continueTree(world, newPos, builder, overrideBlacklist)) continue;
                    return false;
                }
            }
            return true;
        }

        private static boolean isAdjacentBlockStuck(class_2680 state, class_2680 adjacentState) {
            if (state.method_27852(class_2246.field_21211) && adjacentState.method_27852(class_2246.field_10030)) {
                return false;
            }
            if (state.method_27852(class_2246.field_10030) && adjacentState.method_27852(class_2246.field_21211)) {
                return false;
            }
            return state.method_27852(class_2246.field_10030) || state.method_27852(class_2246.field_21211) || adjacentState.method_27852(class_2246.field_10030) || adjacentState.method_27852(class_2246.field_21211);
        }
    }

    public static class Double
    implements FloatingBlockHelper {
        private static final Double INSTANCE = new Double();

        private Double() {
        }

        public static Double getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean tryCreate(class_1937 world, class_2338 pos, boolean force) {
            class_2680 state = world.method_8320(pos);
            boolean dropping = FloatingBlockHelper.willBlockDrop(world, pos, state, true);
            if (!force && FloatingBlockHelper.isBlockBlacklisted(world, pos) || !this.isSuitableFor(state) || this.isBlocked(dropping, world, pos)) {
                return false;
            }
            if (state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609 ? !this.isSuitableFor(state = world.method_8320(pos = pos.method_10074())) : !this.isSuitableFor(world.method_8320(pos.method_10084()))) {
                return false;
            }
            class_2680 upperState = world.method_8320(pos.method_10084());
            FloatingBlockEntity upper = new FloatingBlockEntity(world, pos.method_10084(), upperState, true);
            FloatingBlockEntity lower = new FloatingBlockEntity(world, pos, state, true);
            upper.dropItem = false;
            world.method_8501(pos, class_2246.field_10124.method_9564());
            world.method_8501(pos.method_10084(), class_2246.field_10124.method_9564());
            BlockLikeSet structure = new BlockLikeSet(lower, upper, class_2382.field_11176.method_30931());
            structure.spawn(world);
            return true;
        }

        @Override
        public boolean isBlocked(boolean shouldDrop, class_1937 world, class_2338 pos) {
            class_2680 state = world.method_8320(pos);
            if (state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607) {
                pos = pos.method_10084();
            }
            class_2680 above = world.method_8320(pos.method_10084());
            class_2680 below = world.method_8320(pos.method_10074().method_10074());
            if (shouldDrop) {
                return !class_2346.method_10128((class_2680)below);
            }
            return !class_2346.method_10128((class_2680)above);
        }

        @Override
        public boolean isSuitableFor(class_2680 state) {
            return state.method_28498((class_2769)class_2741.field_12533);
        }
    }

    public static class Standard
    implements FloatingBlockHelper {
        private static final Standard INSTANCE = new Standard();

        private Standard() {
        }

        public static Standard getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean tryCreate(class_1937 world, class_2338 pos, boolean force) {
            class_2680 state = world.method_8320(pos);
            boolean dropping = FloatingBlockHelper.willBlockDrop(world, pos, state, false);
            if (!force && FloatingBlockHelper.isBlockBlacklisted(world, pos) || this.isBlocked(dropping, world, pos)) {
                return false;
            }
            FloatingBlockEntity entity = new FloatingBlockEntity(world, pos, state, false);
            if (state.method_27852(class_2246.field_10375)) {
                entity.setOnEndFloating((impact, landed) -> {
                    if (impact >= 0.8) {
                        class_2338 landingPos = entity.method_24515();
                        world.method_22352(landingPos, false);
                        world.method_8437((class_1297)entity, (double)landingPos.method_10263(), (double)landingPos.method_10264(), (double)landingPos.method_10260(), (float)class_3532.method_15350((double)(impact * 5.5), (double)0.0, (double)10.0), class_1937.class_7867.field_40889);
                    }
                });
            }
            if (state.method_27852(class_2246.field_27171)) {
                entity.setOnEndFloating((impact, landed) -> {
                    if (world.method_8546() && landed.booleanValue() && impact >= 1.1) {
                        class_1538 lightning = new class_1538(class_1299.field_6112, world);
                        lightning.method_33574(class_243.method_24953((class_2382)entity.method_24515()));
                        world.method_8649((class_1297)lightning);
                    }
                });
            }
            world.method_8649((class_1297)entity);
            return true;
        }

        @Override
        public boolean isSuitableFor(class_2680 state) {
            return true;
        }

        @Override
        public boolean isBlocked(boolean shouldDrop, class_1937 world, class_2338 pos) {
            class_2680 above = world.method_8320(pos.method_10084());
            class_2680 below = world.method_8320(pos.method_10074());
            if (shouldDrop) {
                return !class_2346.method_10128((class_2680)below);
            }
            return !class_2346.method_10128((class_2680)above);
        }
    }

    public static class Any
    implements FloatingBlockHelper {
        private static final Any INSTANCE = new Any();

        private Any() {
        }

        public static Any getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean tryCreate(class_1937 world, class_2338 pos, boolean force) {
            return DOUBLE.tryCreate(world, pos, force) || STANDARD.tryCreate(world, pos, force);
        }

        @Override
        public boolean isSuitableFor(class_2680 state) {
            return STANDARD.isSuitableFor(state) || DOUBLE.isSuitableFor(state);
        }

        @Override
        public boolean isBlocked(boolean shouldDrop, class_1937 world, class_2338 pos) {
            class_2680 state = world.method_8320(pos);
            return STANDARD.isBlocked(shouldDrop, world, pos) && DOUBLE.isSuitableFor(state) && DOUBLE.isBlocked(shouldDrop, world, pos);
        }
    }
}

