/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.id.paradiselost.component.MoaGenes;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.entities.passive.moa.MoaAttributes;
import net.id.paradiselost.entities.passive.moa.MoaEntity;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public class MoaStatCommand {
    public static final AttributeSuggester ATTRIBUTE_SUGGESTER = new AttributeSuggester();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"moastat").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"query").executes(context -> MoaStatCommand.printStat((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"target"), null))).then(class_2170.method_9244((String)"attribute", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)ATTRIBUTE_SUGGESTER).executes(context -> MoaStatCommand.printStat((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"attribute")))))).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"attribute", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> MoaStatCommand.setStat((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"attribute"), FloatArgumentType.getFloat((CommandContext)context, (String)"value"))))))));
    }

    private static int printStat(class_2168 source, Collection<? extends class_1297> entities, String rawAttribute) {
        String attributeId = rawAttribute == null ? "ALL" : rawAttribute;
        entities.forEach(entity -> {
            if (entity instanceof MoaEntity) {
                MoaEntity moa = (MoaEntity)((Object)entity);
                MoaGenes genes = moa.getGenes();
                source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.name", (Object[])new Object[]{moa.method_5476()}).method_27692(class_124.field_1076), false);
                source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.race", (Object[])new Object[]{class_2561.method_43471((String)genes.getRace().getTranslationKey())}).method_27692(class_124.field_1076), false);
                if (attributeId.equals("HUNGER")) {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.print", (Object[])new Object[]{class_2561.method_43471((String)"commands.paradise_lost.moastat.hunger"), String.format("%.2f", Float.valueOf(genes.getHunger()))}).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056}), false);
                } else if (attributeId.equals("ALL")) {
                    for (MoaAttributes attribute : MoaAttributes.values()) {
                        source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.print", (Object[])new Object[]{class_2561.method_43471((String)attribute.getTranslationKey()), Float.valueOf(genes.getAttribute(attribute))}).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056}), false);
                    }
                } else {
                    try {
                        MoaAttributes attribute = MoaAttributes.valueOf(attributeId);
                        source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.print", (Object[])new Object[]{class_2561.method_43471((String)attribute.getTranslationKey()), Float.valueOf(genes.getAttribute(attribute))}).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056}), false);
                    }
                    catch (IllegalArgumentException e) {
                        source.method_9213((class_2561)class_2561.method_43471((String)"commands.paradise_lost.moastat.failure.attribute"));
                    }
                }
            } else {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.paradise_lost.moastat.failure.entity", (Object[])new Object[]{entity.method_5864().method_5897()}));
            }
        });
        return 1;
    }

    private static int setStat(class_2168 source, class_1297 entity, String attributeId, float value) {
        if (entity instanceof MoaEntity) {
            MoaEntity moa = (MoaEntity)entity;
            MoaGenes genes = moa.getGenes();
            source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.name", (Object[])new Object[]{moa.method_5476()}).method_27692(class_124.field_1076), false);
            source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.race", (Object[])new Object[]{class_2561.method_43471((String)genes.getRace().getTranslationKey())}).method_27692(class_124.field_1076), false);
            if (attributeId.equals("HUNGER")) {
                genes.setHunger(Math.min(Math.max(value, 100.0f), 0.0f));
                source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.set", (Object[])new Object[]{class_2561.method_43471((String)"commands.paradise_lost.moastat.hunger"), String.format("%.2f", Float.valueOf(genes.getHunger()))}).method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), false);
            } else if (attributeId.equals("ALL")) {
                for (MoaAttributes attribute : MoaAttributes.values()) {
                    genes.setAttribute(attribute, value);
                    source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.set", (Object[])new Object[]{class_2561.method_43471((String)attribute.getTranslationKey()), Float.valueOf(genes.getAttribute(attribute))}).method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), false);
                }
            } else {
                try {
                    MoaAttributes attribute = MoaAttributes.valueOf(attributeId);
                    genes.setAttribute(attribute, value);
                    source.method_9226(() -> class_2561.method_43469((String)"commands.paradise_lost.moastat.set", (Object[])new Object[]{class_2561.method_43471((String)attribute.getTranslationKey()), Float.valueOf(genes.getAttribute(attribute))}).method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), false);
                }
                catch (IllegalArgumentException e) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"commands.paradise_lost.moastat.failure.attribute"));
                }
            }
            ParadiseLostComponents.MOA_GENETICS_KEY.sync((Object)moa);
        } else {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.paradise_lost.moastat.failure.entity", (Object[])new Object[]{entity.method_5864().method_5897()}));
        }
        return 1;
    }

    public static class AttributeSuggester
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            Arrays.stream(MoaAttributes.values()).forEach(attribute -> builder.suggest(attribute.name()));
            builder.suggest("HUNGER");
            builder.suggest("ALL");
            return builder.buildFuture();
        }
    }
}

