/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.id.paradiselost.api.BlockLikeEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class BlockLikeSet {
    private static final Set<BlockLikeSet> structures = new HashSet<BlockLikeSet>();
    private final Map<class_2382, BlockLikeEntity> entries;

    public BlockLikeSet(BlockLikeEntity entity1, BlockLikeEntity entity2, class_2382 offset) {
        this.entries = Map.of(class_2382.field_11176, entity1, offset, entity2);
    }

    public BlockLikeSet(Map<class_2382, BlockLikeEntity> map) {
        this.entries = map;
    }

    public static Iterator<BlockLikeSet> getAllSets() {
        return Set.copyOf(structures).iterator();
    }

    public Map<class_2382, BlockLikeEntity> getEntries() {
        return Map.copyOf(this.entries);
    }

    public void spawn(class_1937 world) {
        this.entries.forEach((offset, block) -> {
            block.markPartOfSet();
            world.method_8650(block.method_24515(), false);
            world.method_8649((class_1297)block);
        });
        this.init();
    }

    protected void synchronize() {
        BlockLikeEntity master = this.getMasterBlock();
        this.entries.forEach((offset, block) -> block.alignWith(master, (class_2382)offset));
    }

    public void postTick() {
        this.synchronize();
        for (BlockLikeEntity block : this.entries.values()) {
            if (!block.method_31481()) continue;
            class_1937 world = block.method_37908();
            class_2680 state = block.getBlockState();
            boolean success = world.method_8320(block.method_24515()).method_27852(state.method_26204());
            this.land(block, success);
            break;
        }
    }

    public void land(BlockLikeEntity lander, boolean success) {
        this.synchronize();
        for (BlockLikeEntity block : this.entries.values()) {
            if (block != lander) {
                if (success) {
                    block.cease();
                } else {
                    class_1937 world = block.method_37908();
                    class_2680 state = block.getBlockState();
                    class_2338 pos = block.method_24515();
                    if (world.method_8320(pos).method_27852(state.method_26204())) {
                        world.method_8650(pos, false);
                    }
                    block.breakApart();
                }
            }
            block.dropItem = false;
        }
        this.remove();
    }

    public BlockLikeEntity getMasterBlock() {
        if (this.entries.containsKey(class_2382.field_11176)) {
            return this.entries.get(class_2382.field_11176);
        }
        return this.entries.values().iterator().next();
    }

    private void init() {
        structures.add(this);
    }

    public void remove() {
        structures.remove(this);
    }

    public static class Builder {
        protected final Map<class_2382, BlockLikeEntity> entries;
        protected final class_2338 origin;

        public Builder(class_2338 origin) {
            this.origin = origin;
            this.entries = new HashMap<class_2382, BlockLikeEntity>(2);
        }

        public Builder add(BlockLikeEntity entity) {
            class_2338 pos = entity.method_24515();
            if (!this.isAlreadyInSet(pos)) {
                this.entries.put((class_2382)pos.method_10059((class_2382)this.origin), entity);
            }
            return this;
        }

        public Builder addIf(BlockLikeEntity entity, Predicate<Map<class_2382, BlockLikeEntity>> predicate) {
            if (predicate.test(Map.copyOf(this.entries))) {
                return this.add(entity);
            }
            return this;
        }

        public int size() {
            return this.entries.size();
        }

        public BlockLikeSet build() {
            return new BlockLikeSet(this.entries);
        }

        public boolean isAlreadyInSet(class_2338 pos) {
            return this.entries.containsKey(pos.method_10059((class_2382)this.origin));
        }
    }
}

