/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.id.paradiselost.blocks.ParadiseLostBlockSets;
import net.id.paradiselost.blocks.ParadiseLostBlocks;
import net.id.paradiselost.blocks.ParadiseLostWoodTypes;
import net.id.paradiselost.blocks.blockentity.ParadiseLostBlockEntityTypes;
import net.id.paradiselost.client.model.ParadiseLostModelLayers;
import net.id.paradiselost.client.model.ParadiseLostModelPredicates;
import net.id.paradiselost.client.model.armor.ParadiseLostArmorModels;
import net.id.paradiselost.client.rendering.block.ParadiseLostBlockEntityRenderers;
import net.id.paradiselost.client.rendering.entity.ParadiseLostEntityRenderers;
import net.id.paradiselost.client.rendering.particle.ParadiseLostParticles;
import net.id.paradiselost.client.rendering.texture.ParadiseLostTextures;
import net.id.paradiselost.client.rendering.util.ParadiseLostColorProviders;
import net.id.paradiselost.commands.ParadiseLostCommands;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.entities.passive.moa.MoaRaces;
import net.id.paradiselost.items.ParadiseLostItemGroups;
import net.id.paradiselost.items.ParadiseLostItems;
import net.id.paradiselost.recipe.ParadiseLostRecipeTypes;
import net.id.paradiselost.screen.ParadiseLostScreens;
import net.id.paradiselost.util.ParadiseLostDamageTypes;
import net.id.paradiselost.util.ParadiseLostSoundEvents;
import net.id.paradiselost.world.ParadiseLostGameRules;
import net.id.paradiselost.world.dimension.ParadiseLostBiomes;
import net.id.paradiselost.world.dimension.ParadiseLostDimension;
import net.id.paradiselost.world.feature.ParadiseLostFeatures;
import net.id.paradiselost.world.gen.carver.ParadiseLostCarvers;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;

public class ParadiseLost
implements ModInitializer,
ClientModInitializer,
DedicatedServerModInitializer {
    public static final String MOD_ID = "paradise_lost";
    public static final Logger LOG = LogUtils.getLogger();
    @Environment(value=EnvType.SERVER)
    private static final String DISABLE_WORLD_CHECK = "PARADISE_LOST_DISABLE_WORLD_CHECK";

    public static class_2960 locate(String location) {
        if (location.contains(":")) {
            return new class_2960(location);
        }
        return new class_2960(MOD_ID, location);
    }

    public void onInitialize() {
        ParadiseLostDamageTypes.init();
        ParadiseLostCarvers.init();
        ParadiseLostFeatures.init();
        ParadiseLostBiomes.init();
        ParadiseLostDimension.init();
        ParadiseLostBlockSets.init();
        ParadiseLostWoodTypes.init();
        ParadiseLostBlocks.init();
        ParadiseLostEntityTypes.init();
        ParadiseLostItems.init();
        ParadiseLostItemGroups.init();
        ParadiseLostBlockEntityTypes.init();
        ParadiseLostRecipeTypes.init();
        ParadiseLostCommands.init();
        ParadiseLostGameRules.init();
        ParadiseLostSoundEvents.init();
        MoaRaces.init();
        ParadiseLostScreens.init();
        ParadiseLostParticles.init();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ParadiseLostDimension.initPortal());
    }

    @Environment(value=EnvType.CLIENT)
    public void onInitializeClient() {
        this.initializeCrowdin();
        ParadiseLostModelPredicates.initClient();
        ParadiseLostArmorModels.initClient();
        ParadiseLostModelLayers.initClient();
        ParadiseLostEntityRenderers.initClient();
        ParadiseLostColorProviders.initClient();
        ParadiseLostBlockEntityRenderers.initClient();
        ParadiseLostParticles.Client.init();
        ParadiseLostTextures.initClient();
        ParadiseLostScreens.initClient();
    }

    @Environment(value=EnvType.CLIENT)
    private void initializeCrowdin() {
        if (FabricLoader.getInstance().isModLoaded("crowdin-translate")) {
            try {
                Class<?> CrowdinTranslate = Class.forName("de.guntram.mcmod.crowdintranslate.CrowdinTranslate");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle downloadTranslations = lookup.findStatic(CrowdinTranslate, "downloadTranslations", MethodType.methodType(Void.TYPE, String.class, String.class));
                downloadTranslations.invokeExact(MOD_ID, MOD_ID);
            }
            catch (Throwable e) {
                LOG.warn("Failed to setup Crowdin Translate", e);
            }
        }
    }

    public void onInitializeServer() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (System.getProperty(DISABLE_WORLD_CHECK) != null) {
                return;
            }
            class_3218 world = server.method_3847(ParadiseLostDimension.PARADISE_LOST_WORLD_KEY);
            if (world == null) {
                String message = "This crash is intentional. This is because of a bug in vanilla Minecraft that caused Paradise Lost\nto be unable to add the Paradise Lost dimension.\n\nPlease restart the server. This should solve this error.\n\nThe related issue on Mojang's issue tracker is MC-195468 at https://bugs.mojang.com/browse/MC-195468\n\nYou should only ever see this error message once per world.\nIf restarting the server doesn't solve the issue, then please contact us at https://discord.gg/eRsJ6F3Wng\n\nIf you would like to suppress this crash add -D%s to your arguments.\nFor example, if you have:\njava -jar fabric-server.jar nogui\nyou would want to add -D%s after the `java` part, like so:\njava -D%s -jar fabric-server.jar nogui\n".formatted(DISABLE_WORLD_CHECK, DISABLE_WORLD_CHECK, DISABLE_WORLD_CHECK);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> System.err.println("\n".repeat(10) + message + "\n".repeat(10))));
                throw new RuntimeException(message);
            }
        });
    }
}

