/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.fabric.platform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandamods.pandalib.platform.services.ModLoaderHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class ModLoaderHelperImpl
implements ModLoaderHelper {
    private final Map<String, ModLoaderHelper.Mod> mods = new HashMap<String, ModLoaderHelper.Mod>();

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public ModLoaderHelper.Mod getMod(String modId) {
        return this.mods.computeIfAbsent(modId, ModImpl::new);
    }

    @Override
    public List<ModLoaderHelper.Mod> getMods() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            this.getMod(mod.getMetadata().getId());
        }
        return List.copyOf(this.mods.values());
    }

    @Override
    public List<String> getModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).toList();
    }

    private static class ModImpl
    implements ModLoaderHelper.Mod {
        private final ModContainer container;
        private final ModMetadata metadata;

        public ModImpl(String modId) {
            this.container = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow();
            this.metadata = this.container.getMetadata();
        }

        @Override
        public String getId() {
            return this.metadata.getId();
        }

        @Override
        public String getDisplayName() {
            return this.metadata.getName();
        }

        @Override
        public String getDescription() {
            return this.metadata.getDescription();
        }

        @Override
        public List<String> getAuthors() {
            return this.metadata.getAuthors().stream().map(Person::getName).toList();
        }

        @Override
        public String getVersion() {
            return this.metadata.getVersion().getFriendlyString();
        }
    }
}

