/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.core.network;

import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import me.pandamods.pandalib.config.ConfigData;
import me.pandamods.pandalib.config.PandaLibConfig;
import me.pandamods.pandalib.config.holders.ClientConfigHolder;
import me.pandamods.pandalib.config.holders.CommonConfigHolder;
import me.pandamods.pandalib.networking.NetworkContext;
import me.pandamods.pandalib.networking.NetworkRegistry;
import me.pandamods.pandalib.networking.PacketDistributor;
import me.pandamods.pandalib.utils.NBTUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ConfigNetworking {
    public static final class_2960 PACKET_ID = new class_2960("pandalib", "config_sync");

    public static void registerPackets(NetworkRegistry registry) {
        registry.registerBiDirectionalReceiver(PACKET_ID, ConfigNetworking::CommonConfigReceiver, ConfigNetworking::ClientConfigReceiver);
    }

    public static void SyncCommonConfigs(class_3222 serverPlayer) {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof CommonConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncCommonConfig(serverPlayer, (CommonConfigHolder)configHolder));
    }

    public static void SyncCommonConfig(class_3222 serverPlayer, CommonConfigHolder<?> holder) {
        holder.logger.info("Sending common config '{}' to {}", (Object)holder.resourceLocation().toString(), (Object)serverPlayer.method_5476().getString());
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        byteBuf.method_10812(holder.resourceLocation());
        byteBuf.method_10794((class_2487)NBTUtils.convertJsonToTag(holder.getGson().toJsonTree(holder.get())));
        PacketDistributor.sendToPlayer(serverPlayer, PACKET_ID, byteBuf);
    }

    public static void SyncClientConfigs() {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof ClientConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncClientConfig((ClientConfigHolder)configHolder));
    }

    public static void SyncClientConfig(ClientConfigHolder<?> holder) {
        holder.logger.info("Sending client config '{}' to server", (Object)holder.resourceLocation().toString());
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        byteBuf.method_10812(holder.resourceLocation());
        byteBuf.method_10794((class_2487)NBTUtils.convertJsonToTag(holder.getGson().toJsonTree(holder.get())));
        PacketDistributor.sendToServer(PACKET_ID, byteBuf);
    }

    private static void ClientConfigReceiver(NetworkContext ctx, class_2540 byteBuf) {
        class_2960 resourceLocation = byteBuf.method_10810();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof ClientConfigHolder) {
                ClientConfigHolder clientConfigHolder = (ClientConfigHolder)configHolder;
                configHolder.logger.info("Received client config '{}' from {}", (Object)configHolder.resourceLocation().toString(), (Object)ctx.getPlayer().method_5476().getString());
                JsonElement configJson = NBTUtils.convertTagToJson((class_2520)byteBuf.method_10798());
                clientConfigHolder.putConfig(ctx.getPlayer(), (ConfigData)configHolder.getGson().fromJson(configJson, configHolder.getConfigClass()));
            }
        });
    }

    private static void CommonConfigReceiver(NetworkContext ctx, class_2540 byteBuf) {
        class_2960 resourceLocation = byteBuf.method_10810();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof CommonConfigHolder) {
                CommonConfigHolder commonConfigHolder = (CommonConfigHolder)configHolder;
                configHolder.logger.info("Received common config '{}' from server", (Object)configHolder.resourceLocation().toString());
                JsonElement configJson = NBTUtils.convertTagToJson((class_2520)byteBuf.method_10798());
                commonConfigHolder.setCommonConfig((ConfigData)configHolder.getGson().fromJson(configJson, configHolder.getConfigClass()));
            }
        });
    }
}

