/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.LizardTail;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1330;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Lizard
extends class_1321
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> VARIANT_ID = class_2945.method_12791(Lizard.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_TAIL = class_2945.method_12791(Lizard.class, (class_2941)class_2943.field_13323);
    private static final class_1856 TEMPT_INGREDIENT = class_1856.method_8106(NaturalistTags.ItemTags.LIZARD_TEMPT_ITEMS);
    private LizardAvoidEntityGoal<class_1657> avoidPlayersGoal;
    private int tailRegrowCooldown = 0;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.lizard.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.lizard.walk");
    protected static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.sf_nba.lizard.sit");
    protected static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.sf_nba.lizard.sleep");

    public Lizard(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23721, 2.0);
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        return null;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new LizardTemptGoal(this, 0.6, TEMPT_INGREDIENT, true));
        this.field_6201.method_6277(6, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_6175() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new LizardAvoidEntityGoal<class_1657>(this, class_1657.class, 16.0f, 0.8, 1.33);
        }
        this.field_6201.method_6280(this.avoidPlayersGoal);
        if (!this.method_6181()) {
            this.field_6201.method_6277(4, this.avoidPlayersGoal);
        }
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
            this.method_6033(20.0f);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(8.0);
        }
        this.method_5996(class_5134.field_23721).method_6192(4.0);
    }

    public class_1269 method_5992(@NotNull class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_37908().field_9236) {
            boolean bl = this.method_6171((class_1309)player) || this.method_6181() || TEMPT_INGREDIENT.method_8093(stack) && !this.method_6181();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (TEMPT_INGREDIENT.method_8093(stack) && this.method_6032() < this.method_6063()) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.method_6025(5.0f);
                if (!this.hasTail() && this.method_6032() >= this.method_6063()) {
                    this.setHasTail(true);
                    this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
                }
                return class_1269.field_5812;
            }
            class_1269 interactionResult = super.method_5992(player, hand);
            if (interactionResult.method_23665() && !this.method_6109() || !this.method_6171((class_1309)player)) {
                return interactionResult;
            }
            this.method_24346(!this.method_24345());
            this.field_6282 = false;
            this.field_6189.method_6340();
            this.method_5980(null);
            return class_1269.field_5812;
        }
        if (!TEMPT_INGREDIENT.method_8093(stack)) {
            return super.method_5992(player, hand);
        }
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        if (this.field_5974.method_43048(3) == 0) {
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            return class_1269.field_5812;
        }
        this.method_37908().method_8421((class_1297)this, (byte)6);
        return class_1269.field_5812;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public int getVariant() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(VARIANT_ID)), (int)0, (int)3);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT_ID, (Object)variant);
    }

    public boolean hasTail() {
        return (Boolean)this.field_6011.method_12789(HAS_TAIL);
    }

    public void setHasTail(boolean hasTail) {
        this.field_6011.method_12778(HAS_TAIL, (Object)hasTail);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT_ID, (Object)0);
        this.field_6011.method_12784(HAS_TAIL, (Object)true);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10556("HasTail", this.hasTail());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.setHasTail(compound.method_10577("HasTail"));
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.hasTail() && this.method_6032() <= this.method_6063() / 2.0f) {
            this.setHasTail(false);
            this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
            LizardTail lizardTail = (LizardTail)NaturalistEntityTypes.LIZARD_TAIL.get().method_5883(this.method_37908());
            if (lizardTail != null) {
                lizardTail.setVariant(this.getVariant());
                lizardTail.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                this.method_37908().method_8649((class_1297)lizardTail);
            }
            for (class_1308 mob : this.method_37908().method_8390(class_1308.class, this.method_5829().method_1014(8.0), entity -> entity.method_5968() == this)) {
                mob.method_5980((class_1309)lizardTail);
            }
            this.tailRegrowCooldown = 12000;
        }
        return super.method_5643(source, amount);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.hasTail() && !this.method_37908().method_8608()) {
            if (this.tailRegrowCooldown > 0) {
                --this.tailRegrowCooldown;
            } else {
                this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
                this.setHasTail(true);
            }
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_6880 holder = level.method_23753(this.method_24515());
        if (holder.method_40225(class_1972.field_9449)) {
            this.setVariant(3);
        } else if (holder.method_40220(class_6908.field_36516)) {
            this.setVariant(0);
        } else if (holder.method_40225(class_1972.field_9424)) {
            this.setVariant(2);
        } else {
            this.setVariant(1);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Lizard> PlayState predicate(AnimationState<E> event) {
        if (this.method_6172()) {
            event.getController().setAnimation(SIT);
            return PlayState.CONTINUE;
        }
        if (this.method_18798().method_37268() > 1.0E-6) {
            event.getController().setAnimation(WALK);
            event.getController().setAnimationSpeed(2.0);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    static class LizardTemptGoal
    extends class_1391 {
        @Nullable
        private class_1657 selectedPlayer;
        private final Lizard lizard;

        public LizardTemptGoal(Lizard lizard, double speedModifier, class_1856 ingredient, boolean canScare) {
            super((class_1314)lizard, speedModifier, ingredient, canScare);
            this.lizard = lizard;
        }

        public void method_6268() {
            super.method_6268();
            if (this.selectedPlayer == null && this.field_6616.method_6051().method_43048(this.method_38847(600)) == 0) {
                this.selectedPlayer = this.field_6617;
            } else if (this.field_6616.method_6051().method_43048(this.method_38847(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean method_16081() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.field_6617)) {
                return false;
            }
            return super.method_16081();
        }

        public boolean method_6264() {
            return super.method_6264() && !this.lizard.method_6181();
        }
    }

    static class LizardAvoidEntityGoal<T extends class_1309>
    extends class_1338<T> {
        @NotNull
        private final Lizard lizard;

        public LizardAvoidEntityGoal(@NotNull Lizard lizard, Class<T> class_, float f, double d, double e) {
            super((class_1314)lizard, class_, f, d, e, class_1301.field_6156::test);
            this.lizard = lizard;
        }

        public boolean method_6264() {
            return !this.lizard.method_6181() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.lizard.method_6181() && super.method_6266();
        }
    }

    static class LizardMeleeAttackGoal
    extends class_1366 {
        private final Lizard lizard;

        public LizardMeleeAttackGoal(Lizard lizard, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((class_1314)lizard, speedModifier, followingTargetEvenIfNotSeen);
            this.lizard = lizard;
        }

        public boolean method_6264() {
            return this.lizard.hasTail() && super.method_6264();
        }

        public boolean method_6266() {
            return this.lizard.hasTail() && super.method_6266();
        }
    }
}

